@echo off

set InstallLogFile=TBT_Install.log
REM remove previous log file
del %InstallLogFile% 2>NUL

echo.
echo Installing Thunderbolt Driver for Windows. Please wait...
echo.

call .\InstallScripts\runDetectPrvDrv.bat >> %InstallLogFile% 2>&1
IF %ERRORLEVEL%==0 ( 
	rem No previous driver, new driver can be installed.
	echo Installation in progress...
	GOTO INSTALL_DRIVERS
) ELSE IF %ERRORLEVEL%==1 (
	rem Installation driver version is greater than installed driver version, installation will proceed.
	echo Upgrade will be performed following previous version uninstall.
	echo Uninstall previous version. >> %InstallLogFile%
	call Uninstall.bat >> %InstallLogFile% 2>&1
	echo.
	echo Newer driver installation in progress...
	GOTO INSTALL_DRIVERS
) ELSE IF %ERRORLEVEL%==2 (
	rem Installation driver version equals to installed driver version, driver installation will be skipped.
	ECHO Thunderbolt driver already installed on host. 
	GOTO EXIT_STOP_INSTALL
) ELSE IF %ERRORLEVEL%==3 (
	rem Installed driver version is greater than Installation driver version. Driver installation will be skipped.
	ECHO A newer version of Thunderbolt driver already installed on host.
	GOTO EXIT_STOP_INSTALL
) ELSE IF %ERRORLEVEL%==4 (
	ECHO An exception was thrown in DetectPrevDrv.ps1. >> %InstallLogFile%
	ECHO Unable to detect previous installed version.
	GOTO ERROR
)

:INSTALL_DRIVERS
pnputil /add-driver "%~dp0ThunderboltWindowsDchSetup\TbtHostController.inf" /install >> %InstallLogFile% 2>&1	
set ERR=%ERRORLEVEL%
IF %ERR% NEQ 0 GOTO ERROR
pnputil /add-driver "%~dp0ThunderboltApplicationLauncherSetup\TbtHostControllerExtension.inf" /install >> %InstallLogFile% 2>&1
set ERR=%ERRORLEVEL%
IF %ERR% NEQ 0 GOTO ERROR

:EXIT
ECHO.
ECHO Thunderbolt installation finished successfully. >> %InstallLogFile%
ECHO Thunderbolt installation finished successfully.
exit /b 0

:EXIT_STOP_INSTALL
ECHO No installation required. >> %InstallLogFile%
ECHO No installation required.
exit /b 0

:ERROR 
ECHO Installation failed. >> %InstallLogFile%
ECHO Installation failed, refer to %InstallLogFile%.
exit /b %ERR%