<?php
//getting migrated target LD size
class GetMigratedLDSize extends BaseFactory
{
	private $HDIDs = array();
	private $RaidMode;
	private $NumOfParityDisk = 0;
	private $LDID;
	
	public function addHDID($HDID)
	{
		$this->HDIDs[] = $HDID;
	}
	
	public function setLDID($LDID)
	{
		$this->LDID = $LDID;
	}
	
	public function setRaidMode($RaidMode)
	{
		$this->RaidMode = $RaidMode;
	}
	
	public function setNumOfParityDisk($NumOfParityDisk)
	{
		$this->NumOfParityDisk = $NumOfParityDisk;
	}
	
	protected function toGetMaxSize()
	{
		$HDCount = sizeof($this->HDIDs);
		
		if ($HDCount == 0) {
			return;
		}
		
		$HDs = "";
		foreach ($this->HDIDs as $HD)
		{
			$HDs .= " " . $HD;
		}
		
		$Cmd = new XMLAPICommand();
		$Cmd->setCommand(XMLAPICommand::MV_LD_GetMigratedLdSize);
		$Cmd->setCommandPara("RaidMode",$this->RaidMode);
		$Cmd->setCommandPara("NumParityDisk",$this->NumOfParityDisk);
		$Cmd->setCommandPara("HDCount",$HDCount);
		$Cmd->setCommandPara("HDIDs",$HDs);
		$Cmd->setCommandPara("LDID",$this->LDID);
		
		$handler = new LdMigrateMaxSizeXmlHandler();
		$this->runCommand($CmdLDGetMax->getCommand(), $handler);
	}
		
	public function createObject()
	{
		//won't used in this
		return 0;
	}
	
	public function setRequestSender()
	{
		$this->reqSender = new BaseSingleRequestSender();
	}
}
?>