<?php
abstract class UserAction
{
	protected $xmlRet;//the xml result
	private $smarty;
	protected $ApiCmd;//the APICommand
	private $isArraySupport;
	private $AdapterID;
	
	protected abstract function validatePara();//validate HTTP parameter 
	protected abstract function doAction();//do the action
	protected abstract function initActionPara();//initialize action parameters
	
	public function getAdapterID()
	{
		return $this->AdapterID;
	}

    protected function setAcceleratorCmdXmlRetFailed()
	{
		$this->xmlRet = new FailXMLRet();
		$XMLRoot = $this->ApiCmd->getResult();
		if (isset($XMLRoot) && $XMLRoot->RetVal . "") {
				$this->xmlRet->Url = getBaseURL() . PHPPageName::TargetPageName ."?Target=" . Target::getAccelerator;
			$Err = AcceleratorError::getErrStr(intval($XMLRoot->RetVal));//ComError::getErrStr(intval($XMLRoot->RetVal));
			$this->xmlRet->Msg = $Err;
		}
	}

	protected function setAcceleratorCmdXmlRetSuccess()
	{
		$this->xmlRet = new SuccessXMLRet();
		$this->xmlRet->Msg = "";
		$this->xmlRet->Url = "JumpPage.php?Target=" . Target::getAccelerator;
	}
	
	protected function setAESPortCmdXMLRetFail()
	{
		$this->xmlRet = new FailXMLRet();
		$XMLRoot = $this->ApiCmd->getResult();
		if ($XMLRoot->RetVal . "") {
			$this->xmlRet->Url = getBaseURL() . PHPPageName::TargetPageName ."?Target=" . Target::AESPortManagePage . "&ID=" . getRequestPara("portid") . "&HBAID=" . $this->getAdapterID();
			$Err = ComError::getErrStr(intval($XMLRoot->RetVal)) ;
			$this->xmlRet->Msg = $Err;
		}
	}
	
	protected function setAESPortCmdXMLRetSuccess()
	{
		$this->xmlRet = new SuccessXMLRet();
		$this->xmlRet->Msg = "";
		$this->xmlRet->Url = getBaseURL() . PHPPageName::TargetPageName ."?Target=" . Target::AESPortManagePage . "&ID=" . getRequestPara("portid") . "&HBAID=" . $this->getAdapterID();
	}

	protected function setAESEntryCmdXMLRetFail()
	{
		$this->xmlRet = new FailXMLRet();
		$XMLRoot = $this->ApiCmd->getResult();
		if ($XMLRoot->RetVal . "") {
			$this->xmlRet->Url = getBaseURL() . PHPPageName::TargetPageName ."?Target=" . Target::AESEntryManagePage . "&ID=" . getRequestPara("portid") . "&HBAID=" . $this->getAdapterID();
			$Err = ComError::getErrStr(intval($XMLRoot->RetVal)) ;
			$this->xmlRet->Msg = $Err;
		}
	}

	protected function setAESEntryCmdXMLRetSuccess()
	{
		$this->xmlRet = new SuccessXMLRet();
		$this->xmlRet->Msg = "";
		$this->xmlRet->Url = getBaseURL() . PHPPageName::TargetPageName ."?Target=" . Target::AESEntryManagePage . "&ID=" . getRequestPara("portid") . "&HBAID=" . $this->getAdapterID();
	}

	//set common ENC XMLAPICommand failure result returned
	protected function setENCCmdXmlRetFail()
	{
		$this->xmlRet = new FailXMLRet();
		$XMLRoot = $this->ApiCmd->getResult();
		if ($XMLRoot->RetVal . "") {
			if ($XMLRoot->RetVal == ComError::ERR_INVALID_ENC_ID 
				) {
				$this->xmlRet->Url = getBaseURL() . PHPPageName::TargetPageName ."?Target=" . Target::EnclosureListPage;
			}
			else
			{
				$this->xmlRet->Url = getBaseURL() . PHPPageName::TargetPageName ."?Target=" . Target::EnclosureDetailPage . "&ID=" . getRequestPara("EnclID");
			}
			$Err = ComError::getErrStr(intval($XMLRoot->RetVal)) ;
			$this->xmlRet->Msg = $Err;
		}
	}
	
	//set common ENC XMLAPICommand success result returned
	protected function setENCCmdXmlRetSuccess()
	{
		$this->xmlRet = new SuccessXMLRet();
		$this->xmlRet->Msg = "";
		$this->xmlRet->Url = getBaseURL() . PHPPageName::TargetPageName ."?Target=" . Target::EnclosureDetailPage . "&ID=" . getRequestPara("EnclID");
	}

    protected function setPackageVDCmdXmlRetFail()
	{
		$this->xmlRet = new FailXMLRet();
		$XMLRoot = $this->ApiCmd->getResult();
		if ($XMLRoot->RetVal . "") {
			if ($XMLRoot->RetVal == ComError::ERR_INVALID_LD_ID
				|| $XMLRoot->RetVal == ComError::ERR_LD_NOT_EXIST
				) {
				$this->xmlRet->Url = getBaseURL() . PHPPageName::TargetPageName ."?Target=" . Target::getSystemSubPage ;
			}
			else
			{
				$this->xmlRet->Url = getBaseURL() . PHPPageName::TargetPageName ."?Target=" . Target::getPackageVDPage . "&ID=" . getRequestPara("LDID") . "&HBAID=" . $this->AdapterID;
			}
			$Err = ComError::getErrStr(intval($XMLRoot->RetVal)) ;
			$this->xmlRet->Msg = $Err;
		}
	}

    protected function setPackageVDCmdXmlRetSuccess()
	{
		$this->xmlRet = new SuccessXMLRet();
		$this->xmlRet->Msg = "";
		$this->xmlRet->Url = getBaseURL() . PHPPageName::TargetPageName ."?Target="
			. Target::getPackageVDPage . "&ID=" . getRequestPara("LDID") . "&HBAID=" . $this->AdapterID;
	}

	protected function setLDOnDGCmdXmlRetFail()
	{
		$this->xmlRet = new FailXMLRet();
		$XMLRoot = $this->ApiCmd->getResult();
		if ($XMLRoot->RetVal . "") {
			if ($XMLRoot->RetVal == ComError::ERR_INVALID_LD_ID 
				|| $XMLRoot->RetVal == ComError::ERR_LD_NOT_EXIST 
				) {
				$this->xmlRet->Url = getBaseURL() . PHPPageName::TargetPageName ."?Target=" . Target::getSystemSubPage ;
			}
			else
			{
				$pageName = Target::getVDSubPage;
				$this->xmlRet->Url = getBaseURL() . PHPPageName::TargetPageName ."?Target=" 
					. $pageName . "&ID=" . getRequestPara("LDID") . "&HBAID=" . $this->AdapterID;
			}
			$Err = ComError::getErrStr(intval($XMLRoot->RetVal)) ;
			$this->xmlRet->Msg = $Err;
		}
	}
	//set common LD XMLAPICommand success result returned
	protected function setLDOnDGCmdXmlRetSuccess()
	{
		$this->xmlRet = new SuccessXMLRet();
		$this->xmlRet->Msg = "";
		$this->xmlRet->Url = getBaseURL() . PHPPageName::TargetPageName ."?Target="
			. Target::getVDSubPage . "&ID=" . getRequestPara("LDID") . "&HBAID=" . $this->AdapterID;
	}
	
	//set common DG XMLAPICommand failure result returned
	protected function setDGCmdXmlRetFail()
	{
		$this->xmlRet = new FailXMLRet();
		$XMLRoot = $this->ApiCmd->getResult();
		if ($XMLRoot->RetVal . "") {
			if ($XMLRoot->RetVal == ComError::ERR_INVALID_DG_ID  
				//|| $XMLRoot->RetVal == ComError::ERR_LD_NOT_EXIST 
				) {
				$this->xmlRet->Url = getBaseURL() . PHPPageName::TargetPageName ."?Target=" . Target::getSystemSubPage ;
			}
			else
			{
				$pageName = Target::getArraySubPage ;
				$this->xmlRet->Url = getBaseURL() . PHPPageName::TargetPageName ."?Target=" . $pageName . "&ID=" . getRequestPara("DGID") . "&HBAID=" . $this->AdapterID;
			}
			$Err = ComError::getErrStr(intval($XMLRoot->RetVal)) ;
			$this->xmlRet->Msg = $Err;
		}
	}
	//set common DG XMLAPICommand success result returned
	protected function setDGCmdXmlRetSuccess()
	{
		$this->xmlRet = new SuccessXMLRet();
		$this->xmlRet->Msg = "";
		$this->xmlRet->Url = getBaseURL() . PHPPageName::TargetPageName ."?Target=" . Target::getArraySubPage . "&ID=" . getRequestPara("DGID") . "&HBAID=" . $this->AdapterID;
	}
	
	//set common LD XMLAPICommand failure result returned
	protected function setLDCmdXmlRetFail()
	{
		$this->xmlRet = new FailXMLRet();
		$XMLRoot = $this->ApiCmd->getResult();
		if ($XMLRoot->RetVal . "") {
			if ($XMLRoot->RetVal == ComError::ERR_INVALID_LD_ID 
				|| $XMLRoot->RetVal == ComError::ERR_LD_NOT_EXIST 
				) {
				$this->xmlRet->Url = getBaseURL() . PHPPageName::TargetPageName ."?Target=" . Target::getSystemSubPage ;
			}
			else
			{
				$this->xmlRet->Url = getBaseURL() . PHPPageName::TargetPageName ."?Target=" . Target::getIndependentVDPage . "&ID=" . getRequestPara("LDID") . "&HBAID=" . $this->AdapterID;
			}
			$Err = ComError::getErrStr(intval($XMLRoot->RetVal)) ;
			$this->xmlRet->Msg = $Err;
		}
	}
	//set common LD XMLAPICommand success result returned
	protected function setLDCmdXmlRetSuccess()
	{
		$this->xmlRet = new SuccessXMLRet();
		$this->xmlRet->Msg = "";
		$this->xmlRet->Url = getBaseURL() . PHPPageName::TargetPageName ."?Target=" . Target::getIndependentVDPage . "&ID=" . getRequestPara("LDID") . "&HBAID=" . $this->AdapterID;
	}
	
	//set common HD XMLAPICommand failure result returned
	protected function setHDCmdXmlRetFail()
	{
		$pageName = Target::getHdDetail;
		$pageName_Default = Target::getSystemSubPage;
		
		$this->xmlRet = new FailXMLRet();
		$XMLRoot = $this->ApiCmd->getResult();
		if ($XMLRoot->RetVal . "") {
			if ($XMLRoot->RetVal == ComError::ERR_INVALID_HD_ID 
				|| $XMLRoot->RetVal == ComError::ERR_HD_NOT_EXIST 
				) {
				$this->xmlRet->Url = getBaseURL() . PHPPageName::TargetPageName ."?Target=" . $pageName_Default  ;
			}
			else
			{
				$this->xmlRet->Url = getBaseURL() . PHPPageName::TargetPageName ."?Target=" . $pageName  . "&ID=" . getRequestPara("HDID") . "&HBAID=" . $this->AdapterID;
			}
			$Err =  ComError::getErrStr(intval($XMLRoot->RetVal));
			$this->xmlRet->Msg = $Err;
		}
	}
	
	//set common PD XMLAPICommand success result returned
	protected function setHDCmdXmlRetSuccess()
	{
		$pageName = "";
		
		$pageName = Target::getHdDetail;
		
		$this->xmlRet = new SuccessXMLRet();
		$this->xmlRet->Msg = "";
		$this->xmlRet->Url = 
			getBaseURL() . PHPPageName::TargetPageName ."?Target=" . $pageName . "&ID=" . getRequestPara("HDID") . "&HBAID=" . $this->AdapterID;
	}
	
	//set common HBA XMLAPICommand failure result returned
	protected function setHBACmdXmlRetFail()
	{
		$this->xmlRet = new FailXMLRet();
		$XMLRoot = $this->ApiCmd->getResult();
		if ($XMLRoot && $XMLRoot->RetVal . "") {
			if ($XMLRoot->RetVal == ComError::ERR_INVALID_ADAPTER_ID 
				) {
				$this->xmlRet->Url = getBaseURL() . PHPPageName::TargetPageName ."?Target=" . Target::getSystemSubPage;
			}
			else
			{
				$this->xmlRet->Url = getBaseURL() . PHPPageName::TargetPageName ."?Target=" . Target::getHBADetail . "&ID=" . getRequestPara("HBAID");
			}
			$Err = ComError::getErrStr(intval($XMLRoot->RetVal));
			$this->xmlRet->Msg = $Err;
		}
	}
	
	//set common HBA XMLAPICommand success result returned
	protected function setHBACmdXmlRetSuccess()
	{
		$this->xmlRet = new SuccessXMLRet();
		$this->xmlRet->Msg = "";
		$this->xmlRet->Url = "JumpPage.php?Target=" . Target::getHBADetail . "&ID=" . getRequestPara("HBAID");
	}
	
	protected function setBBUCmdXmlRetFail()
	{
		$this->xmlRet = new FailXMLRet();
		$XMLRoot = $this->ApiCmd->getResult();
		if ($XMLRoot->RetVal . "") {
			if ($XMLRoot->RetVal == ComError::ERR_INVALID_ADAPTER_ID) 
			{
				$this->xmlRet->Url = getBaseURL() . PHPPageName::TargetPageName ."?Target=" . Target::getSystemSubPage;
			}
			else
			{
				$this->xmlRet->Url = getBaseURL() . PHPPageName::TargetPageName ."?Target=" . Target::getBBUSubPage  . "&HBAID=" . getRequestPara("HBAID");
			}
			$Err = ComError::getErrStr(intval($XMLRoot->RetVal));
			$this->xmlRet->Msg = $Err;
		}
	}
	
	protected function setBBUCmdXmlRetSuccess()
	{
		$this->xmlRet = new SuccessXMLRet();
		$this->xmlRet->Msg = "";
		$this->xmlRet->Url = "JumpPage.php?Target=" . Target::getBBUSubPage . "&HBAID=" . getRequestPara("HBAID");
	}
	
	//do LD BGA action
	public function doBGAAction()
	{
		$this->AdapterID = getRequestPara("HBAID");
		$this->initActionPara();
		$this->doAction();
		
		return $this->xmlRet;
	}
	
	private function FilterAPIcmd()	{
		$cmdName = getRequestPara("cmdName");
		
		$HBAs = HBAFactory::getAllInstance();
		
		$this->isArraySupport = 0;
		
		foreach ($HBAs as $Hba)
		{
			$this->isArraySupport += $Hba->getDiskGroupSupport();
		}
		
		if($this->isArraySupport){
			if($cmdName == APICmd::rebuildLD | $cmdName == APICmd::migrateLD){
				return false;
			}
		}
	
		return true;
	}

	//display the result by smarty
	public function displayResultXML($noPermissionCheck)
	{
		$this->AdapterID = getRequestPara("HBAID");
		$this->initActionPara();
		//Filter APIcmd,such as forbid rebuild/migration to VdOnDg
//		if($this->FilterAPIcmd()){
			//check user permission
			if (($noPermissionCheck != 0) || $this->checkPermission()) {
				$this->doAction();
			}
			else {
				//access without permission
				$this->setPermissionCheckFail();
			}
//		}
//		else{
//			$this->xmlRet = new SuccessXMLRet();
//			$this->xmlRet->Msg = "";
//		    $this->xmlRet->Url = getBaseURL() . PHPPageName::TargetPageName ."?Target=" . Target::LdListPage ;
//		} 	

		
		//localization here
		if ($this->xmlRet->Msg != "") {
			$this->xmlRet->Msg = gettext($this->xmlRet->Msg);
		}
		
		//display by use of XMLRetDisplayer class
		$display = new XMLRetDisplayer();
		$display->assignSmarty($this->smarty);
		$display->display($this->xmlRet);
	}
	
	//check permission
	private function checkPermission()
	{
		if ( !(getSessionPara(USERID) && getSessionPara('isAdmin')) 
                        && getRequestPara("cmdName") != APICmd::appPauseAccelerate
                        && getRequestPara("cmdName") != APICmd::appResumeAccelerate
                        && getRequestPara("cmdName") != APICmd::appStopAccelerate
                        && getRequestPara("cmdName") != APICmd::rescanAdapter
                        ) {
			return false;
		}
		
		return true;
	}
	
	//set check permission failure result returned
	private function setPermissionCheckFail()
	{
		$this->xmlRet = new FailXMLRet();
		$this->xmlRet->Msg = AlertMsg::PERMISSION_CHECK_FAIL;
		$this->xmlRet->Url = getBaseURL() . PHPPageName::TargetPageName ."?Target=" . Target::MarvellRaidPage . "&logout=1";
	}
	
	public function smartyAssign($smarty)
	{
		$this->smarty = $smarty;
	}
}
?>