<?php
//include_once("PageDisplayer.class.php");

class PgCreate2Displayer extends PageDisplayer
{
	protected function initPage()
	{
		if(!getSessionPara('isAdmin'))
		{
			$this->displayDefaultPage(Target::LdListPage);
			return;
		}
		
		$smarty = $this->smarty;
		
		//get request para
		$RaidMode = getRequestPara('RaidMode');
		$subRaidMode = getRequestPara('subRaidMode');
		$LDSize = getRequestPara('LDSize');
		$LDName = trim(getRequestPara('LDName'));
		$InitType = getRequestPara('InitType');
		$StripeSize = getRequestPara('StripeSize');
		$SectorSize = getRequestPara('SectorSize');
		$WriteCache = getRequestPara('WriteCache');
		$DiskCache = getRequestPara('DiskCache');
		$ReadCache = getRequestPara('ReadCache');
		$GBRounding = getRequestPara('GBRounding');
		$ParityDisk = getRequestPara('NumOfParityDisk');
		$CancelAlert = gettext(AlertMsg::CREATE_CANCEL)."?";
		
		//set default name
		if (trim($LDName) == "") {
			$ldlist = new LDList();
			$ldlist->setAdapterID($this->getAdapterID());
			$ldlist->toGetLDInfo();
			$count = sizeof($ldlist->getBaseClasses()) + 1;
			$RaidType = "";
			switch ($RaidMode)
			{
				case RAIDMode::LD_MODE_RAID0 : $RaidType = "R0"; break;
				case RAIDMode::LD_MODE_RAID1 : $RaidType = "R1"; break;
				case RAIDMode::LD_MODE_RAID1E : $RaidType = "R1E"; break;
				case RAIDMode::LD_MODE_RAID5 : $RaidType = "R5"; break;
				case RAIDMode::LD_MODE_RAID6 : $RaidType = "R6"; break;
				case RAIDMode::LD_MODE_JBOD : $RaidType = "JBOD"; break;
				case RAIDMode::LD_MODE_RAID10 : $RaidType = "R10"; break;
				case RAIDMode::LD_MODE_RAID50 : $RaidType = "R50"; break;
				case RAIDMode::LD_MODE_RAID60 : $RaidType = "R60"; break;
			}
			$LDName = "VD_" . $RaidType ."_" .$count;
			
			if ($RaidMode == RAIDMode::LD_MODE_HyperHDD) {
				if ($subRaidMode == RAIDMode::LD_MODE_HyperHDD) 
					$LDName = "HyperDuo_C_" .$count;
				else 
					$LDName = "HyperDuo_S_" .$count;
			}
		}
		
		//default raid mode
		if ($RaidMode == null) {
			$RaidMode = RAIDMode::LD_MODE_RAID1 ;
		}
		
		if ($StripeSize == null) {
			$StripeSize = LDStripeSize::StripeSize64K ;
		}
		$HDs = getRequestPara('HDs');
		if ($HDs == null) {
			$HDIDs = array();
		}
		else {
			$HDIDs = explode(" ",$HDs);
			foreach ($HDIDs as $HD)
			{
				if (trim($HD) === "") {
					unset($HD);
				}
			}
			//set max size
			$container = new CtnCreateLDMaxSize();
			$container->setAdapterID($this->getAdapterID());
			$container->smartyAssign($smarty);
			foreach ($HDIDs as $HD)
			{
				$container->addHDID($HD);
			}
			$container->setRaidMode($RaidMode);
			if ($RaidMode == RAIDMode::LD_MODE_RAID6 || $RaidMode == RAIDMode::LD_MODE_RAID60 ) {
				$container->setNumParityDisk($ParityDisk);
			}
			$container->initContainer();
		}
			
		$sysFeature = AdapterFeature::getInstance($this->getAdapterID());

		if ($sysFeature->supportPackageVD){
			$smarty->assign("createPackageVD",1);
		}

    	$quickInit = gettext(LdBgaStatus::LD_BGA_INIT_QUICK_STR);
    	$bgInit = gettext(LdBgaStatus::LD_BGA_INIT_BACK_STR);
    	$fgInit = gettext(LdBgaStatus::LD_BGA_INIT_FORE_STR);
    	$noInit = gettext("No Initialization");
	
    	$InitOption1 = array(InitType::INIT_QUICK=>$quickInit);
    	$InitOption2 = array(InitType::INIT_NONE =>$noInit);
    	$InitOption3 = array(InitType::INIT_FULLBACKGROUND =>$bgInit);
    	$InitOption4 = array(InitType::INIT_FULLFOREGROUND =>$fgInit);
    	
		$InitOptions = $InitOption2 + $InitOption1;
		//if ($sysFeature->supportForegroundInit || $sysFeature->supportBackgroundInit){
			
			if ($RaidMode != RAIDMode::LD_MODE_RAID0) {//Raid0 can only do quick/none
			
				if ($sysFeature->supportForegroundInit) {
					$InitOptions += $InitOption4;
				}
				if ($sysFeature->supportBackgroundInit) {
					$InitOptions += $InitOption3;
				}
				
			}
			//$smarty->assign("enableInitOptions",1);
		//}else{ //do not support, eg.Magni, disable init options
			//$InitOptions = $InitOption2;
			//$smarty->assign("enableInitOptions",0);
		//}
		
		
		include_once("../phpsrc/action/GetCreateDefaultVal.class.php");
		$cmd = new GetCreateDefaultVal();
		$cmd->smartyAssign($smarty);
		$cmd->setAdapterID($this->getAdapterID());
		$cmd->setCreateDefaultVal();
		
		$defaultWriteCache = $cmd->getDefaultWriteCache();
		$defaultReadCache = $cmd->getDefaultReadCache();
		
		//write cache
		$wBack = gettext(LDCacheMode::WRITEBACK_ENABLE_STR );
	    $wThru = gettext(LDCacheMode::WRITETHRU_ENABLE_STR );
    	    	    	
    	if (!isset($WriteCache)) {
			$WriteCache = $defaultWriteCache ;
		}
		
		$wCacheOptions = 
			array(
				LDCacheMode::WRITEBACK_ENABLE=>$wBack,  
				LDCacheMode::WRITETHRU_ENABLE =>$wThru   
			);
			
		if (!$sysFeature->supportVDWriteCache){
			$smarty->assign("writeCacheDisabled",1);
		}
		
	/*	if ($sysFeature->supportVDWriteCache){
			$wCacheOptions = 
				array(
					LDCacheMode::WRITEBACK_ENABLE=>$wBack,    //default value
					LDCacheMode::WRITETHRU_ENABLE =>$wThru   
				);
		}else{
			$wCacheOptions = 
				array(
					LDCacheMode::WRITETHRU_ENABLE =>$wThru    //if not support, default "write through" and disable select
				);
			$smarty->assign("writeCacheDisabled",1);
		}*/
					
		//read cache	
    	$rAhead = gettext(LDCacheMode::LOOKAHEAD_ENABLE_STR );
    	$rNone = gettext(LDCacheMode::NO_LOOKAHEAD_STR );
    	
		if (!isset($ReadCache)) {
			$ReadCache = $defaultReadCache ;
		}
		if ($sysFeature->supportVDReadCache){
			$rCacheOptions = 
				array(
					0 =>$rNone,
					LDCacheMode::LOOKAHEAD_ENABLE =>$rAhead   //default value
				);
		}else{
			$rCacheOptions = 
				array(
					0 =>$rNone            //if not support, default "no read ahead" and disable select
				);
			$smarty->assign("readCacheDisabled",1);
				
		}
		//read cache	
		
		
    	$None = gettext("None");
    	
    	//gb rounding
		if (!isset($GBRounding)) {
			$GBRounding = Rounding_Scheme::ROUNDING_SCHEME_1GB ;
		}
		if ($sysFeature->supportVDRounding){
			$GBRoundingOptions = 
				array(
					Rounding_Scheme::ROUNDING_SCHEME_NONE  => $None, 
					Rounding_Scheme::ROUNDING_SCHEME_1GB  => "1G", //default value 
					Rounding_Scheme::ROUNDING_SCHEME_10GB   => "10G"
				);
		}else{
			$GBRoundingOptions = 
				array(
					Rounding_Scheme::ROUNDING_SCHEME_NONE  => $None
				);
		}
		
		$hba = HBAFactory::getInstance($this->getAdapterID());

		$stripeOptions = array();
		
		if ($hba->supportStripeSize16()){
			$stripeOptions[LDStripeSize::StripeSize16K] = LDStripeSize::StripeSize16KStr;
		}
		if ($hba->supportStripeSize32()){
			$stripeOptions[LDStripeSize::StripeSize32K] = LDStripeSize::StripeSize32KStr;
		}
		if ($hba->supportStripeSize64()){
			$stripeOptions[LDStripeSize::StripeSize64K] = LDStripeSize::StripeSize64KStr;
		}
		if ($hba->supportStripeSize128()){
			$stripeOptions[LDStripeSize::StripeSize128K] = LDStripeSize::StripeSize128KStr;
		}
		if ($hba->supportStripeSize256()){
			$stripeOptions[LDStripeSize::StripeSize256K] = LDStripeSize::StripeSize256KStr;
		}
		if ($hba->supportStripeSize512()){
			$stripeOptions[LDStripeSize::StripeSize512K] = LDStripeSize::StripeSize512KStr;
		}
		if ($hba->supportStripeSize1024()){
			$stripeOptions[LDStripeSize::StripeSize1024K] = LDStripeSize::StripeSize1024KStr;
		}
		
		$smarty->assign("InitOptions",$InitOptions);
		
		$smarty->assign("wCacheOptions",$wCacheOptions);
		$smarty->assign("rCacheOptions",$rCacheOptions);
		$smarty->assign("stripeOptions",$stripeOptions);
		$smarty->assign("GBRoundingOptions",$GBRoundingOptions);
			
		$smarty->assign("HBAID", $this->getAdapterID());	
		$smarty->assign("RaidMode", $RaidMode);	
		$smarty->assign("subRaidMode", $subRaidMode);	
		$smarty->assign("LDSize", $LDSize);
		$smarty->assign("LDName", $LDName);	
		$smarty->assign("InitType", $InitType);	
		$smarty->assign("StripeSize", $StripeSize);	
		$smarty->assign("SectorSize", $SectorSize);	
		$smarty->assign("WriteCache", $WriteCache);
		$smarty->assign("DiskCache", $DiskCache);
		$smarty->assign("ReadCache", $ReadCache);
		$smarty->assign("GBRounding", $GBRounding);
		$RaidModeStr = RAIDMode::GetRAIDModeStr($RaidMode);
		if ($RaidMode == RAIDMode::LD_MODE_HyperHDD) $RaidModeStr .= ", " . RAIDMode::GetHyperHddSubModeStr($subRaidMode);
		$smarty->assign("RaidModeStr", $RaidModeStr);	
		$smarty->assign("HDIDs", $HDs);
		$smarty->assign("ParityDisk", $ParityDisk);
		$smarty->assign("CancelAlert", $CancelAlert);
		
		$this->setPageName(Target::CreatePage2 . ".tpl");
	}
}
?>