<?php
class ActionFlashBios extends UserAction 
{
	private $Actions;
	private $Type;
	private $filepath;
	private $fileName;
	
	protected function validatePara()
	{
		//check the http request parameters
	}
	protected function initActionPara()
	{
		$this->Actions = getRequestPara("Actions");
		$this->Type = getRequestPara("Type");
		$this->fileName = session_id() . "_"  . rand() . "_" . $this->Actions . "_" . $this->Type;
		$this->filepath = realpath("../db")."/" . $this->fileName;
	}
	
	private function doFlash()
	{
		$this->ApiCmd = new XMLAPICommand();
		$this->ApiCmd->setCommand(XMLAPICommand::MV_Flash_Option);
		$this->ApiCmd->setCommandPara("AdapterID",$this->getAdapterID());
		$this->ApiCmd->setCommandPara('Actions', $this->Actions);//FlashAction::FLASH_DOWNLOAD);
		$this->ApiCmd->setCommandPara('Type', $this->Type);
		$this->ApiCmd->setCommandPara('filepath', $this->filepath);
		$this->ApiCmd->issueCommand();
		
		if ($this->ApiCmd->getResult()->RetVal . "") {
			$this->setFlashCmdXmlRetFail();
		}
		else {
			$this->setFlashCmdXmlRetSuccess();
		}

	}
	
	private function setFlashCmdXmlRetFail()
	{
		$this->xmlRet = new FailXMLRet();
		$XMLRoot = $this->ApiCmd->getResult();
		if ($XMLRoot->RetVal . "") {
			if ($XMLRoot->RetVal == ComError::ERR_INVALID_ADAPTER_ID 
				) {
				$this->xmlRet->Url = getBaseURL() . PHPPageName::TargetPageName ."?Target=" . Target::getSystemSubPage;
			}
			else
			{
				$this->xmlRet->Url = getBaseURL() . PHPPageName::TargetPageName ."?Target=" . Target::getHBADetail . "&ID=" . $this->getAdapterID();
			}
			$Err = ComError::getErrStr(intval($XMLRoot->RetVal));
			$this->xmlRet->Msg = $Err;
		}
		
	}
	
	private function setFlashCmdXmlRetSuccess()
	{
		$this->xmlRet = new SuccessXMLRet();
		$this->xmlRet->Msg = "";
				
		$this->xmlRet->Url = getBaseURL() . PHPPageName::TargetPageName ."?Target="
		                        . Target::BiosFlashPage . "&HBAID=" . $this->getAdapterID()
		                         . "&Actions=" . $this->Actions . "&Type=" . $this->Type . "&FilePath=" . $this->fileName;
		
	}
	
	protected function doAction()
	{
		$this->doFlash();
	}
}
?>
