/*
 * Decompiled with CFR 0.152.
 */
package pdtEditor;

import binTools.BinWriter;
import binTools.Common;
import java.util.ArrayList;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import pdtEditor.BoardDescriptionTable;
import pdtEditor.DataStore;
import pdtEditor.Device;
import pdtEditor.Luid;
import pdtEditor.PdtFile;
import pdtEditor.Sensor;

public class PdtWriter {
    public static final int PDT_TOTAL_SIZE_FIELD_SIZE = 2;
    public static final int PDT_MAX_SIZE = 3990;
    public static final String XML_PDT_HEAD_COMMENT = "Please notice: this XML representation of the PDT binary file has been created for internal use only. The structure and names in this file may be changed in future releases of the PDT editor without advance notice.";
    private BinWriter _writer;
    private PdtFile _pdtFile;

    public PdtWriter(BinWriter writer, PdtFile pdtFile) {
        this._writer = writer;
        this._pdtFile = pdtFile;
    }

    private void writebdtInfoContent(Element pdtElement) {
        ArrayList<BoardDescriptionTable> bdtObjects = this._pdtFile.getBdtObjects();
        this._writer.writeNewField("NumBdtElements", 1, bdtObjects.size(), (Node)pdtElement);
        for (int i = 0; i < bdtObjects.size(); ++i) {
            BoardDescriptionTable bdt = bdtObjects.get(i);
            Element bdtElement = this._writer.writeNewField((String)new StringBuilder().append((String)"BdtElement").append((int)(i + 1)).toString(), (Node)pdtElement).xmlElement;
            bdt.writeToPdt(this._writer, bdtElement);
        }
    }

    private void writeLuid(Luid luid, Element parent) {
        if (parent != null) {
            this._writer.addComment(luid.getSensorTypeIdStr(), parent);
            this._writer.writeNewField("SensorType", 2, luid.getSensorTypeId(), (Node)parent);
            this._writer.addComment(luid.getVendorIdStr(), parent);
            this._writer.writeNewField("SensorVendorId", 2, luid.getVendorId(), (Node)parent);
            this._writer.addComment(luid.getSensorSubTypeIdStr(), parent);
            this._writer.writeNewField("SensorSubType", 2, luid.getSensorSubTypeId(), (Node)parent);
            this._writer.writeNewField("InstanceID", 1, luid.getInstanceId(), (Node)parent);
            this._writer.addComment(luid.getFlagsStr(), parent);
            this._writer.writeNewField("Flags", 1, luid.getFlags(), (Node)parent);
        }
    }

    private void writeSensorInfoContent(Element parent) {
        Element hdtElement = this._writer.writeNewField((String)"HDT", (Node)parent).xmlElement;
        this._writer.writeNewField("NumDevices", 1, this._pdtFile.getDevices().size(), (Node)hdtElement);
        this._writer.writeNewField("Reserved", 1, 0, (Node)hdtElement);
        for (int i = 1; i <= this._pdtFile.getDevices().size(); ++i) {
            Element luidElement;
            Sensor sensor;
            int j;
            Device dev = this._pdtFile.getDevices().get(i - 1);
            Element devElement = this._writer.writeNewField((String)new StringBuilder().append((String)"Device").append((int)i).toString(), (Node)hdtElement).xmlElement;
            Common.Field deviceLengthField = this._writer.writeNewField("Length", 2, 2, (Node)devElement);
            this._writer.addSizeCounter(deviceLengthField);
            this._writer.writeNewField("ProductId", 2, dev.getProductId(), (Node)devElement);
            this._writer.writeNewField("VendorId", 2, dev.getVendorId(), (Node)devElement);
            this._writer.writeNewField("HostIdMask", 2, dev.getHostIdMask(), (Node)devElement);
            this._writer.writeNewField("Reserved", 2, 0, (Node)devElement);
            this._writer.writeNewField("Flags", 1, dev.getFlags(), (Node)devElement);
            this._writer.writeNewField("NumOfSensors", 1, dev.getSensors().size(), (Node)devElement);
            int currSensNum = 1;
            for (j = 1; j <= dev.getPhysicalSensors().size(); ++j) {
                sensor = dev.getPhysicalSensors().get(j - 1);
                luidElement = this._writer.writeNewField((String)new StringBuilder().append((String)"Luid").append((int)currSensNum++).toString(), (Node)devElement).xmlElement;
                this.writeLuid(sensor.getLuid(), luidElement);
            }
            for (j = 1; j <= dev.getAlgorithms().size(); ++j) {
                sensor = dev.getAlgorithms().get(j - 1);
                luidElement = this._writer.writeNewField((String)new StringBuilder().append((String)"Luid").append((int)currSensNum++).toString(), (Node)devElement).xmlElement;
                this.writeLuid(sensor.getLuid(), luidElement);
            }
            if (dev.getDetachable()) {
                Element detachableElement = this._writer.writeNewField((String)"Dockable", (Node)devElement).xmlElement;
                Element interruptElement = this._writer.writeNewField((String)"Interrupt", (Node)detachableElement).xmlElement;
                Element controlElement = this._writer.writeNewField((String)"Control", (Node)detachableElement).xmlElement;
                this._writer.writeNewField("Reserved", 1, 0, (Node)interruptElement);
                this._writer.writeNewField("Purpose", 1, dev.getInterruptPurpose(), (Node)interruptElement);
                this._writer.writeNewField("PinNumber", 1, dev.getInterruptPinNumber(), (Node)interruptElement);
                this._writer.writeNewField("ModeGPIO", 1, dev.getInterruptMode(), (Node)interruptElement);
                this._writer.writeNewField("Id", 1, dev.getControlId(), (Node)controlElement);
                this._writer.writeNewField("Value", 1, dev.getControlValue(), (Node)controlElement);
            }
            this._writer.removeSizeCounter(deviceLengthField);
        }
        Element sdtElement = this._writer.writeNewField((String)"SDT", (Node)parent).xmlElement;
        ArrayList<Sensor> sensorEntries = this._pdtFile.getSensorsThatHasPayloads();
        this._writer.writeNewField("NumSensorEntries", 1, sensorEntries.size(), (Node)sdtElement);
        this._writer.writeNewField("Reserved", 1, 0, (Node)sdtElement);
        for (int i = 1; i <= sensorEntries.size(); ++i) {
            Sensor sensorEntry = sensorEntries.get(i - 1);
            Element sensEntryNode = this._writer.writeNewField((String)new StringBuilder().append((String)"SensorEntry").append((int)i).toString(), (Node)sdtElement).xmlElement;
            Element luidElement = this._writer.writeNewField((String)"Luid", (Node)sensEntryNode).xmlElement;
            this.writeLuid(sensorEntry.getLuid(), luidElement);
            sensorEntry.writeSdtInfo(this._writer, sensEntryNode);
        }
    }

    public void writePdtContent() {
        try {
            this._writer.addComment(XML_PDT_HEAD_COMMENT, this._writer.getHeadElement());
            Element ishElement = this._writer.getHeadElement();
            this._writer.writeNewField("FormatVersion", 1, DataStore.getInstance().getPdtFormatVersion(), (Node)ishElement);
            this._writer.writeNewField("SkuId", 1, this._pdtFile.getSkuId(), (Node)ishElement);
            Common.Field pdtTotalSizeField = this._writer.writeNewField("PdtTotalSize", 2, 4, (Node)ishElement);
            this._writer.addSizeCounter(pdtTotalSizeField);
            if (DataStore.getInstance().getPdtFormatVersion() <= 3) {
                this.writeSensorInfoContent(ishElement);
            } else {
                Element pdtEntry1Element = this._writer.writeNewField((String)"PdtEntry1", (Node)ishElement).xmlElement;
                this._writer.writeNewField("Type", 1, 0, (Node)pdtEntry1Element);
                Common.Field pdtEntry1Length = this._writer.writeNewField("Length", 2, 0, (Node)pdtEntry1Element);
                this._writer.addSizeCounter(pdtEntry1Length);
                Element i2cBusDataElement = this._writer.writeNewField((String)"BdtInfo", (Node)pdtEntry1Element).xmlElement;
                this.writebdtInfoContent(i2cBusDataElement);
                this._writer.removeSizeCounter(pdtEntry1Length);
                Element PdtEntry2Element = this._writer.writeNewField((String)"PdtEntry2", (Node)ishElement).xmlElement;
                this._writer.writeNewField("Type", 1, 1, (Node)PdtEntry2Element);
                Common.Field pdtEntry2Length = this._writer.writeNewField("Length", 2, 0, (Node)PdtEntry2Element);
                this._writer.addSizeCounter(pdtEntry2Length);
                Element sensorInfoElement = this._writer.writeNewField((String)"SensorInfo", (Node)PdtEntry2Element).xmlElement;
                this.writeSensorInfoContent(sensorInfoElement);
                this._writer.removeSizeCounter(pdtEntry2Length);
            }
            if (pdtTotalSizeField.value > 3990) {
                throw new UnsupportedOperationException("The PDT file you are attempting to save is too large. PDT files have a maximum size of 3990 bytes, but this file  is " + pdtTotalSizeField.value + " bytes.\n\nRemove some information from the file and try again.");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Unable to generate XML content from the data: " + e.getMessage());
        }
    }
}

