/*
 * Decompiled with CFR 0.152.
 */
package com.intel.sensing.fdk.model.project;

import com.intel.sensing.fdk.common.exceptions.ISSException;
import com.intel.sensing.fdk.model.abstractData.Category;
import com.intel.sensing.fdk.model.dao.DaoFactory;
import com.intel.sensing.fdk.model.dao.SelectedSensorsDao;
import com.intel.sensing.fdk.model.entity.ModuleEntity;
import com.intel.sensing.fdk.model.entity.ProjectEntity;
import com.intel.sensing.fdk.model.entity.SelectedItemsDataEntity;
import com.intel.sensing.fdk.model.entity.SelectedSensorsEntity;
import com.intel.sensing.fdk.model.entity.SensorDataEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class SelectedModuleManager {
    private SelectedSensorsEntity fSelectedSensorEntity;
    private SelectedSensorsDao fSelectDao = DaoFactory.getDao(SelectedSensorsDao.class);
    private String fFilePath;

    public SelectedModuleManager(String file, ProjectEntity projectEntity, List<ModuleEntity> userModules) {
        this.fFilePath = file;
        this.init(projectEntity, userModules);
    }

    public void init(ProjectEntity projectEntity, List<ModuleEntity> userModules) {
        try {
            this.fSelectedSensorEntity = this.fSelectDao.getEntityByFilePath(this.fFilePath, projectEntity, userModules);
        }
        catch (ISSException iSSException) {
            this.fSelectedSensorEntity = new SelectedSensorsEntity();
            this.fSelectedSensorEntity.setJsonFilePath(this.fFilePath);
        }
    }

    public void reInit(ProjectEntity entity, List<ModuleEntity> modules) {
        this.init(entity, modules);
    }

    public SelectedSensorsEntity getEntity() {
        return this.fSelectedSensorEntity;
    }

    public void add(ModuleEntity module) {
        Category category = module.getCategoryInData();
        if (category.equals(Category.SENSOR)) {
            List<SensorDataEntity> sensors = module.getSensorBundle().getSensors();
            List<SelectedItemsDataEntity> items = sensors.parallelStream().map(sensor -> sensor).collect(Collectors.toList());
            this.fSelectedSensorEntity.addSensorIfNotExist(items);
        } else if (category.equals(Category.LIB)) {
            this.fSelectedSensorEntity.addSelectItem(module);
        }
        this.fSelectDao.saveEntity(this.fSelectedSensorEntity);
    }

    public void remove(ModuleEntity module) {
        Category category = module.getCategoryInData();
        if (category.equals(Category.SENSOR)) {
            List<SensorDataEntity> sensors = module.getSensorBundle().getSensors();
            List<SelectedItemsDataEntity> items = sensors.parallelStream().map(sensor -> sensor).collect(Collectors.toList());
            this.fSelectedSensorEntity.removeSensorIfExist(items);
        } else if (category.equals(Category.LIB)) {
            this.fSelectedSensorEntity.removeSelectItem(module);
        }
        this.fSelectDao.saveEntity(this.fSelectedSensorEntity);
    }

    public List<SelectedItemsDataEntity> getSelectedItems() {
        if (this.fSelectedSensorEntity != null) {
            return this.fSelectedSensorEntity.getSelectedItems();
        }
        return new ArrayList<SelectedItemsDataEntity>();
    }

    public void addLibraries(ArrayList<ModuleEntity> toSelectLibs) {
        toSelectLibs.forEach(m -> this.fSelectedSensorEntity.addSelectItem((SelectedItemsDataEntity)m));
        this.fSelectDao.saveEntity(this.fSelectedSensorEntity);
    }

    public void addSensors(ArrayList<SensorDataEntity> toSelectSensors) {
        List<SelectedItemsDataEntity> items = toSelectSensors.parallelStream().map(sensor -> sensor).collect(Collectors.toList());
        this.fSelectedSensorEntity.addSensorIfNotExist(items);
        this.fSelectDao.saveEntity(this.fSelectedSensorEntity);
    }

    public void update(SelectedSensorsEntity selectSensors) {
        this.fSelectedSensorEntity.sync(selectSensors);
        this.fSelectDao.saveEntity(this.fSelectedSensorEntity);
    }
}

