# <copyright>
# INTEL CONFIDENTIAL
#
# Copyright 2021 Intel Corporation
#
# This software and the related documents are Intel copyrighted materials, and your use of
# them is governed by the express license under which they were provided to you ("License").
# Unless the License provides otherwise, you may not use, modify, copy, publish, distribute,
# disclose or transmit this software or the related documents without Intel's prior written
# permission.
#
# This software and the related documents are provided as is, with no express or implied
# warranties, other than those that are expressly stated in the License.
#
# <copyright>

$BusTypeMap = [ordered]@{
    0 = $Messages.Unknown
    1 = $Messages.ISA
    2 = $Messages.EISA
    3 = $Messages.PCMCIA
    4 = $Messages.CardBus
    5 = $Messages.PCI
    6 = $Messages.PCIX
    7 = $Messages.PCIExpress
    8 = $Messages.IOSF
}

# Map from *SpeedDuplex enum values to possible adapter speeds
$SupportedSpeedsMap = [ordered]@{
    "0"      = 0            #AutoNegotiation
    "1"      = 10000000     #10Mb Half Duplex
    "2"      = 10000000     #10Mb Full Duplex
    "3"      = 100000000    #100Mb Half Duplex
    "4"      = 100000000    #100Mb Full Duplex
    "5"      = 1000000000   #1Gb Full Duplex NDIS5
    "6"      = 1000000000   #1Gb Full Duplex NDIS6
    "7"      = 10000000000  #10Gb Full Duplex
    "8"      = 10000000000  #10Gb Half Duplex
    "9"      = 40000000000  #40Gb Half Duplex
    "2500"   = 2500000000   #2.5Gb
    "5000"   = 5000000000   #5Gb
    "25000"  = 25000000000  #25Gb
    "500000" = 50000000000  #50Gb
    "10"     = 100000000000 #100Gb
}


enum ADAPTER_STATUS
{
    Installed    = 0x1
    DriverLoaded = 0x2
    HwMissing    = 0x4
    Reserved     = 0x8
    HasDiag      = 0x10
    HasLink      = 0x20
    PoweredOff   = 0x1000
}


enum CVL_PHY_TYPE
{
    CVL100BaseTX = 0x0
    CVL100MSGMII = 0x1
    CVL1000BaseT = 0x2
    CVL1000BaseSX = 0x3
    CVL1000BaseLX = 0x4
    CVL1000BaseKX = 0x5
    CVL1GSGMII = 0x6
    CVL2Point5GBaseT = 0x7
    CVL2Point5gBaseX = 0x8
    CVL2Point5GBaseKX = 0x9
    CVL5GBaseT = 0xA
    CVL5GBaseKR = 0xB
    CVL10GBaseT = 0xC
    CVL10GSFIDA = 0xD
    CVL10GBaseSR = 0xE
    CVL10GBaseLR = 0xF
    CVL10GBaseKR = 0x10
    CVL10GSFIAOC_ACC = 0x11
    CVL10GSFIC2C = 0x12
    CVL25GBaseT = 0x13
    CVL25GBaseCR = 0x14
    CVL25GBaseCRS = 0x15
    CVL25GBaseCR1 = 0x16
    CVL25GBaseSR = 0x17
    CVL25GBaseLR = 0x18
    CVL25GBaseKR = 0x19
    CVL25GBaseKRS = 0x1A
    CVL25GBaseKR1 = 0x1B
    CVL25GAUIAOC_ACC = 0x1C
    CVL25GAUIC2C = 0x1D
    CVL40GBaseCR4 = 0x1E
    CVL40GBaseSR4 = 0x1F
    CVL40GBaseLR4 = 0x20
    CVL40GBaseKR4 = 0x21
    CVL40GXLAUIAOC_ACC = 0x22
    CVL40GXLAUI = 0x23
    CVL50GBaseCR2 = 0x24
    CVL50GBaseKR2 = 0x27
    CVL50GLAUI2AOC_ACC = 0x28
    CVL50GLAUI2 = 0x29
    CVL50GAUI2AOC_ACC = 0x2A
    CVL50GAUI2 = 0x2B
    CVL50GBaseCRPAM4 = 0x2C
    CVL50GBaseSR = 0x2D
    CVL50GBaseFR = 0x2E
    CVL50GBaseLR = 0x2F
    CVL50GBaseKRPAM4 = 0x30
    CVL50GAUI1AOC_ACC = 0x31
    CVL50GAUI1 = 0x32
    CVL100GBaseCR4 = 0x33
    CVL100GBaseSR4 = 0x34
    CVL100GBaseLR4 = 0x35
    CVL100GBaseKR4 = 0x36
    CVL100GCAUI4AOC_ACC = 0x37
    CVL100GCAUI4 = 0x38
    CVL100GAUI4AOC_ACC = 0x39
    CVL100GAUI4 = 0x3A
    CVL100GBaseKR4PAM4 = 0x3C
    CVL100GBaseCP2 = 0x3D
    CVL100GBaseSR2 = 0x3E
    CVL100GBaseDR = 0x3F
    CVL100GBaseKR2PAM4 = 0x40
    CVL100GAUI2AOC_ACC = 0x43
    CVL100GAUI2 = 0x44
    CVL200GBaseCR4PAM4 = 0x45
    CVL200GBaseSR4 = 0x46
    CVL200GBaseFR4 = 0x47
    CVL200GBaseLR4 = 0x48
    CVL200GBaseDR4 = 0x49
    CVL200GBaseKR4PAM4 = 0x4A
    CVL200GAUI4AOC_ACC = 0x4B
    CVL200GAUI4 = 0x4C
    CVL200GAUI8AOC_ACC = 0x4D
    CVL200GAUI8 = 0x4E
    CVL400GBaseFR8 = 0x4F
    CVL400GBaseLR8 = 0x50
    CVL400GBaseDR4 = 0x51
    CVL400GAUI8AOC_ACC = 0x52
    CVL400GAUI8 = 0x53
    CVLAutoNegotiation = 0x7E
    CVLOuterphydisabled = 0x7F
}

enum CPK_PHY_INFO
{
    CPK_PHYINFO_MEDIA_BACKPLANE = 1
    CPK_PHYINFO_MEDIA_QSFP      = 2
    CPK_PHYINFO_MEDIA_SFP       = 3
    CPK_PHYINFO_MEDIA_BASE_T    = 4
    CPK_PHYINFO_MEDIA_SGMII     = 5
    CPK_PHYINFO_MEDIA_FIBER     = 6
}

enum NCS_ADAPTER_MEDIA_TYPE
{
    NCS_MEDIA_UNKNOWN = 0
    NCS_MEDIA_COPPER = 1
    NCS_MEDIA_FIBER = 2
    NCS_MEDIA_PHONELINE = 3
    NCS_MEDIA_CX4COPPER = 4
    NCS_MEDIA_SFPDIRECTATTACH = 5
    NCS_MEDIA_SR_FIBER = 6
    NCS_MEDIA_LR_FIBER = 7
    NCS_MEDIA_KX4BACKPLANE = 8
    NCS_MEDIA_SERDES = 9
    NCS_MEDIA_BACKPLANE = 10
    NCS_MEDIA_XAUI = 11
    NCS_MEDIA_SFPACTIVEDIRECTATTACH = 12
    NCS_MEDIA_SWITCHHOST = 13
    NCS_MEDIA_QSFPDIRECTATTACH = 14
    NCS_MEDIA_SFP28DIRECTATTACH = 15
    NCS_MEDIA_CVL_AOC_ACC = 16
    NCS_MEDIA_CVL_Backplane_KR = 17
    NCS_MEDIA_CVL_Backplane_KR1 = 18
    NCS_MEDIA_CVL_Backplane_KR2 = 19
    NCS_MEDIA_CVL_Backplane_KR2_PAM4 = 20
    NCS_MEDIA_CVL_Backplane_KR4 = 21
    NCS_MEDIA_CVL_Backplane_KR4_PAM4 = 22
    NCS_MEDIA_CVL_Backplane_KR_PAM4 = 23
    NCS_MEDIA_CVL_Backplane_KR_S = 24
    NCS_MEDIA_CVL_Backplane_KX = 25
    NCS_MEDIA_CVL_Chip_to_Chip = 26
    NCS_MEDIA_CVL_Copper_T = 27
    NCS_MEDIA_CVL_Copper_TX = 28
    NCS_MEDIA_CVL_Direct_Attach = 29
    NCS_MEDIA_CVL_Direct_Attach_CP2 = 30
    NCS_MEDIA_CVL_Direct_Attach_CR = 31
    NCS_MEDIA_CVL_Direct_Attach_CR1 = 32
    NCS_MEDIA_CVL_Direct_Attach_CR2 = 33
    NCS_MEDIA_CVL_Direct_Attach_CR4 = 34
    NCS_MEDIA_CVL_Direct_Attach_CR_PAM4 = 35
    NCS_MEDIA_CVL_Direct_Attach_CR_S = 36
    NCS_MEDIA_CVL_Fiber_DR = 37
    NCS_MEDIA_CVL_Fiber_FR = 38
    NCS_MEDIA_CVL_Fiber_LR = 39
    NCS_MEDIA_CVL_Fiber_LR4 = 40
    NCS_MEDIA_CVL_Fiber_LX = 41
    NCS_MEDIA_CVL_Fiber_SR = 42
    NCS_MEDIA_CVL_Fiber_SR2 = 43
    NCS_MEDIA_CVL_Fiber_SR4 = 44
    NCS_MEDIA_CVL_Fiber_SX = 45
    NCS_MEDIA_CVL_Fiber_X = 46
    NCS_MEDIA_CVL_SGMII = 47
    NCS_MEDIA_CVL_Unknown = 48
    NCS_MEDIA_INTERFACE_CVL_BACKPLANE = 1000
    NCS_MEDIA_INTERFACE_CVL_QSFP = 1001
    NCS_MEDIA_INTERFACE_CVL_SFP = 1002
    NCS_MEDIA_INTERFACE_CVL_BASE_T = 1003
    NCS_MEDIA_INTERFACE_CVL_SGMII = 1004
    NCS_MEDIA_INTERFACE_CVL_FIBER = 1005
}

enum ADAPTER_CAPABILITY
{
    NCS_ADAPTER_CAP_UNKNOWN = 0
    NCS_ADAPTER_CAP_OTHER = 1
    NCS_ADAPTER_CAP_WAKE_ON_LAN = 3
    NCS_ADAPTER_CAP_FAILOVER = 4
    NCS_ADAPTER_CAP_LOADBALANCING = 5
    NCS_ADAPTER_CAP_IPSEC_OFFLOAD = 6
    NCS_ADAPTER_CAP_FEC = 9
    NCS_ADAPTER_CAP_802_3AD = 10
    NCS_ADAPTER_CAP_CHECKSUM_OFFLOAD = 11
    NCS_ADAPTER_CAP_SWITCHED_FAULT_TOLERANT = 12
    NCS_ADAPTER_CAP_TCO_CAPABILITY = 29
    NCS_ADAPTER_CAP_WAKEUP_CAPABILITIES = 30
    NCS_ADAPTER_CAP_IP_CHECKSUM_OFFLOAD = 31
    NCS_ADAPTER_CAP_SPEED_10_MBPS = 32
    NCS_ADAPTER_CAP_SPEED_100_MBPS = 33
    NCS_ADAPTER_CAP_SPEED_1000_MBPS = 34
    NCS_ADAPTER_CAP_SPEED_10000_MBPS = 35
    NCS_ADAPTER_CAP_TEAM_SUPPORT = 36
    NCS_ADAPTER_CAP_VLAN_SUPPORT = 37
    NCS_ADAPTER_CAP_VLAN_TYPE_IEEE = 38
    NCS_ADAPTER_CAP_VLAN_TYPE_ISL = 39
    NCS_ADAPTER_CAP_IDENTIFY_ADAPTER_SUPPORT = 41
    NCS_ADAPTER_CAP_CABLE_TEST_SUPPORT = 42
    NCS_ADAPTER_CAP_DIAGNOSTIC_SUPPORT = 43
    NCS_ADAPTER_CAP_FLASH_SUPPORT = 44
    NCS_ADAPTER_CAP_USAGE_SERVER = 46
    NCS_ADAPTER_CAP_VENDOR_INTEL = 47
    NCS_ADAPTER_CAP_PWMGMT_SUPPORT = 50
    NCS_ADAPTER_CAP_QUAD_PORT = 54
    NCS_ADAPTER_CAP_JUMBO_FRAMES = 56
    NCS_ADAPTER_CAP_IGP_SIGNAL_QUALITY_TEST = 58
    NCS_ADAPTER_CAP_CABLE_OFFLINE_TEST = 59
    NCS_ADAPTER_IS_A_LOM = 60
    NCS_ADAPTER_CAP_NDIS_IOAT = 61
    NCS_ADAPTER_CAP_CB_PLATFORM_IOAT = 62
    NCS_ADAPTER_CAP_ISCSI = 63
    NCS_ADAPTER_CAP_DCB = 65
    NCS_ADAPTER_CAP_FCOE = 66
    NCS_ADAPTER_CAP_KX_MODULE   = 67
    NCS_ADAPTER_CAP_VM_LOADBALANCING = 68
    NCS_ADAPTER_CAP_PERFORMANCE_PROFILE = 69
    NCS_ADAPTER_CAP_OS2BMC = 70
    NCS_ADAPTER_CAP_AMT = 71
    NCS_ADAPTER_CAP_SPEED_2500_MBPS = 72
    NCS_ADAPTER_CAP_BASIC_DMIX_SUPPORT = 73
    NCS_ADAPTER_CAP_EXTENDED_DMIX_SUPPORT = 74
    NCS_ADAPTER_CAP_SPEED_40000_MBPS = 75
    NCS_ADAPTER_CAP_NPAR_ENABLED = 76
    NCS_ADAPTER_CAP_ANS_SUPPORTED = 77
    NCS_ADAPTER_CAP_QSFP_LINK_MODE_ENABLED = 78
    NCS_ADAPTER_CAP_SPEED_25000_MBPS = 79
    NCS_ADAPTER_CAP_NPAR_CAPABLE = 80
    NCS_ADAPTER_CAP_SPEED_5000_MBPS = 81
    NCS_ADAPTER_CAP_SPEED_50000_MBPS = 82
    NCS_ADAPTER_CAP_SPEED_100000_MBPS = 83
    NCS_ADAPTER_CAP_CYPRESS = 84
}

# SIG # Begin signature block
# MIIo6QYJKoZIhvcNAQcCoIIo2jCCKNYCAQExDzANBglghkgBZQMEAgEFADB5Bgor
# BgEEAYI3AgEEoGswaTA0BgorBgEEAYI3AgEeMCYCAwEAAAQQH8w7YFlLCE63JNLG
# KX7zUQIBAAIBAAIBAAIBAAIBADAxMA0GCWCGSAFlAwQCAQUABCDNn4rZGlg9rGbR
# qtHhmKH2oKUmuwXfpOJpMp1wSrFgxKCCEgUwggWeMIIEhqADAgECAhEAzS1l4rws
# CIvYBjRVawV4ujANBgkqhkiG9w0BAQsFADB8MQswCQYDVQQGEwJHQjEbMBkGA1UE
# CBMSR3JlYXRlciBNYW5jaGVzdGVyMRAwDgYDVQQHEwdTYWxmb3JkMRgwFgYDVQQK
# Ew9TZWN0aWdvIExpbWl0ZWQxJDAiBgNVBAMTG1NlY3RpZ28gUlNBIENvZGUgU2ln
# bmluZyBDQTAeFw0yMTA0MDIwMDAwMDBaFw0yMzA0MDIyMzU5NTlaMIGEMQswCQYD
# VQQGEwJVUzETMBEGA1UECAwKQ2FsaWZvcm5pYTEUMBIGA1UEBwwLU2FudGEgQ2xh
# cmExGjAYBgNVBAoMEUludGVsIENvcnBvcmF0aW9uMRIwEAYDVQQLDAlTb2xhcktN
# Q1MxGjAYBgNVBAMMEUludGVsIENvcnBvcmF0aW9uMIIBojANBgkqhkiG9w0BAQEF
# AAOCAY8AMIIBigKCAYEA7CCN9iKpDHOrRceKhlXFP/tf6Lllw2H2fR9KVI4/fQIx
# MU1hXwnlHmAzMCY7IgcCFY4p3F5/MJGKaqYngwOo28Zo6Q1N6ukysA7PSavmF2RY
# WD6VFeya/2H0PoNeRFjHaRzSeynFFeJAFew9r7UReUwM/507sxZYPQuWWIdAEK7H
# Dqp2VlHmgZOXVGHhNO6GFOKpC/C01g6X3x6OquddRNMt5UrZzZzDo5MpJz9SBB2V
# jiqwZ80dvNR2W2xi90cIHh4BkXvB54UNkp4VTVu16T0k3cweo+C39U7GrCAr5Axz
# DETjBvhNtP1sf9SoRV7xY6g5wssfI7yYT9J0gsifn/Vy8MWH355TPoA+PVhbAu0m
# 9FMz4EWu55nnUurNML2jaUxsos21/7ELat12kWC0tq9fhkODjKO8X9PuiBHflZLk
# d3F4QcSMvuGocWGqE77VV3vn8jlvigm2TOV0CfGTQajGMX0jeTRZ19fzBNkt2X9d
# SSGolI/Kj1gSvCggpkUBAgMBAAGjggGQMIIBjDAfBgNVHSMEGDAWgBQO4TqoUzox
# 1Yq+wbutZxoDha00DjAdBgNVHQ4EFgQUshkNuM2SdwJnW4vFy8c4FtUTrbQwDgYD
# VR0PAQH/BAQDAgeAMAwGA1UdEwEB/wQCMAAwEwYDVR0lBAwwCgYIKwYBBQUHAwMw
# EQYJYIZIAYb4QgEBBAQDAgQQMEoGA1UdIARDMEEwNQYMKwYBBAGyMQECAQMCMCUw
# IwYIKwYBBQUHAgEWF2h0dHBzOi8vc2VjdGlnby5jb20vQ1BTMAgGBmeBDAEEATBD
# BgNVHR8EPDA6MDigNqA0hjJodHRwOi8vY3JsLnNlY3RpZ28uY29tL1NlY3RpZ29S
# U0FDb2RlU2lnbmluZ0NBLmNybDBzBggrBgEFBQcBAQRnMGUwPgYIKwYBBQUHMAKG
# Mmh0dHA6Ly9jcnQuc2VjdGlnby5jb20vU2VjdGlnb1JTQUNvZGVTaWduaW5nQ0Eu
# Y3J0MCMGCCsGAQUFBzABhhdodHRwOi8vb2NzcC5zZWN0aWdvLmNvbTANBgkqhkiG
# 9w0BAQsFAAOCAQEAVadLNRW4f/pKMqrbn0BdOoQ8/1EJ87gvVfosei2bLwTEvpmv
# mn2n561H6AFedtIJ6L4FmXII4M4r20i+5LREbI6PpKDmOAf4xW7POxfCRvkTQAZO
# 3zoVxjMQBXo7cZVF1xHCdviXzD1usuIiCF8DLm6z4O/kyeFFNcn816yPQct91Pnk
# SBBVvL+Kwu8xvR+ZIQy632WUA4HnNpRdFnVSzUifEg2GrtsKZR8k+rm2o8K8yjJq
# 3SznwgJQCMVMh3CtRtUwE/c7o/6rvm53fTYJDd3aoPHVgH6S2WqS3+3mQG7A6hTD
# nrP/mYnS4PF7XzxxjZhUlhy4G/MarJPvT9IrNDCCBfUwggPdoAMCAQICEB2iSDBv
# myYY0ILgln0z02owDQYJKoZIhvcNAQEMBQAwgYgxCzAJBgNVBAYTAlVTMRMwEQYD
# VQQIEwpOZXcgSmVyc2V5MRQwEgYDVQQHEwtKZXJzZXkgQ2l0eTEeMBwGA1UEChMV
# VGhlIFVTRVJUUlVTVCBOZXR3b3JrMS4wLAYDVQQDEyVVU0VSVHJ1c3QgUlNBIENl
# cnRpZmljYXRpb24gQXV0aG9yaXR5MB4XDTE4MTEwMjAwMDAwMFoXDTMwMTIzMTIz
# NTk1OVowfDELMAkGA1UEBhMCR0IxGzAZBgNVBAgTEkdyZWF0ZXIgTWFuY2hlc3Rl
# cjEQMA4GA1UEBxMHU2FsZm9yZDEYMBYGA1UEChMPU2VjdGlnbyBMaW1pdGVkMSQw
# IgYDVQQDExtTZWN0aWdvIFJTQSBDb2RlIFNpZ25pbmcgQ0EwggEiMA0GCSqGSIb3
# DQEBAQUAA4IBDwAwggEKAoIBAQCGIo0yhXoYn0nwli9jCB4t3HyfFM/jJrYlZilA
# hlRGdDFixRDtsocnppnLlTDAVvWkdcapDlBipVGREGrgS2Ku/fD4GKyn/+4uMyD6
# DBmJqGx7rQDDYaHcaWVtH24nlteXUYam9CflfGqLlR5bYNV+1xaSnAAvaPeX7Wpy
# vjg7Y96Pv25MQV0SIAhZ6DnNj9LWzwa0VwW2TqE+V2sfmLzEYtYbC43HZhtKn52B
# xHJAteJf7wtF/6POF6YtVbC3sLxUap28jVZTxvC6eVBJLPcDuf4vZTXyIuosB69G
# 2flGHNyMfHEo8/6nxhTdVZFuihEN3wYklX0Pp6F8OtqGNWHTAgMBAAGjggFkMIIB
# YDAfBgNVHSMEGDAWgBRTeb9aqitKz1SA4dibwJ3ysgNmyzAdBgNVHQ4EFgQUDuE6
# qFM6MdWKvsG7rWcaA4WtNA4wDgYDVR0PAQH/BAQDAgGGMBIGA1UdEwEB/wQIMAYB
# Af8CAQAwHQYDVR0lBBYwFAYIKwYBBQUHAwMGCCsGAQUFBwMIMBEGA1UdIAQKMAgw
# BgYEVR0gADBQBgNVHR8ESTBHMEWgQ6BBhj9odHRwOi8vY3JsLnVzZXJ0cnVzdC5j
# b20vVVNFUlRydXN0UlNBQ2VydGlmaWNhdGlvbkF1dGhvcml0eS5jcmwwdgYIKwYB
# BQUHAQEEajBoMD8GCCsGAQUFBzAChjNodHRwOi8vY3J0LnVzZXJ0cnVzdC5jb20v
# VVNFUlRydXN0UlNBQWRkVHJ1c3RDQS5jcnQwJQYIKwYBBQUHMAGGGWh0dHA6Ly9v
# Y3NwLnVzZXJ0cnVzdC5jb20wDQYJKoZIhvcNAQEMBQADggIBAE1jUO1HNEphpNve
# aiqMm/EAAB4dYns61zLC9rPgY7P7YQCImhttEAcET7646ol4IusPRuzzRl5ARokS
# 9At3WpwqQTr81vTr5/cVlTPDoYMot94v5JT3hTODLUpASL+awk9KsY8k9LOBN9O3
# ZLCmI2pZaFJCX/8E6+F0ZXkI9amT3mtxQJmWunjxucjiwwgWsatjWsgVgG10Xkp1
# fqW4w2y1z99KeYdcx0BNYzX2MNPPtQoOCwR/oEuuu6Ol0IQAkz5TXTSlADVpbL6f
# ICUQDRn7UJBhvjmPeo5N9p8OHv4HURJmgyYZSJXOSsnBf/M6BZv5b9+If8AjntIe
# Q3pFMcGcTanwWbJZGehqjSkEAnd8S0vNcL46slVaeD68u28DECV3FTSK+TbMQ5Lk
# uk/xYpMoJVcp+1EZx6ElQGqEV8aynbG8HArafGd+fS7pKEwYfsR7MUFxmksp7As9
# V1DSyt39ngVR5UR43QHesXWYDVQk/fBO4+L4g71yuss9Ou7wXheSaG3IYfmm8SoK
# C6W59J7umDIFhZ7r+YMp08Ysfb06dy6LN0KgaoLtO0qqlBCk4Q34F8W2WnkzGJLj
# tXX4oemOCiUe5B7xn1qHI/+fpFGe+zmAEc3btcSnqIBv5VPU4OOiwtJbGvoyJi1q
# V3AcPKRYLqPzW0sH3DJZ84enGm1YMIIGZjCCBE6gAwIBAgITMwAAAES3P/zvWs+i
# egAAAAAARDANBgkqhkiG9w0BAQUFADB/MQswCQYDVQQGEwJVUzETMBEGA1UECBMK
# V2FzaGluZ3RvbjEQMA4GA1UEBxMHUmVkbW9uZDEeMBwGA1UEChMVTWljcm9zb2Z0
# IENvcnBvcmF0aW9uMSkwJwYDVQQDEyBNaWNyb3NvZnQgQ29kZSBWZXJpZmljYXRp
# b24gUm9vdDAeFw0xNTA3MjIyMTAzNDlaFw0yNTA3MjIyMTAzNDlaMIGIMQswCQYD
# VQQGEwJVUzETMBEGA1UECBMKTmV3IEplcnNleTEUMBIGA1UEBxMLSmVyc2V5IENp
# dHkxHjAcBgNVBAoTFVRoZSBVU0VSVFJVU1QgTmV0d29yazEuMCwGA1UEAxMlVVNF
# UlRydXN0IFJTQSBDZXJ0aWZpY2F0aW9uIEF1dGhvcml0eTCCAiIwDQYJKoZIhvcN
# AQEBBQADggIPADCCAgoCggIBAIASZRc2DsPbCLPQrFcNdu3NJ9NMrVCDYeKqIE0J
# LWQJ3M6Jn8w9qez2z8Hc8dOx1ns3KBErR9o5xrw6GbRfpr19naNjQrZ28qk7K5H4
# 4m/Q7BYgkAk+4uh0yRi0kdRiZNt/owbxiBhqkCI8vP4T8IcUe/bkH47U5FHGEWdG
# CFHLhhRUP7wz/n5snP8WnRi9UY41pqdmyHJn2yFmsdSbeAPAUDrozPDcvJ5M/q8F
# ljUfV1q3/875PbcstvZU3cjnEjpNrkyKt1yatLcgPcp/IjSufjtoZgFE5wFORlOb
# M2D3lL5TN5BzQ/Myw1Pv26r+dE5px2uMYJPexMcM3+EyrsyTO1F4lWeL7j1W/gzQ
# aQ8bD/MlJmszbfduR/pzQ+V+DqVmsSl8MoRjVYnEDcGTVDAZE6zTfTen6106bDVc
# 20HXEtqpSQvf2ICKCZNijrVmzyWIzYS4sT+kOQ/ZAp7rEkyVfPNrBaleFoPMuGfi
# 6BOdzFuC00yz7Vv/3uVzrCM7LQC/NVV0CUnYSVgaf5I25lGSDvMmfRxNF7zJ7EMm
# 0L9BX0CpRET0medXh55QH1dUqD79dGMvsVBlCeZYQi5DGky08CVHWfoEHpPUJkZK
# UIGy3r54t/xnFeHJV4QeD2PW6WK61l9VLupcxigIBCU5uA4rqfJMlxwHPw1S9e3v
# L4IPAgMBAAGjgdAwgc0wEwYDVR0lBAwwCgYIKwYBBQUHAwMwEgYDVR0TAQH/BAgw
# BgEB/wIBAjAdBgNVHQ4EFgQUU3m/WqorSs9UgOHYm8Cd8rIDZsswCwYDVR0PBAQD
# AgGGMB8GA1UdIwQYMBaAFGL7CiFbf0NuEdoJVFBr9dKWcfGeMFUGA1UdHwROMEww
# SqBIoEaGRGh0dHA6Ly9jcmwubWljcm9zb2Z0LmNvbS9wa2kvY3JsL3Byb2R1Y3Rz
# L01pY3Jvc29mdENvZGVWZXJpZlJvb3QuY3JsMA0GCSqGSIb3DQEBBQUAA4ICAQBr
# IpM8PTlUcWRrDvLkPDARxSBKS4YPkvH/M3k62eSYpw5AoCKAfmGy4KcZzyaVMSpl
# 1GpPMYbqwMYuxWSMPUhZzQsvdD2UJhMQQtSXmCdePHbSeGkdGmTnBXJ14OtmQEOf
# jwxG/5dgpshnrRAIm2Km6b46itMHTZ9ykyW8BhHgLJA4Pmcc/RnXnpDOPcLg52Gs
# wOUE9R6ZVAyRDQFWcTeuJ9SeQyKlySfNTeVxEjkkpUFWh/+8VRQPJcqJ7seX5dIT
# /z1+GqCPP8gs16Nw0MdgwPzYPlHnl8Y+O+3PeL6KyuPE8qen7Z6uCAKPoFLbch7V
# O8NNn476m3DH+OO/bD+Sm+Q3PuxqjCn5waK/iz4aaWb7HGNPJgHJAsQ+0v/DQ6gb
# /Zn61LylueKTLzsBxdH0Oi9ow+Bkt1qVXkbMB4NpuzwFklZzNXNFmE582BKlt0Lp
# omP2QmAYcNE7bzHAh8fmceHzRhbp9bhys+ltH2ImSaNJi91ox4toVvfe/PqHJLgD
# gReP5fFnah2u03T3jKVdswuOQimWzknEd35mfAEXGmwUJMOwF3cF2BpAt4Zr2OR7
# QKx+305vJPkggIKMM+fl+inYndqLcF0ryR2CTAtny4RBnucGfhGDRC2KGe70f5rd
# eRw3GR6fP4wpug1cEIY3bEjNRV3NcLy80U1d2MW4djGCFjowghY2AgEBMIGRMHwx
# CzAJBgNVBAYTAkdCMRswGQYDVQQIExJHcmVhdGVyIE1hbmNoZXN0ZXIxEDAOBgNV
# BAcTB1NhbGZvcmQxGDAWBgNVBAoTD1NlY3RpZ28gTGltaXRlZDEkMCIGA1UEAxMb
# U2VjdGlnbyBSU0EgQ29kZSBTaWduaW5nIENBAhEAzS1l4rwsCIvYBjRVawV4ujAN
# BglghkgBZQMEAgEFAKBqMBkGCSqGSIb3DQEJAzEMBgorBgEEAYI3AgEEMBwGCisG
# AQQBgjcCAQsxDjAMBgorBgEEAYI3AgEWMC8GCSqGSIb3DQEJBDEiBCAMn2+d34I6
# +2daAt+LIoqhgUvR3Pyecd5hOCV8j2S+ITANBgkqhkiG9w0BAQEFAASCAYBgiY6y
# 0REeV2GGl65xJ3UgpmF3aZ3c0XSYdJ3o9Yhbr7FPUwFv8w3JJffb17aHVMPsW+NO
# FBpEGiXKqAhh+Wg7+zmi1QRM0dYu51scqlTeXUWqW2uKTDAHj25+G4T8Njav6F/P
# 1F37LPesRRI6t2sQeov2r0rAQR2hCLM5CwZiNvOSfQxzHQBcckDJnL3D1QXko8mQ
# jw6xwWEbLQL8TqXpbD2WcBms0QaWIWdOxCmQeUqCxKW8FRP5fZsLTeslyMxMHs9o
# PDnIJwu5KGxxyGDz21X3ls09WrMw0AtdCpfVNAdo5WOB2H+yOjYLZUbhukA4Twbg
# 064nZXROgakqd9DmoTJ94p4ryZhazTWRXjc4CzwzlNmMcJUjxzN1QA72no91ZBXA
# JELK5cTNspNgguFQ5TpYXlg4ABZgCTBj5blWmPfzI1BdgL9Z8zZAFJ3qQ0lYYm97
# UNJaDb08UCUC4pvII6UJykn7UNsWosOVM+PxjUbXfLhg5a6t49IQZaQg0sahghON
# MIITiQYKKwYBBAGCNwMDATGCE3kwghN1BgkqhkiG9w0BBwKgghNmMIITYgIBAzEP
# MA0GCWCGSAFlAwQCAgUAMIIBGgYLKoZIhvcNAQkQAQSgggEJBIIBBTCCAQECAQEG
# CisGAQQBsjECAQEwMTANBglghkgBZQMEAgEFAAQgFGR6DNeK0di3iFfUwQ+Fo7xl
# khQbCarVlNi6SnIZ+rQCFQD2uCDAbu0IOvN64poXfIGsItPqLxgPMjAyMjA1MTcw
# NzI4MTVaAghHO2co0KO8z6CBiqSBhzCBhDELMAkGA1UEBhMCR0IxGzAZBgNVBAgT
# EkdyZWF0ZXIgTWFuY2hlc3RlcjEQMA4GA1UEBxMHU2FsZm9yZDEYMBYGA1UEChMP
# U2VjdGlnbyBMaW1pdGVkMSwwKgYDVQQDDCNTZWN0aWdvIFJTQSBUaW1lIFN0YW1w
# aW5nIFNpZ25lciAjMqCCDfswggcHMIIE76ADAgECAhEAjHegAI/00bDGPZ86SION
# azANBgkqhkiG9w0BAQwFADB9MQswCQYDVQQGEwJHQjEbMBkGA1UECBMSR3JlYXRl
# ciBNYW5jaGVzdGVyMRAwDgYDVQQHEwdTYWxmb3JkMRgwFgYDVQQKEw9TZWN0aWdv
# IExpbWl0ZWQxJTAjBgNVBAMTHFNlY3RpZ28gUlNBIFRpbWUgU3RhbXBpbmcgQ0Ew
# HhcNMjAxMDIzMDAwMDAwWhcNMzIwMTIyMjM1OTU5WjCBhDELMAkGA1UEBhMCR0Ix
# GzAZBgNVBAgTEkdyZWF0ZXIgTWFuY2hlc3RlcjEQMA4GA1UEBxMHU2FsZm9yZDEY
# MBYGA1UEChMPU2VjdGlnbyBMaW1pdGVkMSwwKgYDVQQDDCNTZWN0aWdvIFJTQSBU
# aW1lIFN0YW1waW5nIFNpZ25lciAjMjCCAiIwDQYJKoZIhvcNAQEBBQADggIPADCC
# AgoCggIBAJGHSyyLwfEeoJ7TB8YBylKwvnl5XQlmBi0vNX27wPsn2kJqWRslTOrv
# QNaafjLIaoF9tFw+VhCBNToiNoz7+CAph6x00BtivD9khwJf78WA7wYc3F5Ok4e4
# mt5MB06FzHDFDXvsw9njl+nLGdtWRWzuSyBsyT5s/fCb8Sj4kZmq/FrBmoIgOrfv
# 59a4JUnCORuHgTnLw7c6zZ9QBB8amaSAAk0dBahV021SgIPmbkilX8GJWGCK7/Gs
# zYdjGI50y4SHQWljgbz2H6p818FBzq2rdosggNQtlQeNx/ULFx6a5daZaVHHTqad
# KW/neZMNMmNTrszGKYogwWDG8gIsxPnIIt/5J4Khg1HCvMmCGiGEspe81K9EHJaC
# IpUqhVSu8f0+SXR0/I6uP6Vy9MNaAapQpYt2lRtm6+/a35Qu2RrrTCd9TAX3+CNd
# xFfIJgV6/IEjX1QJOCpi1arK3+3PU6sf9kSc1ZlZxVZkW/eOUg9m/Jg/RAYTZG7p
# 4RVgUKWx7M+46MkLvsWE990Kndq8KWw9Vu2/eGe2W8heFBy5r4Qtd6L3OZU3b05/
# HMY8BNYxxX7vPehRfnGtJHQbLNz5fKrvwnZJaGLVi/UD3759jg82dUZbk3bEg+6C
# viyuNxLxvFbD5K1Dw7dmll6UMvqg9quJUPrOoPMIgRrRRKfM97gxAgMBAAGjggF4
# MIIBdDAfBgNVHSMEGDAWgBQaofhhGSAPw0F3RSiO0TVfBhIEVTAdBgNVHQ4EFgQU
# aXU3e7udNUJOv1fTmtufAdGu3tAwDgYDVR0PAQH/BAQDAgbAMAwGA1UdEwEB/wQC
# MAAwFgYDVR0lAQH/BAwwCgYIKwYBBQUHAwgwQAYDVR0gBDkwNzA1BgwrBgEEAbIx
# AQIBAwgwJTAjBggrBgEFBQcCARYXaHR0cHM6Ly9zZWN0aWdvLmNvbS9DUFMwRAYD
# VR0fBD0wOzA5oDegNYYzaHR0cDovL2NybC5zZWN0aWdvLmNvbS9TZWN0aWdvUlNB
# VGltZVN0YW1waW5nQ0EuY3JsMHQGCCsGAQUFBwEBBGgwZjA/BggrBgEFBQcwAoYz
# aHR0cDovL2NydC5zZWN0aWdvLmNvbS9TZWN0aWdvUlNBVGltZVN0YW1waW5nQ0Eu
# Y3J0MCMGCCsGAQUFBzABhhdodHRwOi8vb2NzcC5zZWN0aWdvLmNvbTANBgkqhkiG
# 9w0BAQwFAAOCAgEASgN4kEIz7Hsagwk2M5hVu51ABjBrRWrxlA4ZUP9bJV474TnE
# W7rplZA3N73f+2Ts5YK3lcxXVXBLTvSoh90ihaZXu7ghJ9SgKjGUigchnoq9pxr1
# AhXLRFCZjOw+ugN3poICkMIuk6m+ITR1Y7ngLQ/PATfLjaL6uFqarqF6nhOTGVWP
# CZAu3+qIFxbradbhJb1FCJeA11QgKE/Ke7OzpdIAsGA0ZcTjxcOl5LqFqnpp23Wk
# PnlomjaLQ6421GFyPA6FYg2gXnDbZC8Bx8GhxySUo7I8brJeotD6qNG4JRwW5sDV
# f2gaxGUpNSotiLzqrnTWgufAiLjhT3jwXMrAQFzCn9UyHCzaPKw29wZSmqNAMBew
# KRaZyaq3iEn36AslM7U/ba+fXwpW3xKxw+7OkXfoIBPpXCTH6kQLSuYThBxN6w21
# uIagMKeLoZ+0LMzAFiPJkeVCA0uAzuRN5ioBPsBehaAkoRdA1dvb55gQpPHqGRuA
# VPpHieiYgal1wA7f0GiUeaGgno62t0Jmy9nZay9N2N4+Mh4g5OycTUKNncczmYI3
# RNQmKSZAjngvue76L/Hxj/5QuHjdFJbeHA5wsCqFarFsaOkq5BArbiH903ydN+Qq
# BtbD8ddo408HeYEIE/6yZF7psTzm0Hgjsgks4iZivzupl1HMx0QygbKvz98wggbs
# MIIE1KADAgECAhAwD2+s3WaYdHypRjaneC25MA0GCSqGSIb3DQEBDAUAMIGIMQsw
# CQYDVQQGEwJVUzETMBEGA1UECBMKTmV3IEplcnNleTEUMBIGA1UEBxMLSmVyc2V5
# IENpdHkxHjAcBgNVBAoTFVRoZSBVU0VSVFJVU1QgTmV0d29yazEuMCwGA1UEAxMl
# VVNFUlRydXN0IFJTQSBDZXJ0aWZpY2F0aW9uIEF1dGhvcml0eTAeFw0xOTA1MDIw
# MDAwMDBaFw0zODAxMTgyMzU5NTlaMH0xCzAJBgNVBAYTAkdCMRswGQYDVQQIExJH
# cmVhdGVyIE1hbmNoZXN0ZXIxEDAOBgNVBAcTB1NhbGZvcmQxGDAWBgNVBAoTD1Nl
# Y3RpZ28gTGltaXRlZDElMCMGA1UEAxMcU2VjdGlnbyBSU0EgVGltZSBTdGFtcGlu
# ZyBDQTCCAiIwDQYJKoZIhvcNAQEBBQADggIPADCCAgoCggIBAMgbAa/ZLH6ImX0B
# mD8gkL2cgCFUk7nPoD5T77NawHbWGgSlzkeDtevEzEk0y/NFZbn5p2QWJgn71TJS
# eS7JY8ITm7aGPwEFkmZvIavVcRB5h/RGKs3EWsnb111JTXJWD9zJ41OYOioe/M5Y
# SdO/8zm7uaQjQqzQFcN/nqJc1zjxFrJw06PE37PFcqwuCnf8DZRSt/wflXMkPQEo
# vA8NT7ORAY5unSd1VdEXOzQhe5cBlK9/gM/REQpXhMl/VuC9RpyCvpSdv7QgsGB+
# uE31DT/b0OqFjIpWcdEtlEzIjDzTFKKcvSb/01Mgx2Bpm1gKVPQF5/0xrPnIhRfH
# uCkZpCkvRuPd25Ffnz82Pg4wZytGtzWvlr7aTGDMqLufDRTUGMQwmHSCIc9iVrUh
# cxIe/arKCFiHd6QV6xlV/9A5VC0m7kUaOm/N14Tw1/AoxU9kgwLU++Le8bwCKPRt
# 2ieKBtKWh97oaw7wW33pdmmTIBxKlyx3GSuTlZicl57rjsF4VsZEJd8GEpoGLZ8D
# Xv2DolNnyrH6jaFkyYiSWcuoRsDJ8qb/fVfbEnb6ikEk1Bv8cqUUotStQxykSYtB
# ORQDHin6G6UirqXDTYLQjdprt9v3GEBXc/Bxo/tKfUU2wfeNgvq5yQ1TgH36tjlY
# Mu9vGFCJ10+dM70atZ2h3pVBeqeDAgMBAAGjggFaMIIBVjAfBgNVHSMEGDAWgBRT
# eb9aqitKz1SA4dibwJ3ysgNmyzAdBgNVHQ4EFgQUGqH4YRkgD8NBd0UojtE1XwYS
# BFUwDgYDVR0PAQH/BAQDAgGGMBIGA1UdEwEB/wQIMAYBAf8CAQAwEwYDVR0lBAww
# CgYIKwYBBQUHAwgwEQYDVR0gBAowCDAGBgRVHSAAMFAGA1UdHwRJMEcwRaBDoEGG
# P2h0dHA6Ly9jcmwudXNlcnRydXN0LmNvbS9VU0VSVHJ1c3RSU0FDZXJ0aWZpY2F0
# aW9uQXV0aG9yaXR5LmNybDB2BggrBgEFBQcBAQRqMGgwPwYIKwYBBQUHMAKGM2h0
# dHA6Ly9jcnQudXNlcnRydXN0LmNvbS9VU0VSVHJ1c3RSU0FBZGRUcnVzdENBLmNy
# dDAlBggrBgEFBQcwAYYZaHR0cDovL29jc3AudXNlcnRydXN0LmNvbTANBgkqhkiG
# 9w0BAQwFAAOCAgEAbVSBpTNdFuG1U4GRdd8DejILLSWEEbKw2yp9KgX1vDsn9Fqg
# uUlZkClsYcu1UNviffmfAO9Aw63T4uRW+VhBz/FC5RB9/7B0H4/GXAn5M17qoBwm
# WFzztBEP1dXD4rzVWHi/SHbhRGdtj7BDEA+N5Pk4Yr8TAcWFo0zFzLJTMJWk1vSW
# Vgi4zVx/AZa+clJqO0I3fBZ4OZOTlJux3LJtQW1nzclvkD1/RXLBGyPWwlWEZuSz
# xWYG9vPWS16toytCiiGS/qhvWiVwYoFzY16gu9jc10rTPa+DBjgSHSSHLeT8AtY+
# dwS8BDa153fLnC6NIxi5o8JHHfBd1qFzVwVomqfJN2Udvuq82EKDQwWli6YJ/9Gh
# lKZOqj0J9QVst9JkWtgqIsJLnfE5XkzeSD2bNJaaCV+O/fexUpHOP4n2HKG1qXUf
# cb9bQ11lPVCBbqvw0NP8srMftpmWJvQ8eYtcZMzN7iea5aDADHKHwW5NWtMe6vBE
# 5jJvHOsXTpTDeGUgOw9Bqh/poUGd/rG4oGUqNODeqPk85sEwu8CgYyz8XBYAqNDE
# f+oRnR4GxqZtMl20OAkrSQeq/eww2vGnL8+3/frQo4TZJ577AWZ3uVYQ4SBuxq6x
# +ba6yDVdM3aO8XwgDCp3rrWiAoa6Ke60WgCxjKvj+QrJVF3UuWp0nr1IrpgxggQt
# MIIEKQIBATCBkjB9MQswCQYDVQQGEwJHQjEbMBkGA1UECBMSR3JlYXRlciBNYW5j
# aGVzdGVyMRAwDgYDVQQHEwdTYWxmb3JkMRgwFgYDVQQKEw9TZWN0aWdvIExpbWl0
# ZWQxJTAjBgNVBAMTHFNlY3RpZ28gUlNBIFRpbWUgU3RhbXBpbmcgQ0ECEQCMd6AA
# j/TRsMY9nzpIg41rMA0GCWCGSAFlAwQCAgUAoIIBazAaBgkqhkiG9w0BCQMxDQYL
# KoZIhvcNAQkQAQQwHAYJKoZIhvcNAQkFMQ8XDTIyMDUxNzA3MjgxNVowPwYJKoZI
# hvcNAQkEMTIEMEal+sBhnLY7u5DximXXr37DRmd9ujYFEYHY9n3oGb8mzjCRtM7R
# 5Ma2JsvMiD5d5jCB7QYLKoZIhvcNAQkQAgwxgd0wgdowgdcwFgQUlRE3EB2ILzG9
# UT+UmtpMaK2MCPUwgbwEFALWW5Xig3DBVwCV+oj5I92Tf62PMIGjMIGOpIGLMIGI
# MQswCQYDVQQGEwJVUzETMBEGA1UECBMKTmV3IEplcnNleTEUMBIGA1UEBxMLSmVy
# c2V5IENpdHkxHjAcBgNVBAoTFVRoZSBVU0VSVFJVU1QgTmV0d29yazEuMCwGA1UE
# AxMlVVNFUlRydXN0IFJTQSBDZXJ0aWZpY2F0aW9uIEF1dGhvcml0eQIQMA9vrN1m
# mHR8qUY2p3gtuTANBgkqhkiG9w0BAQEFAASCAgApNqluFdeICsJLH2KyZmhbV5Y/
# z5si7w6oam3/83CqdG8bYjzA500FVXgIokVfaeMTA6EQqFv7A121vnyn7OEfzyvj
# V/hL2KeXD3L9wVJSO/SHCWU36hjTGfCUeLPQ8SQA8oxs5sD3qONTLfz204QvXi0r
# gQZWh5cGZnKwzIVqJCSU5JxT/n71kVsJAzlNL82QiJvXKjiz5gXm0nOxDVvJ+whN
# ScgTMYdP5ZV1Klkb5FSkablUVUb8r+GnH6A8Z9d/UzoHLF4bipUG+3pmC4AAeUC1
# JRSQ1NYXgFHNZ2Va2cisIPTSMkfFcSfpLxidUThtM+ACxp/E615CR65CJS8+SYSu
# jVMIlXanfRuJLPIb0yskQV2bCjBVjSgq8a3P0jMVaay7p27gNqKCeIqrTlXhvxP5
# 261FtfXWrahKb3I9n+wq+2nF0JK5PjOKeDRe12XycddiF3ikqW2c07fZVyG8a3Jq
# 7EqvO1dpeBtieo+xDjRKAqIDcxP21jDkeu6WflJ32X1hkW40S6IrGBlPXOC4vL1O
# VG/R+8CSJIgdrbe7aTWkYPzL1BKKC6iCvKZvIGiPlUmCvaS2pF0jIn883L7X9joH
# t01zFrcBuAT4gwe+tKlIvi+5KMmdP3dzUDw53TLu3v4+ELg0WbhvlaIxo9WAqfec
# o5A8gzrX/kCTzcCshg==
# SIG # End signature block
