/*
 * Decompiled with CFR 0.152.
 */
package pdtEditor.gui.configuration;

import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wb.swt.SWTResourceManager;
import pdtEditor.DataStore;
import pdtEditor.Sensor;
import pdtEditor.gui.GuiUtils;
import pdtEditor.gui.InterruptsModifierOpener;
import pdtEditor.gui.SensorModifier;
import pdtEditor.gui.configuration.ConfigurationEditor;
import pdtEditor.gui.configuration.LidModeConfigurationModifier;
import pdtEditor.payloads.Payload;
import pdtEditor.payloads.calibrations.CalibrationPayload;
import pdtEditor.payloads.configurations.LidModeConfigurationPayload;
import pdtEditor.payloads.configurations.OnlookerDetectionConfigurationPayload;
import resources.CustomSpinner;

public class OnlookerDetectionConfiguration
implements InterruptsModifierOpener,
ConfigurationEditor {
    private static final int DEFAULT_PLM_ROW_CONTROL_COUNT = 6;
    private static final int DEFAULT_PLM_ROW_COUNT = 1;
    protected Shell shell;
    private Display display;
    private SensorModifier parent;
    private boolean _modified = false;
    private DataStore _dataStore;
    private OnlookerDetectionConfigurationPayload _payload;
    private ArrayList<Integer> modeIdList = new ArrayList();
    private Combo cmbFormatId;
    private CustomSpinner spnVersion;
    private CustomSpinner spnHingeLow;
    private CustomSpinner spnHingeHigh;
    private Button chkScreenAngle;
    private Button chkPlmModeIdGroup;
    private Button chkHingeAngle;
    private Group grpPlmModeId;
    private CustomSpinner spnScreenAngleLow;
    private CustomSpinner spnScreenAngleHigh;

    public OnlookerDetectionConfiguration(SensorModifier parentWindow, OnlookerDetectionConfigurationPayload payload, Sensor sensor) {
        this.parent = parentWindow;
        this._payload = payload;
        this._dataStore = DataStore.getInstance();
        this.modeIdList = this.getSupportPlmModeIds();
    }

    @Override
    public String getConfigurationFormatName() {
        return "Onlooker Detection Configuration";
    }

    @Override
    public void open() {
        this.display = Display.getDefault();
        this.createContents();
        this.fillData();
        this.shell.open();
        this.shell.layout();
        while (!this.shell.isDisposed()) {
            if (this.display.readAndDispatch()) continue;
            this.display.sleep();
        }
    }

    public void fillData() {
        int[] allFormatId = OnlookerDetectionConfigurationPayload.getAllSupportFormatId();
        for (int i = 0; i < allFormatId.length; ++i) {
            this.cmbFormatId.add(Integer.toString(allFormatId[i]));
            if (this._payload == null || allFormatId[i] != this._payload.getFormatID()) continue;
            this.cmbFormatId.select(i);
        }
        if (this._payload == null) {
            this.cmbFormatId.select(this.cmbFormatId.getItems().length - 1);
            this.spnVersion.setSelection(0);
            return;
        }
        this.spnHingeLow.setSelection(this._payload.hingeAngleLow);
        this.spnHingeHigh.setSelection(this._payload.hingeAngleHigh);
        if (this._payload.hingeAngleLow == 0 && this._payload.hingeAngleHigh == 360) {
            this.chkHingeAngle.setSelection(false);
            this.chkHingeAngle.notifyListeners(13, new Event());
        }
        if (this._payload.plmModeId == -1) {
            this.chkPlmModeIdGroup.setSelection(false);
            this.chkPlmModeIdGroup.notifyListeners(13, new Event());
        } else {
            this.chkPlmModeIdGroup.setSelection(true);
            this.setChildrenCheckboxBySelectedData((Composite)this.grpPlmModeId, this._payload.plmModeId);
        }
        if (this._payload.getFormatID() >= 1) {
            this.spnScreenAngleLow.setSelection(this._payload.getScreenAngleLow());
            this.spnScreenAngleHigh.setSelection(this._payload.getScreenAngleHigh());
            if (this._payload.getScreenAngleLow() == 0 && this._payload.getScreenAngleHigh() == 360) {
                this.chkScreenAngle.setSelection(false);
                this.chkScreenAngle.notifyListeners(13, new Event());
            }
        }
    }

    public ArrayList<Integer> getSupportPlmModeIds() {
        ArrayList<Payload> payloads = null;
        ArrayList<LidModeConfigurationPayload.TableEntry> tableEntries = null;
        ArrayList<Integer> supportPlmModeIds = new ArrayList<Integer>();
        if (this._dataStore.getCurrentDevice() == null) {
            return supportPlmModeIds;
        }
        ArrayList<Sensor> sensors = this._dataStore.getCurrentDevice().getSensors();
        for (Sensor sensor : sensors) {
            if (sensor.getLuid().getSensorTypeId() != 768) continue;
            payloads = sensor.getPayloads();
            break;
        }
        if (payloads == null) {
            return supportPlmModeIds;
        }
        for (Payload payload : payloads) {
            if (payload.getClass() != LidModeConfigurationPayload.class) continue;
            tableEntries = ((LidModeConfigurationPayload)payload).getTableEntries();
            break;
        }
        if (tableEntries == null) {
            return supportPlmModeIds;
        }
        for (LidModeConfigurationPayload.TableEntry entry : tableEntries) {
            supportPlmModeIds.add(entry.modeId);
        }
        return supportPlmModeIds;
    }

    @Override
    public int getGpioCount() {
        return 0;
    }

    @Override
    public int[] getGpioSelectionIndices() {
        return null;
    }

    @Override
    public HashMap<String, String> getLineValues(int lineIndex) {
        return null;
    }

    @Override
    public void addGpioToTable(String purposeID, String pinNumber, String modelGpio) {
    }

    @Override
    public void updateGpioLine(int lineIndex, HashMap<String, String> values) {
    }

    @Override
    public Shell getShell() {
        return null;
    }

    @Override
    public void setModified() {
        this._modified = true;
    }

    public void save() {
        boolean newConfiguration = false;
        if (this._payload == null) {
            this._payload = new OnlookerDetectionConfigurationPayload();
            newConfiguration = true;
        }
        if (this.chkHingeAngle.getSelection()) {
            this._payload.hingeAngleHigh = this.spnHingeHigh.getSelection();
            this._payload.hingeAngleLow = this.spnHingeLow.getSelection();
        } else {
            this._payload.hingeAngleLow = 0;
            this._payload.hingeAngleHigh = 360;
        }
        this._payload.plmModeId = this.getChildrenCheckboxSelectedDataAsInt((Composite)this.grpPlmModeId);
        if (this._payload.getFormatID() >= 1) {
            if (this.chkScreenAngle.getSelection()) {
                this._payload.setScreenAngleLow(this.spnScreenAngleLow.getSelection());
                this._payload.setScreenAngleHigh(this.spnScreenAngleHigh.getSelection());
            } else {
                this._payload.setScreenAngleLow(0);
                this._payload.setScreenAngleHigh(360);
            }
        }
        if (newConfiguration && this.parent != null) {
            this.parent.addNewConfiguration(this._payload);
        }
        this._modified = false;
        if (this.parent != null) {
            this.parent.setModified();
        }
        this.shell.close();
    }

    public void setChildrenCheckboxBySelectedData(Composite parentControl, int data) {
        Control[] child;
        for (Control control : child = parentControl.getChildren()) {
            if (control.getClass() != Button.class || (control.getStyle() & 0x20) <= 0) continue;
            int bitValue = (Integer)control.getData();
            if ((bitValue & data) > 0) {
                ((Button)control).setSelection(true);
                continue;
            }
            ((Button)control).setSelection(false);
        }
    }

    public int getChildrenCheckboxSelectedDataAsInt(Composite parentControl) {
        Control[] child = parentControl.getChildren();
        int ret = 0;
        for (Control control : child) {
            if (control.getClass() != Button.class || (control.getStyle() & 0x20) <= 0 && (control.getStyle() & 0x10) <= 0 || !((Button)control).getSelection()) continue;
            int value = (Integer)control.getData();
            ret |= value;
        }
        if (ret == 0) {
            ret = -1;
        }
        return ret;
    }

    public void upadteControlState() {
        if (Integer.valueOf(this.cmbFormatId.getText()) == 1) {
            this.chkScreenAngle.setSelection(true);
            this.chkScreenAngle.setEnabled(true);
            this.spnScreenAngleLow.setEnabled(true);
            this.spnScreenAngleHigh.setEnabled(true);
        } else {
            this.chkScreenAngle.setSelection(false);
            this.chkScreenAngle.setEnabled(false);
            this.spnScreenAngleLow.setEnabled(false);
            this.spnScreenAngleHigh.setEnabled(false);
            this.spnScreenAngleLow.setSelection(0);
            this.spnScreenAngleHigh.setSelection(360);
        }
    }

    protected void createContents() {
        int longSpinnerMinWidth;
        this.shell = new Shell(65760);
        this.shell.setImage(SWTResourceManager.getImage(LidModeConfigurationModifier.class, "/resources/Intel.ico"));
        this.shell.setText("Onlooker Detection Configuration");
        this.shell.setLayout((Layout)new GridLayout(1, false));
        Group group = GuiUtils.addGroupToComposite("", (Composite)this.shell, 4, 4, 128, false, false, 1, 1, 2);
        GuiUtils.addLabelToComposite("Calibration Format ID:", (Composite)group, 0, 16384, 0x1000000, false, false, 1, 1);
        this.cmbFormatId = GuiUtils.addComboToComposite((Composite)group, 12, 4, 16384, true, false, 1, 1);
        GuiUtils.addLabelToComposite("Calibration Version:", (Composite)group, 0, 16384, 0x1000000, false, false, 1, 1);
        this.spnVersion = GuiUtils.addCustomSpinnerToComposite(CalibrationPayload.VERSION_MAX_VALUE, this.shell, (Composite)group, 2052, 4, 0x1000000, true, false, 1, 1);
        this.cmbFormatId.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                OnlookerDetectionConfiguration.this.upadteControlState();
            }
        });
        Composite cmpScreenAngle = new Composite((Composite)this.shell, 4);
        FormLayout cmpScreenAngleLayout = new FormLayout();
        cmpScreenAngle.setLayout((Layout)cmpScreenAngleLayout);
        cmpScreenAngle.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.chkScreenAngle = new Button(cmpScreenAngle, 32);
        this.chkScreenAngle.setText("Screen Angle");
        FormData frmDataChkScreenAngleGroup = new FormData();
        this.chkScreenAngle.setLayoutData((Object)frmDataChkScreenAngleGroup);
        frmDataChkScreenAngleGroup.left = new FormAttachment();
        frmDataChkScreenAngleGroup.left.offset = 8;
        this.chkScreenAngle.setSelection(true);
        this.chkScreenAngle.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!OnlookerDetectionConfiguration.this.chkScreenAngle.getSelection()) {
                    OnlookerDetectionConfiguration.this.spnScreenAngleLow.setSelection(0);
                    OnlookerDetectionConfiguration.this.spnScreenAngleLow.setEnabled(false);
                    OnlookerDetectionConfiguration.this.spnScreenAngleHigh.setSelection(360);
                    OnlookerDetectionConfiguration.this.spnScreenAngleHigh.setEnabled(false);
                } else {
                    OnlookerDetectionConfiguration.this.spnScreenAngleLow.setEnabled(true);
                    OnlookerDetectionConfiguration.this.spnScreenAngleHigh.setEnabled(true);
                }
            }
        });
        Group grpScreenAngle = new Group(cmpScreenAngle, 4);
        FormData grpScreenAngleGroupData = new FormData();
        GridLayout grpScreenAngleGroupLayout = new GridLayout(2, false);
        grpScreenAngleGroupLayout.verticalSpacing = 15;
        grpScreenAngleGroupLayout.horizontalSpacing = 15;
        grpScreenAngle.setLayout((Layout)grpScreenAngleGroupLayout);
        grpScreenAngle.setLayoutData((Object)grpScreenAngleGroupData);
        GuiUtils.addLabelToComposite("Low:", (Composite)grpScreenAngle, 4, 16384, 0x1000000, false, false, 1, 1);
        this.spnScreenAngleLow = GuiUtils.addCustomSpinnerToComposite(360, this.shell, (Composite)grpScreenAngle, 2048, 16384, 0x1000000, true, true, 1, 1);
        GuiUtils.addLabelToComposite("High:", (Composite)grpScreenAngle, 4, 16384, 0x1000000, false, false, 1, 1);
        this.spnScreenAngleHigh = GuiUtils.addCustomSpinnerToComposite(360, this.shell, (Composite)grpScreenAngle, 2048, 16384, 0x1000000, true, true, 1, 1);
        this.spnScreenAngleHigh.setSelection(360);
        Composite cmpHingeAngle = new Composite((Composite)this.shell, 4);
        FormLayout cmpHingeAngleLayout = new FormLayout();
        cmpHingeAngle.setLayout((Layout)cmpHingeAngleLayout);
        cmpHingeAngle.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.chkHingeAngle = new Button(cmpHingeAngle, 32);
        this.chkHingeAngle.setText("Hinge Angle");
        FormData frmDataChkHingeAngleGroup = new FormData();
        this.chkHingeAngle.setLayoutData((Object)frmDataChkHingeAngleGroup);
        frmDataChkHingeAngleGroup.left = new FormAttachment();
        frmDataChkHingeAngleGroup.left.offset = 8;
        this.chkHingeAngle.setSelection(true);
        this.chkHingeAngle.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!OnlookerDetectionConfiguration.this.chkHingeAngle.getSelection()) {
                    OnlookerDetectionConfiguration.this.spnHingeLow.setSelection(0);
                    OnlookerDetectionConfiguration.this.spnHingeLow.setEnabled(false);
                    OnlookerDetectionConfiguration.this.spnHingeHigh.setSelection(360);
                    OnlookerDetectionConfiguration.this.spnHingeHigh.setEnabled(false);
                } else {
                    OnlookerDetectionConfiguration.this.spnHingeLow.setEnabled(true);
                    OnlookerDetectionConfiguration.this.spnHingeHigh.setEnabled(true);
                }
            }
        });
        Group grpHingeAngle = new Group(cmpHingeAngle, 4);
        FormData grpHingeAngleGroupData = new FormData();
        GridLayout grpHingeAngleGroupLayout = new GridLayout(2, false);
        grpHingeAngleGroupLayout.verticalSpacing = 15;
        grpHingeAngleGroupLayout.horizontalSpacing = 15;
        grpHingeAngle.setLayout((Layout)grpHingeAngleGroupLayout);
        grpHingeAngle.setLayoutData((Object)grpHingeAngleGroupData);
        GuiUtils.addLabelToComposite("Low", (Composite)grpHingeAngle, 4, 16384, 0x1000000, false, false, 1, 1);
        this.spnHingeLow = GuiUtils.addCustomSpinnerToComposite(360, this.shell, (Composite)grpHingeAngle, 2048, 16384, 0x1000000, true, true, 1, 1);
        GuiUtils.addLabelToComposite("High", (Composite)grpHingeAngle, 4, 16384, 0x1000000, false, false, 1, 1);
        this.spnHingeHigh = GuiUtils.addCustomSpinnerToComposite(360, this.shell, (Composite)grpHingeAngle, 2048, 16384, 0x1000000, true, true, 1, 1);
        this.spnHingeHigh.setSelection(360);
        Composite cmpPlmModelId = new Composite((Composite)this.shell, 4);
        FormLayout cmpPlmModeIdLayout = new FormLayout();
        cmpPlmModelId.setLayout((Layout)cmpPlmModeIdLayout);
        cmpPlmModelId.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.chkPlmModeIdGroup = new Button(cmpPlmModelId, 32);
        this.chkPlmModeIdGroup.setText("PLM Mode ID");
        FormData formData = new FormData();
        this.chkPlmModeIdGroup.setLayoutData((Object)formData);
        formData.left = new FormAttachment();
        formData.left.offset = 8;
        this.grpPlmModeId = new Group(cmpPlmModelId, 4);
        FormData grpPlmModeIdGroupData = new FormData();
        GridLayout plmModeIdGroupLayout = new GridLayout(6, true);
        plmModeIdGroupLayout.verticalSpacing = 15;
        plmModeIdGroupLayout.horizontalSpacing = 15;
        this.grpPlmModeId.setLayout((Layout)plmModeIdGroupLayout);
        if (this.modeIdList == null || this.modeIdList.size() == 0) {
            this.chkPlmModeIdGroup.setSelection(false);
            this.chkPlmModeIdGroup.setEnabled(false);
            Button tempButton = new Button(cmpPlmModelId, 32);
            tempButton.setText("1");
            tempButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
            grpPlmModeIdGroupData.width = 6 * tempButton.computeSize((int)-1, (int)-1).x + plmModeIdGroupLayout.horizontalSpacing * 6 + 2 * plmModeIdGroupLayout.marginWidth;
            grpPlmModeIdGroupData.height = 1 * tempButton.computeSize((int)-1, (int)-1).y + plmModeIdGroupLayout.verticalSpacing * 1 + 2 * plmModeIdGroupLayout.marginHeight;
            tempButton.dispose();
        } else {
            if (this.modeIdList.size() < 6) {
                Button tempButton = new Button(cmpPlmModelId, 32);
                tempButton.setText("1");
                tempButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
                grpPlmModeIdGroupData.width = 6 * tempButton.computeSize((int)-1, (int)-1).x + plmModeIdGroupLayout.horizontalSpacing * 6 + 2 * plmModeIdGroupLayout.marginWidth;
                tempButton.dispose();
            }
            this.chkPlmModeIdGroup.setSelection(true);
            for (int i = 0; i < this.modeIdList.size(); ++i) {
                Button addBtn = new Button((Composite)this.grpPlmModeId, 32);
                addBtn.setText(this.modeIdList.get(i).toString());
                addBtn.setData((Object)(1 << this.modeIdList.get(i)));
                addBtn.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
            }
        }
        this.grpPlmModeId.setLayoutData((Object)grpPlmModeIdGroupData);
        this.chkPlmModeIdGroup.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!OnlookerDetectionConfiguration.this.chkPlmModeIdGroup.getSelection()) {
                    OnlookerDetectionConfiguration.this.setSubCheckboxSelection((Composite)OnlookerDetectionConfiguration.this.grpPlmModeId, false);
                    OnlookerDetectionConfiguration.this.setChildrenEnable((Composite)OnlookerDetectionConfiguration.this.grpPlmModeId, false);
                } else {
                    OnlookerDetectionConfiguration.this.setChildrenEnable((Composite)OnlookerDetectionConfiguration.this.grpPlmModeId, true);
                }
            }
        });
        Composite cmpsOkCancel = new Composite((Composite)this.shell, 0);
        cmpsOkCancel.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.horizontalSpacing = 10;
        gridLayout.verticalSpacing = 10;
        cmpsOkCancel.setLayout((Layout)gridLayout);
        Button btnOk = new Button(cmpsOkCancel, 0);
        GridData gd_btnOk = new GridData(131072, 0x1000000, true, false, 1, 1);
        btnOk.setLayoutData((Object)gd_btnOk);
        gd_btnOk.widthHint = GuiUtils.getButtonWidth((Control)this.shell);
        btnOk.setText("OK");
        btnOk.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OnlookerDetectionConfiguration.this.save();
            }
        });
        Button btnCancel = new Button(cmpsOkCancel, 0);
        GridData gd_btnCancel = new GridData(4, 0x1000000, false, false, 1, 1);
        btnCancel.setLayoutData((Object)gd_btnCancel);
        gd_btnCancel.widthHint = GuiUtils.getButtonWidth((Control)this.shell);
        btnCancel.setText("Cancel");
        btnCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OnlookerDetectionConfiguration.this.shell.close();
            }
        });
        grpHingeAngle.computeSize(-1, -1);
        ((GridData)this.spnHingeLow.getLayoutData()).widthHint = longSpinnerMinWidth = (int)((double)GuiUtils.getButtonWidth((Control)this.shell) * 1.5);
        ((GridData)this.spnHingeHigh.getLayoutData()).widthHint = longSpinnerMinWidth;
        ((GridData)this.spnScreenAngleLow.getLayoutData()).widthHint = longSpinnerMinWidth;
        ((GridData)this.spnScreenAngleHigh.getLayoutData()).widthHint = longSpinnerMinWidth;
        ((GridData)this.cmbFormatId.getLayoutData()).widthHint = longSpinnerMinWidth;
        ((GridData)this.spnVersion.getLayoutData()).widthHint = longSpinnerMinWidth;
        int groupMaxWidth = Math.max(grpHingeAngle.computeSize((int)-1, (int)-1).x, this.grpPlmModeId.computeSize((int)-1, (int)-1).x);
        ((GridData)group.getLayoutData()).widthHint = groupMaxWidth = Math.max(groupMaxWidth, group.computeSize((int)-1, (int)-1).x);
        grpPlmModeIdGroupData.width = groupMaxWidth;
        ((FormData)grpHingeAngle.getLayoutData()).width = groupMaxWidth;
        ((FormData)grpScreenAngle.getLayoutData()).width = groupMaxWidth;
        this.shell.setSize(this.shell.computeSize(-1, -1));
        this.shell.setLocation(GuiUtils.getMiddleLocation(this.shell, this.display));
    }

    public void setSubCheckboxSelection(Composite parentControl, boolean selection) {
        Control[] child;
        for (Control control : child = parentControl.getChildren()) {
            if (control.getClass() != Button.class || (control.getStyle() & 0x20) <= 0 && (control.getStyle() & 0x10) <= 0) continue;
            ((Button)control).setSelection(selection);
        }
    }

    public void setChildrenEnable(Composite parentControl, boolean isEnabled) {
        Control[] child;
        for (Control control : child = parentControl.getChildren()) {
            if (!(control instanceof Button) || (control.getStyle() & 0x20) <= 0 && (control.getStyle() & 0x10) <= 0) continue;
            control.setEnabled(isEnabled);
        }
    }
}

