/*
 * Decompiled with CFR 0.152.
 */
package pdtEditor.gui.calibration;

import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wb.swt.SWTResourceManager;
import pdtEditor.Sensor;
import pdtEditor.gui.GuiUtils;
import pdtEditor.gui.SensorModifier;
import pdtEditor.gui.calibration.CalibrationEditor;
import pdtEditor.gui.calibration.CalibrationEditorOpener;
import pdtEditor.gui.configuration.AngleRegulatorConfiguration;
import pdtEditor.payloads.calibrations.CalibrationPayload;
import pdtEditor.payloads.calibrations.SimpleDmdCalibrationPayload;
import resources.CustomSpinner;

public class SimpleDmdCalibration
implements CalibrationEditor {
    protected Shell shlEditConfiguration;
    private Display display;
    private boolean _modified = false;
    private CalibrationEditorOpener _parent = null;
    private Sensor _sensor = null;
    private SimpleDmdCalibrationPayload _data = null;
    private Combo cmbFormatId;
    private CustomSpinner spnVersion;
    private CustomSpinner spnSlopeThresh;
    private CustomSpinner spnEnterDuration;
    private CustomSpinner spnNoiseThresh;
    private Button btnDisableMedianFilter;
    Group grpThreshold;
    Group grpNoiseThreshold;

    public static void main(String[] args) {
        try {
            SimpleDmdCalibration window = new SimpleDmdCalibration(null, null);
            window.open();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public SimpleDmdCalibration(SensorModifier parent, Sensor sensor) {
        this._parent = parent;
        this._sensor = sensor;
    }

    public SimpleDmdCalibration(CalibrationEditorOpener parent, SimpleDmdCalibrationPayload data, Sensor sensor) {
        this._data = data;
        this._sensor = sensor;
        this._parent = parent;
    }

    @Override
    public void open() {
        this.display = Display.getDefault();
        this.createContents();
        this.fillData();
        this.shlEditConfiguration.open();
        this.shlEditConfiguration.layout();
        while (!this.shlEditConfiguration.isDisposed()) {
            if (this.display.readAndDispatch()) continue;
            this.display.sleep();
        }
    }

    public void fillData() {
        this.cmbFormatId.add("0");
        this.cmbFormatId.add("1");
        if (this._data == null) {
            this.cmbFormatId.select(1);
            this.spnVersion.setSelection(0);
            this.spnSlopeThresh.setSelection(30);
            this.spnEnterDuration.setSelection(5000);
            this.btnDisableMedianFilter.setSelection(false);
            this.spnNoiseThresh.setSelection(3);
        } else {
            this.cmbFormatId.select(this._data.getFormatID());
            this.spnVersion.setSelection(this._data.getVersion());
            this.spnSlopeThresh.setSelection(this._data.get_slopeThreshold());
            this.spnEnterDuration.setSelection(this._data.get_enterDuration());
            this.btnDisableMedianFilter.setSelection(this._data.is_disableMedianFilter());
            this.spnNoiseThresh.setSelection(this._data.get_noiseThreshold());
        }
        this._modified = false;
        this.upadteControlState();
    }

    public void upadteControlState() {
        if (Integer.valueOf(this.cmbFormatId.getText()) == 0) {
            this.spnSlopeThresh.setEnabled(true);
            this.spnEnterDuration.setEnabled(true);
            this.btnDisableMedianFilter.setEnabled(true);
            this.spnNoiseThresh.setEnabled(false);
        } else {
            this.spnSlopeThresh.setEnabled(false);
            this.spnEnterDuration.setEnabled(false);
            this.btnDisableMedianFilter.setEnabled(false);
            this.spnNoiseThresh.setEnabled(true);
        }
    }

    public void saveData() {
        if (this._data == null) {
            this._data = new SimpleDmdCalibrationPayload();
            this._parent.addNewCalibration(this._sensor, this._data);
        }
        this._data.setFormatID(Integer.valueOf(this.cmbFormatId.getText()));
        if (this.cmbFormatId.getText().compareTo("0") == 0) {
            this._data.set_slopeThreshold(Integer.valueOf(this.spnSlopeThresh.getText()));
            this._data.set_enterDuration(Integer.valueOf(this.spnEnterDuration.getText()));
            this._data.set_disableMedianFilter(this.btnDisableMedianFilter.getSelection());
        } else {
            this._data.set_noiseThreshold(Integer.valueOf(this.spnNoiseThresh.getText()));
        }
        this._modified = false;
        this._parent.setModified();
        this._parent.refreshCalibrationData();
        this.shlEditConfiguration.close();
    }

    @Override
    public String getCalibrationFormatName() {
        return "Simple DMD Calibration";
    }

    protected void createContents() {
        int longSpinnerMinWidth;
        this.shlEditConfiguration = new Shell(65632);
        this.shlEditConfiguration.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                if (SimpleDmdCalibration.this._modified) {
                    MessageBox messageBox = new MessageBox(SimpleDmdCalibration.this.shlEditConfiguration, 296);
                    messageBox.setText("Closing The Configuration Window");
                    messageBox.setMessage("Some changes will be lost. Are you sure that you want to continue?");
                    if (messageBox.open() != 32) {
                        e.doit = false;
                        return;
                    }
                }
            }
        });
        this.shlEditConfiguration.setImage(SWTResourceManager.getImage(AngleRegulatorConfiguration.class, "/resources/Intel.ico"));
        this.shlEditConfiguration.setText("Simple DMD Calibration");
        GuiUtils.setGridLayoutToComposite((Composite)this.shlEditConfiguration, 1);
        Group group = GuiUtils.addGroupToComposite("", (Composite)this.shlEditConfiguration, 0, 4, 128, true, false, 1, 1, 2);
        GuiUtils.addLabelToComposite("Calibration Format ID:", (Composite)group, 0, 16384, 0x1000000, false, false, 1, 1);
        this.cmbFormatId = GuiUtils.addComboToComposite((Composite)group, 12, 4, 16384, true, false, 1, 1);
        GuiUtils.addLabelToComposite("Calibration Version:", (Composite)group, 0, 16384, 0x1000000, false, false, 1, 1);
        this.spnVersion = GuiUtils.addCustomSpinnerToComposite(CalibrationPayload.VERSION_MAX_VALUE, this.shlEditConfiguration, (Composite)group, 2048, 16384, 0x1000000, true, false, 1, 1);
        this.grpThreshold = GuiUtils.addGroupToComposite("", (Composite)this.shlEditConfiguration, 0, 4, 128, true, false, 1, 1, 2);
        GuiUtils.addLabelToComposite("Slope Threshold:", (Composite)this.grpThreshold, 0, 16384, 0x1000000, false, false, 1, 1);
        this.spnSlopeThresh = GuiUtils.addCustomSpinnerToComposite(100, this.shlEditConfiguration, (Composite)this.grpThreshold, 2048, 131072, 0x1000000, true, false, 1, 1);
        GuiUtils.addLabelToComposite("Enter Duration:", (Composite)this.grpThreshold, 0, 16384, 0x1000000, false, false, 1, 1);
        this.spnEnterDuration = GuiUtils.addCustomSpinnerToComposite(65535, this.shlEditConfiguration, (Composite)this.grpThreshold, 2048, 131072, 0x1000000, true, false, 1, 1);
        this.btnDisableMedianFilter = GuiUtils.addButtonToComposite("Disable Median Filter", "", (Composite)this.grpThreshold, 32, 16384, 0x1000000, false, false, 2, 1);
        this.grpNoiseThreshold = GuiUtils.addGroupToComposite("", (Composite)this.shlEditConfiguration, 0, 4, 128, true, false, 1, 1, 2);
        GuiUtils.addLabelToComposite("Noise Threshold:", (Composite)this.grpNoiseThreshold, 0, 16384, 0x1000000, false, false, 1, 1);
        this.spnNoiseThresh = GuiUtils.addCustomSpinnerToComposite(50, this.shlEditConfiguration, (Composite)this.grpNoiseThreshold, 2048, 131072, 0x1000000, true, false, 1, 1);
        Composite compositeShellButton = GuiUtils.addCompositeToComposite((Composite)this.shlEditConfiguration, 0, 131072, 0x1000000, false, false, 1, 1, 2);
        Button btnSave = GuiUtils.addButtonToComposite("Save and Close", "", compositeShellButton, 0, 131072, 0x1000000, true, false, 1, 1);
        Button btnCancel = GuiUtils.addButtonToComposite("Cancel", "", compositeShellButton, 0, 131072, 0x1000000, true, false, 1, 1);
        this.spnSlopeThresh.setMinimum(1);
        this.spnNoiseThresh.setMinimum(1);
        this.cmbFormatId.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                SimpleDmdCalibration.this.upadteControlState();
            }
        });
        this.spnEnterDuration.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                SimpleDmdCalibration.this._modified = true;
            }
        });
        this.btnDisableMedianFilter.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                SimpleDmdCalibration.this._modified = true;
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
                SimpleDmdCalibration.this._modified = true;
            }
        });
        this.spnNoiseThresh.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                SimpleDmdCalibration.this._modified = true;
            }
        });
        btnSave.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SimpleDmdCalibration.this.saveData();
            }
        });
        btnCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SimpleDmdCalibration.this.shlEditConfiguration.close();
            }
        });
        ((GridData)this.spnVersion.getLayoutData()).minimumWidth = longSpinnerMinWidth = (int)((double)GuiUtils.getButtonWidth((Control)this.shlEditConfiguration) * 1.5);
        ((GridData)this.spnSlopeThresh.getLayoutData()).minimumWidth = longSpinnerMinWidth;
        ((GridData)this.spnEnterDuration.getLayoutData()).minimumWidth = longSpinnerMinWidth;
        ((GridData)this.spnNoiseThresh.getLayoutData()).minimumWidth = longSpinnerMinWidth;
        this.shlEditConfiguration.setSize(this.shlEditConfiguration.computeSize(-1, -1));
        this.shlEditConfiguration.setLocation(GuiUtils.getMiddleLocation(this.shlEditConfiguration, this.display));
    }
}

