/*
 * Decompiled with CFR 0.152.
 */
package com.intel.sensing.fdk.model.project;

import com.intel.sensing.fdk.common.ManagerEnums;
import com.intel.sensing.fdk.common.exceptions.ExceptionHandler;
import com.intel.sensing.fdk.common.exceptions.ISSException;
import com.intel.sensing.fdk.common.log.ISSLogger;
import com.intel.sensing.fdk.common.utils.ManagerFileUtils;
import com.intel.sensing.fdk.common.utils.UIEventsManager;
import com.intel.sensing.fdk.model.ObservableModel;
import com.intel.sensing.fdk.model.abstractData.CategoryData;
import com.intel.sensing.fdk.model.abstractData.Version;
import com.intel.sensing.fdk.model.dao.DaoFactory;
import com.intel.sensing.fdk.model.dao.ProjectDao;
import com.intel.sensing.fdk.model.entity.ModuleEntity;
import com.intel.sensing.fdk.model.entity.ProjectEntity;
import com.intel.sensing.fdk.model.entity.SelectedItemsDataEntity;
import com.intel.sensing.fdk.model.entity.SelectedSensorsEntity;
import com.intel.sensing.fdk.model.entity.SensorDataEntity;
import com.intel.sensing.fdk.model.project.SelectedModuleManager;
import com.intel.sensing.fdk.model.project.UserModulesManager;
import com.intel.sensing.fdk.model.service.PersistenceService;
import com.intel.sensing.fdk.model.utils.ISSProjectUtils;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;

public abstract class AISSProject
extends ObservableModel {
    protected ProjectEntity fProjectEntity;
    protected SelectedModuleManager fSelectMgr;
    protected UserModulesManager fUserModuleMgr;
    protected String fProjectPath;
    protected IProject fProject;

    public AISSProject(IProject project) {
        this.fProject = project;
        this.fProjectPath = project.getLocation().toOSString();
        this.fUserModuleMgr = new UserModulesManager(this.fProject);
        this.init();
    }

    protected abstract void validate();

    public void init() {
        ISSLogger.i((String)("Start init project " + this.fProject.getName()));
        String jsonPath = ISSProjectUtils.getProjectJsonFileByProjectPath(this.fProjectPath);
        try {
            this.fProjectEntity = DaoFactory.getDao(ProjectDao.class).getEntityByFilePath(jsonPath);
        }
        catch (ISSException e) {
            this.fProjectEntity = null;
            ISSLogger.e((Exception)((Object)e));
        }
        if (this.fProjectEntity == null) {
            return;
        }
        this.fUserModuleMgr.init();
        this.initSelectedManager(this.fProjectPath);
        if (this.fSelectMgr.getEntity() == null) {
            return;
        }
        try {
            ISSProjectUtils.updateIncludePath(this.fProject, this.fProjectEntity);
        }
        catch (Exception e) {
            ISSLogger.e((Exception)e);
        }
    }

    public void UpgradeFirmwareSlience() {
        String plat = this.fProjectEntity.getPlatform();
        boolean supportPlat = PersistenceService.supportPlatform(plat);
        if (!supportPlat) {
            String defaultPlat = PersistenceService.getUpgradePlatorm(plat);
            this.fProjectEntity.setPlatform(defaultPlat);
            this.fProjectEntity.setFwVersion(PersistenceService.getDefaultFirmwareVersion(defaultPlat).getVersion().toString());
        } else {
            Version fw = this.fProjectEntity.getFwVersionInData();
            boolean supportVer = PersistenceService.getAvailableKitVersionByPlatform(plat).contains(fw);
            if (!supportVer) {
                this.fProjectEntity.setFwVersion(PersistenceService.getDefaultFirmwareVersion(plat).getVersion().toString());
            }
        }
        DaoFactory.getDao(ProjectDao.class).saveEntity(this.fProjectEntity);
        if (!plat.equals(this.fProjectEntity.getPlatform())) {
            this.copyPDTFileIfNotExisted(plat, this.fProjectEntity.getPlatform());
        }
    }

    protected void handlePlatformChanges(ProjectEntity original) {
        if (!original.getPlatform().equals(this.fProjectEntity.getPlatform())) {
            this.copyPDTFileIfNotExisted(original.getPlatform(), this.fProjectEntity.getPlatform());
        }
    }

    protected void copyPDTFileIfNotExisted(String plat, String newPlat) {
        String oldPdtFileFolderPath = ISSProjectUtils.getPdtsFolder(this.fProject.getLocation().toOSString(), plat);
        File oldPdtFileFolder = new File(oldPdtFileFolderPath);
        String newPdtFileBinary = ISSProjectUtils.getPdtsBinaryPath(this.fProject.getLocation().toOSString(), newPlat);
        String newPdtFileNvarBinary = ISSProjectUtils.getPdtsNVARBinaryPath(this.fProject.getLocation().toOSString(), newPlat);
        if (oldPdtFileFolder.exists() && !new File(newPdtFileBinary).exists() && !new File(newPdtFileNvarBinary).exists()) {
            String newPdtFolderPath = ISSProjectUtils.getPdtsFolder(this.fProject.getLocation().toOSString(), newPlat);
            File newPdtFolder = new File(newPdtFolderPath);
            try {
                ManagerFileUtils.copyDirectory((File)oldPdtFileFolder, (File)newPdtFolder);
                boolean success = ManagerFileUtils.renamePdtFiles((File)newPdtFolder, (String)(String.valueOf(plat) + "_PDT"), (String)(String.valueOf(newPlat) + "_PDT"), (boolean)false);
                if (!success) {
                    ManagerFileUtils.deleteFileOrDirectoryWithContent((File)newPdtFolder);
                    throw new ISSException("The PDT files in the new directory could not be renamed.");
                }
            }
            catch (Exception e) {
                ISSLogger.e((Exception)e);
            }
        }
    }

    public boolean UpgradeFirmware() {
        String plat = this.fProjectEntity.getPlatform();
        Version fw = this.fProjectEntity.getFwVersionInData();
        boolean supportPlat = PersistenceService.supportPlatform(plat);
        boolean supportVer = false;
        if (supportPlat) {
            supportVer = PersistenceService.getAvailableKitVersionByPlatform(plat).contains(fw);
        }
        if (!supportPlat || !supportVer) {
            int style = 296;
            String errorMsg = "The platform or firmware version used by project " + this.fProject.getName() + " is not supported. Click OK to upgrade your" + " project to the default platform," + " or Click Cancel to update it manually.";
            int res = ExceptionHandler.ShowMessage((String)"Warning", (String)errorMsg.toString(), (int)style);
            if (res == 32) {
                if (!supportPlat) {
                    String defaultPlat = PersistenceService.getUpgradePlatorm(plat);
                    this.fProjectEntity.setPlatform(defaultPlat);
                    this.fProjectEntity.setFwVersion(PersistenceService.getDefaultFirmwareVersion(defaultPlat).getVersion().toString());
                } else {
                    this.fProjectEntity.setFwVersion(PersistenceService.getDefaultFirmwareVersion(plat).getVersion().toString());
                }
                DaoFactory.getDao(ProjectDao.class).saveEntity(this.fProjectEntity);
                return true;
            }
            return false;
        }
        return true;
    }

    private void initSelectedManager(String projectPath) {
        String jsonPath = ISSProjectUtils.getSelectedJsonFileByProjectPath(projectPath);
        this.fSelectMgr = new SelectedModuleManager(jsonPath, this.fProjectEntity, this.fUserModuleMgr.getUserModules());
    }

    public void update(ProjectEntity data, SelectedSensorsEntity selectSensors) throws ISSException {
        if (!data.getName().equals(this.fProjectEntity.getName())) {
            throw new ISSException("Project's name can't be changed.");
        }
        if (!this.fProjectEntity.getPlatform().equals(data.getPlatform()) || !this.fProjectEntity.getFwVersion().equals(data.getFwVersion())) {
            this.updateIncludePath();
        }
        this.fProjectEntity.sync(data);
        DaoFactory.getDao(ProjectDao.class).saveEntity(this.fProjectEntity);
        this.fSelectMgr.update(selectSensors);
    }

    private void updateIncludePath() {
    }

    public String getProjectName() {
        return this.fProjectEntity.getName();
    }

    public String getProjectPath() {
        return this.fProjectEntity.getAbsoluteParentFolderAsStr();
    }

    public String getPlatform() {
        return this.fProjectEntity.getPlatform();
    }

    public Version getFirmwareVersion() {
        return this.fProjectEntity.getFwVersionInData();
    }

    public void addUserModule(ModuleEntity newModule) {
        this.addUserModule(newModule, true);
    }

    public void addUserModule(ModuleEntity newModule, boolean selected) {
        this.fUserModuleMgr.addModule(newModule);
        if (selected) {
            this.fSelectMgr.add(newModule);
        }
        UIEventsManager.fireNewSensorEvent((ActionEvent)new ActionEvent(newModule, 0, this.getProjectName()));
    }

    public List<SelectedItemsDataEntity> getSelectedItems() {
        return this.fSelectMgr.getSelectedItems();
    }

    public List<SensorDataEntity> getUserSensors() {
        return this.fUserModuleMgr.getUserSensors();
    }

    public List<ModuleEntity> getUserModules() {
        return this.fUserModuleMgr.getUserModules();
    }

    public List<ModuleEntity> getUserLibraries() {
        return this.fUserModuleMgr.getUserLibraries();
    }

    public void selectLibraries(ArrayList<ModuleEntity> toSelectLibs) {
        this.fSelectMgr.addLibraries(toSelectLibs);
    }

    public void selectSensors(ArrayList<SensorDataEntity> toSelectSensors) {
        this.fSelectMgr.addSensors(toSelectSensors);
    }

    public IProject getProject() {
        return this.fProject;
    }

    public List<SelectedItemsDataEntity> getUserSelectableItems() {
        return this.fUserModuleMgr.getUserSelectableItems();
    }

    public void updateModule(ModuleEntity module) {
        this.fUserModuleMgr.updateModule(module);
    }

    public void removeModule(ModuleEntity module) {
        this.fUserModuleMgr.removeModule(module);
        this.fSelectMgr.remove(module);
        UIEventsManager.fireSensorPropertyChangedEvent((ActionEvent)new ActionEvent("", 0, ""));
    }

    public ModuleEntity getModuleByName(String moduleName) {
        return this.fUserModuleMgr.getModuleByName(moduleName);
    }

    public StringBuilder generateDeleteMessage(SelectedItemsDataEntity SelectedItemData) {
        ModuleEntity sensorToDelete = SelectedItemData.getModuleEntity();
        StringBuilder msg = new StringBuilder();
        if (sensorToDelete.isSensor().booleanValue() && sensorToDelete.getSensorBundle().getSensors().size() > 1) {
            msg.append("The following sensors in the same module will also be deleted:\n");
            for (SensorDataEntity sde : sensorToDelete.getSensorBundle().getSensors()) {
                if (sde.equals(SelectedItemData)) continue;
                msg.append("\n    - " + sde.getSensorName() + ".");
            }
            msg.append("\n");
            String components = sensorToDelete.getCategory().equals(CategoryData.LIB.getName()) ? ManagerEnums.ComponentName.LIBRARIES.getFriendlyName() : ManagerEnums.ComponentName.SENSORS.getFriendlyName();
            msg.append("\nAre you sure you want to delete these " + components + "?");
        } else {
            String componentName = sensorToDelete.getCategory().equals(CategoryData.LIB.getName()) ? ManagerEnums.ComponentName.LIBRARY.getFriendlyName() : ManagerEnums.ComponentName.SENSOR.getFriendlyName();
            msg.append("WARNING:\nIf you delete this " + componentName + ", all of the code you wrote for it will be deleted.\n\nAre you sure you want to delete it?");
        }
        return msg;
    }

    public boolean deleteModuleFolder(ModuleEntity sensorToDelete) {
        boolean res = false;
        File sensorFolder = sensorToDelete.getAbsoluteParentFolder();
        if (sensorFolder.exists()) {
            res = ManagerFileUtils.deleteFileOrDirectoryWithContent((File)sensorFolder);
        }
        return res;
    }

    public void reInit() {
        this.clearData();
        this.init();
    }

    private void clearData() {
        this.fUserModuleMgr.clear();
    }
}

