/*
 * Decompiled with CFR 0.152.
 */
package com.intel.sensing.fdk.model.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.intel.sensing.fdk.common.ManagerEnums;
import com.intel.sensing.fdk.common.exceptions.ISSException;
import com.intel.sensing.fdk.common.log.ISSLogger;
import com.intel.sensing.fdk.model.SensorDataModel;
import com.intel.sensing.fdk.model.abstractData.Category;
import com.intel.sensing.fdk.model.entity.AbstractEntity;
import com.intel.sensing.fdk.model.entity.SelectedItemsDataEntity;
import com.intel.sensing.fdk.model.entity.SensorBundleEntity;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class ModuleEntity
extends AbstractEntity
implements SelectedItemsDataEntity {
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="version")
    private String version;
    @JsonProperty(value="vendorId")
    private String vendorId;
    @JsonProperty(value="description")
    private String description;
    @JsonProperty(value="arch")
    private String arch;
    @JsonProperty(value="type")
    private String type;
    @JsonProperty(value="category")
    private String category;
    @JsonProperty(value="sources")
    private List<String> sources = null;
    @JsonProperty(value="libs")
    private List<String> libs = null;
    @JsonProperty(value="target")
    private String target;
    @JsonProperty(value="includes")
    private List<String> includes = null;
    @JsonProperty(value="dependencies")
    private List<String> dependencies = null;
    @JsonIgnore
    private SensorBundleEntity sensorBundle;
    @JsonIgnore
    private ManagerEnums.ISSModuleTags issModuleTags;
    @JsonIgnore
    private String iSSPackageName = "";
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    public ModuleEntity() {
    }

    public ModuleEntity(String jsonFilePath) {
        super(jsonFilePath);
        this.setDefaultValue();
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    @JsonProperty(value="vendorId")
    public String getVendorID() {
        return this.vendorId;
    }

    @JsonProperty(value="vendorId")
    public void setVendorID(String VendorID) {
        this.vendorId = VendorID;
    }

    @JsonProperty(value="version")
    public String getVersion() {
        return this.version;
    }

    @JsonProperty(value="version")
    public void setVersion(String version) {
        this.version = version;
    }

    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    public void setDescription(String description) {
        this.description = description;
    }

    @JsonProperty(value="arch")
    public String getArch() {
        return this.arch;
    }

    @JsonProperty(value="arch")
    public void setArch(String arch) {
        this.arch = arch;
    }

    @JsonProperty(value="type")
    public String getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    public void setType(String type) {
        this.type = type;
    }

    @JsonProperty(value="category")
    public String getCategory() {
        return this.category;
    }

    @JsonIgnore
    public Category getCategoryInData() {
        if (this.category == null || this.category.isEmpty() || this.category.isBlank()) {
            return Category.UNKNOWN;
        }
        try {
            return Category.getItemByName(this.category);
        }
        catch (ISSException e) {
            ISSLogger.e((String)(String.valueOf(e.getMessage()) + " -> " + "[" + this.getName() + "]"));
            return Category.UNKNOWN;
        }
    }

    @JsonProperty(value="category")
    public void setCategory(String category) {
        this.category = category;
    }

    @JsonProperty(value="sources")
    public List<String> getSources() {
        return this.sources;
    }

    @JsonProperty(value="sources")
    public void setSources(List<String> sources) {
        this.sources = sources;
    }

    @JsonProperty(value="libs")
    public List<String> getlibraries() {
        return this.libs;
    }

    @JsonProperty(value="libs")
    public void setlibraries(List<String> libs) {
        this.libs = libs;
    }

    @JsonProperty(value="target")
    public String getTarget() {
        return this.target;
    }

    @JsonProperty(value="target")
    public void setTarget(String target) {
        this.target = target;
    }

    @JsonProperty(value="includes")
    public List<String> getIncludes() {
        return this.includes;
    }

    @JsonProperty(value="includes")
    public void setIncludes(List<String> includes) {
        this.includes = includes;
    }

    @JsonProperty(value="dependencies")
    public List<String> getDependencies() {
        return this.dependencies;
    }

    @JsonProperty(value="dependencies")
    public void setDependencies(List<String> dependencies) {
        this.dependencies = dependencies;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    @JsonIgnore
    public UUID getUuid() {
        return UUID.randomUUID();
    }

    @JsonIgnore
    public SensorBundleEntity getSensorBundle() {
        return this.sensorBundle;
    }

    @JsonIgnore
    public void setSensorBundle(SensorBundleEntity sensorBundle) {
        this.sensorBundle = sensorBundle;
    }

    @JsonIgnore
    public void setAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
    }

    @JsonIgnore
    public ManagerEnums.ISSModuleTags getIssModuleTags() {
        return this.issModuleTags;
    }

    @JsonIgnore
    public void setIssModuleTags(ManagerEnums.ISSModuleTags issModuleTags) {
        this.issModuleTags = issModuleTags;
    }

    @JsonIgnore
    public void setPackageName(String PackName) {
        this.iSSPackageName = PackName;
    }

    @JsonIgnore
    public String getPackageName() {
        return this.iSSPackageName;
    }

    @JsonIgnore
    private void setDefaultValue() {
        ArrayList<String> sourceList = new ArrayList<String>();
        String target = "";
        ArrayList<String> includeList = new ArrayList<String>();
        sourceList.add("src/*.c");
        target = new File(this.getJsonFilePath()).getParentFile().getName();
        includeList.add("include");
        this.setSources(sourceList);
        this.setTarget(target);
        this.setIncludes(includeList);
    }

    @Override
    @JsonIgnore
    public boolean equals(Object o) {
        boolean ret;
        if (o == null || !(o instanceof ModuleEntity)) {
            return false;
        }
        ModuleEntity that = (ModuleEntity)o;
        boolean bl = ret = this.name.contentEquals(that.name) && this.arch.contentEquals(that.arch) && this.category.contentEquals(that.category) && this.version.contentEquals(that.version) && this.issModuleTags.equals((Object)that.issModuleTags);
        if (!this.issModuleTags.equals((Object)ManagerEnums.ISSModuleTags.INSTALLED) || !ret) {
            return ret;
        }
        int compare = new File(this.getJsonFilePath()).compareTo(new File(that.getJsonFilePath()));
        return compare == 0;
    }

    @Override
    @JsonIgnore
    public ModuleEntity getModuleEntity() {
        return this;
    }

    @Override
    @JsonIgnore
    public String getUIComponentType() {
        return ManagerEnums.ObjectTypes.LIBRARY.getFriendlyName();
    }

    @Override
    @JsonIgnore
    public String getUIModuleName() {
        return this.getName();
    }

    @Override
    @JsonIgnore
    public String getUISensorType() {
        return "N/A";
    }

    @Override
    @JsonIgnore
    public String getUIVendor() {
        return SensorDataModel.getVendorById(this);
    }

    @Override
    @JsonIgnore
    public String getUIModelName() {
        return "N/A";
    }

    @Override
    @JsonIgnore
    public String getUIFlags() {
        return "N/A";
    }

    @Override
    @JsonIgnore
    public String getUILUID() {
        return "N/A";
    }

    @Override
    @JsonIgnore
    public String getUIModuleFolderName() {
        return this.getName();
    }

    @Override
    @JsonIgnore
    public String getUIVersion() {
        return this.getVersion();
    }

    @JsonIgnore
    public Boolean isLibrary() {
        return this.category.equals(Category.LIB.getName());
    }

    @JsonIgnore
    public Boolean isSensor() {
        return this.category.equals(Category.SENSOR.getName());
    }

    public void sync(ModuleEntity toUpdateModule) {
    }
}

