/*
 * Decompiled with CFR 0.152.
 */
package com.intel.sensing.fdk.common.exceptions;

import com.intel.sensing.fdk.common.log.ISSLogger;

public class Check {
    private Check() {
    }

    public static <T> T notNull(T object) {
        return Check.notNull(object, null);
    }

    public static <T> T notNull(T object, String errorMessage) {
        if (object == null) {
            throw new UnknownError(errorMessage != null ? errorMessage : "An internal error occurred:\nInvalid object is null.");
        }
        return object;
    }

    public static <E extends Exception, T> T notNull(T object, String logMessage, E throwable) throws E {
        block5: {
            if (throwable == null) {
                Check.notNull(object, null);
            } else {
                try {
                    Check.notNull(object, null);
                }
                catch (UnknownError unknownError) {
                    String message;
                    String string = message = logMessage == null ? throwable.getMessage() : null;
                    if (message != null) {
                        ISSLogger.e(message);
                    }
                    if (throwable == null) break block5;
                    throw throwable;
                }
            }
        }
        return object;
    }

    public static <T> T[] notEmpty(T[] array) {
        return Check.notEmpty(array, null);
    }

    public static <T> T[] notEmpty(T[] array, String errorMessage) {
        Check.notNull(array);
        if (array.length == 0) {
            throw new UnknownError(errorMessage != null ? errorMessage : "An internal error occurred:\nInvalid length of object.");
        }
        return array;
    }

    public static <E extends Exception, T> T[] notEmpty(T[] array, String logMessage, E throwable) throws E {
        block5: {
            if (throwable == null) {
                Check.notEmpty(array, null);
            } else {
                try {
                    Check.notEmpty(array, null);
                }
                catch (UnknownError unknownError) {
                    String message;
                    String string = message = logMessage == null ? throwable.getMessage() : null;
                    if (message != null) {
                        ISSLogger.e(message);
                    }
                    if (throwable == null) break block5;
                    throw throwable;
                }
            }
        }
        return array;
    }

    public static String notEmpty(String string) {
        return Check.notEmpty(string, null);
    }

    public static String notEmpty(String string, String errorMessage) {
        Check.notNull(string);
        if (string.length() == 0) {
            throw new UnknownError(errorMessage != null ? errorMessage : "An internal error occurred:\nInvalid length of object.");
        }
        return string;
    }

    public static <E extends Exception> String notEmpty(String string, String logMessage, E throwable) throws E {
        block5: {
            if (throwable == null) {
                Check.notEmpty(string, null);
            } else {
                try {
                    Check.notEmpty(string, null);
                }
                catch (UnknownError unknownError) {
                    String message;
                    String string2 = message = logMessage == null ? throwable.getMessage() : null;
                    if (message != null) {
                        ISSLogger.e(message);
                    }
                    if (throwable == null) break block5;
                    throw throwable;
                }
            }
        }
        return string;
    }

    public static boolean isTrue(boolean result) {
        return Check.isTrue(result, null);
    }

    public static boolean isTrue(boolean result, String errorMessage) {
        if (!result) {
            throw new UnknownError(errorMessage != null ? errorMessage : "An internal error occurred:\nResult not expected.");
        }
        return result;
    }

    public static <E extends Exception> boolean isTrue(boolean result, String logMessage, E throwable) throws E {
        block5: {
            if (throwable == null) {
                Check.isTrue(result, null);
            } else {
                try {
                    Check.isTrue(result, null);
                }
                catch (UnknownError unknownError) {
                    String message;
                    String string = message = logMessage == null ? throwable.getMessage() : null;
                    if (message != null) {
                        ISSLogger.e(message);
                    }
                    if (throwable == null) break block5;
                    throw throwable;
                }
            }
        }
        return result;
    }

    public static boolean isFalse(boolean result) {
        return Check.isFalse(result, null);
    }

    public static boolean isFalse(boolean result, String errorMessage) {
        if (result) {
            throw new UnknownError(errorMessage != null ? errorMessage : "An internal error occurred:\nResult not expected.");
        }
        return result;
    }

    public static <E extends Exception> boolean isFalse(boolean result, String logMessage, E throwable) throws E {
        block5: {
            if (throwable == null) {
                Check.isFalse(result, null);
            } else {
                try {
                    Check.isFalse(result, null);
                }
                catch (UnknownError unknownError) {
                    String message;
                    String string = message = logMessage == null ? throwable.getMessage() : null;
                    if (message != null) {
                        ISSLogger.e(message);
                    }
                    if (throwable == null) break block5;
                    throw throwable;
                }
            }
        }
        return result;
    }

    public static <T> T instanceOf(T object, Class<?> clazz) throws ClassCastException {
        return Check.instanceOf(object, clazz, null);
    }

    public static <T> T instanceOf(T object, Class<?> clazz, String errorMessage) throws ClassCastException {
        if (clazz.isInstance(object)) {
            return object;
        }
        throw new ClassCastException(errorMessage != null ? errorMessage : "An internal error occurred:\nobject is not an instance of class " + clazz.getName());
    }

    public static <E extends Exception, T> T instanceOf(T object, Class<?> clazz, E throwable) throws E, ClassCastException {
        return Check.instanceOf(object, clazz, null, throwable);
    }

    public static <E extends Exception, T> T instanceOf(T object, Class<?> clazz, String logMessage, E throwable) throws E, ClassCastException {
        try {
            return Check.instanceOf(object, clazz, null);
        }
        catch (ClassCastException e) {
            if (logMessage != null) {
                ISSLogger.e(logMessage);
            }
            if (throwable != null) {
                throw throwable;
            }
            throw e;
        }
    }
}

