/* SPDX-License-Identifier: GPL-2.0 or Linux-OpenIB */
/* Copyright (c) 2018 - 2023 Intel Corporation */

#ifndef IG3RDMA_REGS_APF_H
#define IG3RDMA_REGS_APF_H

#include "irdma.h"

#define IG3_APF_CCQPEXTSTATUS 0xBC00004
#define IG3_APF_CCQPEXTSTATUS_RSVD_S 16
#define IG3_APF_CCQPEXTSTATUS_RSVD_M \
	RDMA_MASK3(32, 0xFFFF, IG3_APF_CCQPEXTSTATUS_RSVD_S)
#define IG3_APF_CCQPEXTSTATUS_DBPT_INDEX_S 0
#define IG3_APF_CCQPEXTSTATUS_DBPT_INDEX_M \
	RDMA_MASK3(32, 0xFFFF, IG3_APF_CCQPEXTSTATUS_DBPT_INDEX_S)
#define IG3_APF_CCQPHIGH 0xBC0000C
#define IG3_APF_CCQPHIGH_PECCQPHIGH_S 0
#define IG3_APF_CCQPHIGH_PECCQPHIGH_M \
	RDMA_MASK3(32, 0xFFFFFFFF, IG3_APF_CCQPHIGH_PECCQPHIGH_S)
#define IG3_APF_CCQPLOW 0xBC00008
#define IG3_APF_CCQPLOW_PECCQPLOW_S 0
#define IG3_APF_CCQPLOW_PECCQPLOW_M \
	RDMA_MASK3(32, 0xFFFFFFFF, IG3_APF_CCQPLOW_PECCQPLOW_S)
#define IG3_APF_CCQPSTATUS 0xBC00000
#define IG3_APF_CCQPSTATUS_CCQP_ERR_S 31
#define IG3_APF_CCQPSTATUS_CCQP_ERR_M \
	RDMA_BIT2(32, IG3_APF_CCQPSTATUS_CCQP_ERR_S)
#define IG3_APF_CCQPSTATUS_RSVD2_S 28
#define IG3_APF_CCQPSTATUS_RSVD2_M \
	RDMA_MASK3(32, 0x7, IG3_APF_CCQPSTATUS_RSVD2_S)
#define IG3_APF_CCQPSTATUS_RDMA_EN_VFS_S 16
#define IG3_APF_CCQPSTATUS_RDMA_EN_VFS_M \
	RDMA_MASK3(32, 0xFFF, IG3_APF_CCQPSTATUS_RDMA_EN_VFS_S)
#define IG3_APF_CCQPSTATUS_RSVD1_S 7
#define IG3_APF_CCQPSTATUS_RSVD1_M \
	RDMA_MASK3(32, 0x1FF, IG3_APF_CCQPSTATUS_RSVD1_S)
#define IG3_APF_CCQPSTATUS_HMC_PROFILE_S 4
#define IG3_APF_CCQPSTATUS_HMC_PROFILE_M \
	RDMA_MASK3(32, 0x7, IG3_APF_CCQPSTATUS_HMC_PROFILE_S)
#define IG3_APF_CCQPSTATUS_RSVD0_S 1
#define IG3_APF_CCQPSTATUS_RSVD0_M \
	RDMA_MASK3(32, 0x7, IG3_APF_CCQPSTATUS_RSVD0_S)
#define IG3_APF_CCQPSTATUS_CCQP_DONE_S 0
#define IG3_APF_CCQPSTATUS_CCQP_DONE_M \
	RDMA_BIT2(32, IG3_APF_CCQPSTATUS_CCQP_DONE_S)
#define IG3_APF_CQPDB 0xBC00014
#define IG3_APF_CQPDB_RSVD_S 11
#define IG3_APF_CQPDB_RSVD_M RDMA_MASK3(32, 0x1FFFFF, IG3_APF_CQPDB_RSVD_S)
#define IG3_APF_CQPDB_WQHEAD_S 0
#define IG3_APF_CQPDB_WQHEAD_M RDMA_MASK3(32, 0x7FF, IG3_APF_CQPDB_WQHEAD_S)
#define IG3_APF_CQPERRCODES 0xBC00010
#define IG3_APF_CQPERRCODES_CQP_MAJOR_CODE_S 16
#define IG3_APF_CQPERRCODES_CQP_MAJOR_CODE_M \
	RDMA_MASK3(32, 0xFFFF, IG3_APF_CQPERRCODES_CQP_MAJOR_CODE_S)
#define IG3_APF_CQPERRCODES_CQP_MINOR_CODE_S 0
#define IG3_APF_CQPERRCODES_CQP_MINOR_CODE_M \
	RDMA_MASK3(32, 0xFFFF, IG3_APF_CQPERRCODES_CQP_MINOR_CODE_S)
#define IG3_APF_CQPTAIL 0xBC00018
#define IG3_APF_CQPTAIL_CQP_OP_ERR_S 31
#define IG3_APF_CQPTAIL_CQP_OP_ERR_M RDMA_BIT2(32, IG3_APF_CQPTAIL_CQP_OP_ERR_S)
#define IG3_APF_CQPTAIL_RSVD_S 11
#define IG3_APF_CQPTAIL_RSVD_M RDMA_MASK3(32, 0xFFFFF, IG3_APF_CQPTAIL_RSVD_S)
#define IG3_APF_CQPTAIL_WQTAIL_S 0
#define IG3_APF_CQPTAIL_WQTAIL_M RDMA_MASK3(32, 0x7FF, IG3_APF_CQPTAIL_WQTAIL_S)
#define IG3_APF_IPCONFIG0 0xBC00020
#define IG3_APF_IPCONFIG0_RSVD_S 18
#define IG3_APF_IPCONFIG0_RSVD_M \
	RDMA_MASK3(32, 0x3FFF, IG3_APF_IPCONFIG0_RSVD_S)
#define IG3_APF_IPCONFIG0_UDP_SRC_PORT_MASK_EN_S 17
#define IG3_APF_IPCONFIG0_UDP_SRC_PORT_MASK_EN_M \
	RDMA_BIT2(32, IG3_APF_IPCONFIG0_UDP_SRC_PORT_MASK_EN_S)
#define IG3_APF_IPCONFIG0_USEENTIREIDRANGE_S 16
#define IG3_APF_IPCONFIG0_USEENTIREIDRANGE_M \
	RDMA_BIT2(32, IG3_APF_IPCONFIG0_USEENTIREIDRANGE_S)
#define IG3_APF_IPCONFIG0_PEIPID_S 0
#define IG3_APF_IPCONFIG0_PEIPID_M \
	RDMA_MASK3(32, 0xFFFF, IG3_APF_IPCONFIG0_PEIPID_S)
#define IG3_APF_TCPNOWTIMER 0xBC0001C
#define IG3_APF_TCPNOWTIMER_TCP_NOW_S 0
#define IG3_APF_TCPNOWTIMER_TCP_NOW_M \
	RDMA_MASK3(32, 0xFFFFFFFF, IG3_APF_TCPNOWTIMER_TCP_NOW_S)
#define IG3_APF_DBL_AEQALLOC 0xC0000C0
#define IG3_APF_DBL_AEQALLOC_AECOUNT_S 0
#define IG3_APF_DBL_AEQALLOC_AECOUNT_M \
	RDMA_MASK3(32, 0xFFFFFFFF, IG3_APF_DBL_AEQALLOC_AECOUNT_S)
#define IG3_APF_DBL_AEQITRMASK 0xC000C00
#define IG3_APF_DBL_AEQITRMASK_RESERVED_S 1
#define IG3_APF_DBL_AEQITRMASK_RESERVED_M \
	RDMA_MASK3(32, 0x7FFFFFFF, IG3_APF_DBL_AEQITRMASK_RESERVED_S)
#define IG3_APF_DBL_AEQITRMASK_AEQ_ITR_MASK_S 0
#define IG3_APF_DBL_AEQITRMASK_AEQ_ITR_MASK_M \
	RDMA_BIT2(32, IG3_APF_DBL_AEQITRMASK_AEQ_ITR_MASK_S)
#define IG3_APF_DBL_CEQITRMASK 0xC000800
#define IG3_APF_DBL_CEQITRMASK_CEQ_ITR_MASK_S 31
#define IG3_APF_DBL_CEQITRMASK_CEQ_ITR_MASK_M \
	RDMA_BIT2(32, IG3_APF_DBL_CEQITRMASK_CEQ_ITR_MASK_S)
#define IG3_APF_DBL_CEQITRMASK_RESERVED2_S 12
#define IG3_APF_DBL_CEQITRMASK_RESERVED2_M \
	RDMA_MASK3(32, 0x7FFFF, IG3_APF_DBL_CEQITRMASK_RESERVED2_S)
#define IG3_APF_DBL_CEQITRMASK_CEQINDEX_S 0
#define IG3_APF_DBL_CEQITRMASK_CEQINDEX_M \
	RDMA_MASK3(32, 0xFFF, IG3_APF_DBL_CEQITRMASK_CEQINDEX_S)
#define IG3_APF_DBL_CQACK 0xC000400
#define IG3_APF_DBL_CQACK_RSVD_S 25
#define IG3_APF_DBL_CQACK_RSVD_M RDMA_MASK3(32, 0x7F, IG3_APF_DBL_CQACK_RSVD_S)
#define IG3_APF_DBL_CQACK_PECQID_S 0
#define IG3_APF_DBL_CQACK_PECQID_M \
	RDMA_MASK3(32, 0x1FFFFFF, IG3_APF_DBL_CQACK_PECQID_S)
#define IG3_APF_DBL_CQARM 0xC000040
#define IG3_APF_DBL_CQARM_RSVD_S 25
#define IG3_APF_DBL_CQARM_RSVD_M RDMA_MASK3(32, 0x7F, IG3_APF_DBL_CQARM_RSVD_S)
#define IG3_APF_DBL_CQARM_PECQID_S 0
#define IG3_APF_DBL_CQARM_PECQID_M \
	RDMA_MASK3(32, 0x1FFFFFF, IG3_APF_DBL_CQARM_PECQID_S)
#define IG3_APF_DBL_CQPDB 0xC000100
#define IG3_APF_DBL_CQPDB_RSVD_S 11
#define IG3_APF_DBL_CQPDB_RSVD_M \
	RDMA_MASK3(32, 0x1FFFFF, IG3_APF_DBL_CQPDB_RSVD_S)
#define IG3_APF_DBL_CQPDB_CQPHEAD_S 0
#define IG3_APF_DBL_CQPDB_CQPHEAD_M \
	RDMA_MASK3(32, 0x7FF, IG3_APF_DBL_CQPDB_CQPHEAD_S)
#define IG3_APF_DBL_WQEALLOC 0xC000000
#define IG3_APF_DBL_WQEALLOC_WQE_DESC_INDEX_S 20
#define IG3_APF_DBL_WQEALLOC_WQE_DESC_INDEX_M \
	RDMA_MASK3(32, 0xFFF, IG3_APF_DBL_WQEALLOC_WQE_DESC_INDEX_S)
#define IG3_APF_DBL_WQEALLOC_PEQPID_S 0
#define IG3_APF_DBL_WQEALLOC_PEQPID_M \
	RDMA_MASK3(32, 0xFFFFF, IG3_APF_DBL_WQEALLOC_PEQPID_S)

#endif /* IG3RDMA_REGS_APF_H */
