Name: ixgbe-kmp
Summary: Intel(R) 10GbE PCI Express Linux Network Driver
Version: 5.21.6
Release: 1.sles12sp5
Source0: %{name}-%{version}.tar.bz2
License: GPL-2.0
Vendor: Intel Corporation
Group: System/Kernel
URL: http://support.intel.com
BuildRequires: %kernel_module_package_buildreqs pciutils-ids dracut
Requires: pciutils-ids
BuildRoot: %{_tmppath}/%{name}-%{version}-build

%define kernel_ver_number %(uname -r | cut -d- -f1)-%(uname -r | cut -d- -f2)
%define debug_package %{nil}
%global __strip /bin/true

%if 0%{?BUILD_KERNEL:1}
%define kernel_ver %{BUILD_KERNEL}
%define check_aux_args_kernel -b %{BUILD_KERNEL} 
%else
%define kernel_ver %(uname -r)
%endif

%if 0%{?KSRC:1}
%define check_aux_args_ksrc -k %{KSRC}
%endif

%define check_aux_args %check_aux_args_kernel %check_aux_args_ksrc
%define need_aux_rpm %( [ -L /lib/modules/%kernel_ver/source ] && (rpm -q --whatprovides /lib/modules/%kernel_ver/source/include/linux/auxiliary_bus.h > /dev/null 2>&1 && echo 0 || echo 2) || (rpm -q --whatprovides /lib/modules/%kernel_ver/build/include/linux/auxiliary_bus.h > /dev/null 2>&1 && echo 0 || echo 2) )

%(cat > %{_builddir}/%{name}.files << EOF

%defattr(-,root,root)
/lib/modules/%2-%1/updates/ixgbe.ko
/usr
%{_mandir}/man7/ixgbe.7.gz
/usr/share/pci.ids.d/pci.ids.%{name}-%{version}
%doc source/COPYING
%doc source/README
%exclude /lib/modules/%2-%1/extern-symvers/intel_auxiliary.symvers
%exclude /lib/modules/%2-%1/updates/drivers/net/ethernet/intel/auxiliary/intel_auxiliary.ko
%exclude /lib/modules/%2-%1/source/include/linux/auxiliary_bus.h
%exclude /lib/modules/%2-%1/source/include/linux/auxiliary_compat.h
%exclude /lib/modules/%2-%1/source/include/linux/kcompat_generated_defs.h
EOF)

%description
This package contains the Intel(R) 10GbE PCI Express Linux Network Driver.

%kernel_module_package -f %{_builddir}/%{name}.files -r %{release} -n ixgbe -b

%package KMP
Summary: Intel(R) 10GbE PCI Express Linux Network Driver kernel module
Group: System/Kernel

%description KMP
This package contains the Intel(R) 10GbE PCI Express Linux Network Driver.

%prep
%setup -q
set -- *
mkdir source
mv "$@" source/.
echo "ixgbe.ko external" > source/Module.supported
mkdir obj

%build
export INSTALL_MOD_PATH=$RPM_BUILD_ROOT
export INSTALL_MOD_DIR=updates
# flavors_to_build and kernel_source defined by kernel_module_package
for flavor in %flavors_to_build; do
	export _ksrc=/lib/modules/%kernel_ver_number-$flavor/source
	rm -rf obj/$flavor
	cp -r source obj/$flavor
	BUILD_KERNEL=%kernel_ver_number-$flavor KBUILD_OUTPUT=/lib/modules/%kernel_ver_number-$flavor/build make -C $PWD/obj/$flavor/src KSRC=$_ksrc
done

%install
export INSTALL_MOD_PATH=$RPM_BUILD_ROOT
export INSTALL_MOD_DIR=updates
for flavor in %flavors_to_build; do
	export _ksrc=/lib/modules/%kernel_ver_number-$flavor/source
	BUILD_KERNEL=%kernel_ver_number-$flavor KBUILD_OUTPUT=/lib/modules/%kernel_ver_number-$flavor/build make -C $PWD/obj/$flavor/src KSRC=$_ksrc \
		MANDIR=%{_mandir} modules_install mandocs_install
done
mkdir -p $RPM_BUILD_ROOT/usr/share/pci.ids.d
install -D -m 0644 source/pci.updates \
	$RPM_BUILD_ROOT/usr/share/pci.ids.d/pci.ids.%{name}-%{version}

for flavor in %flavors_to_build; do
export _ksrc=%{kernel_source $flavor}
cd %{buildroot}/lib/modules/%kernel_ver_number-$flavor
# Sign the modules(s)
%if %{?_with_modsign:1}%{!?_with_modsign:0}
%define __strip /bin/true
%{!?privkey: %define privkey %{_sysconfdir}/pki/SECURE-BOOT-KEY.priv}
%{!?pubkey: %define pubkey %{_sysconfdir}/pki/SECURE-BOOT-KEY.der}
%{!?_signfile: %define _signfile ${_ksrc}/scripts/sign-file}
for module in `find . -type f -name *.ko`;
do
strip --strip-debug ${module}
$(KSRC=${_ksrc} %{_signfile} sha512 %{privkey} %{pubkey} ${module} > /dev/null 2>&1)
done
%endif
done

%clean
rm -rf %{buildroot}

%{expand:%(
for flavor in %flavors_to_build; do
echo "%triggerin -n %{name}-$flavor -- %{name}-$flavor"
echo "/usr/bin/merge-pciids"
done
)}

