﻿using System;
using System.Windows.Forms;

namespace SampleApp
{
    public partial class OnlookerDetectedForm : Form
    {
        private readonly int[] snoozeTimeOptions = new int[] { 1, 3, 5, 10, 15, 20, 25, 30, 40, 50, 60, 120, 300, 600 };
        public int SnoozeTime = 0;

        public OnlookerDetectedForm()
        {
            InitializeComponent();
            InitializeSnoozeValues();
        }

        private void InitializeSnoozeValues()
        {
            this.onlookerSnoozeComboBox.Items.AddRange(Array.ConvertAll(this.snoozeTimeOptions, x => x.ToString() + " Seconds"));
        }

        private void onlookerSnoozeComboBox_SelectedIndexChanged(object sender, EventArgs e)
        {
            int targetIdx = -1;
            try
            {
                targetIdx = ((ComboBox)sender).SelectedIndex; // Store in case the rug is pulled out
            }
            catch (Exception)
            {
            }
            if (sender is ComboBox && targetIdx > -1 && targetIdx < this.snoozeTimeOptions.Length)
            {
                this.SnoozeTime = this.snoozeTimeOptions[targetIdx] * 1000;
            }
        }
    }
}
