/*
 * Decompiled with CFR 0.152.
 */
package manager.pack;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import manager.common.BuildVersion;
import manager.configure.Platform;
import manager.pack.ISSPackageException;
import manager.pack.data.Dependency;
import manager.pack.data.ISSPackage;
import manager.pack.data.PackageInfo;
import manager.pack.data.Properties;
import manager.pack.data.Resource;
import manager.pack.data.SensorInfo;
import manager.sensor.SensorData;
import manager.sensor.SensorDataManager;
import manager.sensor.SensorDataWrapper;
import manager.utils.ManagerConfigs;
import manager.utils.ManagerEnums;
import manager.utils.ManagerExternalLibraryUtils;
import manager.utils.ManagerFileUtils;
import manager.utils.ManagerUtils;

public class PackUtils {
    public static ArrayList<SensorData> getSensorFromLib(String sensorLibPath, SensorInfo sensorInfo, Platform plat) throws Exception {
        File sensorLibFile = new File(sensorLibPath);
        String sensorLibName = sensorInfo.getSensorName();
        ArrayList<SensorData> ret = new ArrayList<SensorData>();
        File aFilesTempDir = new File(String.valueOf(ManagerFileUtils.getInstallTempFolder()) + "\\newSensors\\a");
        File oFilesTempDir = new File(String.valueOf(ManagerFileUtils.getInstallTempFolder()) + "\\newSensors\\o");
        try {
            if (aFilesTempDir.exists()) {
                ManagerFileUtils.fastDeleteFileOrDirectory(aFilesTempDir);
            }
            aFilesTempDir.mkdirs();
            if (oFilesTempDir.exists()) {
                ManagerFileUtils.fastDeleteFileOrDirectory(oFilesTempDir);
            }
            oFilesTempDir.mkdirs();
            ManagerFileUtils.copyFile(sensorLibFile, new File(String.valueOf(aFilesTempDir.getPath()) + File.separator + sensorLibName + ".a"));
            ManagerExternalLibraryUtils.importStaticLibrary(String.valueOf(aFilesTempDir.getPath()) + File.separator + sensorLibName + ".a", oFilesTempDir.getPath(), ManagerFileUtils.DEFAULT_GCC_DIR());
            File metaDataFile = sensorInfo.getObjectType().equalsIgnoreCase(ManagerEnums.ObjectTypes.VIRTUAL.getFriendlyName()) ? new File(oFilesTempDir + File.separator + sensorLibName.toLowerCase() + "_init.o") : new File(oFilesTempDir + File.separator + sensorLibName.toLowerCase() + ".o");
            if (metaDataFile.exists() && SensorDataManager.hasMetadata(metaDataFile.getAbsolutePath(), plat)) {
                ArrayList<SensorData> sensors = SensorDataManager.getSensorsInfo(metaDataFile.getName(), metaDataFile.getParentFile().getAbsolutePath(), true, plat);
                ret.addAll(sensors);
            } else {
                File[] fileArray = oFilesTempDir.listFiles();
                int n = fileArray.length;
                int n2 = 0;
                while (n2 < n) {
                    File curentFile = fileArray[n2];
                    if (SensorDataManager.hasMetadata(curentFile.getAbsolutePath(), plat)) {
                        ArrayList<SensorData> sensors = SensorDataManager.getSensorsInfo(curentFile.getName(), curentFile.getParentFile().getAbsolutePath(), true, plat);
                        ret.addAll(sensors);
                    }
                    ++n2;
                }
            }
        }
        finally {
            File tempFile = new File(String.valueOf(ManagerFileUtils.getInstallTempFolder()) + "\\newSensors");
            if (tempFile.exists()) {
                ManagerFileUtils.fastDeleteFileOrDirectory(tempFile);
            }
        }
        return ret;
    }

    public static SensorData getSensorFromSensorInfo(SensorInfo sensor, Platform platform, boolean searchInUser) {
        String vendorName;
        String typeName;
        if (platform == null) {
            platform = ManagerConfigs.getDefaultPlatform();
        }
        SensorData sd = new SensorData();
        sd.setObjectType(ManagerEnums.ObjectTypes.getValueByFriendlyName(sensor.getObjectType()));
        sd.setBuildVersion(BuildVersion.parseVersion(sensor.getBuildNumber()));
        sd.setName(sensor.getSensorName());
        int typeId = sensor.getSensorTypeId();
        sd.setTypeId(typeId);
        try {
            if (platform == null) {
                platform = new Platform("ICL");
            }
            typeName = SensorDataManager.findSensorTypeNameById(typeId, searchInUser, platform);
        }
        catch (Exception e) {
            typeName = Integer.toString(typeId);
        }
        sd.setTypeName(typeName);
        int modelId = sensor.getModelId();
        sd.setModelId(modelId);
        String moduleName = sensor.getModelName() == null ? "" : sensor.getModelName();
        sd.setModelName(moduleName);
        sd.setFriendlyModelName(moduleName);
        int vendorId = sensor.getVendorId();
        sd.setVendorId(vendorId);
        try {
            vendorName = SensorDataManager.findVendorNameById(vendorId, searchInUser, platform);
        }
        catch (Exception e) {
            vendorName = Integer.toString(vendorId);
        }
        sd.setVendorName(vendorName);
        if (sensor.getFlags() == -1) {
            sd.setFlags(null);
        } else {
            sd.setFlags(sensor.getFlags());
        }
        sd.setPlatform(platform);
        sd.setSensorCoreAPIVersion(sensor.getApiVersion());
        sd.setFriendlyName(sensor.getFriendlyName());
        if (sensor.getInitFunction() == null || sensor.getInitFunction().isEmpty()) {
            sd.setInitFunction(String.valueOf(sensor.getSensorName()) + "_init");
        } else {
            sd.setInitFunction(sensor.getInitFunction());
        }
        return sd;
    }

    public static PackageInfo parsePackageXML(String xmlFile) throws ISSPackageException, IOException {
        try (FileInputStream xmlInput = null;){
            JAXBContext jc = JAXBContext.newInstance(PackageInfo.class, SensorInfo.class, Resource.class, Dependency.class);
            xmlInput = new FileInputStream(xmlFile);
            PackageInfo pi = (PackageInfo)jc.createUnmarshaller().unmarshal(xmlInput);
            PackageInfo.validatePackageContent(pi, false);
            PackageInfo packageInfo = pi;
            return packageInfo;
        }
    }

    public static boolean generatePackageXML(ISSPackage pkg, String path) throws Exception {
        File xmlFile = new File(path);
        try {
            JAXBContext jc = JAXBContext.newInstance(PackageInfo.class, Properties.class, Resource.class, SensorInfo.class);
            Marshaller marshalller = jc.createMarshaller();
            marshalller.setProperty("jaxb.formatted.output", true);
            marshalller.marshal((Object)pkg.getPackageInfo(), new File(path));
        }
        catch (Exception e) {
            e.printStackTrace();
            if (xmlFile.exists()) {
                xmlFile.delete();
            }
            String err = ManagerUtils.parseException(e);
            throw new ISSPackageException("Generate file failed:" + err);
        }
        return true;
    }

    public static SensorDataWrapper getSensorFromInstalledPath(String luid, String version, String fileName, Platform platform, String specificPath) {
        try {
            File installFolder = specificPath != null && !specificPath.isEmpty() ? new File(specificPath) : new File(ManagerFileUtils.getPackageInstallLocation());
            File[] fileArray = installFolder.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                PackageInfo pi;
                File packageFile = fileArray[n2];
                String xml = String.valueOf(packageFile.getAbsolutePath()) + File.separator + "package.xml";
                if (new File(xml).exists() && (pi = PackUtils.parsePackageXML(xml)) != null && pi.getSensors() != null) {
                    for (SensorInfo sensor : pi.getSensors()) {
                        SensorData data;
                        if (fileName != null && !sensor.getSensorName().equalsIgnoreCase(fileName) || !(data = PackUtils.getSensorFromSensorInfo(sensor, platform, false)).getLuidString().equals(luid) || version != null && !version.equalsIgnoreCase(data.getBuildVersion().toString())) continue;
                        SensorDataWrapper sdw = new SensorDataWrapper(ManagerEnums.ComponentOwner.THIRD_PARTY_PACKAGE, data.getName(), data);
                        ISSPackage ip = new ISSPackage(pi);
                        ip.setState(1);
                        sdw.setIssPackage(ip);
                        return sdw;
                    }
                }
                ++n2;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static SensorDataWrapper getSensorFromInstalledPath(String luid, String version, String fileName, Platform platform) {
        return PackUtils.getSensorFromInstalledPath(luid, version, fileName, platform, null);
    }

    public static String getSensorPathInPackage(SensorDataWrapper sdw, String specificPath) {
        if (sdw != null && sdw.getIssPackage() != null) {
            String sensorName = sdw.getData().getName();
            return sdw.getIssPackage().getInstalledLibraryPath(sensorName, specificPath);
        }
        return null;
    }

    public static SensorDataWrapper getSensorInPackage(SensorDataWrapper sdr) {
        try {
            String fileName = sdr.getFileName();
            File installFolder = new File(ManagerFileUtils.getPackageInstallLocation());
            File[] fileArray = installFolder.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                PackageInfo pi;
                File packageFile = fileArray[n2];
                String xml = String.valueOf(packageFile.getAbsolutePath()) + File.separator + "package.xml";
                if (new File(xml).exists() && (pi = PackUtils.parsePackageXML(xml)) != null && pi.getSensors() != null) {
                    for (SensorInfo sensor : pi.getSensors()) {
                        SensorData data;
                        if (!sensor.getSensorName().equalsIgnoreCase(fileName) || !(data = PackUtils.getSensorFromSensorInfo(sensor, null, false)).getLuidString().equals(sdr.getData().getLuidString()) || !data.getBuildVersion().equals(sdr.getData().getBuildVersion())) continue;
                        return new SensorDataWrapper(ManagerEnums.ComponentOwner.THIRD_PARTY_PACKAGE, fileName, data);
                    }
                }
                ++n2;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static SensorData getSensorDataFromSensorInfo(SensorInfo sensor, ISSPackage issPackage) {
        String libFile = sensor.getInstalledSensorLibFile(issPackage.getInstalledPath(null));
        if (new File(libFile).exists()) {
            ArrayList<SensorData> sds;
            Platform plat = ManagerConfigs.getDefaultPlatform();
            try {
                sds = PackUtils.getSensorFromLib(libFile, sensor, plat);
            }
            catch (Exception e) {
                return null;
            }
            for (SensorData sd : sds) {
                if (!sd.getName().equalsIgnoreCase(sensor.getSensorName())) continue;
                return sd;
            }
        }
        return null;
    }
}

