/*
 * Decompiled with CFR 0.152.
 */
package com.intel.sensing.fdk.model.service;

import com.intel.sensing.fdk.common.exceptions.ISSException;
import com.intel.sensing.fdk.common.utils.ManagerFileUtils;
import com.intel.sensing.fdk.model.ObservableModel;
import com.intel.sensing.fdk.model.abstractData.Version;
import com.intel.sensing.fdk.model.dao.DaoFactory;
import com.intel.sensing.fdk.model.dao.KitDependencyDao;
import com.intel.sensing.fdk.model.dao.ModuleDao;
import com.intel.sensing.fdk.model.entity.FirmwareKit;
import com.intel.sensing.fdk.model.entity.KitDependencyEntity;
import com.intel.sensing.fdk.model.entity.ModuleEntity;
import com.intel.sensing.fdk.model.persistence.cache.Impl.KitModuleCacheManager;
import com.intel.sensing.fdk.model.persistence.cache.api.ModuleFolderCache;
import com.intel.sensing.fdk.model.service.PersistenceServiceListenName;
import com.intel.sensing.fdk.model.service.PlatformService;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class FirmwareKitService
extends ObservableModel
implements PropertyChangeListener {
    private List<FirmwareKit> fwKitList;
    private static FirmwareKitService _instance;
    private KitModuleCacheManager _kitCacheMgr;
    private PlatformService _platformService;
    private ModuleDao _moduleDao;
    private KitDependencyDao _kitDependencyDao;

    private FirmwareKitService() {
    }

    public static FirmwareKitService getInstance() {
        return _instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static FirmwareKitService init() throws ISSException, IOException {
        if (_instance != null) return _instance;
        Class<FirmwareKitService> clazz = FirmwareKitService.class;
        synchronized (FirmwareKitService.class) {
            if (_instance != null) return _instance;
            _instance = new FirmwareKitService();
            _instance._init();
            // ** MonitorExit[var0] (shouldn't be in output)
            return _instance;
        }
    }

    private void _init() throws ISSException, IOException {
        this._kitCacheMgr = KitModuleCacheManager.init();
        this._moduleDao = DaoFactory.getDao(ModuleDao.class);
        this._kitDependencyDao = DaoFactory.getDao(KitDependencyDao.class);
        this._platformService = PlatformService.getInstance();
        this.setFwKitList(this.parse(this._kitCacheMgr.getCache()));
    }

    private List<FirmwareKit> parse(ModuleFolderCache cache) {
        List moduleStrList = cache.getModulelist().stream().map(moduleFile -> ManagerFileUtils.appendPath((String)moduleFile, (String)"module.json")).filter(moduleFilePath -> moduleFilePath != null && Files.exists(moduleFilePath, new LinkOption[0])).map(Path::toString).collect(Collectors.toList());
        List moduleEntityList = moduleStrList.stream().map(module -> this._moduleDao.getEntityByFilePath((String)module)).filter(module -> module != null).collect(Collectors.toList());
        Map<Path, List<ModuleEntity>> moduleMap = moduleEntityList.stream().collect(Collectors.groupingBy(entity -> Paths.get(entity.getAbsoluteParentFolderAsStr().replace(ManagerFileUtils.getKitsBaseDir(), ""), new String[0]).subpath(0, 2)));
        List<FirmwareKit> kitList = moduleMap.keySet().stream().map(key -> {
            String platform = key.getName(0).toString();
            String version = key.getName(1).toString();
            if (platform == null || version == null || version.isEmpty() || version.isBlank() || !this._platformService.supportPlaform(platform)) {
                return null;
            }
            String fwKitPlatformPath = ManagerFileUtils.appendPathAsStr((String)ManagerFileUtils.getKitsBaseDir(), (String)platform);
            String fwKitPath = ManagerFileUtils.appendPathAsStr((String)fwKitPlatformPath, (String)version.toString());
            String kdPath = ManagerFileUtils.appendPathAsStr((String)fwKitPath, (String)"project_kit_dependency.json");
            if (!new File(kdPath).exists()) {
                return null;
            }
            KitDependencyEntity kd = this._kitDependencyDao.getEntityByFilePath(kdPath);
            FirmwareKit kit = new FirmwareKit(fwKitPath);
            kit.setVersion(Version.parseVersion(version));
            kit.setPlatform(platform);
            kit.setModuleList((List)moduleMap.get(key));
            kit.setKitDependency(kd);
            return kit;
        }).filter(kit -> kit != null).collect(Collectors.toList());
        return kitList;
    }

    public List<FirmwareKit> getFwKitByPlatform(String platform) {
        return this.fwKitList.parallelStream().filter(kit -> kit.getPlatform().equals(platform)).sorted().collect(Collectors.toList());
    }

    public FirmwareKit getFwKitByPlatformAndVersion(String platform, Version version) {
        if (this.fwKitList == null) {
            return null;
        }
        return this.fwKitList.parallelStream().filter(kit -> kit.getPlatform().equals(platform)).filter(kit -> kit.getVersion().equals(version)).findFirst().orElse(null);
    }

    public List<FirmwareKit> getAllFwKit() {
        return this.fwKitList;
    }

    public void setFwKitList(List<FirmwareKit> fwKitList) {
        List<FirmwareKit> oldValue = this.fwKitList;
        this.fwKitList = fwKitList;
        this.fwKitList.equals(oldValue);
        if (oldValue != null && !oldValue.equals(fwKitList)) {
            this.firePropertyChange(PersistenceServiceListenName.FWKitService.getServiceListenName(), oldValue, fwKitList);
        }
    }

    public Map<String, List<FirmwareKit>> getFwKitMapByPlatform() {
        return this.fwKitList.parallelStream().collect(Collectors.groupingBy(FirmwareKit::getPlatform));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().contentEquals(PersistenceServiceListenName.ModuleCacheService.getServiceListenName()) || evt.getPropertyName().contentEquals(PersistenceServiceListenName.PlatformService.getServiceListenName())) {
            FirmwareKitService firmwareKitService = this;
            synchronized (firmwareKitService) {
                this.setFwKitList(this.parse(this._kitCacheMgr.getCache()));
            }
        }
    }
}

