/*************************************************************************************************************
 *                                                                                                           *
 *  Copyright (c) 2015 - 2021, Intel Corporation                                                                    *
 *                                                                                                           *
 *  Redistribution and use in source and binary forms, with or without                                       *
 *  modification, are permitted provided that the following conditions are met:                              *
 *                                                                                                           *
 *      * Redistributions of source code must retain the above copyright notice,                             *
 *        this list of conditions and the following disclaimer.                                              *
 *      * Redistributions in binary form must reproduce the above copyright                                  *
 *        notice, this list of conditions and the following disclaimer in the                                *
 *        documentation and/or other materials provided with the distribution.                               *
 *      * Neither the name of Intel Corporation nor the names of its contributors                            *
 *        may be used to endorse or promote products derived from this software                              *
 *        without specific prior written permission.                                                         *
 *                                                                                                           *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"                              *
 *  AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE                                *
 *  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE                           *
 *  DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE                              *
 *  FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL                               *
 *  DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR                               *
 *  SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER                               *
 *  CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,                            *
 *  OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE                            *
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.                                     *
 *                                                                                                           *
 *************************************************************************************************************
 *                                                                                                           *
 *  Module name:                                                                                             *
 *      freebsdos_i.h                                                                                        *
 *                                                                                                           *
 *  Abstract:                                                                                                *
 *      This file contains definitions of interface for freebsd os.                                          *
 *                                                                                                           *
 ************************************************************************************************************/
#ifndef SDK_NAL_INC_FREEBSD_FREEBSDOS_I_H_
#define SDK_NAL_INC_FREEBSD_FREEBSDOS_I_H_

#ifndef NAL_DRIVER
#include <sys/time.h>
#include <stdio.h>
#include <stdarg.h>           /* for va_start etc             */
#include <string.h>
#include <ctype.h>
#include <nalbytes.h>
#endif

#include <freebsddefs.h>
#include <freebsdtypes.h>
#include <naltypes.h>
#include <hwbus_t.h>
#include <sys/errno.h>
#include <sys/stat.h>

#ifndef NAL_DRIVER
/* ===========================================================================================================
 *                                        USER SPACE PROTOTYPES
   =========================================================================================================*/

#include <pthread.h>
#include <freebsdnallibrary.h>

#define NAL_OPEN_FILE_DEFINED

NAL_STATUS
_NalOsSpecIoctlResultToNalErrorCode(
    IN  INT32       IoctlResultCode,
    IN  NAL_STATUS  OperationFailSatus
    );

NAL_STATUS
_NalConnectToIoDriver(
    VOID
    );

NAL_STATUS
_NalConnectToMemDriver(
    VOID
    );

NAL_STATUS
_NalConnectToPciDriver(
    VOID
    );

NAL_STATUS
_NalDisconnectFromIoDriver(
    VOID
    );

NAL_STATUS
_NalDisconnectFromMemDriver(
    VOID
    );

NAL_STATUS
_NalDisconnectFromPciDriver(
    VOID
    );

CHAR *
_NalGetCurrentShell(
    VOID
    );

NAL_PHYSICAL_ADDRESS
_NalFindEfiRsdPtrStructureTable(
    VOID
    );

NAL_STATUS
_NalSilentCommand(
    IN CHAR *         Command ,
    IN NAL_STATUS     CommandFailStatus
    );

NAL_STATUS
_NalScanResponseOfCommand(
      IN CHAR*      Command ,
      IN NAL_STATUS FailedStatus ,
      IN CHAR*      Format ,
      ...
      );

extern NAL_OS_SPEC_GLOBAL_VARIABLES Global_OsVariables;
#else
/* ===========================================================================================================
 *                                          QV DRIVER PROTOTYPES
   =========================================================================================================*/

#include <machine/bus.h>
#include <sys/param.h>
#include <sys/bus.h>

#include <machine/bus.h>
#include <sys/rman.h>
#include <machine/resource.h>

extern NAL_OS_SPEC_PCI_ALLOCATION_SLOT    Global_PciAllocationSlotsTable[NAL_OS_SPEC_MAX_NON_PAGED_MEMORY_ALLOCATIONS];
extern NAL_OS_SPEC_DMA_ALLOCATION_SLOT    Global_DmaAllocationSlotsTable[NAL_OS_SPEC_MAX_NON_PAGED_MEMORY_ALLOCATIONS];
#endif
/* ===========================================================================================================
 *                                          COMMON PROTOTYPES
   =========================================================================================================*/
KVOID*
NalKMemset(
    IN KVOID*  Dest,
    IN int     Value,
    IN UINTN   Size
    );

VOID*
NalKtoUMemcpy(
    IN VOID*        Dest,
    IN const KVOID* Source,
    IN UINTN        Size
    );

KVOID*
NalKtoKMemcpy(
    IN KVOID*       Dest,
    IN const KVOID* Source,
    IN UINTN        Size
    );

KVOID*
NalUtoKMemcpy(
    IN KVOID*       Dest,
    IN const VOID*  Source,
    IN UINTN        Size
    );

#endif /* SDK_NAL_INC_FREEBSD_FREEBSDOS_I_H_ */
