/* SPDX-License-Identifier: GPL-2.0 or Linux-OpenIB */
/* Copyright (c) 2020 Intel Corporation */
#ifndef SUSE_KCOMPAT_H
#define SUSE_KCOMPAT_H

#ifdef SLES_15_SP_2
int irdma_alloc_ucontext(struct ib_ucontext *uctx, struct ib_udata *udata);
void irdma_dealloc_ucontext(struct ib_ucontext *context);
int irdma_alloc_pd(struct ib_pd *pd, struct ib_udata *udata);
void irdma_dealloc_pd(struct ib_pd *ibpd, struct ib_udata *udata);
int irdma_add_gid(struct ib_device *device,
		  u8 port_num,
		  unsigned int index,
		  const union ib_gid *gid,
		  const struct ib_gid_attr *attr,
		  void **context);
int irdma_del_gid(struct ib_device *device,
		  u8 port_num,
		  unsigned int index,
		  void **context);

#define CREATE_AH_VER_2
#define DESTROY_AH_VER_3
#define ALLOC_UCONTEXT_VER_2
#define DEALLOC_UCONTEXT_VER_2
#define ALLOC_PD_VER_3
#define DEALLOC_PD_VER_3
#define IB_DEALLOC_DRIVER_SUPPORT
#define SET_ROCE_CM_INFO_VER_3
#define IB_UMEM_GET_V1
#define RDMA_MMAP_DB_SUPPORT
#define DEVLINK_RELOAD_DOWN_NETNS_CHANGE
#define HAS_IB_SET_DEVICE_OP
#define IRDMA_DEVLINK_RELOAD_SPLIT_OPS
#define NETDEV_TO_IBDEV_SUPPORT
#define SET_BEST_PAGE_SZ_V2
#define IB_IW_PKEY

#define kc_typeq_ib_wr const
#define kc_set_ibdev_add_del_gid(ibdev)
#define kc_set_props_ip_gid_caps(props) ((props)->ip_gids = true)
#define kc_deref_sgid_attr(sgid_attr)   ((sgid_attr)->ndev)
#define kc_ib_register_device(device, name) ib_register_device(device, name)
#define kc_rdma_udata_to_drv_context(ibpd, udata) rdma_udata_to_drv_context(udata, struct irdma_ucontext, ibucontext)
#define devlink_params_publish(devlink)
#define kc_destroy_qp(ibqp, udata) irdma_destroy_qp(ibqp, udata)
#define kc_get_ucontext(udata) rdma_udata_to_drv_context(udata, struct irdma_ucontext, ibucontext)
#define ah_attr_to_dmac(attr) ((attr).roce.dmac)
#define set_ibdev_dma_device(ibdev, dev)

#define set_max_sge(props, rf) do { \
	((props)->max_send_sge = (rf)->sc_dev.hw_attrs.uk_attrs.max_hw_wq_frags); \
	((props)->max_recv_sge = (rf)->sc_dev.hw_attrs.uk_attrs.max_hw_wq_frags); \
	} while (0)

#define kc_rdma_gid_attr_network_type(sgid_attr, gid_type, gid) \
	rdma_gid_attr_network_type(sgid_attr)

#define kc_ib_modify_qp_is_ok(cur_state, next_state, type, mask, ll) \
	ib_modify_qp_is_ok(cur_state, next_state, type, mask)
#endif /* SLES_15_SP2 */

#ifdef SLES_15_SP_1
enum ib_port_phys_state {
	IB_PORT_PHYS_STATE_SLEEP = 1,
	IB_PORT_PHYS_STATE_POLLING = 2,
	IB_PORT_PHYS_STATE_DISABLED = 3,
	IB_PORT_PHYS_STATE_PORT_CONFIGURATION_TRAINING = 4,
	IB_PORT_PHYS_STATE_LINK_UP = 5,
	IB_PORT_PHYS_STATE_LINK_ERROR_RECOVERY = 6,
	IB_PORT_PHYS_STATE_PHY_TEST = 7,
};

struct ib_ucontext *irdma_alloc_ucontext(struct ib_device *ibdev, struct ib_udata *udata);
int irdma_dealloc_ucontext(struct ib_ucontext *context);
struct ib_pd *irdma_alloc_pd(struct ib_device *ibdev, struct ib_ucontext *context, struct ib_udata *udata);
int irdma_dealloc_pd(struct ib_pd *ibpd);
int irdma_add_gid(struct ib_device *device,
		  u8 port_num,
		  unsigned int index,
		  const union ib_gid *gid,
		  const struct ib_gid_attr *attr,
		  void **context);
int irdma_del_gid(struct ib_device *device,
		  u8 port_num,
		  unsigned int index,
		  void **context);

#define CREATE_AH_VER_4
#define DESTROY_AH_VER_1
#define ALLOC_UCONTEXT_VER_1
#define DEALLOC_UCONTEXT_VER_1
#define ALLOC_PD_VER_1
#define DEALLOC_PD_VER_1
#define SET_ROCE_CM_INFO_VER_2
#define IRDMA_SET_DRIVER_ID
#define IRDMA_ADD_DEL_GID
#define IB_UMEM_GET_V1
#define SET_BEST_PAGE_SZ_V1
#define IB_IW_PKEY

#define kc_typeq_ib_wr const
#define kc_set_ibdev_add_del_gid(ibdev)
#define kc_set_props_ip_gid_caps(props) ((props)->ip_gids = true)
#define kc_deref_sgid_attr(sgid_attr)   ((sgid_attr)->ndev)
#define kc_ib_register_device(device, name) ib_register_device(device, name, NULL)
#define kc_rdma_udata_to_drv_context(ibpd, udata) to_ucontext(ibpd->uobject->context)
#define ib_device_put(dev)
#define devlink_params_publish(devlink)
#define kc_destroy_qp(ibqp, udata) irdma_destroy_qp(ibqp)
#define kc_get_ucontext(udata) to_ucontext(context)
#define ah_attr_to_dmac(attr) ((attr).roce.dmac)
#define set_ibdev_dma_device(ibdev, dev)

#define set_max_sge(props, rf) do { \
	((props)->max_send_sge = (rf)->sc_dev.hw_attrs.uk_attrs.max_hw_wq_frags); \
	((props)->max_recv_sge = (rf)->sc_dev.hw_attrs.uk_attrs.max_hw_wq_frags); \
	} while (0)

#define kc_rdma_gid_attr_network_type(sgid_attr, gid_type, gid) \
	rdma_gid_attr_network_type(sgid_attr)

#define ib_alloc_device(irdma_device, ibdev) \
	((struct irdma_device *)ib_alloc_device(sizeof(struct irdma_device)))

#define kc_ib_modify_qp_is_ok(cur_state, next_state, type, mask, ll) \
	ib_modify_qp_is_ok(cur_state, next_state, type, mask)

#define ib_umem_get(udata, addr, size, access, dmasync) \
	ib_umem_get(pd->uobject->context, addr, size, access, dmasync)
#endif /* SLES_15_SP_1 */

#ifdef SLES_15
enum ib_port_phys_state {
	IB_PORT_PHYS_STATE_SLEEP = 1,
	IB_PORT_PHYS_STATE_POLLING = 2,
	IB_PORT_PHYS_STATE_DISABLED = 3,
	IB_PORT_PHYS_STATE_PORT_CONFIGURATION_TRAINING = 4,
	IB_PORT_PHYS_STATE_LINK_UP = 5,
	IB_PORT_PHYS_STATE_LINK_ERROR_RECOVERY = 6,
	IB_PORT_PHYS_STATE_PHY_TEST = 7,
};

struct ib_ucontext *irdma_alloc_ucontext(struct ib_device *ibdev, struct ib_udata *udata);
int irdma_dealloc_ucontext(struct ib_ucontext *context);
struct ib_pd *irdma_alloc_pd(struct ib_device *ibdev, struct ib_ucontext *context, struct ib_udata *udata);
int irdma_dealloc_pd(struct ib_pd *ibpd);
int irdma_add_gid(struct ib_device *device,
		  u8 port_num,
		  unsigned int index,
		  const union ib_gid *gid,
		  const struct ib_gid_attr *attr,
		  void **context);
int irdma_del_gid(struct ib_device *device,
		  u8 port_num,
		  unsigned int index,
		  void **context);

#define CREATE_AH_VER_1_2
#define DESTROY_AH_VER_1
#define ALLOC_UCONTEXT_VER_1
#define DEALLOC_UCONTEXT_VER_1
#define ALLOC_PD_VER_1
#define DEALLOC_PD_VER_1
#define SET_ROCE_CM_INFO_VER_1
#define IRDMA_ADD_DEL_GID
#define IB_UMEM_GET_V1
#define SET_BEST_PAGE_SZ_V1
#define ETHER_COPY_VER_2
#define IB_GET_CACHED_GID
#define IB_IW_PKEY
#define IB_UVERBS_CQ_FLAGS_TIMESTAMP_COMPLETION IB_CQ_FLAGS_TIMESTAMP_COMPLETION

#define kc_typeq_ib_wr
#define kc_set_props_ip_gid_caps(props) \
	((props)->port_cap_flags  |= IB_PORT_IP_BASED_GIDS)
#define kc_deref_sgid_attr(sgid_attr)	((sgid_attr).ndev)
#define kc_ib_register_device(device, name) ib_register_device(device, NULL)
#define kc_rdma_udata_to_drv_context(ibpd, udata) to_ucontext(ibpd->uobject->context)
#define ib_device_put(dev)
#define devlink_params_publish(devlink)
#define kc_destroy_qp(ibqp, udata) irdma_destroy_qp(ibqp)
#define kc_get_ucontext(udata) to_ucontext(context)
#define ah_attr_to_dmac(attr) ((attr).roce.dmac)
#define set_ibdev_dma_device(ibdev, dev)

#define kc_set_ibdev_add_del_gid(ibdev) do {   \
	ibdev->add_gid = irdma_add_gid;  \
	ibdev->del_gid = irdma_del_gid;  \
} while (0)

#define set_max_sge(props, rf)  \
	((props)->max_sge = (rf)->sc_dev.hw_attrs.uk_attrs.max_hw_wq_frags)

#define kc_rdma_gid_attr_network_type(sgid_attr, gid_type, gid) \
	ib_gid_to_network_type(gid_type, gid)

#define rdma_query_gid(ibdev, port, index, gid) \
	ib_get_cached_gid(ibdev, port, index, gid, NULL)

#define ib_alloc_device(irdma_device, ibdev) \
	((struct irdma_device *)ib_alloc_device(sizeof(struct irdma_device)))

#define kc_ib_modify_qp_is_ok(cur_state, next_state, type, mask, ll) \
	ib_modify_qp_is_ok(cur_state, next_state, type, mask, ll)

#define ibdev_dbg(ibdev, ...) \
	dev_dbg(&((ibdev)->dev), __VA_ARGS__)

#define ib_umem_get(udata, addr, size, access, dmasync) \
	ib_umem_get(pd->uobject->context, addr, size, access, dmasync)
#endif /* SLES_15 */

#ifdef SLES_12_SP_4
enum ib_port_phys_state {
	IB_PORT_PHYS_STATE_SLEEP = 1,
	IB_PORT_PHYS_STATE_POLLING = 2,
	IB_PORT_PHYS_STATE_DISABLED = 3,
	IB_PORT_PHYS_STATE_PORT_CONFIGURATION_TRAINING = 4,
	IB_PORT_PHYS_STATE_LINK_UP = 5,
	IB_PORT_PHYS_STATE_LINK_ERROR_RECOVERY = 6,
	IB_PORT_PHYS_STATE_PHY_TEST = 7,
};

struct ib_ucontext *irdma_alloc_ucontext(struct ib_device *ibdev, struct ib_udata *udata);
int irdma_dealloc_ucontext(struct ib_ucontext *context);
struct ib_pd *irdma_alloc_pd(struct ib_device *ibdev, struct ib_ucontext *context, struct ib_udata *udata);
int irdma_dealloc_pd(struct ib_pd *ibpd);
int irdma_add_gid(struct ib_device *device,
		  u8 port_num,
		  unsigned int index,
		  const union ib_gid *gid,
		  const struct ib_gid_attr *attr,
		  void **context);
int irdma_del_gid(struct ib_device *device,
		  u8 port_num,
		  unsigned int index,
		  void **context);

#define CREATE_AH_VER_1_2
#define DESTROY_AH_VER_1
#define ALLOC_UCONTEXT_VER_1
#define DEALLOC_UCONTEXT_VER_1
#define ALLOC_PD_VER_1
#define DEALLOC_PD_VER_1
#define SET_ROCE_CM_INFO_VER_1
#define IRDMA_ADD_DEL_GID
#define IB_UMEM_GET_V1
#define SET_BEST_PAGE_SZ_V1
#define ETHER_COPY_VER_2
#define IB_GET_CACHED_GID
#define IB_IW_PKEY
#define IB_UVERBS_CQ_FLAGS_TIMESTAMP_COMPLETION IB_CQ_FLAGS_TIMESTAMP_COMPLETION

#define kc_typeq_ib_wr
#define kc_deref_sgid_attr(sgid_attr)        ((sgid_attr).ndev)
#define kc_ib_register_device(device, name) ib_register_device(device, NULL)
#define kc_rdma_udata_to_drv_context(ibpd, udata) to_ucontext(ibpd->uobject->context)
#define ib_device_put(dev)
#define devlink_params_publish(devlink)
#define kc_destroy_qp(ibqp, udata) irdma_destroy_qp(ibqp)
#define kc_get_ucontext(udata) to_ucontext(context)
#define ah_attr_to_dmac(attr) ((attr).roce.dmac)
#define set_ibdev_dma_device(ibdev, dev)

#define kc_set_ibdev_add_del_gid(ibdev) do {   \
	ibdev->add_gid = irdma_add_gid;  \
	ibdev->del_gid = irdma_del_gid;  \
} while (0)

#define set_max_sge(props, rf)  \
	((props)->max_sge = (rf)->sc_dev.hw_attrs.uk_attrs.max_hw_wq_frags)

#define kc_set_props_ip_gid_caps(props) \
	((props)->port_cap_flags  |= IB_PORT_IP_BASED_GIDS)

#define kc_rdma_gid_attr_network_type(sgid_attr, gid_type, gid) \
	ib_gid_to_network_type(gid_type, gid)

#define rdma_query_gid(ibdev, port, index, gid) \
	ib_get_cached_gid(ibdev, port, index, gid, NULL)

#define ib_alloc_device(irdma_device, ibdev) \
	((struct irdma_device *)ib_alloc_device(sizeof(struct irdma_device)))

#define kc_ib_modify_qp_is_ok(cur_state, next_state, type, mask, ll) \
	ib_modify_qp_is_ok(cur_state, next_state, type, mask, ll)

#define ib_umem_get(udata, addr, size, access, dmasync) \
	ib_umem_get(pd->uobject->context, addr, size, access, dmasync)
#endif /* SLES_12_SP_4 */

#ifdef SLES_12_SP_5
enum ib_port_phys_state {
	IB_PORT_PHYS_STATE_SLEEP = 1,
	IB_PORT_PHYS_STATE_POLLING = 2,
	IB_PORT_PHYS_STATE_DISABLED = 3,
	IB_PORT_PHYS_STATE_PORT_CONFIGURATION_TRAINING = 4,
	IB_PORT_PHYS_STATE_LINK_UP = 5,
	IB_PORT_PHYS_STATE_LINK_ERROR_RECOVERY = 6,
	IB_PORT_PHYS_STATE_PHY_TEST = 7,
};

struct ib_ucontext *irdma_alloc_ucontext(struct ib_device *ibdev, struct ib_udata *udata);
int irdma_dealloc_ucontext(struct ib_ucontext *context);
struct ib_pd *irdma_alloc_pd(struct ib_device *ibdev, struct ib_ucontext *context, struct ib_udata *udata);
int irdma_dealloc_pd(struct ib_pd *ibpd);
int irdma_add_gid(struct ib_device *device,
		  u8 port_num,
		  unsigned int index,
		  const union ib_gid *gid,
		  const struct ib_gid_attr *attr,
		  void **context);
int irdma_del_gid(struct ib_device *device,
		  u8 port_num,
		  unsigned int index,
		  void **context);

#define CREATE_AH_VER_1_2
#define DESTROY_AH_VER_1
#define ALLOC_UCONTEXT_VER_1
#define DEALLOC_UCONTEXT_VER_1
#define ALLOC_PD_VER_1
#define DEALLOC_PD_VER_1
#define SET_ROCE_CM_INFO_VER_2
#define IRDMA_ADD_DEL_GID
#define IB_UMEM_GET_V1
#define SET_BEST_PAGE_SZ_V1
#define ETHER_COPY_VER_2
#define IB_GET_CACHED_GID
#define IB_IW_PKEY

#define kc_typeq_ib_wr
#define kc_deref_sgid_attr(sgid_attr)        (sgid_attr.ndev)
#define kc_ib_register_device(device, name) ib_register_device(device, NULL)
#define kc_rdma_udata_to_drv_context(ibpd, udata) to_ucontext(ibpd->uobject->context)
#define ib_device_put(dev)
#define devlink_params_publish(devlink)
#define kc_destroy_qp(ibqp, udata) irdma_destroy_qp(ibqp)
#define kc_get_ucontext(udata) to_ucontext(context)
#define ah_attr_to_dmac(attr) ((attr).roce.dmac)
#define set_ibdev_dma_device(ibdev, dev)

#define kc_set_ibdev_add_del_gid(ibdev) do {   \
	ibdev->add_gid = irdma_add_gid;  \
	ibdev->del_gid = irdma_del_gid;  \
} while (0)

#define set_max_sge(props, rf)  \
	((props)->max_sge = (rf)->sc_dev.hw_attrs.uk_attrs.max_hw_wq_frags)

#define kc_set_props_ip_gid_caps(props) \
	((props)->port_cap_flags  |= IB_PORT_IP_BASED_GIDS)

#define kc_rdma_gid_attr_network_type(sgid_attr, gid_type, gid) \
	ib_gid_to_network_type(gid_type, gid)

#define rdma_query_gid(ibdev, port, index, gid) \
	ib_get_cached_gid(ibdev, port, index, gid, NULL)

#define ib_alloc_device(irdma_device, ibdev) \
	((struct irdma_device *)ib_alloc_device(sizeof(struct irdma_device)))

#define kc_ib_modify_qp_is_ok(cur_state, next_state, type, mask, ll) \
	ib_modify_qp_is_ok(cur_state, next_state, type, mask, ll)

#define ib_umem_get(udata, addr, size, access, dmasync) \
	ib_umem_get(pd->uobject->context, addr, size, access, dmasync)
#endif /* SLES_12_SP_5 */

#endif /* SUSE_KCOMPAT_H */
