<?php
class ActionDeleteDG extends UserAction
{
	private $DG_ID;	
	//private $AdapterID;
	const DeleteCheckPara = "DeleteCheck";
	private $deleteChecked = 0;
//	private $toStop = 0;
//	private $isOffline = 0;
//	private $isForeign = 0;
	private $Actions = BgaControl::BGA_CONTROL_TERMINATE_IMMEDIATE;
    const ToStopMP = "ToStopMP";
    private $isRunningMP = 0;
	
	private $stopBGASuccess = 1;
	
	protected function initActionPara()
	{
		$this->DG_ID = getRequestPara("DGID");
		$this->deleteChecked = getRequestPara(self::DeleteCheckPara);
	}
	
	protected function validatePara()
	{
		//check the http request parameters
	}
	
	private function doStopBGA()
	{
		$this->ApiCmd = new XMLAPICommand();
		$this->ApiCmd->setCommand(XMLAPICommand::MV_DG_BGAControl);
		$this->ApiCmd->setCommandPara("AdapterID",$this->getAdapterID());
		$this->ApiCmd->setCommandPara("DG_ID",$this->DG_ID);
		$this->ApiCmd->setCommandPara("Actions",$this->Actions);
		$this->ApiCmd->issueCommand();
		
		//var_dump($this->ApiCmd);
		if ($this->ApiCmd->getResult()->RetVal . "") 
		{
			$this->stopBGASuccess = 0;
		}
		else 
		{
			$this->stopBGASuccess = 1;
		}
		
	}
	
	private function doDelete()
	{
		$this->ApiCmd = new XMLAPICommand();
		$this->ApiCmd->setCommand(XMLAPICommand::MV_DG_Delete);
		$this->ApiCmd->setCommandPara("AdapterID",$this->getAdapterID());
		$this->ApiCmd->setCommandPara("DG_ID",$this->DG_ID);
		$this->ApiCmd->issueCommand();
		
		if ($this->ApiCmd->getResult()->RetVal . "") {
			$this->setDGCmdXmlRetFail();
		}
		else {
			$this->deleteRelatedSchedule();//don't check
			$this->setDeleteDGXmlRetSuccess();
		}
		
	}
	
	private function setDeleteDGXmlRetSuccess()
	{
		$this->xmlRet = new SuccessXMLRet();
		$this->xmlRet->Msg = "";
		$this->xmlRet->Url = getBaseURL() . PHPPageName::TargetPageName
			. "?Target=" . Target::getHBADetail . "&ID=" . $this->getAdapterID() ;
	}
	
	private function deleteRelatedSchedule()
	{
		$da = new BGAJobDataAccess();
		$da->deleteBGAJobByDGID($this->DG_ID, $this->getAdapterID());
	}
	
/*	private function setAdapterID()
	{
		include_once("../phpsrc/baseclass/DG.class.php");
		include_once("../phpsrc/baseclass/DGBase.class.php");
		include_once("../phpsrc/baseclass/DGDetail.class.php");
		
		$dg = new DgDetail();
		$dg->setDGID($this->DG_ID);
		$dg->toGetDGInfo();
		$dg->initData();
		$this->AdapterID = 0;
		$list = $dg->getBaseClasses();
		if ($list) {
			$dg = array_shift($list);
			$this->AdapterID = $dg->getAdapterID();
		}
		
	}
	*/

	private function setFlags()
	{
		include_once("../phpsrc/baseclass/Device.class.php");
		include_once("../phpsrc/baseclass/SASDevice.class.php");
		include_once("../phpsrc/baseclass/DeviceFactory.class.php");
		include_once("../phpsrc/baseclass/PortDevice.class.php");
		include_once("../phpsrc/baseclass/Block.class.php");
		include_once("../phpsrc/baseclass/HD.class.php");
		include_once("../phpsrc/baseclass/PM.class.php");
		include_once("../phpsrc/baseclass/HBA.class.php");
		include_once("../phpsrc/baseclass/ExpanderDevice.class.php");
		include_once("../phpsrc/baseclass/DG.class.php");
		include_once("../phpsrc/baseclass/DgDetail.class.php");
		$dgDtl = new DgDetail();
		$dgDtl->setAdapterID($this->getAdapterID());
		$dgDtl->setDGID($this->DG_ID);
		$dgDtl->toGetDgInfo();

		$base = $dgDtl->getBaseClasses();
		if (sizeof($base)) {
		    $dgDetail = array_shift($base);
            if ($dgDetail->getPDBgaRunning()) {
                $this->isRunningMP = 1;
            }
        }
    }
    
	protected function doAction()
	{
        $cmdName = trim(getRequestPara("cmdName"));
		$this->setFlags();

        if ((getRequestPara(self::ToStopMP) == null) && $this->isRunningMP) {
			$YesUrl = getBaseURL() . PHPPageName::CmdPageName
				. "?cmdName=" . $cmdName ;
			$YesUrl .=  "&DGID" . "=" . $this->DG_ID . "&HBAID=" . $this->HBAID;
			$YesUrl .=  "&" . self::ToStopMP  . "= 1";

			$NoUrl = getBaseURL()
					. PHPPageName::TargetPageName ."?Target=" . Target::getArraySubPage
                    . "&ID=" . $this->DG_ID . "&HBAID=" . $this->HBAID;

			$this->xmlRet = new ContXMLRet();
			$this->xmlRet->Msg =
				AlertMsg::DGINFO_STOP_MP;
			$this->xmlRet->YesUrl = $YesUrl;
			$this->xmlRet->NoUrl = $NoUrl;
			$this->xmlRet->YesUrlType = XMLRetUrlType::CmdUrl;
			$this->xmlRet->NoUrlType = XMLRetUrlType::PageUrl;
            return;
        }

		if ($this->xmlRet == null) {
				$this->Actions = BgaControl::BGA_CONTROL_TERMINATE_IMMEDIATE;
				$this->doStopBGA();
				$this->doDelete();
		}
	}
}
?>