//LD Create add information in page
var ArrayCreate = new Object();
ArrayCreate.MSG_RMODE_NOTMATCH = 'Number of PDs does not match the giving RAID Mode!';
ArrayCreate.MSG_PARITYNUM_OUTOFRANGE="Total parity disks of RAID6 should be a number between 2 and ";
ArrayCreate.MSG_PARITYNUMERROE_R60="Total parity disks of RAID60 should be an EVEN number between 4 and ";
ArrayCreate.MSG_PARITY_BENUMBER = "Invalid parity disks number";
ArrayCreate.MSG_PDTYPE_NOTCONSISTENT = "Mixed SAS and SATA PDs are not allowed in a single array";
ArrayCreate.MSG_NAME_INVALID = "Array name can only contain numbers, letters, spaces, underlines!";

ArrayCreate.HBAID=255;

ArrayCreate.initialize = function()
{
	//globe variable
	ArrayCreate.iRaidMode = -1;
	ArrayCreate.aHDs=new Array();
	ArrayCreate.aHDsType=new Array();
	ArrayCreate.iHDsLength=0;
	ArrayCreate.iCache=-1;
	ArrayCreate.iStripe=-1;
	ArrayCreate.oArrayName="";
	ArrayCreate.sArrayName="";
	
	ArrayCreate.oCache=null;
	ArrayCreate.oStripe=null;
	ArrayCreate.oRaidMode = null;
	ArrayCreate.oArrayName=null;
	ArrayCreate.oSubmit=null;
	ArrayCreate.oNext=null;
	
	
	ArrayCreate.oParity=null;
	ArrayCreate.oParityDiv = null;
	ArrayCreate.iParityDisk=2;
	
	ArrayCreate.oSubmit=getObjectById('submitBtn');
	ArrayCreate.oRaidMode=getObjectById('raidModeSel');
	ArrayCreate.oCache=getObjectById('selArrayCache');
	
	if (getObjectById('selStripeSize').style.display != 'none')
		ArrayCreate.oStripe=getObjectById('selStripeSize');
	else
		ArrayCreate.oStripe=getObjectById('selStripeSize');
		
	ArrayCreate.oArrayName=getObjectById('createArrayName');
	ArrayCreate.oParity=getObjectById('inputParity');
	
	ArrayCreate.InputParityShow();
}


ArrayCreate.unSelectHD=function(oImg)
{
    if (oImg!=null){oImg.className="drvSelOFF";}
}

ArrayCreate.selectHD=function(oImg)
{
    if (oImg!=null){oImg.className="drvSelON";}
}

ArrayCreate.disableButton=function(oButton)
{
    if (oButton!=null){oButton.onclick=doNothing;oButton.className="disButtChar";}
}

ArrayCreate.enableButton=function(oButton)
{
    if (oButton!=null){oButton.className="buttonChar";}
}

ArrayCreate.enableSubmit=function()
{
    ArrayCreate.Page2Value();
    ArrayCreate.oSubmit.onclick=ArrayCreate.doCreate;
    ArrayCreate.enableButton(ArrayCreate.oSubmit);
}

ArrayCreate.onkeyupCheckEnable=function(){
	if (CheckLDMode(ArrayCreate.iRaidMode,ArrayCreate.iHDsLength)){
		ArrayCreate.enableSubmit();
	}
}

ArrayCreate.doCreate=function()
{
    ArrayCreate.disableButton(ArrayCreate.oSubmit);
    ArrayCreate.Page2Value();
    if (ArrayCreate.checkPage())
    {
		//alert('create');
        var cmdURL="command.php?cmdName=createDGSubmit";
        cmdURL+=ArrayCreate.linkURL();
        var createCMD=new Command(cmdURL);
        createCMD.run();
        var result = createCMD.getResult();
        if (result!="")
        {
			MarvellRaidDetail.partUrl = result+"&newCreate=1";
            MarvellRaidDetail.run();
        }
		//MarvellRaidTree.setCurrentNode("treelink_"+MarvellRaidTree.ARRAY_LEAF+);
		MarvellRaidTree.run();
        createCMD=null;
        cmdURL=null;
    }
    else
    {
        //if (ArrayCreate.sMSG!="") {alert(ArrayCreate.sMSG);ArrayCreate.sMSG="";}
        if (ArrayCreate.oControl!=null) 
        {
            if (ArrayCreate.oControl==ArrayCreate.oStripe) {selHasError(ArrayCreate.oControl);}
            else {txtHasError(ArrayCreate.oControl);}
            ArrayCreate.oControl=null;
        }
    }
    return false;
}

ArrayCreate.checkSelectedHDType=function(){
	if (ArrayCreate.iHDsLength)
	{
		var type = ArrayCreate.aHDsType[0];
		for(var i=1; i< ArrayCreate.iHDsLength; i++) {
			if (ArrayCreate.aHDsType[i] != type){
				return false;
			}
		}
	}
	return true;
}

ArrayCreate.checkPage=function()
{
    var bVaule=true;

    if (ArrayCreate.iRaidMode==6||ArrayCreate.iRaidMode==96) {
		if (!ArrayCreate.checkParityNum()) {
			txtHasError(ArrayCreate.oParity);
			return false;
		}
	}
    if (!CheckName(ArrayCreate.oArrayName,ArrayCreate.MSG_NAME_INVALID)) {bVaule=false;}
    return bVaule;
}

ArrayCreate.getHDsUrl=function()
{
    var sHDs="";
    if (ArrayCreate.iHDsLength>0) {sHDs="&HDIDs=";}
    for (var i=0;i<ArrayCreate.iHDsLength;i++)
    {
        if (i==0)
        {
            sHDs+=ArrayCreate.aHDs[i];
        }
        else
        {
            sHDs+=("%20"+ArrayCreate.aHDs[i]);
        }
    }
    return sHDs;
}

ArrayCreate.getLDSize=function()
{
    var urlPath = "JumpPage.php?ra="+RefreshControl.getSeq()
    	+"&Target=getLdMax&RaidMode="+ArrayCreate.iRaidMode
		+"&NumOfParityDisk"+ArrayCreate.iParityDisk+"&HBAID="+ArrayCreate.HBAID;
    urlPath+=ArrayCreate.getHDsUrl();
    ContentLoader.loadXMLImmediate(ArrayCreate,urlPath);
    urlPath=null;
}

ArrayCreate.clickHD=function(pdType, idClickHD,idSelImg)
{
    var selHDImg=document.getElementById(idSelImg);
    if (selHDImg.className=="drvSelON")
    {
        for (var i=0;i<ArrayCreate.iHDsLength;i++)
        {
            if (ArrayCreate.aHDs[i]==idClickHD)
            {
                ArrayCreate.aHDs.splice(i,1);
                ArrayCreate.aHDsType.splice(i,1);
                break;
            }
        }
        ArrayCreate.unSelectHD(selHDImg);
        ArrayCreate.iHDsLength--;
    }
    else
    {
		ArrayCreate.aHDsType[ArrayCreate.iHDsLength] = pdType;
        ArrayCreate.aHDs[ArrayCreate.iHDsLength]=idClickHD;
        ArrayCreate.iHDsLength++;
        ArrayCreate.selectHD(selHDImg);
    }
    selHDImg=null;
    ArrayCreate.selMode();
    return false;
}

ArrayCreate.addHDID=function(iID)
{
    ArrayCreate.aHDs[ArrayCreate.iHDsLength]=iID;
    ArrayCreate.iHDsLength++;
}

ArrayCreate.linkURL=function()
{
    var sUrl=ArrayCreate.getHDsUrl();
    if (ArrayCreate.iRaidMode!=-1) {sUrl+=("&RaidMode="+ArrayCreate.iRaidMode);}
    if (ArrayCreate.sArrayName!="") {sUrl+=("&DGName="+ArrayCreate.sArrayName);}
    if (ArrayCreate.iCache!=-1) {sUrl+=("&EnableCache="+ArrayCreate.iCache);}
    if (ArrayCreate.iStripe!=-1) {sUrl+=("&StripeSize="+ArrayCreate.iStripe);}
    sUrl+=("&HBAID="+ArrayCreate.HBAID);
    if (ArrayCreate.iRaidMode==6||ArrayCreate.iRaidMode==96)
    {
        sUrl+="&NumOfParityDisk=";
        sUrl+=ArrayCreate.iParityDisk;
    }
    return sUrl;
}

ArrayCreate.checkParityNum = function()
{
	ArrayCreate.iParityDisk=ArrayCreate.oParity.options[ArrayCreate.oParity.selectedIndex].value;
	if (isNaN(ArrayCreate.iParityDisk)) {
		alert(ArrayCreate.MSG_PARITY_BENUMBER);
		return false;
	}
	if (!CheckParity(ArrayCreate.iRaidMode, ArrayCreate.iParityDisk, ArrayCreate.iHDsLength))
	{
		var alerlMsg;
		if (ArrayCreate.iRaidMode == 6)
		{
			alerlMsg= ArrayCreate.MSG_PARITYNUM_OUTOFRANGE + Math.min(Math.floor(ArrayCreate.iHDsLength/2), RAID6_MAXMUM_PARITY);
		}
		else if (ArrayCreate.iRaidMode == 96)
		{
			alerlMsg= ArrayCreate.MSG_PARITYNUMERROE_R60 + Math.min(Math.floor(ArrayCreate.iHDsLength/2), RAID60_MAXMUM_PARITY);
		}
		alert(alerlMsg);
		return false;
	}
	return true;
}

ArrayCreate.selMode=function()
{
    if (ArrayCreate.oRaidMode!=null) 
    {
    	ArrayCreate.iRaidMode=parseInt(ArrayCreate.oRaidMode.options[ArrayCreate.oRaidMode.selectedIndex].value);
    	ArrayCreate.oParityDiv = document.getElementById("inputParityDiv");
    	ArrayCreate.InputParityShow();
    }

    if (ArrayCreate.oParity!=null && ArrayCreate.oParity.options.length > 0) 
	{
		ArrayCreate.iParityDisk = ArrayCreate.oParity.options[ArrayCreate.oParity.selectedIndex].value;
	}
    if (CheckLDMode(ArrayCreate.iRaidMode,ArrayCreate.iHDsLength))
	{
		ArrayCreate.enableButton(ArrayCreate.oSubmit);
		ArrayCreate.oSubmit.onclick=ArrayCreate.doCreate;
	} 
	else 
	{
		ArrayCreate.disableButton(ArrayCreate.oSubmit);
	}
}

ArrayCreate.saveParity=function()
{
	ArrayCreate.iParityDisk = ArrayCreate.oParity.options[ArrayCreate.oParity.selectedIndex].value;
}

ArrayCreate.Page2Value=function()
{
    if (ArrayCreate.oCache!=null) {ArrayCreate.iCache=parseInt(ArrayCreate.oCache.options[ArrayCreate.oCache.selectedIndex].value);}
    if (ArrayCreate.oStripe!=null) {ArrayCreate.iStripe=parseInt(ArrayCreate.oStripe.options[ArrayCreate.oStripe.selectedIndex].value);}
    if (ArrayCreate.oArrayName!=null) {ArrayCreate.sArrayName=ArrayCreate.oArrayName.value;}
}


function unArrayCreatePage()
{
    ArrayCreate.oInit=null;
    ArrayCreate.oCache=null;
    ArrayCreate.oRaidMode = null;
    ArrayCreate.oArrayName=null;
    ArrayCreate.oSubmit=null;
    ArrayCreate.oNext=null;
    ArrayCreate.aHDs=null;
    ArrayCreate.oDiv=null;
    ArrayCreate.oParity=null;
    ArrayCreate.oControl=null;
    ArrayCreate=null;
}

ArrayCreate.InputParityShow=function()
{
    var iMode=parseInt(ArrayCreate.oRaidMode.options[ArrayCreate.oRaidMode.selectedIndex].value);
	var i;
	ArrayCreate.oParity.options.length = 0;
    if (iMode == 6)
    {
		var maxParity = Math.min(Math.floor(ArrayCreate.iHDsLength/2), RAID6_MAXMUM_PARITY);
		for (i = RAID6_MINIMUM_PARITY; i <= maxParity; i++)
		{
			if (i == RAID6_MINIMUM_PARITY)
			{
				ArrayCreate.oParity.options[ArrayCreate.oParity.options.length] = new Option(i + ' ', i + ' ', true);
			}
			else
			{
				ArrayCreate.oParity.options[ArrayCreate.oParity.options.length] = new Option(i + ' ', i + ' ', false);
			}
		}
    	ArrayCreate.oParityDiv.style.display = "";
    }
    else if (iMode == 96)
    {
		var maxParity = Math.min(Math.floor(ArrayCreate.iHDsLength/2), RAID60_MAXMUM_PARITY);
		for (i = RAID60_MINIMUM_PARITY; i <= maxParity; i += 2)
		{
			if (i == RAID60_MINIMUM_PARITY)
			{
				ArrayCreate.oParity.options[ArrayCreate.oParity.options.length] = new Option(i + ' ', i + ' ', true);
			}
			else
			{
				ArrayCreate.oParity.options[ArrayCreate.oParity.options.length] = new Option(i + ' ', i + ' ', false);
			}
		}
    	ArrayCreate.oParityDiv.style.display = "";
    }
	else
	{
    	ArrayCreate.oParityDiv.style.display = "none";
	}
	return false;	
}

function ArrayCreatePage(){

	ArrayCreate.XMLResize();

	AddSplitterChangeResize(ArrayCreate.XMLResize);

	MarvellRaidTree.setCurrentNode("treelink_"+MarvellRaidTree.ADAPTER_LEAF+ArrayCreate.HBAID+0);
	clickTreeNode(MarvellRaidTree.currentNode);
}

ArrayCreate.XMLResize=function(){
	var treeObj = getObjectById("TreeHtmlScrollBody");
	var subScrollPartObj= getObjectById("createDgScrollPart");
	if (treeObj) {
		var treeHeight = treeObj.style.height;
		treeHeight = treeHeight.slice(0, -2);
		if (subScrollPartObj) {
			var minSubPartHeight = 70;
			var height = treeHeight - 135;
			if (height >= minSubPartHeight)
				subScrollPartObj.style.height = height;
			else 
				subScrollPartObj.style.height = minSubPartHeight;
		}
	}
}

addUnLoad(unArrayCreatePage);