<?php
class PgEventsSaveFileDisplayer extends PageDisplayer
{
	protected function initPage()
	{				
		$fileName = gettext("EventsLog") . date("Ymd") . ".txt";
		/*
		header("Cache-Control: no-store, no-cache, must-revalidate");
		header("Cache-Control: post-check=0, pre-check=0", false);
		header("Cache-control: private");
		header("Pragma: no-cache");
		*/
		header("Content-Type: application/octet-stream");
		header("Content-Disposition: attachment; filename=$fileName");
		header("Content-transfer-encoding: binary");
		
		$len = 200;
		$totalLen = EventList::GetEventNum();
		$i = $totalLen;
		while($i > 0)
		{
			$onceLen = 0;
			if($i - $len > 0){				
				$onceLen = $len;
			}
			else {
				$onceLen = $i;
			}
			
			$startNo = $i - $onceLen;			
			
			$container = new CtnEventList();
			$container->setStartNo($startNo);
			$container->setEventNum($onceLen);
			$container->smartyAssign($this->smarty);
			$container->initContainer();		
						
			$container->display("EventsSaveFilePage.tpl");
			
			$i -= $len;
		}
	}
}
?>