<?php
class SSDCreateVolumeMaxSize extends BaseFactory {
	private $RaidMode;
	private $opLevel;
	private $HDIDs;
	
	public function setRaidMode($RaidMode)
	{
		$this->RaidMode = $RaidMode;
	}
	
	public function setOpLevel($opLevel)
	{
		$this->opLevel = $opLevel;
	}
	
	public function setHDIDs($hdids)
	{
		$this->HDIDs = $hdids;
	}
	
	public function toGetMaxSize()
	{
		$CmdGetMax = new XMLAPICommand();
		$CmdGetMax->setCommand(XMLAPICommand::MV_SSDVolume_GetMaxSize);
		$CmdGetMax->setCommandPara("RaidMode",$this->RaidMode);
		$CmdGetMax->setCommandPara("OpLevel",$this->opLevel);
		$CmdGetMax->setCommandPara("HDIDs",$this->HDIDs);
		
		$hds = split(" ", $this->HDIDs);
		$CmdGetMax->setCommandPara("HDCount",sizeof($hds));
		
		//var_dump($CmdGetMax);
		$handler = new SSDVolumeCreateMaxSizeXmlHandler();
		$this->runCommand($CmdGetMax->getCommand(), $handler);
	}
	
	public function createObject()
	{
		//won't used in this
		return 0;
	}
	
	public function setRequestSender()
	{
		$this->reqSender = new BaseSingleRequestSender();
	}
}
?>