/*
 * Decompiled with CFR 0.152.
 */
package pdtEditor.gui;

import entity.GpioEntity;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wb.swt.SWTResourceManager;
import pdtEditor.InformationStore;
import pdtEditor.Sensor;
import pdtEditor.gui.GuiUtils;
import pdtEditor.gui.InterruptsModifierOpener;
import pdtEditor.gui.SensorModifier;
import pdtEditor.gui.configuration.LidModeConfiguration;
import pdtEditor.payloads.GpioPayload;

public class InteruptsModifier {
    private Display display;
    private InterruptsModifierOpener _parent;
    private InformationStore infoStore = null;
    protected Object result;
    protected Shell shlInteruptsModifier;
    private Text textGpioID;
    private Label lblPurpose;
    private Label lblGpioId;
    private Label lblMode;
    private Button btnSave;
    private int _selectedLine = -1;
    private Combo purposeCombo;
    private Combo modeCombo;
    private Sensor _sensor;

    public InteruptsModifier(InterruptsModifierOpener parent, Sensor sensor) {
        this._parent = parent;
        this._sensor = sensor;
    }

    public InteruptsModifier(InterruptsModifierOpener parent, Sensor sensor, int selectedLine) {
        this._parent = parent;
        this._sensor = sensor;
        this._selectedLine = selectedLine;
    }

    private void initScreen() {
        ArrayList<String> gpioPurposes = new ArrayList<String>();
        if (this._sensor == null || this._sensor.getPossibleGpio() == null) {
            gpioPurposes.addAll(this.infoStore.getAllGpioPurposeNames());
        } else {
            for (GpioEntity gpio : this._sensor.getPossibleGpio()) {
                gpioPurposes.add(gpio.getName());
            }
        }
        for (String purpose : gpioPurposes) {
            this.purposeCombo.add(purpose);
        }
        ArrayList<String> gpioModes = this.infoStore.getAllGpioModesNames();
        for (String mode : gpioModes) {
            this.modeCombo.add(mode);
        }
    }

    private void fillGpioData() {
        if (this._selectedLine == -1) {
            return;
        }
        HashMap<String, String> values = this._parent.getLineValues(this._selectedLine);
        this.purposeCombo.setText(InteruptsModifier.getPurposeById(this._sensor, Integer.valueOf(values.get("purposeID"))));
        GuiUtils.chooseComboItemByValue(this.purposeCombo);
        this.textGpioID.append(values.get("pinNumber"));
        try {
            int mode = Integer.valueOf(values.get("modeGpio"));
            this.modeCombo.setText(String.valueOf(mode));
        }
        catch (NumberFormatException e) {
            this.modeCombo.setText(values.get("modeGpio"));
        }
        GuiUtils.chooseComboItemByValue(this.modeCombo);
    }

    public Object open() {
        this.display = Display.getDefault();
        this.createContents();
        try {
            this.infoStore = InformationStore.getInstance();
        }
        catch (Exception e) {
            MessageBox messageBox = new MessageBox(this.shlInteruptsModifier, 513);
            messageBox.setText("Cannot load file");
            messageBox.setMessage("Cannot load the sensor definitions file - the file is missing or damaged. Aborting.");
            messageBox.open();
            return null;
        }
        this.shlInteruptsModifier.open();
        this.shlInteruptsModifier.layout();
        this.display = Display.getDefault();
        this.initScreen();
        this.fillGpioData();
        while (!this.shlInteruptsModifier.isDisposed()) {
            if (this.display.readAndDispatch()) continue;
            this.display.sleep();
        }
        return this.result;
    }

    public void save() {
        int mode;
        int purpose;
        if (this.purposeCombo.getSelectionIndex() < 0) {
            purpose = this.validatePurpose();
            if (purpose == -1) {
                return;
            }
        } else {
            purpose = InteruptsModifier.getIdByPurposeName(this._sensor, this.purposeCombo.getText().trim());
        }
        if (!this.validateId()) {
            return;
        }
        if (this.modeCombo.getSelectionIndex() < 0) {
            mode = this.validateMode();
            if (mode == -1) {
                return;
            }
        } else {
            mode = this.infoStore.getGpioModeId(this.modeCombo.getText().trim());
        }
        if (this.tableContainsNonSelectedGpioEntry(String.valueOf(purpose), this.textGpioID.getText(), this.infoStore.getGpioModeName(mode))) {
            MessageBox messageBox = new MessageBox(this.shlInteruptsModifier, 513);
            messageBox.setText("Invalid GPIO ID");
            messageBox.setMessage("Another GPIO entry with that ID already exists for this sensor");
            messageBox.open();
            return;
        }
        if (this._selectedLine == -1) {
            this._parent.addGpioToTable(String.valueOf(purpose), this.textGpioID.getText(), this.infoStore.getGpioModeName(mode));
        } else {
            HashMap<String, String> updateVals = new HashMap<String, String>();
            updateVals.put("purpose", this.infoStore.getGpioPurposeName(purpose));
            updateVals.put("purposeID", String.valueOf(purpose));
            updateVals.put("pinNumber", this.textGpioID.getText());
            updateVals.put("modeGpio", this.infoStore.getGpioModeName(mode));
            this._parent.updateGpioLine(this._selectedLine, updateVals);
        }
        this._parent.setModified();
        this.shlInteruptsModifier.close();
    }

    public boolean tableContainsNonSelectedGpioEntry(String purposeID, String pinNumber, String modeGpio) {
        for (int i = 0; i < this._parent.getGpioCount(); ++i) {
            if (this._selectedLine == i) continue;
            HashMap<String, String> lineValues = this._parent.getLineValues(i);
            if (pinNumber == null || !pinNumber.equals(lineValues.get("pinNumber"))) continue;
            return true;
        }
        return false;
    }

    public static String getPurposeById(Sensor sensor, int id) {
        if (sensor == null || sensor.getPossibleGpio() == null) {
            try {
                return InformationStore.getInstance().getGpioPurposeName(id);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            for (GpioEntity gpio : sensor.getPossibleGpio()) {
                if (gpio.getPurposeId() != id) continue;
                return gpio.getName();
            }
        }
        return String.valueOf(id);
    }

    public static int getIdByPurposeName(Sensor sensor, String purposeName) {
        if (sensor == null || sensor.getPossibleGpio() == null) {
            try {
                Integer id = InformationStore.getInstance().getGpioPurposeId(purposeName);
                if (id != null) {
                    return id;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            for (GpioEntity gpio : sensor.getPossibleGpio()) {
                if (!gpio.getName().equals(purposeName)) continue;
                return gpio.getPurposeId();
            }
        }
        return -1;
    }

    private void createContents() {
        int textBoxMinWidth;
        this.shlInteruptsModifier = new Shell(this._parent.getShell(), 224);
        this.shlInteruptsModifier.setImage(SWTResourceManager.getImage(InteruptsModifier.class, "/resources/Intel.ico"));
        this.shlInteruptsModifier.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                InteruptsModifier.this._parent.getShell().setEnabled(true);
            }
        });
        this.shlInteruptsModifier.setText("GPIO Modifier");
        this._parent.getShell().setEnabled(false);
        this.shlInteruptsModifier.setLayout((Layout)new GridLayout(2, false));
        Group group = new Group((Composite)this.shlInteruptsModifier, 0);
        group.setLayout((Layout)new GridLayout(2, false));
        group.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        this.lblPurpose = new Label((Composite)group, 0);
        this.lblPurpose.setText("Purpose:");
        this.purposeCombo = new Combo((Composite)group, 0);
        this.purposeCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.purposeCombo.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                if (InteruptsModifier.this._parent instanceof SensorModifier) {
                    GuiUtils.chooseComboItemByValue(InteruptsModifier.this.purposeCombo);
                } else if (InteruptsModifier.this._parent instanceof LidModeConfiguration) {
                    LidModeConfiguration.chooseComboItemByValue(InteruptsModifier.this.purposeCombo);
                }
            }
        });
        this.purposeCombo.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent arg0) {
                if (InteruptsModifier.this.purposeCombo.getSelectionIndex() < 0) {
                    InteruptsModifier.this.validatePurpose();
                }
            }
        });
        this.lblGpioId = new Label((Composite)group, 0);
        this.lblGpioId.setText("ISS GPIO ID:");
        this.textGpioID = new Text((Composite)group, 2048);
        this.textGpioID.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                InteruptsModifier.this.validateId();
            }
        });
        this.textGpioID.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.lblMode = new Label((Composite)group, 0);
        this.lblMode.setText("Mode:");
        this.modeCombo = new Combo((Composite)group, 0);
        this.modeCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.modeCombo.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                if (InteruptsModifier.this._parent instanceof SensorModifier) {
                    GuiUtils.chooseComboItemByValue(InteruptsModifier.this.modeCombo);
                } else if (InteruptsModifier.this._parent instanceof LidModeConfiguration) {
                    LidModeConfiguration.chooseComboItemByValue(InteruptsModifier.this.modeCombo);
                }
            }
        });
        this.modeCombo.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent arg0) {
                if (InteruptsModifier.this.modeCombo.getSelectionIndex() < 0) {
                    InteruptsModifier.this.validateMode();
                }
            }
        });
        this.btnSave = new Button((Composite)this.shlInteruptsModifier, 0);
        GridData gd_btnSave = new GridData(131072, 0x1000000, true, false, 1, 1);
        gd_btnSave.widthHint = GuiUtils.getButtonWidth((Control)this.shlInteruptsModifier);
        this.btnSave.setLayoutData((Object)gd_btnSave);
        this.btnSave.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InteruptsModifier.this.save();
            }
        });
        this.btnSave.setText("Save and Close");
        Button btnCancel = new Button((Composite)this.shlInteruptsModifier, 0);
        GridData gd_btnCancel = new GridData(4, 0x1000000, false, false, 1, 1);
        gd_btnCancel.widthHint = GuiUtils.getButtonWidth((Control)this.shlInteruptsModifier);
        btnCancel.setLayoutData((Object)gd_btnCancel);
        btnCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InteruptsModifier.this.shlInteruptsModifier.close();
            }
        });
        btnCancel.setText("Cancel");
        ((GridData)this.purposeCombo.getLayoutData()).minimumWidth = textBoxMinWidth = GuiUtils.getButtonWidth((Control)this.shlInteruptsModifier) * 2;
        ((GridData)this.textGpioID.getLayoutData()).minimumWidth = textBoxMinWidth;
        ((GridData)this.modeCombo.getLayoutData()).minimumWidth = textBoxMinWidth;
        this.shlInteruptsModifier.setSize(this.shlInteruptsModifier.computeSize(-1, -1));
        this.shlInteruptsModifier.setLocation(GuiUtils.getMiddleLocation(this.shlInteruptsModifier, this.display));
    }

    public int validatePurpose() {
        try {
            int res = Integer.valueOf(this.purposeCombo.getText());
            if (res < 0 || res > GpioPayload.GPIO_PURPOSE_FIELD_MAX_VALUE) {
                throw new NumberFormatException();
            }
            return res;
        }
        catch (NumberFormatException e2) {
            MessageBox messageBox = new MessageBox(this.shlInteruptsModifier, 513);
            messageBox.setText("Invalid Purpose Value");
            messageBox.setMessage("Invalid Purpose value. Please choose a value from the list or enter an integer in the range [0," + GpioPayload.GPIO_PURPOSE_FIELD_MAX_VALUE + "].");
            messageBox.open();
            this.purposeCombo.setFocus();
            return -1;
        }
    }

    public boolean validateId() {
        try {
            int res = Integer.valueOf(this.textGpioID.getText());
            if (res < 0 || res > 31) {
                throw new NumberFormatException();
            }
            return true;
        }
        catch (NumberFormatException e) {
            MessageBox messageBox = new MessageBox(this.shlInteruptsModifier, 513);
            messageBox.setText("Input Error");
            messageBox.setMessage("Invalid GPIO ID value. Please enter an integer in the range [0,31].");
            messageBox.open();
            return false;
        }
    }

    public int validateMode() {
        try {
            int res = Integer.valueOf(this.modeCombo.getText());
            if (res < 0 || res > GpioPayload.GPIO_MODE_FIELD_MAX_VALUE) {
                throw new NumberFormatException();
            }
            return res;
        }
        catch (NumberFormatException e2) {
            MessageBox messageBox = new MessageBox(this.shlInteruptsModifier, 513);
            messageBox.setText("Invalid Mode Value");
            messageBox.setMessage("Invalid GPIO mode value. Please choose a value from the list or enter an integer in the range [0," + GpioPayload.GPIO_MODE_FIELD_MAX_VALUE + "].");
            messageBox.open();
            this.modeCombo.setFocus();
            return -1;
        }
    }
}

