# <copyright>
# INTEL CONFIDENTIAL
#
# Copyright 2021 Intel Corporation
#
# This software and the related documents are Intel copyrighted materials, and your use of
# them is governed by the express license under which they were provided to you ("License").
# Unless the License provides otherwise, you may not use, modify, copy, publish, distribute,
# disclose or transmit this software or the related documents without Intel's prior written
# permission.
#
# This software and the related documents are provided as is, with no express or implied
# warranties, other than those that are expressly stated in the License.
#
# <copyright>

# Suppress irrelevant PS Script Analyzer warnings
[Diagnostics.CodeAnalysis.SuppressMessageAttribute("PSUseDeclaredVarsMoreThanAssignments", "")] Param()

$BusTypeMap = [ordered]@{
    0 = $Messages.Unknown
    1 = $Messages.ISA
    2 = $Messages.EISA
    3 = $Messages.PCMCIA
    4 = $Messages.CardBus
    5 = $Messages.PCI
    6 = $Messages.PCIX
    7 = $Messages.PCIExpress
    8 = $Messages.IOSF
}

# Map from *SpeedDuplex enum values to possible adapter speeds
$SupportedSpeedsMap = [ordered]@{
    "0"      = 0            #AutoNegotiation
    "1"      = 10000000     #10Mb Half Duplex
    "2"      = 10000000     #10Mb Full Duplex
    "3"      = 100000000    #100Mb Half Duplex
    "4"      = 100000000    #100Mb Full Duplex
    "5"      = 1000000000   #1Gb Full Duplex NDIS5
    "6"      = 1000000000   #1Gb Full Duplex NDIS6
    "7"      = 10000000000  #10Gb Full Duplex
    "8"      = 10000000000  #10Gb Half Duplex
    "9"      = 40000000000  #40Gb Half Duplex
    "2500"   = 2500000000   #2.5Gb
    "5000"   = 5000000000   #5Gb
    "25000"  = 25000000000  #25Gb
    "500000" = 50000000000  #50Gb
    "10"     = 100000000000 #100Gb
}

$DebugClusterMap = [ordered]@{
    0  = "Switch"
    1  = "ACL"
    2  = "TX Scheduler"
    3  = "Profile Configuration"
    5  = "Link"
    7  = "DCB"
    8  = "L2P"
    22 = "Manageability Transactions", "MNG Transactions", "MNG"
}

$I40EA_WPP_GUID = "{4A6F89F6-C31F-449C-8854-9EE02A879D14}"
$I40EB_WPP_GUID = "{75BFFF12-65EC-4631-ADBA-BA8851D3A064}"
$ICEA_WPP_GUID = "{BDD04ED8-F4BB-4B36-BB76-D2FFC123EC67}"
$SCEA_WPP_GUID = "{2104EB78-B564-47BF-AB55-DBFD9338627D}"

$I40EA_LOGNAME = "X710_Log"
$I40EB_LOGNAME = "X722_Log"
$ICEA_LOGNAME = "E810_Log"
$SCEA_LOGNAME = "E823_Log"

$DRIVER_LOG_LEVEL_MAP = [ordered]@{
    "Verbose" = 4
    "Normal" = 3
    "Warning" = 2
    "Error" = 1
    "Disabled" = 0
}

$SUB_MODULE_MAP = [ordered]@{
    "Default"        = (1 -shl 0)
    "Init"           = (1 -shl 1)
    "Resource"       = (1 -shl 2)
    "Request"        = (1 -shl 3)
    "Power"          = (1 -shl 4)
    "FuncCall"       = (1 -shl 5)
    "Shared"         = (1 -shl 6)
    "Link"           = (1 -shl 7)
    "Offload"        = (1 -shl 8)
    "Tx"             = (1 -shl 9)
    "Rx"             = (1 -shl 10)
    "Packet"         = (1 -shl 11)
    "Interrupt"      = (1 -shl 12)
    "Lock"           = (1 -shl 13)
    "Watchdog"       = (1 -shl 14)
    "SIPS"           = (1 -shl 15)
    "RCTL"           = (1 -shl 16)
    "RDMA"           = (1 -shl 17)
    "RDMA_Shared"    = (1 -shl 18)
    "RDMA_CM"        = (1 -shl 19)
    "RDMA_Resources" = (1 -shl 20)
    "Diags"          = (1 -shl 21)
}

$DRIVER_MODULE_ID = 0x80

$DRIVER_MODULE_NAME = "Driver"
$DRIVERLOG_REGISTRYVAR_NAME = "DriverLogLevel"
$SUBMODULE_REGISTRYVAR_NAME = "SubModule"

# Define the upper limit of the SubModule map for default SubModule
$SUBMODULE_DEFAULT_RANGE_LIMIT = 5

# Add to upper limit to calculate default SubModule
$SUBMODULE_DEFAULT_SUM = ($SUB_MODULE_MAP[0..$SUBMODULE_DEFAULT_RANGE_LIMIT] | Measure-Object -Sum).Sum

$SUM_SUBMODULES = [int]($SUB_MODULE_MAP.Values | Measure-Object -Sum).Sum

$INTEL_GEN_DATA_STATUS_CALL_GET_GEN_DATA = 1
$INTEL_GEN_DATA_STATUS_UNSUPPORTED_OP_VER = 4

enum DcbxStatusValue
{
    NOT_STARTED    = 0
    IN_PROGRESS    = 1
    DONE           = 2
    MULTIPLE_PEERS = 3
    DISABLED       = 7
}
enum ADAPTER_STATUS
{
    Installed    = 0x1
    DriverLoaded = 0x2
    HwMissing    = 0x4
    Reserved     = 0x8
    HasDiag      = 0x10
    HasLink      = 0x20
    PoweredOff   = 0x1000
}


enum CVL_PHY_TYPE
{
    CVL100BaseTX = 0x0
    CVL100MSGMII = 0x1
    CVL1000BaseT = 0x2
    CVL1000BaseSX = 0x3
    CVL1000BaseLX = 0x4
    CVL1000BaseKX = 0x5
    CVL1GSGMII = 0x6
    CVL2Point5GBaseT = 0x7
    CVL2Point5gBaseX = 0x8
    CVL2Point5GBaseKX = 0x9
    CVL5GBaseT = 0xA
    CVL5GBaseKR = 0xB
    CVL10GBaseT = 0xC
    CVL10GSFIDA = 0xD
    CVL10GBaseSR = 0xE
    CVL10GBaseLR = 0xF
    CVL10GBaseKR = 0x10
    CVL10GSFIAOC_ACC = 0x11
    CVL10GSFIC2C = 0x12
    CVL25GBaseT = 0x13
    CVL25GBaseCR = 0x14
    CVL25GBaseCRS = 0x15
    CVL25GBaseCR1 = 0x16
    CVL25GBaseSR = 0x17
    CVL25GBaseLR = 0x18
    CVL25GBaseKR = 0x19
    CVL25GBaseKRS = 0x1A
    CVL25GBaseKR1 = 0x1B
    CVL25GAUIAOC_ACC = 0x1C
    CVL25GAUIC2C = 0x1D
    CVL40GBaseCR4 = 0x1E
    CVL40GBaseSR4 = 0x1F
    CVL40GBaseLR4 = 0x20
    CVL40GBaseKR4 = 0x21
    CVL40GXLAUIAOC_ACC = 0x22
    CVL40GXLAUI = 0x23
    CVL50GBaseCR2 = 0x24
    CVL50GBaseKR2 = 0x27
    CVL50GLAUI2AOC_ACC = 0x28
    CVL50GLAUI2 = 0x29
    CVL50GAUI2AOC_ACC = 0x2A
    CVL50GAUI2 = 0x2B
    CVL50GBaseCRPAM4 = 0x2C
    CVL50GBaseSR = 0x2D
    CVL50GBaseFR = 0x2E
    CVL50GBaseLR = 0x2F
    CVL50GBaseKRPAM4 = 0x30
    CVL50GAUI1AOC_ACC = 0x31
    CVL50GAUI1 = 0x32
    CVL100GBaseCR4 = 0x33
    CVL100GBaseSR4 = 0x34
    CVL100GBaseLR4 = 0x35
    CVL100GBaseKR4 = 0x36
    CVL100GCAUI4AOC_ACC = 0x37
    CVL100GCAUI4 = 0x38
    CVL100GAUI4AOC_ACC = 0x39
    CVL100GAUI4 = 0x3A
    CVL100GBaseKR4PAM4 = 0x3C
    CVL100GBaseCP2 = 0x3D
    CVL100GBaseSR2 = 0x3E
    CVL100GBaseDR = 0x3F
    CVL100GBaseKR2PAM4 = 0x40
    CVL100GAUI2AOC_ACC = 0x43
    CVL100GAUI2 = 0x44
    CVL200GBaseCR4PAM4 = 0x45
    CVL200GBaseSR4 = 0x46
    CVL200GBaseFR4 = 0x47
    CVL200GBaseLR4 = 0x48
    CVL200GBaseDR4 = 0x49
    CVL200GBaseKR4PAM4 = 0x4A
    CVL200GAUI4AOC_ACC = 0x4B
    CVL200GAUI4 = 0x4C
    CVL200GAUI8AOC_ACC = 0x4D
    CVL200GAUI8 = 0x4E
    CVL400GBaseFR8 = 0x4F
    CVL400GBaseLR8 = 0x50
    CVL400GBaseDR4 = 0x51
    CVL400GAUI8AOC_ACC = 0x52
    CVL400GAUI8 = 0x53
    CVLAutoNegotiation = 0x7E
    CVLOuterphydisabled = 0x7F
}

enum CPK_PHY_INFO
{
    CPK_PHYINFO_MEDIA_BACKPLANE = 1
    CPK_PHYINFO_MEDIA_QSFP      = 2
    CPK_PHYINFO_MEDIA_SFP       = 3
    CPK_PHYINFO_MEDIA_BASE_T    = 4
    CPK_PHYINFO_MEDIA_SGMII     = 5
    CPK_PHYINFO_MEDIA_FIBER     = 6
}

enum NCS_ADAPTER_MEDIA_TYPE
{
    NCS_MEDIA_UNKNOWN = 0
    NCS_MEDIA_COPPER = 1
    NCS_MEDIA_FIBER = 2
    NCS_MEDIA_PHONELINE = 3
    NCS_MEDIA_CX4COPPER = 4
    NCS_MEDIA_SFPDIRECTATTACH = 5
    NCS_MEDIA_SR_FIBER = 6
    NCS_MEDIA_LR_FIBER = 7
    NCS_MEDIA_KX4BACKPLANE = 8
    NCS_MEDIA_SERDES = 9
    NCS_MEDIA_BACKPLANE = 10
    NCS_MEDIA_XAUI = 11
    NCS_MEDIA_SFPACTIVEDIRECTATTACH = 12
    NCS_MEDIA_SWITCHHOST = 13
    NCS_MEDIA_QSFPDIRECTATTACH = 14
    NCS_MEDIA_SFP28DIRECTATTACH = 15
    NCS_MEDIA_CVL_AOC_ACC = 16
    NCS_MEDIA_CVL_Backplane_KR = 17
    NCS_MEDIA_CVL_Backplane_KR1 = 18
    NCS_MEDIA_CVL_Backplane_KR2 = 19
    NCS_MEDIA_CVL_Backplane_KR2_PAM4 = 20
    NCS_MEDIA_CVL_Backplane_KR4 = 21
    NCS_MEDIA_CVL_Backplane_KR4_PAM4 = 22
    NCS_MEDIA_CVL_Backplane_KR_PAM4 = 23
    NCS_MEDIA_CVL_Backplane_KR_S = 24
    NCS_MEDIA_CVL_Backplane_KX = 25
    NCS_MEDIA_CVL_Chip_to_Chip = 26
    NCS_MEDIA_CVL_Copper_T = 27
    NCS_MEDIA_CVL_Copper_TX = 28
    NCS_MEDIA_CVL_Direct_Attach = 29
    NCS_MEDIA_CVL_Direct_Attach_CP2 = 30
    NCS_MEDIA_CVL_Direct_Attach_CR = 31
    NCS_MEDIA_CVL_Direct_Attach_CR1 = 32
    NCS_MEDIA_CVL_Direct_Attach_CR2 = 33
    NCS_MEDIA_CVL_Direct_Attach_CR4 = 34
    NCS_MEDIA_CVL_Direct_Attach_CR_PAM4 = 35
    NCS_MEDIA_CVL_Direct_Attach_CR_S = 36
    NCS_MEDIA_CVL_Fiber_DR = 37
    NCS_MEDIA_CVL_Fiber_FR = 38
    NCS_MEDIA_CVL_Fiber_LR = 39
    NCS_MEDIA_CVL_Fiber_LR4 = 40
    NCS_MEDIA_CVL_Fiber_LX = 41
    NCS_MEDIA_CVL_Fiber_SR = 42
    NCS_MEDIA_CVL_Fiber_SR2 = 43
    NCS_MEDIA_CVL_Fiber_SR4 = 44
    NCS_MEDIA_CVL_Fiber_SX = 45
    NCS_MEDIA_CVL_Fiber_X = 46
    NCS_MEDIA_CVL_SGMII = 47
    NCS_MEDIA_CVL_Unknown = 48
    NCS_MEDIA_INTERFACE_CVL_BACKPLANE = 1000
    NCS_MEDIA_INTERFACE_CVL_QSFP = 1001
    NCS_MEDIA_INTERFACE_CVL_SFP = 1002
    NCS_MEDIA_INTERFACE_CVL_BASE_T = 1003
    NCS_MEDIA_INTERFACE_CVL_SGMII = 1004
    NCS_MEDIA_INTERFACE_CVL_FIBER = 1005
}

enum I40E_PHY_TYPE
{
    I40E_PHY_TYPE_SGMII                     = 0x0
    I40E_PHY_TYPE_1000BASE_KX               = 0x1
    I40E_PHY_TYPE_10GBASE_KX4               = 0x2
    I40E_PHY_TYPE_10GBASE_KR                = 0x3
    I40E_PHY_TYPE_40GBASE_KR4               = 0x4
    I40E_PHY_TYPE_XAUI                      = 0x5
    I40E_PHY_TYPE_XFI                       = 0x6
    I40E_PHY_TYPE_SFI                       = 0x7
    I40E_PHY_TYPE_XLAUI                     = 0x8
    I40E_PHY_TYPE_XLPPI                     = 0x9
    I40E_PHY_TYPE_40GBASE_CR4_CU            = 0xA
    I40E_PHY_TYPE_10GBASE_CR1_CU            = 0xB
    I40E_PHY_TYPE_10GBASE_AOC               = 0xC
    I40E_PHY_TYPE_40GBASE_AOC               = 0xD
    I40E_PHY_TYPE_UNRECOGNIZED              = 0xE
    I40E_PHY_TYPE_UNSUPPORTED               = 0xF
    I40E_PHY_TYPE_100BASE_TX                = 0x11
    I40E_PHY_TYPE_1000BASE_T                = 0x12
    I40E_PHY_TYPE_10GBASE_T                 = 0x13
    I40E_PHY_TYPE_10GBASE_SR                = 0x14
    I40E_PHY_TYPE_10GBASE_LR                = 0x15
    I40E_PHY_TYPE_10GBASE_SFPP_CU           = 0x16
    I40E_PHY_TYPE_10GBASE_CR1               = 0x17
    I40E_PHY_TYPE_40GBASE_CR4               = 0x18
    I40E_PHY_TYPE_40GBASE_SR4               = 0x19
    I40E_PHY_TYPE_40GBASE_LR4               = 0x1A
    I40E_PHY_TYPE_1000BASE_SX               = 0x1B
    I40E_PHY_TYPE_1000BASE_LX               = 0x1C
    I40E_PHY_TYPE_1000BASE_T_OPTICAL        = 0x1D
    I40E_PHY_TYPE_20GBASE_KR2               = 0x1E
    I40E_PHY_TYPE_25GBASE_KR                = 0x1F
    I40E_PHY_TYPE_25GBASE_CR                = 0x20
    I40E_PHY_TYPE_25GBASE_SR                = 0x21
    I40E_PHY_TYPE_25GBASE_LR                = 0x22
    I40E_PHY_TYPE_25GBASE_AOC               = 0x23
    I40E_PHY_TYPE_25GBASE_ACC               = 0x24
    I40E_PHY_TYPE_2_5GBASE_T                = 0x26
    I40E_PHY_TYPE_5GBASE_T                  = 0x27
    I40E_PHY_TYPE_2_5GBASE_T_LINK_STATUS    = 0x30
    I40E_PHY_TYPE_5GBASE_T_LINK_STATUS      = 0x31
    I40E_PHY_TYPE_NOT_SUPPORTED_HIGH_TEMP   = 0xFD
    I40E_PHY_TYPE_EMPTY                     = 0xFE
    I40E_PHY_TYPE_DEFAULT                   = 0xFF
}

enum LinkType
{
    LINK_TYPE_SGMII              = 0x1
    LINK_TYPE_1000BASE_KX        = 0x2
    LINK_TYPE_10GBASE_KX4        = 0x4
    LINK_TYPE_10GBASE_KR         = 0x8
    LINK_TYPE_40GBASE_KR4        = 0x10
    LINK_TYPE_XAUI               = 0x20
    LINK_TYPE_XFI                = 0x40
    LINK_TYPE_SFI                = 0x80
    LINK_TYPE_XLAUI              = 0x100
    LINK_TYPE_XLPPI              = 0x200
    LINK_TYPE_40GBASE_CR4_CU     = 0x400
    LINK_TYPE_10GBASE_CR1_CU     = 0x800
    LINK_TYPE_100BASE_TX         = 0x20000
    LINK_TYPE_1000BASE_T         = 0x40000
    LINK_TYPE_10GBASE_T          = 0x80000
    LINK_TYPE_10GBASE_SR         = 0x100000
    LINK_TYPE_10GBASE_LR         = 0x200000
    LINK_TYPE_10GBASE_SFP_Cu     = 0x400000
    LINK_TYPE_10GBASE_CR1        = 0x800000
    LINK_TYPE_40GBASE_CR4        = 0x1000000
    LINK_TYPE_40GBASE_SR4        = 0x2000000
    LINK_TYPE_40GBASE_LR4        = 0x4000000
    LINK_TYPE_1000BASE_SX        = 0x8000000
    LINK_TYPE_1000BASE_LX        = 0x10000000
    LINK_TYPE_1000BASE_T_Optical = 0x20000000
    LINK_TYPE_20GBASE_KR2        = 0x40000000
}

enum LinkTypeExt
{
    LINK_TYPE_25GBase_KR         = 0x1
    LINK_TYPE_25GBase_CR         = 0x2
    LINK_TYPE_25GBase_SR         = 0x4
    LINK_TYPE_25GBase_LR         = 0x8
    LINK_TYPE_25G_AOC            = 0x10
    LINK_TYPE_25G_ACC            = 0x20
    LINK_TYPE_2_5GBASE_T         = 0x40
    LINK_TYPE_5GBASE_T           = 0x80
}

enum ADAPTER_CAPABILITY
{
    NCS_ADAPTER_CAP_UNKNOWN = 0
    NCS_ADAPTER_CAP_OTHER = 1
    NCS_ADAPTER_CAP_WAKE_ON_LAN = 3
    NCS_ADAPTER_CAP_FAILOVER = 4
    NCS_ADAPTER_CAP_LOADBALANCING = 5
    NCS_ADAPTER_CAP_IPSEC_OFFLOAD = 6
    NCS_ADAPTER_CAP_FEC = 9
    NCS_ADAPTER_CAP_802_3AD = 10
    NCS_ADAPTER_CAP_CHECKSUM_OFFLOAD = 11
    NCS_ADAPTER_CAP_SWITCHED_FAULT_TOLERANT = 12
    NCS_ADAPTER_CAP_TCO_CAPABILITY = 29
    NCS_ADAPTER_CAP_WAKEUP_CAPABILITIES = 30
    NCS_ADAPTER_CAP_IP_CHECKSUM_OFFLOAD = 31
    NCS_ADAPTER_CAP_SPEED_10_MBPS = 32
    NCS_ADAPTER_CAP_SPEED_100_MBPS = 33
    NCS_ADAPTER_CAP_SPEED_1000_MBPS = 34
    NCS_ADAPTER_CAP_SPEED_10000_MBPS = 35
    NCS_ADAPTER_CAP_TEAM_SUPPORT = 36
    NCS_ADAPTER_CAP_VLAN_SUPPORT = 37
    NCS_ADAPTER_CAP_VLAN_TYPE_IEEE = 38
    NCS_ADAPTER_CAP_VLAN_TYPE_ISL = 39
    NCS_ADAPTER_CAP_IDENTIFY_ADAPTER_SUPPORT = 41
    NCS_ADAPTER_CAP_CABLE_TEST_SUPPORT = 42
    NCS_ADAPTER_CAP_DIAGNOSTIC_SUPPORT = 43
    NCS_ADAPTER_CAP_FLASH_SUPPORT = 44
    NCS_ADAPTER_CAP_USAGE_SERVER = 46
    NCS_ADAPTER_CAP_VENDOR_INTEL = 47
    NCS_ADAPTER_CAP_PWMGMT_SUPPORT = 50
    NCS_ADAPTER_CAP_QUAD_PORT = 54
    NCS_ADAPTER_CAP_JUMBO_FRAMES = 56
    NCS_ADAPTER_CAP_IGP_SIGNAL_QUALITY_TEST = 58
    NCS_ADAPTER_CAP_CABLE_OFFLINE_TEST = 59
    NCS_ADAPTER_IS_A_LOM = 60
    NCS_ADAPTER_CAP_NDIS_IOAT = 61
    NCS_ADAPTER_CAP_CB_PLATFORM_IOAT = 62
    NCS_ADAPTER_CAP_ISCSI = 63
    NCS_ADAPTER_CAP_DCB = 65
    NCS_ADAPTER_CAP_FCOE = 66
    NCS_ADAPTER_CAP_KX_MODULE   = 67
    NCS_ADAPTER_CAP_VM_LOADBALANCING = 68
    NCS_ADAPTER_CAP_PERFORMANCE_PROFILE = 69
    NCS_ADAPTER_CAP_OS2BMC = 70
    NCS_ADAPTER_CAP_AMT = 71
    NCS_ADAPTER_CAP_SPEED_2500_MBPS = 72
    NCS_ADAPTER_CAP_BASIC_DMIX_SUPPORT = 73
    NCS_ADAPTER_CAP_EXTENDED_DMIX_SUPPORT = 74
    NCS_ADAPTER_CAP_SPEED_40000_MBPS = 75
    NCS_ADAPTER_CAP_NPAR_ENABLED = 76
    NCS_ADAPTER_CAP_ANS_SUPPORTED = 77
    NCS_ADAPTER_CAP_QSFP_LINK_MODE_ENABLED = 78
    NCS_ADAPTER_CAP_SPEED_25000_MBPS = 79
    NCS_ADAPTER_CAP_NPAR_CAPABLE = 80
    NCS_ADAPTER_CAP_SPEED_5000_MBPS = 81
    NCS_ADAPTER_CAP_SPEED_50000_MBPS = 82
    NCS_ADAPTER_CAP_SPEED_100000_MBPS = 83
    NCS_ADAPTER_CAP_CYPRESS = 84
}

# from MSFT_NetAdapterAdvancedPropertySettingData WMI class
enum DisplayParameterType
{
    int   = 1
    long  = 2
    word  = 3
    dword = 4
    enum  = 5
    edit  = 6
}

# from MSFT_NetAdapter WMI class
enum NetAdapterState
{
    Unknown  = 0
    Present  = 1
    Started  = 2
    Disabled = 3
}

$NETWORK_ADDRESS_LEN = 12

$PROFILE_VALUE_TO_NAME = [ordered]@{
    "1" = "Custom Settings"
    "2" = "Standard Server"
    "3" = "Web Server"
    "4" = "Storage Server"
    "5" = "Virtualization Server (Hyper-V*)"
    "6" = "Low Latency"
    "7" = "Storage + Virtualization"
}

$PROFILE_TO_XMLPROFILE = @{
    "Standard Server" = "standard"
    "Web Server" = "web"
    "Storage Server" = "storage"
    "Virtualization Server (Hyper-V*)" = "hyperv"
    "Low Latency" = "lowlatency"
    "Storage + Virtualization" = "storagevirtualization"
}

#maps targeted towards Performance profile naming IDs
$DRIVER_TO_CODENAME = @{
    "i40ea" = "710"
    "i40eb" = "X722"
    "icea" = "E8"
    "scea" = "E8"
}

# Each Key treated as a range of Build Numbers (14393 to 16299 is NDIS v6.60)
$OSBUILD_TO_NDIS = [ordered]@{
    14393 = "ndis660"
    16299 = "ndis680"
}

$INTEL_DIAG_TEST = @{
    1 = $Messages.Register
    2 = $Messages.EEPROM
    3 = $Messages.MacLoopback
    4 = $Messages.Interrupt
    5 = $Messages.FIFO
}

# SIG # Begin signature block
# MIIocgYJKoZIhvcNAQcCoIIoYzCCKF8CAQExDzANBglghkgBZQMEAgEFADB5Bgor
# BgEEAYI3AgEEoGswaTA0BgorBgEEAYI3AgEeMCYCAwEAAAQQH8w7YFlLCE63JNLG
# KX7zUQIBAAIBAAIBAAIBAAIBADAxMA0GCWCGSAFlAwQCAQUABCC8hvZefZLEfsOk
# XB9vYYpRa4Xxwk46kA6Ky2r9MusEkKCCEfMwggVvMIIEV6ADAgECAhBI/JO0YFWU
# jTanyYqJ1pQWMA0GCSqGSIb3DQEBDAUAMHsxCzAJBgNVBAYTAkdCMRswGQYDVQQI
# DBJHcmVhdGVyIE1hbmNoZXN0ZXIxEDAOBgNVBAcMB1NhbGZvcmQxGjAYBgNVBAoM
# EUNvbW9kbyBDQSBMaW1pdGVkMSEwHwYDVQQDDBhBQUEgQ2VydGlmaWNhdGUgU2Vy
# dmljZXMwHhcNMjEwNTI1MDAwMDAwWhcNMjgxMjMxMjM1OTU5WjBWMQswCQYDVQQG
# EwJHQjEYMBYGA1UEChMPU2VjdGlnbyBMaW1pdGVkMS0wKwYDVQQDEyRTZWN0aWdv
# IFB1YmxpYyBDb2RlIFNpZ25pbmcgUm9vdCBSNDYwggIiMA0GCSqGSIb3DQEBAQUA
# A4ICDwAwggIKAoICAQCN55QSIgQkdC7/FiMCkoq2rjaFrEfUI5ErPtx94jGgUW+s
# hJHjUoq14pbe0IdjJImK/+8Skzt9u7aKvb0Ffyeba2XTpQxpsbxJOZrxbW6q5KCD
# J9qaDStQ6Utbs7hkNqR+Sj2pcaths3OzPAsM79szV+W+NDfjlxtd/R8SPYIDdub7
# P2bSlDFp+m2zNKzBenjcklDyZMeqLQSrw2rq4C+np9xu1+j/2iGrQL+57g2extme
# me/G3h+pDHazJyCh1rr9gOcB0u/rgimVcI3/uxXP/tEPNqIuTzKQdEZrRzUTdwUz
# T2MuuC3hv2WnBGsY2HH6zAjybYmZELGt2z4s5KoYsMYHAXVn3m3pY2MeNn9pib6q
# RT5uWl+PoVvLnTCGMOgDs0DGDQ84zWeoU4j6uDBl+m/H5x2xg3RpPqzEaDux5mcz
# mrYI4IAFSEDu9oJkRqj1c7AGlfJsZZ+/VVscnFcax3hGfHCqlBuCF6yH6bbJDoEc
# QNYWFyn8XJwYK+pF9e+91WdPKF4F7pBMeufG9ND8+s0+MkYTIDaKBOq3qgdGnA2T
# OglmmVhcKaO5DKYwODzQRjY1fJy67sPV+Qp2+n4FG0DKkjXp1XrRtX8ArqmQqsV/
# AZwQsRb8zG4Y3G9i/qZQp7h7uJ0VP/4gDHXIIloTlRmQAOka1cKG8eOO7F/05QID
# AQABo4IBEjCCAQ4wHwYDVR0jBBgwFoAUoBEKIz6W8Qfs4q8p74Klf9AwpLQwHQYD
# VR0OBBYEFDLrkpr/NZZILyhAQnAgNpFcF4XmMA4GA1UdDwEB/wQEAwIBhjAPBgNV
# HRMBAf8EBTADAQH/MBMGA1UdJQQMMAoGCCsGAQUFBwMDMBsGA1UdIAQUMBIwBgYE
# VR0gADAIBgZngQwBBAEwQwYDVR0fBDwwOjA4oDagNIYyaHR0cDovL2NybC5jb21v
# ZG9jYS5jb20vQUFBQ2VydGlmaWNhdGVTZXJ2aWNlcy5jcmwwNAYIKwYBBQUHAQEE
# KDAmMCQGCCsGAQUFBzABhhhodHRwOi8vb2NzcC5jb21vZG9jYS5jb20wDQYJKoZI
# hvcNAQEMBQADggEBABK/oe+LdJqYRLhpRrWrJAoMpIpnuDqBv0WKfVIHqI0fTiGF
# OaNrXi0ghr8QuK55O1PNtPvYRL4G2VxjZ9RAFodEhnIq1jIV9RKDwvnhXRFAZ/ZC
# J3LFI+ICOBpMIOLbAffNRk8monxmwFE2tokCVMf8WPtsAO7+mKYulaEMUykfb9gZ
# pk+e96wJ6l2CxouvgKe9gUhShDHaMuwV5KZMPWw5c9QLhTkg4IUaaOGnSDip0TYl
# d8GNGRbFiExmfS9jzpjoad+sPKhdnckcW67Y8y90z7h+9teDnRGWYpquRRPaf9xH
# +9/DUp/mBlXpnYzyOmJRvOwkDynUWICE5EV7WtgwggYcMIIEBKADAgECAhAz1wio
# kUBTGeKlu9M5ua1uMA0GCSqGSIb3DQEBDAUAMFYxCzAJBgNVBAYTAkdCMRgwFgYD
# VQQKEw9TZWN0aWdvIExpbWl0ZWQxLTArBgNVBAMTJFNlY3RpZ28gUHVibGljIENv
# ZGUgU2lnbmluZyBSb290IFI0NjAeFw0yMTAzMjIwMDAwMDBaFw0zNjAzMjEyMzU5
# NTlaMFcxCzAJBgNVBAYTAkdCMRgwFgYDVQQKEw9TZWN0aWdvIExpbWl0ZWQxLjAs
# BgNVBAMTJVNlY3RpZ28gUHVibGljIENvZGUgU2lnbmluZyBDQSBFViBSMzYwggGi
# MA0GCSqGSIb3DQEBAQUAA4IBjwAwggGKAoIBgQC70f4et0JbePWQp64sg/GNIdMw
# hoV739PN2RZLrIXFuwHP4owoEXIEdiyBxasSekBKxRDogRQ5G19PB/YwMDB/NSXl
# wHM9QAmU6Kj46zkLVdW2DIseJ/jePiLBv+9l7nPuZd0o3bsffZsyf7eZVReqskmo
# PBBqOsMhspmoQ9c7gqgZYbU+alpduLyeE9AKnvVbj2k4aOqlH1vKI+4L7bzQHkND
# brBTjMJzKkQxbr6PuMYC9ruCBBV5DFIg6JgncWHvL+T4AvszWbX0w1Xn3/YIIq62
# 0QlZ7AGfc4m3Q0/V8tm9VlkJ3bcX9sR0gLqHRqwG29sEDdVOuu6MCTQZlRvmcBME
# Jd+PuNeEM4xspgzraLqVT3xE6NRpjSV5wyHxNXf4T7YSVZXQVugYAtXueciGoWnx
# G06UE2oHYvDQa5mll1CeHDOhHu5hiwVoHI717iaQg9b+cYWnmvINFD42tRKtd3V6
# zOdGNmqQU8vGlHHeBzoh+dYyZ+CcblSGoGSgg8sCAwEAAaOCAWMwggFfMB8GA1Ud
# IwQYMBaAFDLrkpr/NZZILyhAQnAgNpFcF4XmMB0GA1UdDgQWBBSBMpJBKyjNRsjE
# osYqORLsSKk/FDAOBgNVHQ8BAf8EBAMCAYYwEgYDVR0TAQH/BAgwBgEB/wIBADAT
# BgNVHSUEDDAKBggrBgEFBQcDAzAaBgNVHSAEEzARMAYGBFUdIAAwBwYFZ4EMAQMw
# SwYDVR0fBEQwQjBAoD6gPIY6aHR0cDovL2NybC5zZWN0aWdvLmNvbS9TZWN0aWdv
# UHVibGljQ29kZVNpZ25pbmdSb290UjQ2LmNybDB7BggrBgEFBQcBAQRvMG0wRgYI
# KwYBBQUHMAKGOmh0dHA6Ly9jcnQuc2VjdGlnby5jb20vU2VjdGlnb1B1YmxpY0Nv
# ZGVTaWduaW5nUm9vdFI0Ni5wN2MwIwYIKwYBBQUHMAGGF2h0dHA6Ly9vY3NwLnNl
# Y3RpZ28uY29tMA0GCSqGSIb3DQEBDAUAA4ICAQBfNqz7+fZyWhS38Asd3tj9lwHS
# /QHumS2G6Pa38Dn/1oFKWqdCSgotFZ3mlP3FaUqy10vxFhJM9r6QZmWLLXTUqwj3
# ahEDCHd8vmnhsNufJIkD1t5cpOCy1rTP4zjVuW3MJ9bOZBHoEHJ20/ng6SyJ6UnT
# s5eWBgrh9grIQZqRXYHYNneYyoBBl6j4kT9jn6rNVFRLgOr1F2bTlHH9nv1HMePp
# GoYd074g0j+xUl+yk72MlQmYco+VAfSYQ6VK+xQmqp02v3Kw/Ny9hA3s7TSoXpUr
# OBZjBXXZ9jEuFWvilLIq0nQ1tZiao/74Ky+2F0snbFrmuXZe2obdq2TWauqDGIgb
# MYL1iLOUJcAhLwhpAuNMu0wqETDrgXkG4UGVKtQg9guT5Hx2DJ0dJmtfhAH2KpnN
# r97H8OQYok6bLyoMZqaSdSa+2UA1E2+upjcaeuitHFFjBypWBmztfhj24+xkc6Zt
# CDaLrw+ZrnVrFyvCTWrDUUZBVumPwo3/E3Gb2u2e05+r5UWmEsUUWlJBl6MGAAjF
# 5hzqJ4I8O9vmRsTvLQA1E802fZ3lqicIBczOwDYOSxlP0GOabb/FKVMxItt1UHeG
# 0PL4au5rBhs+hSMrl8h+eplBDN1Yfw6owxI9OjWb4J0sjBeBVESoeh2YnZZ/WVim
# VGX/UUIL+Efrz/jlvzCCBlwwggTEoAMCAQICEQC0WMhOLa9BaZ9kSX5iJ3F/MA0G
# CSqGSIb3DQEBCwUAMFcxCzAJBgNVBAYTAkdCMRgwFgYDVQQKEw9TZWN0aWdvIExp
# bWl0ZWQxLjAsBgNVBAMTJVNlY3RpZ28gUHVibGljIENvZGUgU2lnbmluZyBDQSBF
# ViBSMzYwHhcNMjQwMjI2MDAwMDAwWhcNMjUwMjI1MjM1OTU5WjCBuzEQMA4GA1UE
# BRMHMjE4OTA3NDETMBEGCysGAQQBgjc8AgEDEwJVUzEZMBcGCysGAQQBgjc8AgEC
# EwhEZWxhd2FyZTEdMBsGA1UEDxMUUHJpdmF0ZSBPcmdhbml6YXRpb24xCzAJBgNV
# BAYTAlVTMRMwEQYDVQQIDApDYWxpZm9ybmlhMRowGAYDVQQKDBFJbnRlbCBDb3Jw
# b3JhdGlvbjEaMBgGA1UEAwwRSW50ZWwgQ29ycG9yYXRpb24wggGiMA0GCSqGSIb3
# DQEBAQUAA4IBjwAwggGKAoIBgQDBCfpjptqBxrQLJGyUHE47EvbngKTbZ0xMZoUj
# CJVmRhCCzWtZeKwlwhuI3bJyq4sSeejZxY7IMjroOoditsPm5xYohctw0UO+j1Th
# L71qce9bigWpDFDBBqksK5+011j/XPA+kRu/gJBolI50N8tIHHsH31NzD09/sN7U
# V242zTBy0TnMwanTXLMux/kVJbIloWSHRn0wIZmGuWESmWDrsLQEtSIo4zyUlzvQ
# UmJrtHMmJc3Rw/5TE7rC9Zq4Yt6s+BNu8i5howcK7yEOtiw/sKIlbACFJqpp6EUT
# Kwi7RRLKkuoL7G/+50XrJlCQqDbYxQAm7Tc2oFBVZW9xf4gUz3f48iflabLvDmc0
# pVWgDF0OmX+SzsHf94GYG3slCw8JJKfU66TfJEModuiDPwfgA6ripNWdBHqaDoY7
# JQPt6T6wierKjp64ABBHwyYSD55RIMUm/w33oe0i44tAlvUTkujJzwUQKpjXQ9av
# FyA2VqPea77rc3yiCRNeGQTpyO0CAwEAAaOCAbwwggG4MB8GA1UdIwQYMBaAFIEy
# kkErKM1GyMSixio5EuxIqT8UMB0GA1UdDgQWBBSC0NSIL647v94GegQBXPynnV+p
# cDAOBgNVHQ8BAf8EBAMCB4AwDAYDVR0TAQH/BAIwADATBgNVHSUEDDAKBggrBgEF
# BQcDAzBJBgNVHSAEQjBAMDUGDCsGAQQBsjEBAgEGATAlMCMGCCsGAQUFBwIBFhdo
# dHRwczovL3NlY3RpZ28uY29tL0NQUzAHBgVngQwBAzBLBgNVHR8ERDBCMECgPqA8
# hjpodHRwOi8vY3JsLnNlY3RpZ28uY29tL1NlY3RpZ29QdWJsaWNDb2RlU2lnbmlu
# Z0NBRVZSMzYuY3JsMHsGCCsGAQUFBwEBBG8wbTBGBggrBgEFBQcwAoY6aHR0cDov
# L2NydC5zZWN0aWdvLmNvbS9TZWN0aWdvUHVibGljQ29kZVNpZ25pbmdDQUVWUjM2
# LmNydDAjBggrBgEFBQcwAYYXaHR0cDovL29jc3Auc2VjdGlnby5jb20wLgYDVR0R
# BCcwJaAjBggrBgEFBQcIA6AXMBUME1VTLURFTEFXQVJFLTIxODkwNzQwDQYJKoZI
# hvcNAQELBQADggGBADRT5U3ne/vFqaxPbuhkYXvhfhBMHNi+fHEkOCjPhEyqOkeU
# 1a7bjucUQh+Jb6yOlEKzb8KppbyTDNZzlo5NpkpBtFimyPY/h7pboom7mDOFXS9/
# NUuESrc/niHOTRkTzipQa125g5y/hgZ8a6+XoMjKi/rWOvllhdyUiJi6KY9x5+IN
# nXSgYZu/7xnGge/UybwaVrCVqmirark7p8I3vPOmIQeeGupn7qyzFdiMK5EEpPUI
# uO4po7YGOTQDgpdPjUQGmmGqbkrGgvH2fT2W/Ti8IZSgBM+3i3Rtqo50gOTOe9py
# fG30f9aFUtFHFc9BAA3kvG+Xqr4MLOdFYgQRGFXNjN5IA6zc0admMuG8m/hVasJN
# p+ACnv8HeWID2O6oTGPhwHZkvfgqL05qEO6ZiThnzwWDukiduuceeYxIVqyYW253
# hzgZCKnjWVdDT3gUWoO2TJNR7sZuP/gP7I2hyotU8uRTl3SvlFfbaVGHj+xVqR1k
# taptv3zLnJYUhbTyNjGCFdUwghXRAgEBMGwwVzELMAkGA1UEBhMCR0IxGDAWBgNV
# BAoTD1NlY3RpZ28gTGltaXRlZDEuMCwGA1UEAxMlU2VjdGlnbyBQdWJsaWMgQ29k
# ZSBTaWduaW5nIENBIEVWIFIzNgIRALRYyE4tr0Fpn2RJfmIncX8wDQYJYIZIAWUD
# BAIBBQCgajAZBgkqhkiG9w0BCQMxDAYKKwYBBAGCNwIBBDAcBgorBgEEAYI3AgEL
# MQ4wDAYKKwYBBAGCNwIBFjAvBgkqhkiG9w0BCQQxIgQgXwzhp3qxeA+K8NYS7iWE
# p9ksOtzHNJTcVoerLNfrVQkwDQYJKoZIhvcNAQEBBQAEggGALpqtS8enLmAQpEnv
# FtpYFRW492BtfwyPF/UELKXUVeuT7Lud+7I5aQ48EK4PJ8Foy4eTKPEyCfgdX39y
# YfUZrikiJxV0vvQS400rV86ZF1+YmOg22ezTVzYGOMvnldBW1QZA0eZqmGO8zVQs
# D6aJABW/tMZZrJE/pF6IVr0CyimARndoRjOHOH4JkTNZvSu6KBWmz+q4bPtDvshl
# dI1iNc5I06PCoRC+ZTTWN3Ni2rDz48mgn6c2Rgwq+A2MKNLrWzkDURY9Jm3gW7hj
# 9+6hIyOWpboQ4YBQg8J0vOTvG6+ZLhnh44GSbtPoMQZTJsMbBRdErs5L+XlaHeZ0
# avpi/3pU+BDzDS5eMyiwUw7JZbs4a7y6qc4687m9Fdoo9s1MmFAQxbu0mSnoD0Co
# uWn51Bamo8b5F80IGswW/VNIjMB1KvCe++ByY1WlNrbyriMQFEfPXJ9wlgzkqAAG
# 1GF5Dj5jqYjzw11TmArg9bE3moSf099iwPCSDLW+7NThD1zMoYITTjCCE0oGCisG
# AQQBgjcDAwExghM6MIITNgYJKoZIhvcNAQcCoIITJzCCEyMCAQMxDzANBglghkgB
# ZQMEAgIFADCB7wYLKoZIhvcNAQkQAQSggd8EgdwwgdkCAQEGCisGAQQBsjECAQEw
# MTANBglghkgBZQMEAgEFAAQglzrd+vPv72z9Uk4Ogv4a3B4TAd9z2UMejhdjxY0z
# gSkCFDYXy12EQoVTbl+65GkO8rlP9Dw5GA8yMDI0MDcxMTE5MzAyNVqgbqRsMGox
# CzAJBgNVBAYTAkdCMRMwEQYDVQQIEwpNYW5jaGVzdGVyMRgwFgYDVQQKEw9TZWN0
# aWdvIExpbWl0ZWQxLDAqBgNVBAMMI1NlY3RpZ28gUlNBIFRpbWUgU3RhbXBpbmcg
# U2lnbmVyICM0oIIN6TCCBvUwggTdoAMCAQICEDlMJeF8oG0nqGXiO9kdItQwDQYJ
# KoZIhvcNAQEMBQAwfTELMAkGA1UEBhMCR0IxGzAZBgNVBAgTEkdyZWF0ZXIgTWFu
# Y2hlc3RlcjEQMA4GA1UEBxMHU2FsZm9yZDEYMBYGA1UEChMPU2VjdGlnbyBMaW1p
# dGVkMSUwIwYDVQQDExxTZWN0aWdvIFJTQSBUaW1lIFN0YW1waW5nIENBMB4XDTIz
# MDUwMzAwMDAwMFoXDTM0MDgwMjIzNTk1OVowajELMAkGA1UEBhMCR0IxEzARBgNV
# BAgTCk1hbmNoZXN0ZXIxGDAWBgNVBAoTD1NlY3RpZ28gTGltaXRlZDEsMCoGA1UE
# AwwjU2VjdGlnbyBSU0EgVGltZSBTdGFtcGluZyBTaWduZXIgIzQwggIiMA0GCSqG
# SIb3DQEBAQUAA4ICDwAwggIKAoICAQCkkyhSS88nh3akKRyZOMDnDtTRHOxoywFk
# 5IrNd7BxZYK8n/yLu7uVmPslEY5aiAlmERRYsroiW+b2MvFdLcB6og7g4FZk7aHl
# gSByIGRBbMfDCPrzfV3vIZrCftcsw7oRmB780yAIQrNfv3+IWDKrMLPYjHqWShkT
# XKz856vpHBYusLA4lUrPhVCrZwMlobs46Q9vqVqakSgTNbkf8z3hJMhrsZnoDe+7
# TeU9jFQDkdD8Lc9VMzh6CRwH0SLgY4anvv3Sg3MSFJuaTAlGvTS84UtQe3LgW/0Z
# ux88ahl7brstRCq+PEzMrIoEk8ZXhqBzNiuBl/obm36Ih9hSeYn+bnc317tQn/oY
# JU8T8l58qbEgWimro0KHd+D0TAJI3VilU6ajoO0ZlmUVKcXtMzAl5paDgZr2YGaQ
# WAeAzUJ1rPu0kdDF3QFAaraoEO72jXq3nnWv06VLGKEMn1ewXiVHkXTNdRLRnG/k
# Xg2b7HUm7v7T9ZIvUoXo2kRRKqLMAMqHZkOjGwDvorWWnWKtJwvyG0rJw5RCN4gg
# hKiHrsO6I3J7+FTv+GsnsIX1p0OF2Cs5dNtadwLRpPr1zZw9zB+uUdB7bNgdLRFC
# U3F0wuU1qi1SEtklz/DT0JFDEtcyfZhs43dByP8fJFTvbq3GPlV78VyHOmTxYEsF
# T++5L+wJEwIDAQABo4IBgjCCAX4wHwYDVR0jBBgwFoAUGqH4YRkgD8NBd0UojtE1
# XwYSBFUwHQYDVR0OBBYEFAMPMciRKpO9Y/PRXU2kNA/SlQEYMA4GA1UdDwEB/wQE
# AwIGwDAMBgNVHRMBAf8EAjAAMBYGA1UdJQEB/wQMMAoGCCsGAQUFBwMIMEoGA1Ud
# IARDMEEwNQYMKwYBBAGyMQECAQMIMCUwIwYIKwYBBQUHAgEWF2h0dHBzOi8vc2Vj
# dGlnby5jb20vQ1BTMAgGBmeBDAEEAjBEBgNVHR8EPTA7MDmgN6A1hjNodHRwOi8v
# Y3JsLnNlY3RpZ28uY29tL1NlY3RpZ29SU0FUaW1lU3RhbXBpbmdDQS5jcmwwdAYI
# KwYBBQUHAQEEaDBmMD8GCCsGAQUFBzAChjNodHRwOi8vY3J0LnNlY3RpZ28uY29t
# L1NlY3RpZ29SU0FUaW1lU3RhbXBpbmdDQS5jcnQwIwYIKwYBBQUHMAGGF2h0dHA6
# Ly9vY3NwLnNlY3RpZ28uY29tMA0GCSqGSIb3DQEBDAUAA4ICAQBMm2VY+uB5z+8V
# wzJt3jOR63dY4uu9y0o8dd5+lG3DIscEld9laWETDPYMnvWJIF7Bh8cDJMrHpfAm
# 3/j4MWUN4OttUVemjIRSCEYcKsLe8tqKRfO+9/YuxH7t+O1ov3pWSOlh5Zo5d7y+
# upFkiHX/XYUWNCfSKcv/7S3a/76TDOxtog3Mw/FuvSGRGiMAUq2X1GJ4KoR5qNc9
# rCGPcMMkeTqX8Q2jo1tT2KsAulj7NYBPXyhxbBlewoNykK7gxtjymfvqtJJlfAd8
# NUQdrVgYa2L73mzECqls0yFGcNwvjXVMI8JB0HqWO8NL3c2SJnR2XDegmiSeTl9O
# 048P5RNPWURlS0Nkz0j4Z2e5Tb/MDbE6MNChPUitemXk7N/gAfCzKko5rMGk+al9
# NdAyQKCxGSoYIbLIfQVxGksnNqrgmByDdefHfkuEQ81D+5CXdioSrEDBcFuZCkD6
# gG2UYXvIbrnIZ2ckXFCNASDeB/cB1PguEc2dg+X4yiUcRD0n5bCGRyoLG4R2fXto
# T4239xO07aAt7nMP2RC6nZksfNd1H48QxJTmfiTllUqIjCfWhWYd+a5kdpHoSP7I
# VQrtKcMf3jimwBT7Mj34qYNiNsjDvgCHHKv6SkIciQPc9Vx8cNldeE7un14g5glq
# fCsIo0j1FfwET9/NIRx65fWOGtS5QDCCBuwwggTUoAMCAQICEDAPb6zdZph0fKlG
# Nqd4LbkwDQYJKoZIhvcNAQEMBQAwgYgxCzAJBgNVBAYTAlVTMRMwEQYDVQQIEwpO
# ZXcgSmVyc2V5MRQwEgYDVQQHEwtKZXJzZXkgQ2l0eTEeMBwGA1UEChMVVGhlIFVT
# RVJUUlVTVCBOZXR3b3JrMS4wLAYDVQQDEyVVU0VSVHJ1c3QgUlNBIENlcnRpZmlj
# YXRpb24gQXV0aG9yaXR5MB4XDTE5MDUwMjAwMDAwMFoXDTM4MDExODIzNTk1OVow
# fTELMAkGA1UEBhMCR0IxGzAZBgNVBAgTEkdyZWF0ZXIgTWFuY2hlc3RlcjEQMA4G
# A1UEBxMHU2FsZm9yZDEYMBYGA1UEChMPU2VjdGlnbyBMaW1pdGVkMSUwIwYDVQQD
# ExxTZWN0aWdvIFJTQSBUaW1lIFN0YW1waW5nIENBMIICIjANBgkqhkiG9w0BAQEF
# AAOCAg8AMIICCgKCAgEAyBsBr9ksfoiZfQGYPyCQvZyAIVSTuc+gPlPvs1rAdtYa
# BKXOR4O168TMSTTL80VlufmnZBYmCfvVMlJ5LsljwhObtoY/AQWSZm8hq9VxEHmH
# 9EYqzcRaydvXXUlNclYP3MnjU5g6Kh78zlhJ07/zObu5pCNCrNAVw3+eolzXOPEW
# snDTo8Tfs8VyrC4Kd/wNlFK3/B+VcyQ9ASi8Dw1Ps5EBjm6dJ3VV0Rc7NCF7lwGU
# r3+Az9ERCleEyX9W4L1GnIK+lJ2/tCCwYH64TfUNP9vQ6oWMilZx0S2UTMiMPNMU
# opy9Jv/TUyDHYGmbWApU9AXn/TGs+ciFF8e4KRmkKS9G493bkV+fPzY+DjBnK0a3
# Na+WvtpMYMyou58NFNQYxDCYdIIhz2JWtSFzEh79qsoIWId3pBXrGVX/0DlULSbu
# RRo6b83XhPDX8CjFT2SDAtT74t7xvAIo9G3aJ4oG0paH3uhrDvBbfel2aZMgHEqX
# LHcZK5OVmJyXnuuOwXhWxkQl3wYSmgYtnwNe/YOiU2fKsfqNoWTJiJJZy6hGwMny
# pv99V9sSdvqKQSTUG/xypRSi1K1DHKRJi0E5FAMeKfobpSKupcNNgtCN2mu32/cY
# QFdz8HGj+0p9RTbB942C+rnJDVOAffq2OVgy728YUInXT50zvRq1naHelUF6p4MC
# AwEAAaOCAVowggFWMB8GA1UdIwQYMBaAFFN5v1qqK0rPVIDh2JvAnfKyA2bLMB0G
# A1UdDgQWBBQaofhhGSAPw0F3RSiO0TVfBhIEVTAOBgNVHQ8BAf8EBAMCAYYwEgYD
# VR0TAQH/BAgwBgEB/wIBADATBgNVHSUEDDAKBggrBgEFBQcDCDARBgNVHSAECjAI
# MAYGBFUdIAAwUAYDVR0fBEkwRzBFoEOgQYY/aHR0cDovL2NybC51c2VydHJ1c3Qu
# Y29tL1VTRVJUcnVzdFJTQUNlcnRpZmljYXRpb25BdXRob3JpdHkuY3JsMHYGCCsG
# AQUFBwEBBGowaDA/BggrBgEFBQcwAoYzaHR0cDovL2NydC51c2VydHJ1c3QuY29t
# L1VTRVJUcnVzdFJTQUFkZFRydXN0Q0EuY3J0MCUGCCsGAQUFBzABhhlodHRwOi8v
# b2NzcC51c2VydHJ1c3QuY29tMA0GCSqGSIb3DQEBDAUAA4ICAQBtVIGlM10W4bVT
# gZF13wN6MgstJYQRsrDbKn0qBfW8Oyf0WqC5SVmQKWxhy7VQ2+J9+Z8A70DDrdPi
# 5Fb5WEHP8ULlEH3/sHQfj8ZcCfkzXuqgHCZYXPO0EQ/V1cPivNVYeL9IduFEZ22P
# sEMQD43k+ThivxMBxYWjTMXMslMwlaTW9JZWCLjNXH8Blr5yUmo7Qjd8Fng5k5OU
# m7Hcsm1BbWfNyW+QPX9FcsEbI9bCVYRm5LPFZgb289ZLXq2jK0KKIZL+qG9aJXBi
# gXNjXqC72NzXStM9r4MGOBIdJIct5PwC1j53BLwENrXnd8ucLo0jGLmjwkcd8F3W
# oXNXBWiap8k3ZR2+6rzYQoNDBaWLpgn/0aGUpk6qPQn1BWy30mRa2Coiwkud8Tle
# TN5IPZs0lpoJX47997FSkc4/ifYcobWpdR9xv1tDXWU9UIFuq/DQ0/yysx+2mZYm
# 9Dx5i1xkzM3uJ5rloMAMcofBbk1a0x7q8ETmMm8c6xdOlMN4ZSA7D0GqH+mhQZ3+
# sbigZSo04N6o+TzmwTC7wKBjLPxcFgCo0MR/6hGdHgbGpm0yXbQ4CStJB6r97DDa
# 8acvz7f9+tCjhNknnvsBZne5VhDhIG7GrrH5trrINV0zdo7xfCAMKneutaIChrop
# 7rRaALGMq+P5CslUXdS5anSevUiumDGCBCwwggQoAgEBMIGRMH0xCzAJBgNVBAYT
# AkdCMRswGQYDVQQIExJHcmVhdGVyIE1hbmNoZXN0ZXIxEDAOBgNVBAcTB1NhbGZv
# cmQxGDAWBgNVBAoTD1NlY3RpZ28gTGltaXRlZDElMCMGA1UEAxMcU2VjdGlnbyBS
# U0EgVGltZSBTdGFtcGluZyBDQQIQOUwl4XygbSeoZeI72R0i1DANBglghkgBZQME
# AgIFAKCCAWswGgYJKoZIhvcNAQkDMQ0GCyqGSIb3DQEJEAEEMBwGCSqGSIb3DQEJ
# BTEPFw0yNDA3MTExOTMwMjVaMD8GCSqGSIb3DQEJBDEyBDBTDZJW18kaocgj0S09
# 8y2vobl6mmpBcGrCHQOhDacY2f7Qkh2uOuqcIwtBmqvZeOMwge0GCyqGSIb3DQEJ
# EAIMMYHdMIHaMIHXMBYEFK5ir3UKDL1H1kYfdWjivIznyk+UMIG8BBQC1luV4oNw
# wVcAlfqI+SPdk3+tjzCBozCBjqSBizCBiDELMAkGA1UEBhMCVVMxEzARBgNVBAgT
# Ck5ldyBKZXJzZXkxFDASBgNVBAcTC0plcnNleSBDaXR5MR4wHAYDVQQKExVUaGUg
# VVNFUlRSVVNUIE5ldHdvcmsxLjAsBgNVBAMTJVVTRVJUcnVzdCBSU0EgQ2VydGlm
# aWNhdGlvbiBBdXRob3JpdHkCEDAPb6zdZph0fKlGNqd4LbkwDQYJKoZIhvcNAQEB
# BQAEggIAbGGCACf/eRqe62dbwH7qWJv3bbauYcOUmXSRht9x+oyn/T1VxGTzOJnw
# /YBygXRrgFCh4mbkTCv06EUYU47Y5XXv/5JCwvGRmRb12S3HIbalorRdW01+alv3
# fzk3aH23rq/KEfI2LjO4KQMJ4uhDxGYI28qqxAXCYzN2eUqBeYAKPlTPMeX7PJJU
# F55CxpfqT6pQGvynrSVbEfN+V0hPakNK4H0uOWwBnVwLV41tCbd+OufLffjS1L4T
# 891NVQKKicgHWij8zz1D8H3nVemA/TaQ9inb4eNqVMuf2A0iE/rIEN/1ca66yvDk
# GsjGO+0r0Rw842jyrxsEYLyPRt3rrNyA9/rTcwHdAenyOL+8vv4H6/fSGT0Ll/Us
# h3u1PcP91QZhO7jUKGyILAWIR4o46f5KmduSzmcX+kZOJpGT+cYeXQcMdDQGzsJB
# KQaS5wS9KYT6aw1neyqNshzplWOncDBseSkuk/thpDX2+BaCy4HSBP+b58dCLID6
# NvNkG//wkDci6XuN9yMoMQBN5/3k9SBGfvewMe6ojTpS+aXEhQRzzxhxf50f72yK
# iUPyVyd7pcFLy+mwCDA2ELfcTz1V37M/cHEIbfHPrzjPdvRCKfIdTqoP1dG+8xvD
# Y+BRLng+3mXOTQRZV4nMTQ/+VHLyXJ4PqaIEaouFgYiPs/6F5Ms=
# SIG # End signature block
