# <copyright>
# INTEL CONFIDENTIAL
#
# Copyright 2021 Intel Corporation
#
# This software and the related documents are Intel copyrighted materials, and your use of
# them is governed by the express license under which they were provided to you ("License").
# Unless the License provides otherwise, you may not use, modify, copy, publish, distribute,
# disclose or transmit this software or the related documents without Intel's prior written
# permission.
#
# This software and the related documents are provided as is, with no express or implied
# warranties, other than those that are expressly stated in the License.
#
# <copyright>

# Suppress irrelevant PS Script Analyzer warnings
[Diagnostics.CodeAnalysis.SuppressMessageAttribute("PSUseDeclaredVarsMoreThanAssignments", "")] Param()

$BusTypeMap = [ordered]@{
    0 = $Messages.Unknown
    1 = $Messages.ISA
    2 = $Messages.EISA
    3 = $Messages.PCMCIA
    4 = $Messages.CardBus
    5 = $Messages.PCI
    6 = $Messages.PCIX
    7 = $Messages.PCIExpress
    8 = $Messages.IOSF
}

# Map from *SpeedDuplex enum values to possible adapter speeds
$SupportedSpeedsMap = [ordered]@{
    "0"      = 0            #AutoNegotiation
    "1"      = 10000000     #10Mb Half Duplex
    "2"      = 10000000     #10Mb Full Duplex
    "3"      = 100000000    #100Mb Half Duplex
    "4"      = 100000000    #100Mb Full Duplex
    "5"      = 1000000000   #1Gb Full Duplex NDIS5
    "6"      = 1000000000   #1Gb Full Duplex NDIS6
    "7"      = 10000000000  #10Gb Full Duplex
    "8"      = 10000000000  #10Gb Half Duplex
    "9"      = 40000000000  #40Gb Half Duplex
    "2500"   = 2500000000   #2.5Gb
    "5000"   = 5000000000   #5Gb
    "25000"  = 25000000000  #25Gb
    "500000" = 50000000000  #50Gb
    "10"     = 100000000000 #100Gb
}

$DebugClusterMap = [ordered]@{
    0  = "Switch"
    1  = "ACL"
    2  = "TX Scheduler"
    3  = "Profile Configuration"
    5  = "Link"
    7  = "DCB"
    8  = "L2P"
    22 = "Manageability Transactions", "MNG Transactions", "MNG"
}

$I40EA_WPP_GUID = "{4A6F89F6-C31F-449C-8854-9EE02A879D14}"
$I40EB_WPP_GUID = "{75BFFF12-65EC-4631-ADBA-BA8851D3A064}"
$ICEA_WPP_GUID = "{BDD04ED8-F4BB-4B36-BB76-D2FFC123EC67}"
$SCEA_WPP_GUID = "{2104EB78-B564-47BF-AB55-DBFD9338627D}"

$I40EA_LOGNAME = "X710_Log"
$I40EB_LOGNAME = "X722_Log"
$ICEA_LOGNAME = "E810_Log"
$SCEA_LOGNAME = "E823_Log"

$DRIVER_LOG_LEVEL_MAP = [ordered]@{
    "Verbose" = 4
    "Normal" = 3
    "Warning" = 2
    "Error" = 1
    "Disabled" = 0
}

$SUB_MODULE_MAP = [ordered]@{
    "Default"        = (1 -shl 0)
    "Init"           = (1 -shl 1)
    "Resource"       = (1 -shl 2)
    "Request"        = (1 -shl 3)
    "Power"          = (1 -shl 4)
    "FuncCall"       = (1 -shl 5)
    "Shared"         = (1 -shl 6)
    "Link"           = (1 -shl 7)
    "Offload"        = (1 -shl 8)
    "Tx"             = (1 -shl 9)
    "Rx"             = (1 -shl 10)
    "Packet"         = (1 -shl 11)
    "Interrupt"      = (1 -shl 12)
    "Lock"           = (1 -shl 13)
    "Watchdog"       = (1 -shl 14)
    "SIPS"           = (1 -shl 15)
    "RCTL"           = (1 -shl 16)
    "RDMA"           = (1 -shl 17)
    "RDMA_Shared"    = (1 -shl 18)
    "RDMA_CM"        = (1 -shl 19)
    "RDMA_Resources" = (1 -shl 20)
    "Diags"          = (1 -shl 21)
}

$DRIVER_MODULE_ID = 0x80

$DRIVER_MODULE_NAME = "Driver"
$DRIVERLOG_REGISTRYVAR_NAME = "DriverLogLevel"
$SUBMODULE_REGISTRYVAR_NAME = "SubModule"

# Define the upper limit of the SubModule map for default SubModule
$SUBMODULE_DEFAULT_RANGE_LIMIT = 5

# Add to upper limit to calculate default SubModule
$SUBMODULE_DEFAULT_SUM = ($SUB_MODULE_MAP[0..$SUBMODULE_DEFAULT_RANGE_LIMIT] | Measure-Object -Sum).Sum

$SUM_SUBMODULES = [int]($SUB_MODULE_MAP.Values | Measure-Object -Sum).Sum

$INTEL_GEN_DATA_STATUS_CALL_GET_GEN_DATA = 1
$INTEL_GEN_DATA_STATUS_UNSUPPORTED_OP_VER = 4

enum DcbxStatusValue
{
    NOT_STARTED    = 0
    IN_PROGRESS    = 1
    DONE           = 2
    MULTIPLE_PEERS = 3
    DISABLED       = 7
}
enum ADAPTER_STATUS
{
    Installed    = 0x1
    DriverLoaded = 0x2
    HwMissing    = 0x4
    Reserved     = 0x8
    HasDiag      = 0x10
    HasLink      = 0x20
    PoweredOff   = 0x1000
}


enum CVL_PHY_TYPE
{
    CVL100BaseTX = 0x0
    CVL100MSGMII = 0x1
    CVL1000BaseT = 0x2
    CVL1000BaseSX = 0x3
    CVL1000BaseLX = 0x4
    CVL1000BaseKX = 0x5
    CVL1GSGMII = 0x6
    CVL2Point5GBaseT = 0x7
    CVL2Point5gBaseX = 0x8
    CVL2Point5GBaseKX = 0x9
    CVL5GBaseT = 0xA
    CVL5GBaseKR = 0xB
    CVL10GBaseT = 0xC
    CVL10GSFIDA = 0xD
    CVL10GBaseSR = 0xE
    CVL10GBaseLR = 0xF
    CVL10GBaseKR = 0x10
    CVL10GSFIAOC_ACC = 0x11
    CVL10GSFIC2C = 0x12
    CVL25GBaseT = 0x13
    CVL25GBaseCR = 0x14
    CVL25GBaseCRS = 0x15
    CVL25GBaseCR1 = 0x16
    CVL25GBaseSR = 0x17
    CVL25GBaseLR = 0x18
    CVL25GBaseKR = 0x19
    CVL25GBaseKRS = 0x1A
    CVL25GBaseKR1 = 0x1B
    CVL25GAUIAOC_ACC = 0x1C
    CVL25GAUIC2C = 0x1D
    CVL40GBaseCR4 = 0x1E
    CVL40GBaseSR4 = 0x1F
    CVL40GBaseLR4 = 0x20
    CVL40GBaseKR4 = 0x21
    CVL40GXLAUIAOC_ACC = 0x22
    CVL40GXLAUI = 0x23
    CVL50GBaseCR2 = 0x24
    CVL50GBaseKR2 = 0x27
    CVL50GLAUI2AOC_ACC = 0x28
    CVL50GLAUI2 = 0x29
    CVL50GAUI2AOC_ACC = 0x2A
    CVL50GAUI2 = 0x2B
    CVL50GBaseCRPAM4 = 0x2C
    CVL50GBaseSR = 0x2D
    CVL50GBaseFR = 0x2E
    CVL50GBaseLR = 0x2F
    CVL50GBaseKRPAM4 = 0x30
    CVL50GAUI1AOC_ACC = 0x31
    CVL50GAUI1 = 0x32
    CVL100GBaseCR4 = 0x33
    CVL100GBaseSR4 = 0x34
    CVL100GBaseLR4 = 0x35
    CVL100GBaseKR4 = 0x36
    CVL100GCAUI4AOC_ACC = 0x37
    CVL100GCAUI4 = 0x38
    CVL100GAUI4AOC_ACC = 0x39
    CVL100GAUI4 = 0x3A
    CVL100GBaseKR4PAM4 = 0x3C
    CVL100GBaseCP2 = 0x3D
    CVL100GBaseSR2 = 0x3E
    CVL100GBaseDR = 0x3F
    CVL100GBaseKR2PAM4 = 0x40
    CVL100GAUI2AOC_ACC = 0x43
    CVL100GAUI2 = 0x44
    CVL200GBaseCR4PAM4 = 0x45
    CVL200GBaseSR4 = 0x46
    CVL200GBaseFR4 = 0x47
    CVL200GBaseLR4 = 0x48
    CVL200GBaseDR4 = 0x49
    CVL200GBaseKR4PAM4 = 0x4A
    CVL200GAUI4AOC_ACC = 0x4B
    CVL200GAUI4 = 0x4C
    CVL200GAUI8AOC_ACC = 0x4D
    CVL200GAUI8 = 0x4E
    CVL400GBaseFR8 = 0x4F
    CVL400GBaseLR8 = 0x50
    CVL400GBaseDR4 = 0x51
    CVL400GAUI8AOC_ACC = 0x52
    CVL400GAUI8 = 0x53
    CVLAutoNegotiation = 0x7E
    CVLOuterphydisabled = 0x7F
}

enum CPK_PHY_INFO
{
    CPK_PHYINFO_MEDIA_BACKPLANE = 1
    CPK_PHYINFO_MEDIA_QSFP      = 2
    CPK_PHYINFO_MEDIA_SFP       = 3
    CPK_PHYINFO_MEDIA_BASE_T    = 4
    CPK_PHYINFO_MEDIA_SGMII     = 5
    CPK_PHYINFO_MEDIA_FIBER     = 6
}

enum NCS_ADAPTER_MEDIA_TYPE
{
    NCS_MEDIA_UNKNOWN = 0
    NCS_MEDIA_COPPER = 1
    NCS_MEDIA_FIBER = 2
    NCS_MEDIA_PHONELINE = 3
    NCS_MEDIA_CX4COPPER = 4
    NCS_MEDIA_SFPDIRECTATTACH = 5
    NCS_MEDIA_SR_FIBER = 6
    NCS_MEDIA_LR_FIBER = 7
    NCS_MEDIA_KX4BACKPLANE = 8
    NCS_MEDIA_SERDES = 9
    NCS_MEDIA_BACKPLANE = 10
    NCS_MEDIA_XAUI = 11
    NCS_MEDIA_SFPACTIVEDIRECTATTACH = 12
    NCS_MEDIA_SWITCHHOST = 13
    NCS_MEDIA_QSFPDIRECTATTACH = 14
    NCS_MEDIA_SFP28DIRECTATTACH = 15
    NCS_MEDIA_CVL_AOC_ACC = 16
    NCS_MEDIA_CVL_Backplane_KR = 17
    NCS_MEDIA_CVL_Backplane_KR1 = 18
    NCS_MEDIA_CVL_Backplane_KR2 = 19
    NCS_MEDIA_CVL_Backplane_KR2_PAM4 = 20
    NCS_MEDIA_CVL_Backplane_KR4 = 21
    NCS_MEDIA_CVL_Backplane_KR4_PAM4 = 22
    NCS_MEDIA_CVL_Backplane_KR_PAM4 = 23
    NCS_MEDIA_CVL_Backplane_KR_S = 24
    NCS_MEDIA_CVL_Backplane_KX = 25
    NCS_MEDIA_CVL_Chip_to_Chip = 26
    NCS_MEDIA_CVL_Copper_T = 27
    NCS_MEDIA_CVL_Copper_TX = 28
    NCS_MEDIA_CVL_Direct_Attach = 29
    NCS_MEDIA_CVL_Direct_Attach_CP2 = 30
    NCS_MEDIA_CVL_Direct_Attach_CR = 31
    NCS_MEDIA_CVL_Direct_Attach_CR1 = 32
    NCS_MEDIA_CVL_Direct_Attach_CR2 = 33
    NCS_MEDIA_CVL_Direct_Attach_CR4 = 34
    NCS_MEDIA_CVL_Direct_Attach_CR_PAM4 = 35
    NCS_MEDIA_CVL_Direct_Attach_CR_S = 36
    NCS_MEDIA_CVL_Fiber_DR = 37
    NCS_MEDIA_CVL_Fiber_FR = 38
    NCS_MEDIA_CVL_Fiber_LR = 39
    NCS_MEDIA_CVL_Fiber_LR4 = 40
    NCS_MEDIA_CVL_Fiber_LX = 41
    NCS_MEDIA_CVL_Fiber_SR = 42
    NCS_MEDIA_CVL_Fiber_SR2 = 43
    NCS_MEDIA_CVL_Fiber_SR4 = 44
    NCS_MEDIA_CVL_Fiber_SX = 45
    NCS_MEDIA_CVL_Fiber_X = 46
    NCS_MEDIA_CVL_SGMII = 47
    NCS_MEDIA_CVL_Unknown = 48
    NCS_MEDIA_INTERFACE_CVL_BACKPLANE = 1000
    NCS_MEDIA_INTERFACE_CVL_QSFP = 1001
    NCS_MEDIA_INTERFACE_CVL_SFP = 1002
    NCS_MEDIA_INTERFACE_CVL_BASE_T = 1003
    NCS_MEDIA_INTERFACE_CVL_SGMII = 1004
    NCS_MEDIA_INTERFACE_CVL_FIBER = 1005
}

enum I40E_PHY_TYPE
{
    I40E_PHY_TYPE_SGMII                     = 0x0
    I40E_PHY_TYPE_1000BASE_KX               = 0x1
    I40E_PHY_TYPE_10GBASE_KX4               = 0x2
    I40E_PHY_TYPE_10GBASE_KR                = 0x3
    I40E_PHY_TYPE_40GBASE_KR4               = 0x4
    I40E_PHY_TYPE_XAUI                      = 0x5
    I40E_PHY_TYPE_XFI                       = 0x6
    I40E_PHY_TYPE_SFI                       = 0x7
    I40E_PHY_TYPE_XLAUI                     = 0x8
    I40E_PHY_TYPE_XLPPI                     = 0x9
    I40E_PHY_TYPE_40GBASE_CR4_CU            = 0xA
    I40E_PHY_TYPE_10GBASE_CR1_CU            = 0xB
    I40E_PHY_TYPE_10GBASE_AOC               = 0xC
    I40E_PHY_TYPE_40GBASE_AOC               = 0xD
    I40E_PHY_TYPE_UNRECOGNIZED              = 0xE
    I40E_PHY_TYPE_UNSUPPORTED               = 0xF
    I40E_PHY_TYPE_100BASE_TX                = 0x11
    I40E_PHY_TYPE_1000BASE_T                = 0x12
    I40E_PHY_TYPE_10GBASE_T                 = 0x13
    I40E_PHY_TYPE_10GBASE_SR                = 0x14
    I40E_PHY_TYPE_10GBASE_LR                = 0x15
    I40E_PHY_TYPE_10GBASE_SFPP_CU           = 0x16
    I40E_PHY_TYPE_10GBASE_CR1               = 0x17
    I40E_PHY_TYPE_40GBASE_CR4               = 0x18
    I40E_PHY_TYPE_40GBASE_SR4               = 0x19
    I40E_PHY_TYPE_40GBASE_LR4               = 0x1A
    I40E_PHY_TYPE_1000BASE_SX               = 0x1B
    I40E_PHY_TYPE_1000BASE_LX               = 0x1C
    I40E_PHY_TYPE_1000BASE_T_OPTICAL        = 0x1D
    I40E_PHY_TYPE_20GBASE_KR2               = 0x1E
    I40E_PHY_TYPE_25GBASE_KR                = 0x1F
    I40E_PHY_TYPE_25GBASE_CR                = 0x20
    I40E_PHY_TYPE_25GBASE_SR                = 0x21
    I40E_PHY_TYPE_25GBASE_LR                = 0x22
    I40E_PHY_TYPE_25GBASE_AOC               = 0x23
    I40E_PHY_TYPE_25GBASE_ACC               = 0x24
    I40E_PHY_TYPE_2_5GBASE_T                = 0x26
    I40E_PHY_TYPE_5GBASE_T                  = 0x27
    I40E_PHY_TYPE_2_5GBASE_T_LINK_STATUS    = 0x30
    I40E_PHY_TYPE_5GBASE_T_LINK_STATUS      = 0x31
    I40E_PHY_TYPE_NOT_SUPPORTED_HIGH_TEMP   = 0xFD
    I40E_PHY_TYPE_EMPTY                     = 0xFE
    I40E_PHY_TYPE_DEFAULT                   = 0xFF
}

enum LinkType
{
    LINK_TYPE_SGMII              = 0x1
    LINK_TYPE_1000BASE_KX        = 0x2
    LINK_TYPE_10GBASE_KX4        = 0x4
    LINK_TYPE_10GBASE_KR         = 0x8
    LINK_TYPE_40GBASE_KR4        = 0x10
    LINK_TYPE_XAUI               = 0x20
    LINK_TYPE_XFI                = 0x40
    LINK_TYPE_SFI                = 0x80
    LINK_TYPE_XLAUI              = 0x100
    LINK_TYPE_XLPPI              = 0x200
    LINK_TYPE_40GBASE_CR4_CU     = 0x400
    LINK_TYPE_10GBASE_CR1_CU     = 0x800
    LINK_TYPE_100BASE_TX         = 0x20000
    LINK_TYPE_1000BASE_T         = 0x40000
    LINK_TYPE_10GBASE_T          = 0x80000
    LINK_TYPE_10GBASE_SR         = 0x100000
    LINK_TYPE_10GBASE_LR         = 0x200000
    LINK_TYPE_10GBASE_SFP_Cu     = 0x400000
    LINK_TYPE_10GBASE_CR1        = 0x800000
    LINK_TYPE_40GBASE_CR4        = 0x1000000
    LINK_TYPE_40GBASE_SR4        = 0x2000000
    LINK_TYPE_40GBASE_LR4        = 0x4000000
    LINK_TYPE_1000BASE_SX        = 0x8000000
    LINK_TYPE_1000BASE_LX        = 0x10000000
    LINK_TYPE_1000BASE_T_Optical = 0x20000000
    LINK_TYPE_20GBASE_KR2        = 0x40000000
}

enum LinkTypeExt
{
    LINK_TYPE_25GBase_KR         = 0x1
    LINK_TYPE_25GBase_CR         = 0x2
    LINK_TYPE_25GBase_SR         = 0x4
    LINK_TYPE_25GBase_LR         = 0x8
    LINK_TYPE_25G_AOC            = 0x10
    LINK_TYPE_25G_ACC            = 0x20
    LINK_TYPE_2_5GBASE_T         = 0x40
    LINK_TYPE_5GBASE_T           = 0x80
}

enum ADAPTER_CAPABILITY
{
    NCS_ADAPTER_CAP_UNKNOWN = 0
    NCS_ADAPTER_CAP_OTHER = 1
    NCS_ADAPTER_CAP_WAKE_ON_LAN = 3
    NCS_ADAPTER_CAP_FAILOVER = 4
    NCS_ADAPTER_CAP_LOADBALANCING = 5
    NCS_ADAPTER_CAP_IPSEC_OFFLOAD = 6
    NCS_ADAPTER_CAP_FEC = 9
    NCS_ADAPTER_CAP_802_3AD = 10
    NCS_ADAPTER_CAP_CHECKSUM_OFFLOAD = 11
    NCS_ADAPTER_CAP_SWITCHED_FAULT_TOLERANT = 12
    NCS_ADAPTER_CAP_TCO_CAPABILITY = 29
    NCS_ADAPTER_CAP_WAKEUP_CAPABILITIES = 30
    NCS_ADAPTER_CAP_IP_CHECKSUM_OFFLOAD = 31
    NCS_ADAPTER_CAP_SPEED_10_MBPS = 32
    NCS_ADAPTER_CAP_SPEED_100_MBPS = 33
    NCS_ADAPTER_CAP_SPEED_1000_MBPS = 34
    NCS_ADAPTER_CAP_SPEED_10000_MBPS = 35
    NCS_ADAPTER_CAP_TEAM_SUPPORT = 36
    NCS_ADAPTER_CAP_VLAN_SUPPORT = 37
    NCS_ADAPTER_CAP_VLAN_TYPE_IEEE = 38
    NCS_ADAPTER_CAP_VLAN_TYPE_ISL = 39
    NCS_ADAPTER_CAP_IDENTIFY_ADAPTER_SUPPORT = 41
    NCS_ADAPTER_CAP_CABLE_TEST_SUPPORT = 42
    NCS_ADAPTER_CAP_DIAGNOSTIC_SUPPORT = 43
    NCS_ADAPTER_CAP_FLASH_SUPPORT = 44
    NCS_ADAPTER_CAP_USAGE_SERVER = 46
    NCS_ADAPTER_CAP_VENDOR_INTEL = 47
    NCS_ADAPTER_CAP_PWMGMT_SUPPORT = 50
    NCS_ADAPTER_CAP_QUAD_PORT = 54
    NCS_ADAPTER_CAP_JUMBO_FRAMES = 56
    NCS_ADAPTER_CAP_IGP_SIGNAL_QUALITY_TEST = 58
    NCS_ADAPTER_CAP_CABLE_OFFLINE_TEST = 59
    NCS_ADAPTER_IS_A_LOM = 60
    NCS_ADAPTER_CAP_NDIS_IOAT = 61
    NCS_ADAPTER_CAP_CB_PLATFORM_IOAT = 62
    NCS_ADAPTER_CAP_ISCSI = 63
    NCS_ADAPTER_CAP_DCB = 65
    NCS_ADAPTER_CAP_FCOE = 66
    NCS_ADAPTER_CAP_KX_MODULE   = 67
    NCS_ADAPTER_CAP_VM_LOADBALANCING = 68
    NCS_ADAPTER_CAP_PERFORMANCE_PROFILE = 69
    NCS_ADAPTER_CAP_OS2BMC = 70
    NCS_ADAPTER_CAP_AMT = 71
    NCS_ADAPTER_CAP_SPEED_2500_MBPS = 72
    NCS_ADAPTER_CAP_BASIC_DMIX_SUPPORT = 73
    NCS_ADAPTER_CAP_EXTENDED_DMIX_SUPPORT = 74
    NCS_ADAPTER_CAP_SPEED_40000_MBPS = 75
    NCS_ADAPTER_CAP_NPAR_ENABLED = 76
    NCS_ADAPTER_CAP_ANS_SUPPORTED = 77
    NCS_ADAPTER_CAP_QSFP_LINK_MODE_ENABLED = 78
    NCS_ADAPTER_CAP_SPEED_25000_MBPS = 79
    NCS_ADAPTER_CAP_NPAR_CAPABLE = 80
    NCS_ADAPTER_CAP_SPEED_5000_MBPS = 81
    NCS_ADAPTER_CAP_SPEED_50000_MBPS = 82
    NCS_ADAPTER_CAP_SPEED_100000_MBPS = 83
    NCS_ADAPTER_CAP_CYPRESS = 84
}

# from MSFT_NetAdapterAdvancedPropertySettingData WMI class
enum DisplayParameterType
{
    int   = 1
    long  = 2
    word  = 3
    dword = 4
    enum  = 5
    edit  = 6
}

# from MSFT_NetAdapter WMI class
enum NetAdapterState
{
    Unknown  = 0
    Present  = 1
    Started  = 2
    Disabled = 3
}

$NETWORK_ADDRESS_LEN = 12

$PROFILE_VALUE_TO_NAME = [ordered]@{
    "1" = "Custom Settings"
    "2" = "Standard Server"
    "3" = "Web Server"
    "4" = "Storage Server"
    "5" = "Virtualization Server (Hyper-V*)"
    "6" = "Low Latency"
    "7" = "Storage + Virtualization"
}

$PROFILE_TO_XMLPROFILE = @{
    "Standard Server" = "standard"
    "Web Server" = "web"
    "Storage Server" = "storage"
    "Virtualization Server (Hyper-V*)" = "hyperv"
    "Low Latency" = "lowlatency"
    "Storage + Virtualization" = "storagevirtualization"
}

#maps targeted towards Performance profile naming IDs
$DRIVER_TO_CODENAME = @{
    "i40ea" = "710"
    "i40eb" = "X722"
    "icea" = "E8"
    "scea" = "E8"
}

# Each Key treated as a range of Build Numbers (14393 to 16299 is NDIS v6.60)
$OSBUILD_TO_NDIS = [ordered]@{
    14393 = "ndis660"
    16299 = "ndis680"
}

$INTEL_DIAG_TEST = @{
    1 = $Messages.Register
    2 = $Messages.EEPROM
    3 = $Messages.MacLoopback
    4 = $Messages.Interrupt
    5 = $Messages.FIFO
}

# SIG # Begin signature block
# MIIocQYJKoZIhvcNAQcCoIIoYjCCKF4CAQExDzANBglghkgBZQMEAgEFADB5Bgor
# BgEEAYI3AgEEoGswaTA0BgorBgEEAYI3AgEeMCYCAwEAAAQQH8w7YFlLCE63JNLG
# KX7zUQIBAAIBAAIBAAIBAAIBADAxMA0GCWCGSAFlAwQCAQUABCC8hvZefZLEfsOk
# XB9vYYpRa4Xxwk46kA6Ky2r9MusEkKCCEfIwggVvMIIEV6ADAgECAhBI/JO0YFWU
# jTanyYqJ1pQWMA0GCSqGSIb3DQEBDAUAMHsxCzAJBgNVBAYTAkdCMRswGQYDVQQI
# DBJHcmVhdGVyIE1hbmNoZXN0ZXIxEDAOBgNVBAcMB1NhbGZvcmQxGjAYBgNVBAoM
# EUNvbW9kbyBDQSBMaW1pdGVkMSEwHwYDVQQDDBhBQUEgQ2VydGlmaWNhdGUgU2Vy
# dmljZXMwHhcNMjEwNTI1MDAwMDAwWhcNMjgxMjMxMjM1OTU5WjBWMQswCQYDVQQG
# EwJHQjEYMBYGA1UEChMPU2VjdGlnbyBMaW1pdGVkMS0wKwYDVQQDEyRTZWN0aWdv
# IFB1YmxpYyBDb2RlIFNpZ25pbmcgUm9vdCBSNDYwggIiMA0GCSqGSIb3DQEBAQUA
# A4ICDwAwggIKAoICAQCN55QSIgQkdC7/FiMCkoq2rjaFrEfUI5ErPtx94jGgUW+s
# hJHjUoq14pbe0IdjJImK/+8Skzt9u7aKvb0Ffyeba2XTpQxpsbxJOZrxbW6q5KCD
# J9qaDStQ6Utbs7hkNqR+Sj2pcaths3OzPAsM79szV+W+NDfjlxtd/R8SPYIDdub7
# P2bSlDFp+m2zNKzBenjcklDyZMeqLQSrw2rq4C+np9xu1+j/2iGrQL+57g2extme
# me/G3h+pDHazJyCh1rr9gOcB0u/rgimVcI3/uxXP/tEPNqIuTzKQdEZrRzUTdwUz
# T2MuuC3hv2WnBGsY2HH6zAjybYmZELGt2z4s5KoYsMYHAXVn3m3pY2MeNn9pib6q
# RT5uWl+PoVvLnTCGMOgDs0DGDQ84zWeoU4j6uDBl+m/H5x2xg3RpPqzEaDux5mcz
# mrYI4IAFSEDu9oJkRqj1c7AGlfJsZZ+/VVscnFcax3hGfHCqlBuCF6yH6bbJDoEc
# QNYWFyn8XJwYK+pF9e+91WdPKF4F7pBMeufG9ND8+s0+MkYTIDaKBOq3qgdGnA2T
# OglmmVhcKaO5DKYwODzQRjY1fJy67sPV+Qp2+n4FG0DKkjXp1XrRtX8ArqmQqsV/
# AZwQsRb8zG4Y3G9i/qZQp7h7uJ0VP/4gDHXIIloTlRmQAOka1cKG8eOO7F/05QID
# AQABo4IBEjCCAQ4wHwYDVR0jBBgwFoAUoBEKIz6W8Qfs4q8p74Klf9AwpLQwHQYD
# VR0OBBYEFDLrkpr/NZZILyhAQnAgNpFcF4XmMA4GA1UdDwEB/wQEAwIBhjAPBgNV
# HRMBAf8EBTADAQH/MBMGA1UdJQQMMAoGCCsGAQUFBwMDMBsGA1UdIAQUMBIwBgYE
# VR0gADAIBgZngQwBBAEwQwYDVR0fBDwwOjA4oDagNIYyaHR0cDovL2NybC5jb21v
# ZG9jYS5jb20vQUFBQ2VydGlmaWNhdGVTZXJ2aWNlcy5jcmwwNAYIKwYBBQUHAQEE
# KDAmMCQGCCsGAQUFBzABhhhodHRwOi8vb2NzcC5jb21vZG9jYS5jb20wDQYJKoZI
# hvcNAQEMBQADggEBABK/oe+LdJqYRLhpRrWrJAoMpIpnuDqBv0WKfVIHqI0fTiGF
# OaNrXi0ghr8QuK55O1PNtPvYRL4G2VxjZ9RAFodEhnIq1jIV9RKDwvnhXRFAZ/ZC
# J3LFI+ICOBpMIOLbAffNRk8monxmwFE2tokCVMf8WPtsAO7+mKYulaEMUykfb9gZ
# pk+e96wJ6l2CxouvgKe9gUhShDHaMuwV5KZMPWw5c9QLhTkg4IUaaOGnSDip0TYl
# d8GNGRbFiExmfS9jzpjoad+sPKhdnckcW67Y8y90z7h+9teDnRGWYpquRRPaf9xH
# +9/DUp/mBlXpnYzyOmJRvOwkDynUWICE5EV7WtgwggYcMIIEBKADAgECAhAz1wio
# kUBTGeKlu9M5ua1uMA0GCSqGSIb3DQEBDAUAMFYxCzAJBgNVBAYTAkdCMRgwFgYD
# VQQKEw9TZWN0aWdvIExpbWl0ZWQxLTArBgNVBAMTJFNlY3RpZ28gUHVibGljIENv
# ZGUgU2lnbmluZyBSb290IFI0NjAeFw0yMTAzMjIwMDAwMDBaFw0zNjAzMjEyMzU5
# NTlaMFcxCzAJBgNVBAYTAkdCMRgwFgYDVQQKEw9TZWN0aWdvIExpbWl0ZWQxLjAs
# BgNVBAMTJVNlY3RpZ28gUHVibGljIENvZGUgU2lnbmluZyBDQSBFViBSMzYwggGi
# MA0GCSqGSIb3DQEBAQUAA4IBjwAwggGKAoIBgQC70f4et0JbePWQp64sg/GNIdMw
# hoV739PN2RZLrIXFuwHP4owoEXIEdiyBxasSekBKxRDogRQ5G19PB/YwMDB/NSXl
# wHM9QAmU6Kj46zkLVdW2DIseJ/jePiLBv+9l7nPuZd0o3bsffZsyf7eZVReqskmo
# PBBqOsMhspmoQ9c7gqgZYbU+alpduLyeE9AKnvVbj2k4aOqlH1vKI+4L7bzQHkND
# brBTjMJzKkQxbr6PuMYC9ruCBBV5DFIg6JgncWHvL+T4AvszWbX0w1Xn3/YIIq62
# 0QlZ7AGfc4m3Q0/V8tm9VlkJ3bcX9sR0gLqHRqwG29sEDdVOuu6MCTQZlRvmcBME
# Jd+PuNeEM4xspgzraLqVT3xE6NRpjSV5wyHxNXf4T7YSVZXQVugYAtXueciGoWnx
# G06UE2oHYvDQa5mll1CeHDOhHu5hiwVoHI717iaQg9b+cYWnmvINFD42tRKtd3V6
# zOdGNmqQU8vGlHHeBzoh+dYyZ+CcblSGoGSgg8sCAwEAAaOCAWMwggFfMB8GA1Ud
# IwQYMBaAFDLrkpr/NZZILyhAQnAgNpFcF4XmMB0GA1UdDgQWBBSBMpJBKyjNRsjE
# osYqORLsSKk/FDAOBgNVHQ8BAf8EBAMCAYYwEgYDVR0TAQH/BAgwBgEB/wIBADAT
# BgNVHSUEDDAKBggrBgEFBQcDAzAaBgNVHSAEEzARMAYGBFUdIAAwBwYFZ4EMAQMw
# SwYDVR0fBEQwQjBAoD6gPIY6aHR0cDovL2NybC5zZWN0aWdvLmNvbS9TZWN0aWdv
# UHVibGljQ29kZVNpZ25pbmdSb290UjQ2LmNybDB7BggrBgEFBQcBAQRvMG0wRgYI
# KwYBBQUHMAKGOmh0dHA6Ly9jcnQuc2VjdGlnby5jb20vU2VjdGlnb1B1YmxpY0Nv
# ZGVTaWduaW5nUm9vdFI0Ni5wN2MwIwYIKwYBBQUHMAGGF2h0dHA6Ly9vY3NwLnNl
# Y3RpZ28uY29tMA0GCSqGSIb3DQEBDAUAA4ICAQBfNqz7+fZyWhS38Asd3tj9lwHS
# /QHumS2G6Pa38Dn/1oFKWqdCSgotFZ3mlP3FaUqy10vxFhJM9r6QZmWLLXTUqwj3
# ahEDCHd8vmnhsNufJIkD1t5cpOCy1rTP4zjVuW3MJ9bOZBHoEHJ20/ng6SyJ6UnT
# s5eWBgrh9grIQZqRXYHYNneYyoBBl6j4kT9jn6rNVFRLgOr1F2bTlHH9nv1HMePp
# GoYd074g0j+xUl+yk72MlQmYco+VAfSYQ6VK+xQmqp02v3Kw/Ny9hA3s7TSoXpUr
# OBZjBXXZ9jEuFWvilLIq0nQ1tZiao/74Ky+2F0snbFrmuXZe2obdq2TWauqDGIgb
# MYL1iLOUJcAhLwhpAuNMu0wqETDrgXkG4UGVKtQg9guT5Hx2DJ0dJmtfhAH2KpnN
# r97H8OQYok6bLyoMZqaSdSa+2UA1E2+upjcaeuitHFFjBypWBmztfhj24+xkc6Zt
# CDaLrw+ZrnVrFyvCTWrDUUZBVumPwo3/E3Gb2u2e05+r5UWmEsUUWlJBl6MGAAjF
# 5hzqJ4I8O9vmRsTvLQA1E802fZ3lqicIBczOwDYOSxlP0GOabb/FKVMxItt1UHeG
# 0PL4au5rBhs+hSMrl8h+eplBDN1Yfw6owxI9OjWb4J0sjBeBVESoeh2YnZZ/WVim
# VGX/UUIL+Efrz/jlvzCCBlswggTDoAMCAQICEDB3Np9sRenync55S1/V2zEwDQYJ
# KoZIhvcNAQELBQAwVzELMAkGA1UEBhMCR0IxGDAWBgNVBAoTD1NlY3RpZ28gTGlt
# aXRlZDEuMCwGA1UEAxMlU2VjdGlnbyBQdWJsaWMgQ29kZSBTaWduaW5nIENBIEVW
# IFIzNjAeFw0yNDAxMTYwMDAwMDBaFw0yNTAxMTUyMzU5NTlaMIG7MRAwDgYDVQQF
# EwcyMTg5MDc0MRMwEQYLKwYBBAGCNzwCAQMTAlVTMRkwFwYLKwYBBAGCNzwCAQIT
# CERlbGF3YXJlMR0wGwYDVQQPExRQcml2YXRlIE9yZ2FuaXphdGlvbjELMAkGA1UE
# BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExGjAYBgNVBAoMEUludGVsIENvcnBv
# cmF0aW9uMRowGAYDVQQDDBFJbnRlbCBDb3Jwb3JhdGlvbjCCAaIwDQYJKoZIhvcN
# AQEBBQADggGPADCCAYoCggGBALUx6h43Sbt+ZfuTa/V0GFWgAAfUIWg9ruenPoc8
# FTqJxPdbqYRlGKEK2vCSQyBTn7tGV54Y/hMGvRTBQce4dMFe7R5wL9p92J3R4jkR
# MadZxJ4HuWalG13CpjQZP1Jg61Wx0KjsCPd2VdbBTpTiLRI+PKjokE6I/TLuA2bA
# tqy1phe2/82SRlx/fVGuIzI1BOQCaC9Olao3kJ9JwKt6VZidIgmzXAYLpzZ2VhW9
# HTRLaqTLTKxgO2mtpMTbfqc7RR/oYHG2cbGCoW3KB5Tlgjhm85ZsMEMV48O7JWeB
# wQoNy9admwqsdUzr5HdDbM7/EuiNHvP+sIauOmHEkLtqxM37sSgDBQX3V+vqiR5b
# H6xTcfIceaa4ukwKuVmfWrB35TGSEkWFzZu3ZUYGKRCI9WZ8GixV/5PHm571xSrD
# jbrigtkHtPahVVC8EUojnIGiDXovnm7ZG0FEXKuVybNOSpD3BzE2Pw3j/evKHuIr
# hWCzdPBOkbbEoYFBxts6UtJNFwIDAQABo4IBvDCCAbgwHwYDVR0jBBgwFoAUgTKS
# QSsozUbIxKLGKjkS7EipPxQwHQYDVR0OBBYEFKRLkSq7xH/Ru5kWUgmDt9ZZsJHj
# MA4GA1UdDwEB/wQEAwIHgDAMBgNVHRMBAf8EAjAAMBMGA1UdJQQMMAoGCCsGAQUF
# BwMDMEkGA1UdIARCMEAwNQYMKwYBBAGyMQECAQYBMCUwIwYIKwYBBQUHAgEWF2h0
# dHBzOi8vc2VjdGlnby5jb20vQ1BTMAcGBWeBDAEDMEsGA1UdHwREMEIwQKA+oDyG
# Omh0dHA6Ly9jcmwuc2VjdGlnby5jb20vU2VjdGlnb1B1YmxpY0NvZGVTaWduaW5n
# Q0FFVlIzNi5jcmwwewYIKwYBBQUHAQEEbzBtMEYGCCsGAQUFBzAChjpodHRwOi8v
# Y3J0LnNlY3RpZ28uY29tL1NlY3RpZ29QdWJsaWNDb2RlU2lnbmluZ0NBRVZSMzYu
# Y3J0MCMGCCsGAQUFBzABhhdodHRwOi8vb2NzcC5zZWN0aWdvLmNvbTAuBgNVHREE
# JzAloCMGCCsGAQUFBwgDoBcwFQwTVVMtREVMQVdBUkUtMjE4OTA3NDANBgkqhkiG
# 9w0BAQsFAAOCAYEAI6NvLiKQmXol9qHiDAxrF41RjhawR5g4ZQuWIxU2uMkjL9Eh
# NV16cKJjZ+KSPebFErInVlf/NLvKCfSUpf+2olf7Phu1pbb2p2R1mFtGYIA1Bcwa
# UmIsA/XsQ+ZHYlVdqBcpJCdc/jTzfAQen0gv1hFOIfk0vOKjjAAuTIgQNkG3c5Sw
# FMZjhu+wrSXx9Qvv85BhIX/xF1xYkKN4iBwqqebxAhmaE2tZUI7X/kKDx9QexONP
# Wo5Vw9b3P9I9pP8pWS/Txa4AC8x5AcZ8f6FUkl5Y750Ma6XEeHJZlUGkf1d/Ph9M
# c6bg5/P4wuXceTd4iqu3sK4ZxbiXWiFD+PtZ9UbzDarUNCqskSwudIzEcgwt7glZ
# YUNC+gD64uddohltoXXIasQNs/LK+qzOuqZKhFkRf+v4+Q28EQYuVIcJDHspW1CV
# k3Y4zhEb1dhCAPZ9jyXyz827Uji6HD5dnGO2lPCcEvM/aWEjYYM285g0CZix3LeB
# XQydSyjK95klPc99MYIV1TCCFdECAQEwazBXMQswCQYDVQQGEwJHQjEYMBYGA1UE
# ChMPU2VjdGlnbyBMaW1pdGVkMS4wLAYDVQQDEyVTZWN0aWdvIFB1YmxpYyBDb2Rl
# IFNpZ25pbmcgQ0EgRVYgUjM2AhAwdzafbEXp8p3OeUtf1dsxMA0GCWCGSAFlAwQC
# AQUAoGowGQYJKoZIhvcNAQkDMQwGCisGAQQBgjcCAQQwHAYKKwYBBAGCNwIBCzEO
# MAwGCisGAQQBgjcCARYwLwYJKoZIhvcNAQkEMSIEIF8M4ad6sXgPivDWEu4lhKfZ
# LDrcxzSU3FaHqyzX61UJMA0GCSqGSIb3DQEBAQUABIIBgJ4kfQaHI79rENECjqVY
# JQxcADFRHt5ISqvvMiUAxtHNI6WIWwTcO3GDogDLucA2YNiPP05sNa4cBILUCs9q
# /3KfLlmJqcOR/IY23nBJ4gpsDA0COaOBLfSMTIdG/pmXDs7k7frZALNbSAecgpNX
# +AE4983ZxcK2M00ctqSINlVmAo2Y0TonZP4F3e6/VAnmseGRAyjVA8721j5UMUWn
# GAJ0gJCso+vTwucKmPVoIEowFt/E/L3UuR0gl3dJNANCCcYG0Wm0PrutuCyHZEet
# xGdCQU1CfFlk804cplNxR4xFnz09tC+sT1mUiVeBL4Hmi07EEBsbIV7XbwYqF3Yt
# qcV5iLA23X1USyYkRF+Rt/mOlpulVzY/qV0uRb6D59STb7esX1Y6la8t+auMcwez
# 6mYIGIcLOR0znQ1T0PHesMGn8N3ZnLBQI4yon6FJuIr0Xu0+aJqJFrDH7bRIGgyd
# mn1ihWNI6FXFDlsF9VKfRQmKEDIGLVZP0UtHuWQZdgXvXKGCE08wghNLBgorBgEE
# AYI3AwMBMYITOzCCEzcGCSqGSIb3DQEHAqCCEygwghMkAgEDMQ8wDQYJYIZIAWUD
# BAICBQAwgfAGCyqGSIb3DQEJEAEEoIHgBIHdMIHaAgEBBgorBgEEAbIxAgEBMDEw
# DQYJYIZIAWUDBAIBBQAEIHxq37UMw/3+BC5Yx6fiOCFNOjxYXumN8XZLBal3D7Zk
# AhUArglmWG4E5SrxiUPkGj/iEbU/BYIYDzIwMjQwMzE4MTgyMzQzWqBupGwwajEL
# MAkGA1UEBhMCR0IxEzARBgNVBAgTCk1hbmNoZXN0ZXIxGDAWBgNVBAoTD1NlY3Rp
# Z28gTGltaXRlZDEsMCoGA1UEAwwjU2VjdGlnbyBSU0EgVGltZSBTdGFtcGluZyBT
# aWduZXIgIzSggg3pMIIG9TCCBN2gAwIBAgIQOUwl4XygbSeoZeI72R0i1DANBgkq
# hkiG9w0BAQwFADB9MQswCQYDVQQGEwJHQjEbMBkGA1UECBMSR3JlYXRlciBNYW5j
# aGVzdGVyMRAwDgYDVQQHEwdTYWxmb3JkMRgwFgYDVQQKEw9TZWN0aWdvIExpbWl0
# ZWQxJTAjBgNVBAMTHFNlY3RpZ28gUlNBIFRpbWUgU3RhbXBpbmcgQ0EwHhcNMjMw
# NTAzMDAwMDAwWhcNMzQwODAyMjM1OTU5WjBqMQswCQYDVQQGEwJHQjETMBEGA1UE
# CBMKTWFuY2hlc3RlcjEYMBYGA1UEChMPU2VjdGlnbyBMaW1pdGVkMSwwKgYDVQQD
# DCNTZWN0aWdvIFJTQSBUaW1lIFN0YW1waW5nIFNpZ25lciAjNDCCAiIwDQYJKoZI
# hvcNAQEBBQADggIPADCCAgoCggIBAKSTKFJLzyeHdqQpHJk4wOcO1NEc7GjLAWTk
# is13sHFlgryf/Iu7u5WY+yURjlqICWYRFFiyuiJb5vYy8V0twHqiDuDgVmTtoeWB
# IHIgZEFsx8MI+vN9Xe8hmsJ+1yzDuhGYHvzTIAhCs1+/f4hYMqsws9iMepZKGRNc
# rPznq+kcFi6wsDiVSs+FUKtnAyWhuzjpD2+pWpqRKBM1uR/zPeEkyGuxmegN77tN
# 5T2MVAOR0Pwtz1UzOHoJHAfRIuBjhqe+/dKDcxIUm5pMCUa9NLzhS1B7cuBb/Rm7
# HzxqGXtuuy1EKr48TMysigSTxleGoHM2K4GX+hubfoiH2FJ5if5udzfXu1Cf+hgl
# TxPyXnypsSBaKaujQod34PRMAkjdWKVTpqOg7RmWZRUpxe0zMCXmloOBmvZgZpBY
# B4DNQnWs+7SR0MXdAUBqtqgQ7vaNereeda/TpUsYoQyfV7BeJUeRdM11EtGcb+Re
# DZvsdSbu/tP1ki9ShejaRFEqoswAyodmQ6MbAO+itZadYq0nC/IbSsnDlEI3iCCE
# qIeuw7ojcnv4VO/4ayewhfWnQ4XYKzl021p3AtGk+vXNnD3MH65R0Hts2B0tEUJT
# cXTC5TWqLVIS2SXP8NPQkUMS1zJ9mGzjd0HI/x8kVO9urcY+VXvxXIc6ZPFgSwVP
# 77kv7AkTAgMBAAGjggGCMIIBfjAfBgNVHSMEGDAWgBQaofhhGSAPw0F3RSiO0TVf
# BhIEVTAdBgNVHQ4EFgQUAw8xyJEqk71j89FdTaQ0D9KVARgwDgYDVR0PAQH/BAQD
# AgbAMAwGA1UdEwEB/wQCMAAwFgYDVR0lAQH/BAwwCgYIKwYBBQUHAwgwSgYDVR0g
# BEMwQTA1BgwrBgEEAbIxAQIBAwgwJTAjBggrBgEFBQcCARYXaHR0cHM6Ly9zZWN0
# aWdvLmNvbS9DUFMwCAYGZ4EMAQQCMEQGA1UdHwQ9MDswOaA3oDWGM2h0dHA6Ly9j
# cmwuc2VjdGlnby5jb20vU2VjdGlnb1JTQVRpbWVTdGFtcGluZ0NBLmNybDB0Bggr
# BgEFBQcBAQRoMGYwPwYIKwYBBQUHMAKGM2h0dHA6Ly9jcnQuc2VjdGlnby5jb20v
# U2VjdGlnb1JTQVRpbWVTdGFtcGluZ0NBLmNydDAjBggrBgEFBQcwAYYXaHR0cDov
# L29jc3Auc2VjdGlnby5jb20wDQYJKoZIhvcNAQEMBQADggIBAEybZVj64HnP7xXD
# Mm3eM5Hrd1ji673LSjx13n6UbcMixwSV32VpYRMM9gye9YkgXsGHxwMkysel8Cbf
# +PgxZQ3g621RV6aMhFIIRhwqwt7y2opF87739i7Efu347Wi/elZI6WHlmjl3vL66
# kWSIdf9dhRY0J9Ipy//tLdr/vpMM7G2iDczD8W69IZEaIwBSrZfUYngqhHmo1z2s
# IY9wwyR5OpfxDaOjW1PYqwC6WPs1gE9fKHFsGV7Cg3KQruDG2PKZ++q0kmV8B3w1
# RB2tWBhrYvvebMQKqWzTIUZw3C+NdUwjwkHQepY7w0vdzZImdHZcN6CaJJ5OX07T
# jw/lE09ZRGVLQ2TPSPhnZ7lNv8wNsTow0KE9SK16ZeTs3+AB8LMqSjmswaT5qX01
# 0DJAoLEZKhghssh9BXEaSyc2quCYHIN158d+S4RDzUP7kJd2KhKsQMFwW5kKQPqA
# bZRhe8huuchnZyRcUI0BIN4H9wHU+C4RzZ2D5fjKJRxEPSflsIZHKgsbhHZ9e2hP
# jbf3E7TtoC3ucw/ZELqdmSx813UfjxDElOZ+JOWVSoiMJ9aFZh35rmR2kehI/shV
# Cu0pwx/eOKbAFPsyPfipg2I2yMO+AIccq/pKQhyJA9z1XHxw2V14Tu6fXiDmCWp8
# KwijSPUV/ARP380hHHrl9Y4a1LlAMIIG7DCCBNSgAwIBAgIQMA9vrN1mmHR8qUY2
# p3gtuTANBgkqhkiG9w0BAQwFADCBiDELMAkGA1UEBhMCVVMxEzARBgNVBAgTCk5l
# dyBKZXJzZXkxFDASBgNVBAcTC0plcnNleSBDaXR5MR4wHAYDVQQKExVUaGUgVVNF
# UlRSVVNUIE5ldHdvcmsxLjAsBgNVBAMTJVVTRVJUcnVzdCBSU0EgQ2VydGlmaWNh
# dGlvbiBBdXRob3JpdHkwHhcNMTkwNTAyMDAwMDAwWhcNMzgwMTE4MjM1OTU5WjB9
# MQswCQYDVQQGEwJHQjEbMBkGA1UECBMSR3JlYXRlciBNYW5jaGVzdGVyMRAwDgYD
# VQQHEwdTYWxmb3JkMRgwFgYDVQQKEw9TZWN0aWdvIExpbWl0ZWQxJTAjBgNVBAMT
# HFNlY3RpZ28gUlNBIFRpbWUgU3RhbXBpbmcgQ0EwggIiMA0GCSqGSIb3DQEBAQUA
# A4ICDwAwggIKAoICAQDIGwGv2Sx+iJl9AZg/IJC9nIAhVJO5z6A+U++zWsB21hoE
# pc5Hg7XrxMxJNMvzRWW5+adkFiYJ+9UyUnkuyWPCE5u2hj8BBZJmbyGr1XEQeYf0
# RirNxFrJ29ddSU1yVg/cyeNTmDoqHvzOWEnTv/M5u7mkI0Ks0BXDf56iXNc48Ray
# cNOjxN+zxXKsLgp3/A2UUrf8H5VzJD0BKLwPDU+zkQGObp0ndVXRFzs0IXuXAZSv
# f4DP0REKV4TJf1bgvUacgr6Unb+0ILBgfrhN9Q0/29DqhYyKVnHRLZRMyIw80xSi
# nL0m/9NTIMdgaZtYClT0Bef9Maz5yIUXx7gpGaQpL0bj3duRX58/Nj4OMGcrRrc1
# r5a+2kxgzKi7nw0U1BjEMJh0giHPYla1IXMSHv2qyghYh3ekFesZVf/QOVQtJu5F
# GjpvzdeE8NfwKMVPZIMC1Pvi3vG8Aij0bdonigbSlofe6GsO8Ft96XZpkyAcSpcs
# dxkrk5WYnJee647BeFbGRCXfBhKaBi2fA179g6JTZ8qx+o2hZMmIklnLqEbAyfKm
# /31X2xJ2+opBJNQb/HKlFKLUrUMcpEmLQTkUAx4p+hulIq6lw02C0I3aa7fb9xhA
# V3PwcaP7Sn1FNsH3jYL6uckNU4B9+rY5WDLvbxhQiddPnTO9GrWdod6VQXqngwID
# AQABo4IBWjCCAVYwHwYDVR0jBBgwFoAUU3m/WqorSs9UgOHYm8Cd8rIDZsswHQYD
# VR0OBBYEFBqh+GEZIA/DQXdFKI7RNV8GEgRVMA4GA1UdDwEB/wQEAwIBhjASBgNV
# HRMBAf8ECDAGAQH/AgEAMBMGA1UdJQQMMAoGCCsGAQUFBwMIMBEGA1UdIAQKMAgw
# BgYEVR0gADBQBgNVHR8ESTBHMEWgQ6BBhj9odHRwOi8vY3JsLnVzZXJ0cnVzdC5j
# b20vVVNFUlRydXN0UlNBQ2VydGlmaWNhdGlvbkF1dGhvcml0eS5jcmwwdgYIKwYB
# BQUHAQEEajBoMD8GCCsGAQUFBzAChjNodHRwOi8vY3J0LnVzZXJ0cnVzdC5jb20v
# VVNFUlRydXN0UlNBQWRkVHJ1c3RDQS5jcnQwJQYIKwYBBQUHMAGGGWh0dHA6Ly9v
# Y3NwLnVzZXJ0cnVzdC5jb20wDQYJKoZIhvcNAQEMBQADggIBAG1UgaUzXRbhtVOB
# kXXfA3oyCy0lhBGysNsqfSoF9bw7J/RaoLlJWZApbGHLtVDb4n35nwDvQMOt0+Lk
# VvlYQc/xQuUQff+wdB+PxlwJ+TNe6qAcJlhc87QRD9XVw+K81Vh4v0h24URnbY+w
# QxAPjeT5OGK/EwHFhaNMxcyyUzCVpNb0llYIuM1cfwGWvnJSajtCN3wWeDmTk5Sb
# sdyybUFtZ83Jb5A9f0VywRsj1sJVhGbks8VmBvbz1kteraMrQoohkv6ob1olcGKB
# c2NeoLvY3NdK0z2vgwY4Eh0khy3k/ALWPncEvAQ2ted3y5wujSMYuaPCRx3wXdah
# c1cFaJqnyTdlHb7qvNhCg0MFpYumCf/RoZSmTqo9CfUFbLfSZFrYKiLCS53xOV5M
# 3kg9mzSWmglfjv33sVKRzj+J9hyhtal1H3G/W0NdZT1QgW6r8NDT/LKzH7aZlib0
# PHmLXGTMze4nmuWgwAxyh8FuTVrTHurwROYybxzrF06Uw3hlIDsPQaof6aFBnf6x
# uKBlKjTg3qj5PObBMLvAoGMs/FwWAKjQxH/qEZ0eBsambTJdtDgJK0kHqv3sMNrx
# py/Pt/360KOE2See+wFmd7lWEOEgbsausfm2usg1XTN2jvF8IAwqd661ogKGuinu
# tFoAsYyr4/kKyVRd1LlqdJ69SK6YMYIELDCCBCgCAQEwgZEwfTELMAkGA1UEBhMC
# R0IxGzAZBgNVBAgTEkdyZWF0ZXIgTWFuY2hlc3RlcjEQMA4GA1UEBxMHU2FsZm9y
# ZDEYMBYGA1UEChMPU2VjdGlnbyBMaW1pdGVkMSUwIwYDVQQDExxTZWN0aWdvIFJT
# QSBUaW1lIFN0YW1waW5nIENBAhA5TCXhfKBtJ6hl4jvZHSLUMA0GCWCGSAFlAwQC
# AgUAoIIBazAaBgkqhkiG9w0BCQMxDQYLKoZIhvcNAQkQAQQwHAYJKoZIhvcNAQkF
# MQ8XDTI0MDMxODE4MjM0M1owPwYJKoZIhvcNAQkEMTIEMAj3PiCMC7pDoMxc7KdB
# PVtosz9d/7DG42DfOr0gU5T2Cykx8wg+VvTst5FVsVZP6DCB7QYLKoZIhvcNAQkQ
# Agwxgd0wgdowgdcwFgQUrmKvdQoMvUfWRh91aOK8jOfKT5QwgbwEFALWW5Xig3DB
# VwCV+oj5I92Tf62PMIGjMIGOpIGLMIGIMQswCQYDVQQGEwJVUzETMBEGA1UECBMK
# TmV3IEplcnNleTEUMBIGA1UEBxMLSmVyc2V5IENpdHkxHjAcBgNVBAoTFVRoZSBV
# U0VSVFJVU1QgTmV0d29yazEuMCwGA1UEAxMlVVNFUlRydXN0IFJTQSBDZXJ0aWZp
# Y2F0aW9uIEF1dGhvcml0eQIQMA9vrN1mmHR8qUY2p3gtuTANBgkqhkiG9w0BAQEF
# AASCAgBNcoorR6iJElYUedt8AD6c8zWx9ysHTanvK+aL4PJCQ9tLNufYzs3yAo/X
# Jm61eOyM/rDDjO6L1E1OAJUJLMCXhWmlyBx4B7vyAELrSJXNJDJLAi46OottIXkn
# UPCtWOFC1uMWB0LS/M5Er1XquxTXt2I2pIL+Za30oMJrZ4kWgmio1rELFrRHFZYF
# bTrGIzx/YSbUhx2L+g9nmZ9vUACkxjjjhtNkAKUKpXq38vtcoAQLac9KGRLECied
# bHn5L0anatXSrt7o+1ezUG83YtAUGmsF641dUmhZVALsrD4u4Nrff5fEiv+KBe0h
# o5bApXDw/Mc5FLq6hwaGVPPu5Tiy3uxREwumB6Lw8wkp2v4kj/porxp+20el5gfo
# xUjD1Rhssj4Q49dDAVjOK0F+7FNVAMo7XYkm5Nt8FT4FNITVygAIgSmXy+T8o4jx
# 5p5Qf4sKkJ3G+EZ/lU493m5jveeSdEVB0IvAnC0eR5qQIZp7OFzMTqBLlhlloJsh
# 79pJELuqkZ/YS/22I6T6nv+bepb/lrJWL5FRUDO/TOMYnYLrfIuSBmlkD60t66xE
# hK4WJxQVAnDWKRhenbTsgahA/CkjfpJgvReUkx1+uAniVUIpcBZ1TJ5S8EizQHeL
# nrU9rSzIap7harYHHf1N5cg+p2zJorIA7n5ZzvnLDz1xE3esVg==
# SIG # End signature block
