/**************************************************************************

Copyright (c) 2014 - 2020, Intel Corporation. All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

    * Redistributions of source code must retain the above copyright notice,
      this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.
    * Neither the name of Intel Corporation nor the names of its contributors
      may be used to endorse or promote products derived from this software
      without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

***************************************************************************/
#include <wol.h>

#define FVL_AUTOGEN_PTR_PFPM_APM_SECTION  0x1
#define FVL_AUTOGEN_PTR_PFPM_APM_OFFSET   0x2
#define SOFTWARE_RESERVED_WORD_2          I40E_SR_NVM_WAKE_ON_LAN
#define SR_AUTO_GENERATED_POINTERS_PTR    I40E_SR_AUTO_GENERATED_POINTERS_PTR
#define AUTOGEN_PTR_PFPM_APM_SECTION      FVL_AUTOGEN_PTR_PFPM_APM_SECTION
#define AUTOGEN_PTR_PFPM_APM_OFFSET       FVL_AUTOGEN_PTR_PFPM_APM_OFFSET

static UINT16 _WolGetFVLRegisterInitializationDataOffset(
  IN  WOL_ADAPTER_HANDLE_TYPE Handle,
  IN  UINT16                  ModulePointer,
  IN  UINT32                  OffsetWithinModulePointer
) {
  UINT16     ModuleOffset = 0;
  UINT16     OffsetWithinModule = 0;
  WOL_STATUS Status = WOL_SUCCESS;




  UINT16     AutoGeneratedSectionPointer = 0;
  /* Read pointer to the auto generated pointers section */
  Status = _WolEepromRead16(
             Handle,
             SR_AUTO_GENERATED_POINTERS_PTR,
             &AutoGeneratedSectionPointer
             );
  if (Status != WOL_SUCCESS)
  {
    return 0;
  }
  
  /* Read Nvm Module offset in SR */
  Status = _WolEepromRead16(
             Handle,
             AutoGeneratedSectionPointer + ModulePointer,
             &ModuleOffset
             );
  if (Status != WOL_SUCCESS)
  {
    return 0;
  }

  /* Read the length of the module */
  Status = _WolEepromRead16 (
             Handle,
             AutoGeneratedSectionPointer + OffsetWithinModulePointer,
             &OffsetWithinModule
             );
  if (Status != WOL_SUCCESS)
  {
    return 0;
  }


  if ((ModuleOffset == 0x7FFF) || (ModuleOffset == 0xFFFF))
  {
    return 0;
  }

  if (OffsetWithinModule == 0x0000)
  {
    return 0;
  }

  return ModuleOffset + OffsetWithinModule;

}

WOL_STATUS
_WolGetOffsetBitmask_40GBE (
  IN    WOL_ADAPTER_HANDLE_TYPE  Handle,
  OUT   UINT16                   *Offset,
  OUT   UINT16                   *Bitmask
)
{

  UINT8 FunctionNumber;
#ifndef WOL_HAF
  DEBUGPRINT (WOL, ("-->_WolGetOffsetBitmask_40GBE\n"));
#endif
  if (Handle == NULL)
  {
    return WOL_FEATURE_NOT_SUPPORTED;
  }

  FunctionNumber = _WolGetFunction(Handle);
#ifndef WOL_HAF
  DEBUGPRINT (WOL, ("Function numb: %d\n", FunctionNumber));
#endif
  if (FunctionNumber > 15)
  {
    return WOL_FEATURE_NOT_SUPPORTED;
  }

  /* EEPROM Control Word 3 */
  *Offset = _WolGetFVLRegisterInitializationDataOffset(
                                      Handle,
                                      AUTOGEN_PTR_PFPM_APM_SECTION,
                                      AUTOGEN_PTR_PFPM_APM_OFFSET
                                      );

  if (*Offset == 0)
  {
    return WOL_FEATURE_NOT_SUPPORTED;
  }

#ifndef WOL_HAF
  DEBUGPRINT (WOL, ("GetOffsetBitmask fun: %d, offset: %x", FunctionNumber, *Offset));
#endif

  /* return offset based on _PF */
  /* skip attributes word and get offset for PF */
  *Offset = *Offset + 2 * FunctionNumber;

  /* PFPM_APM.APME - APM Enable Bit 0 */
  *Bitmask = 0x0001;

  return WOL_SUCCESS;
}

BOOLEAN _WolGetInfoFromEeprom_40G(WOL_ADAPTER_HANDLE_TYPE Handle)
{
  UINT16      WolSupportMask = 0;
  WOL_STATUS  Status;
  UINT8       LanPort;
  UINT8       WolSupport;

  Status = _WolEepromRead16(Handle,
                            SOFTWARE_RESERVED_WORD_2,
                            &WolSupportMask);

  if (Status != WOL_SUCCESS)
  {
#ifndef WOL_HAF
    DEBUGPRINT (WOL, ("Read Eeprom failed \n"));
#endif
    return FALSE;
  }
  else
  {
    LanPort = _WolGetLanPort(Handle);

    /* WolSupportMask: 1b = unsupported, 0b = supported */
    WolSupport = ((~WolSupportMask) & (1 << LanPort));

#ifndef WOL_HAF
    DEBUGPRINT(WOL, ("SW rsv word 2: %x LanPort: %d WolSupport: %d\n", WolSupportMask, LanPort, WolSupport));
#endif
    return (BOOLEAN)WolSupport;
  }
}

