/*
 * Decompiled with CFR 0.152.
 */
package pdtEditor;

import binTools.BinReader;
import binTools.BinWriter;
import binTools.Common;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import pdtEditor.BoardDescriptionTable;

public class CustomDataEntryTable
extends BoardDescriptionTable {
    public static final int BDT_TYPE = 4;
    public static final int BINARY_DATA_MAX_SIZE = 1024;
    private byte[] customDataEntry = null;

    public byte[] getCustomDataEntry() {
        return this.customDataEntry;
    }

    public void setCustomDataEntry(byte[] dataEntry) {
        this.customDataEntry = dataEntry;
    }

    public CustomDataEntryTable() {
        this.setType(4);
    }

    public CustomDataEntryTable(BinReader reader, Element payloadXmlNode) throws Exception {
        this.setType(4);
    }

    public CustomDataEntryTable(BinReader reader, Element payloadXmlNode, int length) {
        this.setType(4);
        this.customDataEntry = reader.readBytes(length, "CustomDataEntry", payloadXmlNode);
    }

    @Override
    public void writeToPdt(BinWriter writer, Element parent) {
        if (this.customDataEntry != null && this.customDataEntry.length > 0) {
            writer.writeNewField("Type", 1, this.getType(), (Node)parent);
            Common.Field lengthField = writer.writeNewField("Length", 2, 0, (Node)parent);
            writer.addSizeCounter(lengthField);
            if (this.customDataEntry != null && this.customDataEntry.length > 0) {
                writer.writerBinaryField("CustomDataEntry", this.customDataEntry, parent);
            }
            writer.removeSizeCounter(lengthField);
        }
    }
}

