<?php
class SSDAdapter extends Device {

    private $ecc_power;
    private $flash_id;
    private $max_async_timing_mode;
    private $max_sync_timing_mode;
    private $model_name;
    private $nand_type;
    private $nr_au_per_weru;
    private $nr_bad_blocks_max;
    private $nr_dev;
    private $nr_lun;
    private $nr_page_per_block;
    private $nr_plane;
    private $nr_total_defect;
    private $nr_weru;
    private $oem_id;
    private $page_sz;
    private $pci_speed;
    private $pci_width;
    private $sector_size;
    private $serial_num;
    private $size;
    private $spare_sz;
    private $timing_mode;
    private $total_space_in_gbit;

    private $max_partitions;
    private $num_partitions;
    private $features;
    private $nr_channel;
    private $endurance;
    private $bit_per_cell;
    private $FirmwareVersion;
    private $NeedReboot;

    public function isSAS() {
        return false;
    }

    public function needReboot() {
        return $this->NeedReboot;
    }

    public function getFirmwareVersion() {
        return $this->FirmwareVersion;
    }
    public function get_max_partitions() {
        return $this->max_partitions;
    }
    public function get_num_partitions() {
        return $this->num_partitions;
    }
    public function get_features() {
        return $this->features;
    }
    public function get_nr_channel() {
        return $this->nr_channel;
    }
    public function get_endurance() {
        return $this->endurance;
    }
    public function get_bit_per_cell() {
        return $this->bit_per_cell;
    }

    public function get_ecc_power() {
        return $this->ecc_power;
    }
    public function set_ecc_power($ecc_power) {
        $this->ecc_power = $ecc_power;
    }

    public function get_flash_id() {
        $i = 0;
        $tok = strtok($this->flash_id, " ");

        while ($tok !== false) {
            $arr[$i] = $tok;
            $i++;
            $tok = strtok(" ");
        }
        return sprintf("%02X%02X%02X%02X%02X", $arr[0], $arr[1], $arr[2], $arr[3], $arr[4]);
    }
    public function set_flash_id($flash_id) {
        $this->flash_id = $flash_id;
    }

    public function get_max_async_timing_mode() {
        return $this->max_async_timing_mode;
    }
    public function set_max_async_timing_mode($max_async_timing_mode) {
        $this->max_async_timing_mode = $max_async_timing_mode;
    }

    public function get_max_sync_timing_mode() {
        return $this->max_sync_timing_mode;
    }
    public function set_max_sync_timing_mode($max_sync_timing_mode) {
        $this->max_sync_timing_mode = $max_sync_timing_mode;
    }

    public function get_model_name() {
        return $this->model_name;
    }
    public function set_model_name($model_name) {
        $this->model_name = $model_name;
    }

    public function get_nand_type() {
        return $this->nand_type;
    }
    public function set_nand_type($nand_type) {
        $this->nand_type = $nand_type;
    }

    public function get_nr_au_per_weru() {
        return $this->nr_au_per_weru;
    }
    public function set_nr_au_per_weru($nr_au_per_weru) {
        $this->nr_au_per_weru = $nr_au_per_weru;
    }

    public function get_nr_bad_blocks_max() {
        return $this->nr_bad_blocks_max;
    }
    public function set_nr_bad_blocks_max($nr_bad_blocks_max) {
        $this->nr_bad_blocks_max = $nr_bad_blocks_max;
    }

    public function get_nr_dev() {
        return $this->nr_dev;
    }
    public function set_nr_dev($nr_dev) {
        $this->nr_dev = $nr_dev;
    }

    public function get_nr_lun() {
        return $this->nr_lun;
    }
    public function set_nr_lun($nr_lun) {
        $this->nr_lun = $nr_lun;
    }

    public function get_nr_page_per_block() {
        return $this->nr_page_per_block;
    }
    public function set_nr_page_per_block($nr_page_per_block) {
        $this->nr_page_per_block = $nr_page_per_block;
    }

    public function get_nr_plane() {
        return $this->nr_plane;
    }
    public function set_nr_plane($nr_plane) {
        $this->nr_plane = $nr_plane;
    }

    public function get_nr_total_defect() {
        return $this->nr_total_defect;
    }
    public function set_nr_total_defect($nr_total_defect) {
        $this->nr_total_defect = $nr_total_defect;
    }

    public function get_nr_weru() {
        return $this->nr_weru;
    }
    public function set_nr_weru($nr_weru) {
        $this->nr_weru = $nr_weru;
    }

    public function get_oem_id() {
        return $this->oem_id;
    }
    public function set_oem_id($oem_id) {
        $this->oem_id = $oem_id;
    }

    public function get_page_sz() {
        return $this->page_sz;
    }
    public function set_page_sz($page_sz) {
        $this->page_sz = $page_sz;
    }

    public function get_pci_speed() {
        return $this->pci_speed;
    }
    public function set_pci_speed($pci_speed) {
        $this->pci_speed = $pci_speed;
    }

    public function get_pci_width() {
        return $this->pci_width;
    }
    public function set_pci_width($pci_width) {
        $this->pci_width = $pci_width;
    }

    public function get_sector_size() {
        return $this->sector_size;
    }
    public function set_sector_size($sector_size) {
        $this->sector_size = $sector_size;
    }

    public function get_serial_num() {
        return $this->serial_num;
    }
    public function set_serial_num($serial_num) {
        $this->serial_num = $serial_num;
    }

    public function get_size() {
        return $this->size;
    }
    public function set_size($size) {
        $this->size = $size;
    }

    public function get_spare_sz() {
        return $this->spare_sz;
    }
    public function set_spare_sz($spare_sz) {
        $this->spare_sz = $spare_sz;
    }

    public function get_timing_mode() {
        return $this->timing_mode;
    }
    public function set_timing_mode($timing_mode) {
        $this->timing_mode = $timing_mode;
    }

    public function get_total_space_in_gbit() {
        return $this->total_space_in_gbit;
    }
    public function set_total_space_in_gbit($total_space_in_gbit) {
        $this->total_space_in_gbit = $total_space_in_gbit;
    }

    public function setSSDAdapterInfo($info) {

        if(isset($info->oem_id)) {
            $this->oem_id=strtoupper(trim($info->oem_id));
        }

        if(isset($info->serial_num)) {
            $this->serial_num=trim($info->serial_num);
        }

        if(isset($info->size)) {
            $this->size=trim($info->size);
        }

        if(isset($info->max_partitions)) {
            $this->max_partitions=trim($info->max_partitions);
        }

        if(isset($info->num_partitions)) {
            $this->num_partitions=trim($info->num_partitions);
        }

        if(isset($info->features)) {
            $this->features=trim($info->features);
        }

        if(isset($info->nr_dev)) {
            $this->nr_dev=trim($info->nr_dev);
        }

        if(isset($info->pci_speed)) {
            $this->pci_speed=trim($info->pci_speed);
        }

        if(isset($info->pci_width)) {
            $this->pci_width=trim($info->pci_width);
        }

        if(isset($info->model_name)) {
            $this->model_name=trim($info->model_name);
        }

        if(isset($info->nr_channel)) {
            $this->nr_channel=trim($info->nr_channel);
        }

        if(isset($info->flash_id)) {
            $this->flash_id=trim($info->flash_id);
        }

        if(isset($info->nand_type)) {
            $this->nand_type=trim($info->nand_type);
        }

        if(isset($info->timing_mode)) {
            $this->timing_mode=trim($info->timing_mode);
        }

        if(isset($info->max_async_timing_mode)) {
            $this->max_async_timing_mode=trim($info->max_async_timing_mode);
        }

        if(isset($info->max_sync_timing_mode)) {
            $this->max_sync_timing_mode=trim($info->max_sync_timing_mode);
        }

        if(isset($info->ecc_power)) {
            $this->ecc_power=trim($info->ecc_power);
        }

        if(isset($info->nr_page_per_block)) {
            $this->nr_page_per_block=trim($info->nr_page_per_block);
        }

        if(isset($info->spare_sz)) {
            $this->spare_sz=trim($info->spare_sz);
        }

        if(isset($info->page_sz)) {
            $this->page_sz=trim($info->page_sz);
        }

        if(isset($info->nr_lun)) {
            $this->nr_lun=trim($info->nr_lun);
        }

        if(isset($info->nr_bad_blocks_max)) {
            $this->nr_bad_blocks_max=trim($info->nr_bad_blocks_max);
        }

        if(isset($info->nr_au_per_weru)) {
            $this->nr_au_per_weru=trim($info->nr_au_per_weru);
        }

        if(isset($info->nr_plane)) {
            $this->nr_plane=trim($info->nr_plane);
        }

        if(isset($info->nr_total_defect)) {
            $this->nr_total_defect=trim($info->nr_total_defect);
        }

        if(isset($info->nr_weru)) {
            $this->nr_weru=trim($info->nr_weru);
        }

        if(isset($info->sector_size)) {
            $this->sector_size=trim($info->sector_size);
        }

        if(isset($info->total_space_in_gbit)) {
            $this->total_space_in_gbit=trim($info->total_space_in_gbit);
        }

        if(isset($info->endurance)) {
            $this->endurance=trim($info->endurance);
        }

        if(isset($info->bit_per_cell)) {
            $this->bit_per_cell=trim($info->bit_per_cell);
        }
        
        if(isset($info->NeedReboot)) {
            $this->NeedReboot=trim($info->NeedReboot);
        }

        foreach ($info->FWVersion as $Version) {
            $this->setFirmwareVersion($Version);
        }

    }

    private function setFirmwareVersion($Version) {
        $this->FirmwareVersion =
                $Version->VerMajor . "."
                . $Version->VerMinor . "."
                . $Version->VerOEM . "."
                . $this->getBuildVersion($Version->VerBuild);
    }
    
    private function getBuildVersion($version) {
        return sprintf("%04d", intval($version));
    }
}
?>