//
//  hwInterfaceWin.h
//  SimpleDriver
//
//  Created by Egor Pomozov on 07.12.14.
//  Copyright (c) 2014 Aquantia Corp. All rights reserved.
//
//  OS X-specific parts split from SimpleControl.h
//

#ifndef hwInterfaceWin_
#define hwInterfaceWin_

//#define WIN32_LEAN_AND_MEAN             // Exclude rarely-used stuff from Windows headers
// Windows Header Files:
#include <windows.h>

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <tchar.h>
#include <stdarg.h>
#include <stdint.h>

#include <strsafe.h>  // for safe string functions

#if defined(_DEBUG)
/* Use debug wrappers with the Python release dll */
# undef _DEBUG
# include <Python.h>
# define _DEBUG
#else
#include <Python.h>
#endif

#ifdef _WIN32
// The function Py_DECREF uses while (0), which causes warning C4127:
// conditional expression is constant (Python2.7, Visual Studio 2013)
#pragma warning (disable : 4127)
#endif

#ifndef boolean_t
#define boolean_t BOOL
#endif

#ifndef void_t
#define void_t VOID
#endif

#define LODWORD(x) (((uint32_t *)&x)[0])
#define HIDWORD(x) (((uint32_t *)&x)[1])

#define STRING_COPY(var,size,msg) StringCchCopyA(var,size,msg)
// StringCchPrintfA( HW_ErrorMessage, ERROR_MESSAGE_SIZE, "Failed to initialize driver in HW_Initialize() 0x%08X", hr);
#define STRING_PRINTF(var,size,msg,...) StringCchPrintfA(var,size,msg,__VA_ARGS__)
#ifdef __MINGW32__
    #define FUNCTION_NAME __FUNCTION__
#else
    #define FUNCTION_NAME ""__FUNCTION__""
#endif

// TODO: reference additional headers your program requires here
#endif
