/*
 * Decompiled with CFR 0.152.
 */
package pdtEditor.payloads.configurations;

import binTools.BinReader;
import binTools.BinWriter;
import binTools.Common;
import java.util.ArrayList;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import pdtEditor.Sensor;
import pdtEditor.exceptions.FeatureNotSupportedYetException;
import pdtEditor.payloads.configurations.ConfigurationPayload;
import pdtEditor.validation.Validator;

public class DynamicSarConfigurationPayload
extends ConfigurationPayload {
    public static final int CONFIGURATION_TYPE = 107;
    public static final int NOT_AVAILABLE_VALUE = -1;
    public static final String NOT_AVAILABLE_TEXT = "Not Available";
    public static final String CALIBRATION_FORMAT_STRING = "Dynamic Sar Configuration";
    public static final String DYNAMIC_SAR_ANT_POS_TOP_STRING = "Top";
    public static final String DYNAMIC_SAR_ANT_POS_SIDE_STRING = "Side";
    public static final String DYNAMIC_SAR_ANT_POS_HINGE_STRING = "Hinge";
    public static final String DYNAMIC_SAR_ANT_POS_BASE_STRING = "Base";
    public static final int DYNAMIC_SAR_ANT_POS_TOP_VALUE = 0;
    public static final int DYNAMIC_SAR_ANT_POS_SIDE_VALUE = 1;
    public static final int DYNAMIC_SAR_ANT_POS_HINGE_VALUE = 2;
    public static final int DYNAMIC_SAR_ANT_POS_BASE_VALUE = 3;
    public static final int DYNAMIC_SAR_ANT_POS_NOT_SELECT_VALUE = 255;
    public static final String DYNAMIC_SAR_DMD_STATUS_MOTIONLESS_STRING = "On Table";
    public static final String DYNAMIC_SAR_DMD_STATUS_MOTION_STRING = "Not On Table";
    public static final String DYNAMIC_SAR_DMD_STATUS_NOT_CARE_STRING = "Not Care";
    public static final int DYNAMIC_SAR_DMD_STATUS_MOTIONLESS_VALUE = 0;
    public static final int DYNAMIC_SAR_DMD_STATUS_MOTION_VALUE = 1;
    public static final int DYNAMIC_SAR_DMD_STATUS_NOT_CARE_VALUE = 255;
    private static final int LATEST_FORMAT_ID = 0;
    public static final int POSITION_FIELD_SIZE = 1;
    public static final int CONDITION_NUMBER_FIELD_SIZE = 1;
    public static final int PLM_MODE_ID_FIELD_SIZE = 4;
    public static final int DMD_STATUS_FIELD_SIZE = 1;
    public static final int INDEX_FIELD_SIZE = 1;
    public static final int MIN_ROWS_IN_CONF_TABLE = 1;
    public static final int MAX_ROWS_IN_CONF_TABLE = 15;
    private int _formatID = 0;
    private int _version;
    private AntennaConfig antennaAConfig = new AntennaConfig();
    private AntennaConfig antennaBConfig = new AntennaConfig();

    public AntennaConfig getAntennaAConfig() {
        return this.antennaAConfig;
    }

    public void setAntennaAConfig(AntennaConfig antennaAConfig) {
        this.antennaAConfig = antennaAConfig;
    }

    public AntennaConfig getAntennaBConfig() {
        return this.antennaBConfig;
    }

    public void setAntennaBConfig(AntennaConfig antennaBConfig) {
        this.antennaBConfig = antennaBConfig;
    }

    public DynamicSarConfigurationPayload() {
        this.antennaAConfig.conditionList = new ArrayList();
        this.antennaBConfig.conditionList = new ArrayList();
    }

    public DynamicSarConfigurationPayload(DynamicSarConfigurationPayload src) {
        ConditionTable newCondition;
        this.antennaAConfig.conditionList = new ArrayList();
        this.antennaBConfig.conditionList = new ArrayList();
        this.antennaAConfig.postion = src.getAntennaAConfig().postion;
        this.antennaBConfig.postion = src.getAntennaBConfig().postion;
        for (ConditionTable condition : src.getAntennaAConfig().conditionList) {
            newCondition = new ConditionTable();
            newCondition.plmModeId = condition.plmModeId;
            newCondition.dmdStatus = condition.dmdStatus;
            newCondition.indexNumber = condition.indexNumber;
            this.antennaAConfig.conditionList.add(newCondition);
        }
        for (ConditionTable condition : src.getAntennaBConfig().conditionList) {
            newCondition = new ConditionTable();
            newCondition.plmModeId = condition.plmModeId;
            newCondition.dmdStatus = condition.dmdStatus;
            newCondition.indexNumber = condition.indexNumber;
            this.antennaBConfig.conditionList.add(newCondition);
        }
    }

    public DynamicSarConfigurationPayload(int formatId, BinReader reader, Node payloadXmlNode) throws FeatureNotSupportedYetException {
        super(payloadXmlNode);
        this._formatID = formatId;
        if (this._formatID > 0) {
            throw new FeatureNotSupportedYetException(this);
        }
        this._version = reader.readNewField((String)"Version", (int)1, (boolean)false, (Node)payloadXmlNode).value;
        Element configurationElement = reader.readNewField((String)"DynamicSarConfiguration", (Node)payloadXmlNode).xmlElement;
        Element AntennaAElement = reader.readNewField((String)"AntennaA", (Node)configurationElement).xmlElement;
        this.antennaAConfig.postion = reader.readNewField((String)"Position", (int)1, (boolean)false, (Node)AntennaAElement).value;
        int antennaAConditionNumber = reader.readNewField((String)"ConditionNumber", (int)1, (boolean)false, (Node)AntennaAElement).value;
        this.antennaAConfig.conditionList = new ArrayList();
        for (int i = 0; i < antennaAConditionNumber; ++i) {
            Element aConditionElement = reader.readNewField((String)"ConditionRow", (Node)AntennaAElement).xmlElement;
            ConditionTable addCondition = new ConditionTable();
            addCondition.plmModeId = reader.readNewField((String)"PlmModeID", (int)4, (boolean)false, (Node)aConditionElement).value;
            addCondition.dmdStatus = reader.readNewField((String)"DmdStatus", (int)1, (boolean)false, (Node)aConditionElement).value;
            addCondition.indexNumber = reader.readNewField((String)"Index", (int)1, (boolean)false, (Node)aConditionElement).value;
            this.antennaAConfig.conditionList.add(addCondition);
        }
        Element AntennaBElement = reader.readNewField((String)"AntennaB", (Node)configurationElement).xmlElement;
        this.antennaBConfig.postion = reader.readNewField((String)"Position", (int)1, (boolean)false, (Node)AntennaBElement).value;
        int antennaBConditionNumber = reader.readNewField((String)"ConditionNumber", (int)1, (boolean)false, (Node)AntennaBElement).value;
        this.antennaBConfig.conditionList = new ArrayList();
        for (int i = 0; i < antennaBConditionNumber; ++i) {
            Element bConditionElement = reader.readNewField((String)"ConditionRow", (Node)AntennaBElement).xmlElement;
            ConditionTable addCondition = new ConditionTable();
            addCondition.plmModeId = reader.readNewField((String)"PlmModeID", (int)4, (boolean)false, (Node)bConditionElement).value;
            addCondition.dmdStatus = reader.readNewField((String)"DmdStatus", (int)1, (boolean)false, (Node)bConditionElement).value;
            addCondition.indexNumber = reader.readNewField((String)"Index", (int)1, (boolean)false, (Node)bConditionElement).value;
            this.antennaBConfig.conditionList.add(addCondition);
        }
    }

    @Override
    public void writeToPdt(BinWriter writer, Element parent) {
        super.writeToPdt(writer, parent);
        Common.Field payloadDataLength = writer.writeNewField("DataLength", 2, 0, (Node)parent);
        writer.addSizeCounter(payloadDataLength);
        writer.writeNewField("FormatId", 1, this._formatID, (Node)parent);
        writer.writeNewField("Version", 1, this._version, (Node)parent);
        Element rootElement = writer.writeNewField((String)"DynamicSarConfiguration", (Node)parent).xmlElement;
        Element AntennaAElement = writer.writeNewField((String)"AntennaA", (Node)rootElement).xmlElement;
        writer.writeNewField("Position", 1, this.antennaAConfig.postion, (Node)AntennaAElement);
        writer.writeNewField("ConditionNumber", 1, this.antennaAConfig.conditionList.size(), (Node)AntennaAElement);
        for (int i = 0; i < this.antennaAConfig.conditionList.size(); ++i) {
            ConditionTable condition = this.antennaAConfig.conditionList.get(i);
            Element conditionElement = writer.writeNewField((String)"ConditionRow", (Node)AntennaAElement).xmlElement;
            writer.writeNewField("PlmModeID", 4, condition.plmModeId, (Node)conditionElement);
            writer.writeNewField("DmdStatus", 1, condition.dmdStatus, (Node)conditionElement);
            writer.writeNewField("Index", 1, condition.indexNumber, (Node)conditionElement);
        }
        Element AntennaBElement = writer.writeNewField((String)"AntennaB", (Node)rootElement).xmlElement;
        writer.writeNewField("Position", 1, this.antennaBConfig.postion, (Node)AntennaBElement);
        writer.writeNewField("ConditionNumber", 1, this.antennaBConfig.conditionList.size(), (Node)AntennaBElement);
        for (int i = 0; i < this.antennaBConfig.conditionList.size(); ++i) {
            ConditionTable condition = this.antennaBConfig.conditionList.get(i);
            Element conditionElement = writer.writeNewField((String)"ConditionRow", (Node)AntennaBElement).xmlElement;
            writer.writeNewField("PlmModeID", 4, condition.plmModeId, (Node)conditionElement);
            writer.writeNewField("DmdStatus", 1, condition.dmdStatus, (Node)conditionElement);
            writer.writeNewField("Index", 1, condition.indexNumber, (Node)conditionElement);
        }
        writer.removeSizeCounter(payloadDataLength);
    }

    @Override
    public void checkValidity(Validator validator, Sensor sensor) {
    }

    @Override
    public ConfigurationPayload clone() {
        return new DynamicSarConfigurationPayload(this);
    }

    @Override
    public String getConfigurationFormatString() {
        return CALIBRATION_FORMAT_STRING;
    }

    @Override
    public String getConfigurationDataString() {
        return "";
    }

    @Override
    public boolean controllsBusData() {
        return false;
    }

    @Override
    public boolean controllsGpioData() {
        return false;
    }

    public static class ConditionTable {
        public int plmModeId;
        public int dmdStatus;
        public int indexNumber;

        public boolean equals(Object arg0) {
            if (arg0 == null || !(arg0 instanceof ConditionTable)) {
                return false;
            }
            ConditionTable other = (ConditionTable)arg0;
            return this.plmModeId == other.plmModeId && this.dmdStatus == other.dmdStatus && this.indexNumber == other.indexNumber;
        }

        public int hashCode() {
            return super.hashCode();
        }
    }

    public class AntennaConfig {
        public int postion = 255;
        public ArrayList<ConditionTable> conditionList;
    }
}

