/*
 * Decompiled with CFR 0.152.
 */
package com.intel.sensing.fdk.model.dao;

import com.intel.sensing.fdk.common.ManagerEnums;
import com.intel.sensing.fdk.common.exceptions.ISSException;
import com.intel.sensing.fdk.common.log.ISSLogger;
import com.intel.sensing.fdk.common.utils.ManagerFileUtils;
import com.intel.sensing.fdk.model.abstractData.Category;
import com.intel.sensing.fdk.model.dao.AbstractJsonDao;
import com.intel.sensing.fdk.model.dao.DaoFactory;
import com.intel.sensing.fdk.model.dao.SensorBundleDao;
import com.intel.sensing.fdk.model.entity.ModuleEntity;
import com.intel.sensing.fdk.model.entity.SensorBundleEntity;
import java.io.File;

public class ModuleDao
extends AbstractJsonDao<ModuleEntity> {
    private SensorBundleDao _sensorBundleDao = DaoFactory.getDao(SensorBundleDao.class);

    @Override
    public ModuleEntity getEntityByFilePath(String filePath) {
        ModuleEntity entity = (ModuleEntity)this.getEntityByFilePath(filePath, ModuleEntity.class);
        if (entity == null) {
            return entity;
        }
        try {
            String parentFolder = entity.getAbsoluteParentFolderAsStr();
            if (parentFolder.contains(ManagerFileUtils.getKitsBaseDir())) {
                entity.setIssModuleTags(ManagerEnums.ISSModuleTags.KITS);
            } else if (parentFolder.contains(ManagerFileUtils.getInstalledModulesDir())) {
                entity.setIssModuleTags(ManagerEnums.ISSModuleTags.INSTALLED);
                String packageName = parentFolder.replace(String.valueOf(ManagerFileUtils.getInstalledModulesDir()) + File.separator, "");
                packageName = packageName.substring(0, packageName.indexOf(File.separator));
                entity.setPackageName(packageName);
            } else {
                entity.setIssModuleTags(ManagerEnums.ISSModuleTags.USER);
            }
            if (entity.getCategory() != null && Category.getItemByName(entity.getCategory()).equals(Category.SENSOR)) {
                String sensorJsonPath = ManagerFileUtils.appendPathAsStr((String)parentFolder, (String)"sensor.json");
                SensorBundleEntity sensorBundleEntity = this._sensorBundleDao.getEntityByFilePath(sensorJsonPath);
                if (sensorBundleEntity == null) {
                    throw new ISSException("Sensor Module error when parsing senson.json: \n-> [" + entity.getAbsoluteParentFolderAsStr() + "]");
                }
                entity.setSensorBundle(sensorBundleEntity);
                sensorBundleEntity.setModuleEntity(entity);
            }
        }
        catch (ISSException e) {
            e.AddMsg("Module parsing error: \n ->" + entity.getAbsoluteParentFolderAsStr());
            ISSLogger.e((Exception)((Object)e));
            return null;
        }
        return entity;
    }
}

