<?php
//include_once("PageDisplayer.class.php");

class PgHyperCreate2Displayer extends PageDisplayer
{
	protected function initPage()
	{
		$smarty = $this->smarty;
		
		//hd list
		$hdlist  = new CtnHdList();
		$hdlist->setAdapterID($this->getAdapterID());
		$hdlist->toGetHDInfo();
		$hdlist->toGetValidSize();
		$hdlist->toGetSpareInfo();
		$hdlist->toGetHdFreeInfo();
                $hdlist->toGetConfig();
		$hdlist->setFilter(new HdCreateFilter());
		$hdlist->smartyAssign($smarty);
		$hdlist->initContainer();
		
		$hds = $hdlist->getInfos();
		$ssdHDList = array();
		$hddList = array();

		foreach ($hds as $hd) 
		{
			if ($hd->IsSSD) {
				$ssdHDList[$hd->ID] = $hd;
			} else {
				$hddList[$hd->ID] = $hd;
			}
		}

		$hba = HBAFactory::getInstance($this->getAdapterID());
                
		$hyperHddTypes = array();
                if ($hba->supportHyperHDDMirror())
                    $hyperHddTypes[RAIDMode::LD_MODE_RAID_HDD_MIRROR] = RAIDMode::HDDMirror; //default mirror
                if ($hba->supportHyperHDDSpan())
                    $hyperHddTypes[RAIDMode::LD_MODE_HyperHDD] = RAIDMode::HDDSPAN;
                if ($hba->supportHybrid())
                    $hyperHddTypes[RAIDMode::LD_MODE_RAID_HDD_MIRROR_HYBRID] = RAIDMode::Hybrid;

                $smarty->assign("supportHyperHDDMirror", $hba->supportHyperHDDMirror());

		if (sizeof($ssdHDList) == 0) {
			$smarty->assign("noSSDFound", 1);
		} 
		
		$defaultSelectedSSD = 255;
		$defaultSelectedHDD = 255;
		if (sizeof($ssdHDList) > 0 && sizeof($hddList) > 0) {
			$tmp = $ssdHDList;
			$defaultSelectedSSD = array_shift($tmp);
			$smarty->assign("defaultSelectedSSD", $defaultSelectedSSD->ID);
			$tmp = $hddList;
			$defaultSelectedHDD = array_shift($tmp);
			$smarty->assign("defaultSelectedHDD", $defaultSelectedHDD->ID);
		}
		
		include_once("../phpsrc/action/GetSSDCreateHypperMaxSize.class.php");
		$ssdCreateMaxSize = new GetSSDCreateHypperMaxSize();
                $ssdCreateMaxSize->setHBAID($this->getAdapterID());
		$ssdCreateMaxSize->smartyAssign($smarty);
		
		foreach ($ssdHDList as $ssd) {
			$ssdCreateMaxSize->setHDIDs($ssd->ID);
			$ssdCreateMaxSize->setMaxSize();
			$maxSize = ConvertSize($ssdCreateMaxSize->getMaxSize());
			$maxSizeGB = FormatSize($ssdCreateMaxSize->getMaxSize());
			if ($maxSize > 0) {
				$ssd->createMaxSize = $maxSize;
				$ssd->createMaxSizeGB = $maxSizeGB;
			} else {
				$ssd->createMaxSize = 0;
				$ssd->createMaxSizeGB = "N/A";
			}
		}
		
		//$smarty->assign("ssdCreateMaxSize", $maxSize);

                $keepDataTypes = array();
                $keepDataTypes[0] = "Not Sync";
                $keepDataTypes[1] = "Sync Data";
                if ($hba->supportIntelligentKeep()) {
                    $keepDataTypes[2] = "Intelligent Sync Data";
                }
//                if ($hba->supportHyperHDDMirrorPlus()) {
//                    $keepDataTypes[2] = "Keep SSD Data";
//                }

                if ($hba->supportIntelligentKeep())
                    $defaultKeppDataType = 2;
                else if ($hba->supportHyperHDDMirror())
                    $defaultKeppDataType = 1;
                else
                    $defaultKeppDataType = 0;
                
		$smarty->assign("keepDataTypes", $keepDataTypes);
		$smarty->assign("defaultKeppDataType", $defaultKeppDataType);
                
		$smarty->assign("hyperHddTypes", $hyperHddTypes);
		$smarty->assign("ssdHDList", $ssdHDList);
		$smarty->assign("ssdCount", sizeof($ssdHDList));
		$smarty->assign("hddList", $hddList);
		$smarty->assign("hddCount", sizeof($hddList));
		$smarty->assign("HBAID", $this->getAdapterID());
		$smarty->assign("MaxSSDPerHyperDuo", $hba->getMaxSSDPerHyperDuo());
		
		$this->setPageName(Target::HyperCreatePage2 . ".tpl");
	}
}
?>