<?php
class CtnCreateDGMaxSize extends Container
{
	private $HDIDs = array();
	private $RaidMode;
	private $NumParityDisk;
	
	public function addHDID($HDID)
	{
		$this->HDIDs[] = $HDID;
	}
	
	public function setRaidMode($RaidMode)
	{
		$this->RaidMode = $RaidMode;
	}
	
	public function setNumParityDisk($NumParityDisk)
	{
		$this->NumParityDisk = $NumParityDisk;
	}
	
	protected function setBase()
	{
		$this->base = new CreateDGMaxSize();
		foreach ($this->HDIDs as $HDID)
		{
			$this->base->addHDID($HDID);
		}
		$this->base->setRaidMode($this->RaidMode);
		$this->base->setNumParityDisk($this->NumParityDisk);
	}

	protected function setDataToPage()
	{
		$baseclasses = $this->base->getBaseClasses();
		if ($baseclasses) {
			$this->smarty->assign("CreateDGMaxSizeGB",FormatSize($baseclasses[0]));
			$MaxSize = ConvertSize($baseclasses[0]);
			$this->smarty->assign("CreateDGMaxSize",$MaxSize);
		}
		else {
			$this->smarty->assign("CreateDGMaxSizeGB",gettext("Select disk(s)"));
		}
	}
	
	public function displayXML()
	{
		$this->display("CreateDGMaxSize.tpl");
	}
}
?>