<?php
include_once("../phpsrc/mail/swiftmailer/lib/swift_required.php");
class MailSettingException extends Exception {
    public function __construct($msg = "") {
        if($msg == "")
            parent::__construct('Cannot connect to smtp server with setting specified!');
        else
            parent::__construct($msg);
    }
}

class MailSendingException extends Exception {
    public function __construct($msg = "") {
        if($msg == "")
            parent::__construct('Cannot send mail with setting specified!');
        else
            parent::__construct($msg);
    }
}

class MRUMailer {
    private $userName;
    private $passwd;
    private $port;
    private $serverAddr;
    private $isSSL;
    //private $isTSL;
    private $needAuth = 1;
    private $swift = null;

    const HelloMsg = 'Hello';
    const MailAutoMsg = 'This mail is automatically sent out by Marvell Storage Utility.Please don\'t reply to this mail.';
    const MailHeadMsg = 'The following event(s) have ocurred on the machine';

    public function getUserName() {
        return $this->userName;
    }
    public function setUserName($userName) {
        $this->userName = $userName;
    }

    public function getPasswd() {
        return $this->passwd;
    }
    public function setPasswd($passwd) {
        $this->passwd = $passwd;
    }

    public function getPort() {
        return $this->port;
    }
    public function setPort($port) {
        $this->port = $port;
    }

    public function getServerAddr() {
        return $this->serverAddr;
    }
    public function setServerAddr($serverAddr) {
        $this->serverAddr = $serverAddr;
    }

    public function isSSL() {
        return $this->isSSL;
    }
    public function setSSL($isSSL) {
        $this->isSSL = $isSSL;
    }

    public function needAuth() {
        $this->needAuth = 1;
    }

    public function notNeedAuth() {
        $this->needAuth = 0;
    }

    //get smtp connection
    private function getSMTPConn() {
        $smtp = null;

        if ($this->isSSL) {
            //use ssl
            if($this->port == 465)
                $smtp = Swift_SmtpTransport::newInstance($this->serverAddr,$this->port,'ssl');
            else
                $smtp = Swift_SmtpTransport::newInstance($this->serverAddr,$this->port,'tls');
        }
        else if ( ! $this->port ) {
            //use default port no : 25
            $smtp = Swift_SmtpTransport::newInstance($this->serverAddr);
        }
        else {
            $smtp = Swift_SmtpTransport::newInstance($this->serverAddr,$this->port);
        }

        //if ($this->needAuth) {
        if ($this->userName) {
            //if user name is set,then need authentication
            $smtp->setUsername($this->userName);
            $smtp->setPassword($this->passwd);
        }
        //}

        $smtp->setTimeout(20);

        return $smtp;
    }

    //
    public function initMailer() {
        $smtp = null;
        try {
            $smtp = $this->getSMTPConn();
            //$this->swift->log->enable();
        }
        catch (Exception $e) {
            //if($e->getMessage())
            $smtp = null;
            throw new MailSettingException();
        }

        try {
            if($smtp != null)
                $this->swift = Swift_Mailer::newInstance($smtp);
            //$this->swift->log->enable();
        }
        catch (Exception $e) {
            //if($e->getMessage())
            throw new MailSettingException();
        }
    }

    //send basic mail
    public function send($to,$subject,$content,$type='text/plain') {
        try {
            $message = new Swift_Message($subject,$content,$type);
            $this->swift->send($message,$to,$this->userName);
        }
        catch (Exception $e) {
            throw new MailSendingException($e->getMessage());
        }
    }

    public function sendTestMail($testAddr = null) {
        try {
            $message = Swift_Message::newInstance();
            $message->setSubject(gettext('Email Setting Test'));
            $message->setBody(gettext(self::MailAutoMsg));
            $message->setPriority(2);
            if ($this->userName) {
                $message->setFrom($this->userName);
                $message->setTo(array($this->userName));
                $this->swift->send($message);
            }
            /*
			else 
			{
				$recipients->addTo('noreply@mru.com',"MRU");
				$this->swift->send($message,$recipients,'noreply@mru.com');
			}
            */
        }
        catch (Exception $e) {
            throw new MailSendingException($e->getMessage());
        }
    }

    //send event notify mail(text/html)
    //$contacts = array("mailaddress@mail.com"=>userName,.......);
    public function sendEventNotify($contacts,$eventsRelated) {
        if ($this->swift != null && $contacts && $eventsRelated) {
            //if swift are successfully initialized, both contacts and events are not empty
            //then send mails
            $recipients = array();
            /*
			if (!$this->userName) {
				//if no user name,default user name
				$recipients->addTo("noreply@mru.com","MRU");
			}
			else
			{
				$recipients->addTo($this->userName,$this->userName);
			}
            */
            foreach ($contacts as $mailAddr=>$userName) {
                $recipients[$mailAddr] = $userName;
            }

            $message = $this->formMultipartContent(gettext("MRU User"),$eventsRelated);
            $message->setTo($recipients);
            $message->setFrom($this->userName);
            $message->setPriority(1);
            try {
                //$this->swift->send($message,$recipients,"noreply@mru.com");

                if (!$this->userName) {
                    //if no user name,default user name
                    $this->swift->send($message);
                }
                else {
                    $this->swift->send($message);
                }

            }
            catch (Exception $e) {
                //echo $e->getMessage() .'<br/>';
                //echo '<br/>'  . $this->swift->log->dump() . '<br/>';
                throw new MailSendingException($e->getMessage());
            }
        }
    }

    private function formMultipartContent($name,$eventsRelated) {
        $message = Swift_Message::newInstance();
        $message->setSubject(gettext('Marvell Storage Utility Event Notification'));

        $os_string = getenv('OS');
        $newLine = "\n";
        if (stripos($os_string,'win') !== false) {
            $newLine = "\r\n";
        }

        $htmlNewLine = '<br/>';

        $txtContent = '';
        $htmlContent = '';

        /*
		$htmlContent .= '<html>';
		$htmlContent .= '<head>';
		$htmlContent .= '<META HTTP-EQUIV="Content-Type" CONTENT="text/html; charset=us-ascii" />';
		$htmlContent .= '<style></style>';
		$htmlContent .= '</head>';
		$htmlContent .= '<body>';
		$htmlContent .= '</body>';
		$htmlContent .= '</html>';
        */

        if (strtoupper(substr(PHP_OS, 0, 3)) === 'WIN') {
            $HostName = getenv('COMPUTERNAME');
        }
        else {
            $HostName = exec("hostname");
        }

        $htmlContent .= gettext(self::HelloMsg) .', ' . $name .'.' . $htmlNewLine;
        $htmlContent .= gettext(self::MailAutoMsg) . $htmlNewLine;
        $htmlContent .= gettext(self::MailHeadMsg).'('
                . $HostName .').' . $htmlNewLine;

        $txtContent = gettext('Hello') .', ' . $name .'.' . $newLine;
        $txtContent .= gettext(self::MailAutoMsg) . $newLine;
        $txtContent .= gettext(self::MailHeadMsg).'('
                . $HostName .').' . $newLine;

        foreach ($eventsRelated as $event) {
            $htmlContent .= $event->Date . " : ["
                    . $event->SeverityTitle . "] " . $event->Class . " : " . $event->Log . $htmlNewLine;
            $txtContent .=  $event->Date . " : ["
                    . $event->SeverityTitle . "] " . $event->Class . " : " . $event->Log . $newLine;
        }

        $message->setBody($txtContent);
        $message->addPart($htmlContent, "text/html");

        return $message;
    }
}
?>
