/*
 * Decompiled with CFR 0.152.
 */
package manager.sensor;

import java.util.ArrayList;
import java.util.Comparator;
import manager.common.APIVersion;
import manager.common.BuildVersion;
import manager.common.Field;
import manager.common.Interrupt;
import manager.common.SPI;
import manager.configure.Platform;
import manager.sensor.SensorDataManager;
import manager.utils.ManagerEnums;

public class SensorData {
    private ManagerEnums.ObjectTypes objectType;
    private Platform platform;
    private String SensorCoreAPIVersion;
    private String pluginVersion;
    private String name;
    private int typeId;
    private String typeName;
    private String friendlyName;
    private int vendorId;
    private String vendorName;
    private String friendlyVendorName;
    private int modelId;
    private String modelName;
    private String friendlyModelName;
    private String initFunction;
    private int instanceId;
    private BuildVersion buildVersion;
    private ManagerEnums.DependencyTypes dependencyType;
    private ManagerEnums.Configurations configuration;
    private int reportIntervalMin;
    private int reportIntervalMax;
    private int sensitivity;
    private boolean autoStart = false;
    private int autoStartSensitivity;
    private int autoStartMinRi;
    private boolean doNotAddSensorPostfix = false;
    private boolean userDefinedOutput = false;
    private ManagerEnums.FlagValues customFlagValue;
    private ManagerEnums.FlagValues notExposedFlagValue;
    private ArrayList<ManagerEnums.BusTypes> busTypes;
    private ArrayList<ManagerEnums.Flags> flags;
    private ArrayList<Integer> addresses;
    private ArrayList<Interrupt> GPInputs;
    private ArrayList<Interrupt> GPOutputs;
    private ArrayList<Integer> calibrationFormats;
    private ArrayList<SensorData> dependencies;
    private ArrayList<ManagerEnums.SystemEvents> systemEvents;
    private ArrayList<ManagerEnums.SensorAttributes> sensorAttributes;
    private ArrayList<Field> fields;
    private ArrayList<String> callbacks;
    private ArrayList<Field> properties;
    private SPI spi;

    public BuildVersion getBuildVersion() {
        if (this.buildVersion == null) {
            this.buildVersion = BuildVersion.emptyVersion;
        }
        return this.buildVersion;
    }

    public void setBuildVersion(BuildVersion buildVersion) {
        this.buildVersion = buildVersion;
    }

    public ManagerEnums.ObjectTypes getObjectType() {
        return this.objectType;
    }

    public void setObjectType(ManagerEnums.ObjectTypes objectType) {
        this.objectType = objectType;
    }

    public Platform getPlatform() {
        return this.platform;
    }

    public void setPlatform(Platform newPlatform) {
        this.platform = newPlatform;
    }

    public String getSensorCoreAPIVersion() {
        return this.SensorCoreAPIVersion;
    }

    public void setSensorCoreAPIVersion(String sensorCoreAPIVer) {
        if (sensorCoreAPIVer == null || sensorCoreAPIVer.isEmpty()) {
            this.SensorCoreAPIVersion = APIVersion.emptyVersion.toString();
        } else if (sensorCoreAPIVer.contains("SC_SENSOR_CORE_API_VER_MAJOR") || sensorCoreAPIVer.contains("SC_SENSOR_CORE_API_VER_MINOR") || sensorCoreAPIVer.contains("SC_SENSOR_CORE_API_VER_PATCH")) {
            this.SensorCoreAPIVersion = APIVersion.dynamicVersion.toString();
        } else {
            try {
                APIVersion ver = APIVersion.parseVersion(sensorCoreAPIVer);
                this.SensorCoreAPIVersion = ver.toString();
            }
            catch (Exception e) {
                this.SensorCoreAPIVersion = APIVersion.emptyVersion.toString();
            }
        }
    }

    public String getPluginVersion() {
        return this.pluginVersion;
    }

    public void setPluginVersion(String pluginVersion) {
        this.pluginVersion = pluginVersion;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getTypeId() {
        return this.typeId;
    }

    public void setTypeId(int typeId) {
        this.typeId = typeId;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    public int getVendorId() {
        return this.vendorId;
    }

    public void setVendorId(int vendorId) {
        this.vendorId = vendorId;
    }

    public String getVendorName() {
        return this.vendorName;
    }

    public void setVendorName(String vendorName) {
        this.vendorName = vendorName;
    }

    public int getModelId() {
        return this.modelId;
    }

    public void setModelId(int modelId) {
        this.modelId = modelId;
    }

    public String getModelName() {
        return this.modelName;
    }

    public void setModelName(String modelName) {
        this.modelName = modelName;
    }

    public String getInitFunction() {
        return this.initFunction;
    }

    public void setInitFunction(String initFunction) {
        this.initFunction = initFunction;
    }

    public String[] getBusTypesAsStringList() {
        if (this.busTypes != null) {
            int index = 0;
            String[] busTypesStrings = new String[this.busTypes.size()];
            for (ManagerEnums.BusTypes busType : this.busTypes) {
                busTypesStrings[index++] = busType.name();
            }
            return busTypesStrings;
        }
        return null;
    }

    public ArrayList<ManagerEnums.BusTypes> getBusTypes() {
        return this.busTypes;
    }

    public int getInstanceId() {
        return this.instanceId;
    }

    public void setInstanceId(int instanceId) {
        this.instanceId = instanceId;
    }

    public ManagerEnums.DependencyTypes getDependencyType() {
        return this.dependencyType;
    }

    public void setDependencyType(ManagerEnums.DependencyTypes dependencyType) {
        this.dependencyType = dependencyType;
    }

    public ManagerEnums.Configurations getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(ManagerEnums.Configurations configuration) {
        this.configuration = configuration;
    }

    public int getReportIntervalMin() {
        return this.reportIntervalMin;
    }

    public void setReportIntervalMin(int reportIntervalMin) {
        this.reportIntervalMin = reportIntervalMin;
    }

    public int getReportIntervalMax() {
        return this.reportIntervalMax;
    }

    public void setReportIntervalMax(int reportIntervalMax) {
        this.reportIntervalMax = reportIntervalMax;
    }

    public int getSensitivity() {
        return this.sensitivity;
    }

    public void setSensitivity(int sensitivity) {
        this.sensitivity = sensitivity;
    }

    public int getAutoStartSensitivity() {
        return this.autoStartSensitivity;
    }

    public void setAutoStartSensitivity(int autoStartSensitivity) {
        this.autoStartSensitivity = autoStartSensitivity;
    }

    public int getAutoStartMinRi() {
        return this.autoStartMinRi;
    }

    public void setAutoStartMinRi(int autoStartMinRi) {
        this.autoStartMinRi = autoStartMinRi;
    }

    public boolean getAutoStart() {
        return this.autoStart;
    }

    public void setAutoStart(boolean autoStart) {
        this.autoStart = autoStart;
    }

    public boolean getDoNotAddSensorPostfix() {
        return this.doNotAddSensorPostfix;
    }

    public void setDoNotAddSensorPostfix(boolean doNotAddSensorPostfix) {
        this.doNotAddSensorPostfix = doNotAddSensorPostfix;
    }

    public boolean isUserDefinedOutput() {
        return this.userDefinedOutput;
    }

    public void setUserDefinedOutput(boolean userDefinedOutput) {
        this.userDefinedOutput = userDefinedOutput;
    }

    public ManagerEnums.FlagValues getCustomFlagvalue() {
        return this.customFlagValue;
    }

    public void setCustomFlagvalue(ManagerEnums.FlagValues customFlagValue) {
        this.customFlagValue = customFlagValue;
    }

    public ManagerEnums.FlagValues getNotExposedFlagvalue() {
        return this.notExposedFlagValue;
    }

    public void setNotExposedFlagvalue(ManagerEnums.FlagValues notExposedFlagValue) {
        this.notExposedFlagValue = notExposedFlagValue;
    }

    public ArrayList<ManagerEnums.Flags> getFlags() {
        return this.flags;
    }

    public String[] getFlagsNames() {
        if (this.flags != null) {
            int index = 0;
            String[] flagsNames = new String[this.flags.size()];
            for (ManagerEnums.Flags flag : this.flags) {
                flagsNames[index++] = flag.name();
            }
            return flagsNames;
        }
        return null;
    }

    public void setFlags(ArrayList<ManagerEnums.Flags> flags) {
        this.flags = flags;
    }

    public void setFlags(int intFlag) {
        this.flags = SensorDataManager.getFlagsFromInt(intFlag);
    }

    public int getFlagsAsInteger() {
        if (this.flags == null || this.flags.size() == 0) {
            return -1;
        }
        if (this.flags.size() == 1 && this.flags.get(0).equals((Object)ManagerEnums.Flags.SC_LUID_FLAG_NONE)) {
            return 0;
        }
        StringBuilder binStringFlags = new StringBuilder("00000000");
        for (ManagerEnums.Flags flag : this.flags) {
            if (flag.equals((Object)ManagerEnums.Flags.SC_LUID_FLAG_NONE)) continue;
            binStringFlags.setCharAt(8 - flag.getValue(), '1');
        }
        return Integer.parseInt(binStringFlags.toString(), 2);
    }

    public ArrayList<Integer> getAddresses() {
        return this.addresses;
    }

    public String[] getAddressesAsStringList() {
        if (this.addresses != null) {
            int index = 0;
            String[] addressesStrings = new String[this.addresses.size()];
            for (Integer address : this.addresses) {
                addressesStrings[index++] = address.toString();
            }
            return addressesStrings;
        }
        return null;
    }

    public String[] getAddressesAsHexStringList() {
        if (this.addresses != null) {
            int index = 0;
            String[] addressesHexStrings = new String[this.addresses.size()];
            for (Integer address : this.addresses) {
                String hex = Integer.toHexString(address);
                if (hex.length() == 1) {
                    hex = "0" + hex;
                }
                addressesHexStrings[index++] = "0x" + hex;
            }
            return addressesHexStrings;
        }
        return null;
    }

    public void setAddresses(ArrayList<Integer> addresses) {
        this.addresses = addresses;
    }

    public ArrayList<Interrupt> getGPInputs() {
        return this.GPInputs;
    }

    public String[] getGPInputsNames() {
        if (this.GPInputs != null) {
            int index = 0;
            String[] GPInputsNames = new String[this.GPInputs.size()];
            for (Interrupt GPInput : this.GPInputs) {
                GPInputsNames[index++] = GPInput.getName();
            }
            return GPInputsNames;
        }
        return null;
    }

    public void setGPInputs(ArrayList<Interrupt> GPInputs) {
        this.GPInputs = GPInputs;
    }

    public ArrayList<Interrupt> getGPOutputs() {
        return this.GPOutputs;
    }

    public String[] getGPOutputsNames() {
        if (this.GPOutputs != null) {
            int index = 0;
            String[] GPOutputsNames = new String[this.GPOutputs.size()];
            for (Interrupt GPOutput : this.GPOutputs) {
                GPOutputsNames[index++] = GPOutput.getName();
            }
            return GPOutputsNames;
        }
        return null;
    }

    public void setGPOutputs(ArrayList<Interrupt> GPOutputs) {
        this.GPOutputs = GPOutputs;
    }

    public ArrayList<Integer> getCalibrationFormats() {
        return this.calibrationFormats;
    }

    public String[] getCalibrationFormatsAsStringList() {
        if (this.calibrationFormats != null) {
            int index = 0;
            String[] CalibrationFormatsStrings = new String[this.calibrationFormats.size()];
            for (Integer format : this.calibrationFormats) {
                CalibrationFormatsStrings[index++] = format.toString();
            }
            return CalibrationFormatsStrings;
        }
        return null;
    }

    public void setCalibrationFormats(ArrayList<Integer> calibrationFormats) {
        this.calibrationFormats = calibrationFormats;
    }

    public ArrayList<SensorData> getDependencies() {
        return this.dependencies;
    }

    public void setDependencies(ArrayList<SensorData> dependencies) {
        this.dependencies = dependencies;
    }

    public void addBusType(ManagerEnums.BusTypes busType) {
        if (this.busTypes == null) {
            this.busTypes = new ArrayList();
        }
        this.busTypes.add(busType);
    }

    public void addAddress(int address) {
        if (this.addresses == null) {
            this.addresses = new ArrayList();
        }
        this.addresses.add(address);
    }

    public void addGPInput(Interrupt input) {
        if (this.GPInputs == null) {
            this.GPInputs = new ArrayList();
        }
        if (input != null) {
            this.GPInputs.add(input);
        }
    }

    public void addGPOutput(Interrupt output) {
        if (this.GPOutputs == null) {
            this.GPOutputs = new ArrayList();
        }
        if (output != null) {
            this.GPOutputs.add(output);
        }
    }

    public void addDependency(SensorData sensor) {
        if (this.dependencies == null) {
            this.dependencies = new ArrayList();
        }
        if (sensor != null) {
            this.dependencies.add(sensor);
        }
    }

    public void addCalibrationFormat(int format) {
        if (this.calibrationFormats == null) {
            this.calibrationFormats = new ArrayList();
        }
        this.calibrationFormats.add(format);
    }

    public String getFriendlyName() {
        return this.friendlyName;
    }

    public void setFriendlyName(String friendlyName) {
        if (friendlyName == null) {
            friendlyName = "";
        }
        if (!this.doNotAddSensorPostfix) {
            if (!friendlyName.isEmpty() && !friendlyName.toLowerCase().trim().endsWith(ManagerEnums.ComponentName.SENSOR.getFriendlyName())) {
                friendlyName = String.valueOf(friendlyName) + " Sensor";
            }
        } else if (friendlyName.toLowerCase().trim().endsWith(" sensor")) {
            friendlyName = friendlyName.substring(0, friendlyName.length() - 7);
        }
        this.friendlyName = friendlyName;
    }

    public void setBusTypes(ArrayList<ManagerEnums.BusTypes> busTypes) {
        this.busTypes = busTypes;
    }

    public String getFriendlyVendorName() {
        return this.friendlyVendorName;
    }

    public void setFriendlyVendorName(String friendlyVendorName) {
        this.friendlyVendorName = friendlyVendorName;
    }

    public String getFriendlyModelName() {
        return this.friendlyModelName;
    }

    public void setFriendlyModelName(String friendlyModelName) {
        if (friendlyModelName == null) {
            friendlyModelName = "";
        }
        if (!this.doNotAddSensorPostfix) {
            if (!friendlyModelName.isEmpty() && !friendlyModelName.toLowerCase().trim().endsWith(ManagerEnums.ComponentName.SENSOR.getFriendlyName())) {
                friendlyModelName = String.valueOf(friendlyModelName) + " Sensor";
            }
        } else if (friendlyModelName.toLowerCase().trim().endsWith(" sensor")) {
            friendlyModelName = friendlyModelName.substring(0, friendlyModelName.length() - 7);
        }
        this.friendlyModelName = friendlyModelName;
    }

    public ArrayList<ManagerEnums.SystemEvents> getSystemEvents() {
        return this.systemEvents;
    }

    public void setSystemEvents(ArrayList<ManagerEnums.SystemEvents> systemEvents) {
        this.systemEvents = systemEvents;
    }

    public ArrayList<ManagerEnums.SensorAttributes> getSensorAttributes() {
        return this.sensorAttributes;
    }

    public void setSensorAttributes(ArrayList<ManagerEnums.SensorAttributes> sensorAttributes) {
        this.sensorAttributes = sensorAttributes;
    }

    public ArrayList<Field> getFields() {
        return this.fields;
    }

    public void setFields(ArrayList<Field> fields) {
        this.fields = fields;
    }

    public ArrayList<Field> getProperties() {
        return this.properties;
    }

    public void setProperties(ArrayList<Field> properties) {
        this.properties = properties;
    }

    public ArrayList<String> getCallbacks() {
        return this.callbacks;
    }

    public void setCallbacks(ArrayList<String> callbacks) {
        this.callbacks = callbacks;
    }

    public boolean equals(Object arg0) {
        if (arg0 == null || !(arg0 instanceof SensorData)) {
            return false;
        }
        SensorData other = (SensorData)arg0;
        if (this.getObjectType() == other.getObjectType() && (this.getObjectType() != ManagerEnums.ObjectTypes.LIBRARY ? this.getTypeId() == other.getTypeId() && this.getVendorId() == other.getVendorId() && this.getModelId() == other.getModelId() && SensorDataManager.compareSensorFlags(this.getFlagsAsInteger(), other.getFlagsAsInteger(), false) && this.getInstanceId() == other.instanceId : this.getVendorId() == other.getVendorId() && this.getModelId() == other.getModelId() && this.getName().toLowerCase().equals(other.getName().toLowerCase()))) {
            return this.getBuildVersion().equals(other.getBuildVersion());
        }
        return false;
    }

    public String getLuidString() {
        int i;
        StringBuilder builder = new StringBuilder("****************");
        Integer typeIdDec = this.getTypeId();
        String typeIdHex = Integer.toHexString(typeIdDec);
        int len = typeIdHex.length();
        int i2 = 0;
        while (i2 < 4 - len) {
            typeIdHex = "0" + typeIdHex;
            ++i2;
        }
        builder.replace(0, 4, typeIdHex);
        if (this.getVendorName() != null) {
            Integer vendorIdDec = this.getVendorId();
            String vendorIdHex = Integer.toHexString(vendorIdDec);
            len = vendorIdHex.length();
            i = 0;
            while (i < 4 - len) {
                vendorIdHex = "0" + vendorIdHex;
                ++i;
            }
            builder.replace(4, 8, vendorIdHex);
        }
        if (this.getModelName() != null) {
            Integer modelIdDec = this.getModelId();
            String modelIdHex = Integer.toHexString(modelIdDec);
            len = modelIdHex.length();
            i = 0;
            while (i < 4 - len) {
                modelIdHex = "0" + modelIdHex;
                ++i;
            }
            builder.replace(8, 12, modelIdHex);
        }
        builder.replace(12, 14, "**");
        if (this.getFlags() != null) {
            Integer flagsDec = this.getFlagsAsInteger();
            String flagsHex = Integer.toHexString(flagsDec);
            len = flagsHex.length();
            i = 0;
            while (i < 2 - len) {
                flagsHex = "0" + flagsHex;
                ++i;
            }
            builder.replace(14, 16, flagsHex);
        }
        return "0x" + builder.toString();
    }

    public SPI getSpi() {
        return this.spi;
    }

    public void setSpi(SPI spi) {
        this.spi = new SPI(spi);
    }

    public APIVersion getAPIVersion() {
        if (this.SensorCoreAPIVersion != null) {
            return APIVersion.parseVersion(this.SensorCoreAPIVersion);
        }
        return APIVersion.emptyVersion;
    }

    public static class DataComparator
    implements Comparator<SensorData> {
        @Override
        public int compare(SensorData data1, SensorData data2) {
            if (data1.getObjectType() == data2.getObjectType()) {
                if (data1.getObjectType() != ManagerEnums.ObjectTypes.LIBRARY) {
                    if (data1.getTypeName().toLowerCase().equals(data2.getTypeName().toLowerCase())) {
                        if (data1.getVendorName().toLowerCase().equals(data2.getVendorName().toLowerCase())) {
                            if (data1.getModelId() == data2.getModelId()) {
                                if (data1.getModelName().toLowerCase().equals(data2.getModelName().toLowerCase())) {
                                    if (SensorDataManager.compareSensorFlags(data1.getFlagsAsInteger(), data2.getFlagsAsInteger(), false)) {
                                        if (data1.getBuildVersion().compareTo(data2.getBuildVersion()) == 0) {
                                            return data1.getInstanceId() - data2.instanceId;
                                        }
                                        return data1.getBuildVersion().compareTo(data2.getBuildVersion());
                                    }
                                    return data1.getFlagsAsInteger() - data2.getFlagsAsInteger();
                                }
                                return data1.getModelName().toLowerCase().compareTo(data2.getModelName().toLowerCase());
                            }
                            return data1.getModelId() - data2.getModelId();
                        }
                        return data1.getVendorName().toLowerCase().compareTo(data2.getVendorName().toLowerCase());
                    }
                    return data1.getTypeName().toLowerCase().compareTo(data2.getTypeName().toLowerCase());
                }
                if (data1.getVendorName().toLowerCase().equals(data2.getVendorName().toLowerCase())) {
                    if (data1.getModelId() == data2.getModelId()) {
                        if (data1.getModelName().toLowerCase().equals(data2.getModelName().toLowerCase())) {
                            if (data1.getBuildVersion().compareTo(data2.getBuildVersion()) == 0) {
                                return data1.getName().toLowerCase().compareTo(data2.getName().toLowerCase());
                            }
                            return data1.getBuildVersion().compareTo(data2.getBuildVersion());
                        }
                        return data1.getModelName().toLowerCase().compareTo(data2.getModelName().toLowerCase());
                    }
                    return data1.getModelId() - data2.getModelId();
                }
                return data1.getVendorName().toLowerCase().compareTo(data2.getVendorName().toLowerCase());
            }
            if (data1.getObjectType() == ManagerEnums.ObjectTypes.PHYSICAL) {
                return -1;
            }
            if (data2.getObjectType() == ManagerEnums.ObjectTypes.PHYSICAL) {
                return 1;
            }
            if (data1.getObjectType() == ManagerEnums.ObjectTypes.VIRTUAL && data2.getObjectType() == ManagerEnums.ObjectTypes.LIBRARY) {
                return -1;
            }
            return 1;
        }
    }
}

