/*
 * Decompiled with CFR 0.152.
 */
package pdtEditor.gui.configuration;

import java.util.ArrayList;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.wb.swt.SWTResourceManager;
import pdtEditor.gui.GuiUtils;
import pdtEditor.gui.configuration.DynamicSarConfiguration;
import pdtEditor.gui.configuration.LidModeConfigurationModifier;
import pdtEditor.payloads.configurations.DynamicSarConfigurationPayload;
import resources.CustomSpinner;

public class DynamicSarConfigurationModifier {
    protected Shell shell;
    private Display display;
    private DynamicSarConfiguration parent;
    private ArrayList<Integer> modeIdList = new ArrayList();
    private TableItem _currentItem = null;
    private Table currentTable;
    private Group grpPlmModeId;
    private Group grpDmd;
    private Button chkPlmModeIdGroup;
    private Button rbtnDmdMotionLess;
    private Button rbtnDmdMotion;
    private Button rbtnDmdNotCare;
    private CustomSpinner cspnIndex;
    private static final int DEFAULT_PLM_ROW_CONTROL_COUNT = 6;
    private static final int DEFAULT_PLM_ROW_COUNT = 1;

    public static void main(String[] args) {
        try {
            DynamicSarConfigurationModifier window = new DynamicSarConfigurationModifier(null, null, null, null);
            window.open();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public DynamicSarConfigurationModifier(DynamicSarConfiguration parentWindow, ArrayList<Integer> plmModeIds, TableItem item, Table table) {
        this.parent = parentWindow;
        this.modeIdList = plmModeIds;
        this._currentItem = item;
        this.currentTable = table;
    }

    public void open() {
        this.display = Display.getDefault();
        this.createContents();
        this.fillData();
        this.shell.open();
        this.shell.layout();
        while (!this.shell.isDisposed()) {
            if (this.display.readAndDispatch()) continue;
            this.display.sleep();
        }
    }

    protected void createContents() {
        this.shell = new Shell(65760);
        this.shell.setImage(SWTResourceManager.getImage(LidModeConfigurationModifier.class, "/resources/Intel.ico"));
        this.shell.setText("Dynamic Sar Configuration");
        this.shell.setLayout((Layout)new GridLayout(1, false));
        Composite cmpPlmModelId = new Composite((Composite)this.shell, 4);
        FormLayout cmpPlmModeIdLayout = new FormLayout();
        cmpPlmModeIdLayout.marginWidth = 5;
        cmpPlmModeIdLayout.marginHeight = 5;
        cmpPlmModelId.setLayout((Layout)cmpPlmModeIdLayout);
        cmpPlmModelId.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.chkPlmModeIdGroup = new Button(cmpPlmModelId, 32);
        this.chkPlmModeIdGroup.setText("PLM Mode ID");
        FormData formData = new FormData();
        this.chkPlmModeIdGroup.setLayoutData((Object)formData);
        formData.left = new FormAttachment();
        formData.left.offset = 8;
        this.grpPlmModeId = new Group(cmpPlmModelId, 4);
        FormData grpPlmModeIdGroupData = new FormData();
        GridLayout plmModeIdGroupLayout = new GridLayout(6, false);
        plmModeIdGroupLayout.verticalSpacing = 15;
        plmModeIdGroupLayout.horizontalSpacing = 15;
        this.grpPlmModeId.setLayout((Layout)plmModeIdGroupLayout);
        if (this.modeIdList == null || this.modeIdList.size() == 0) {
            this.chkPlmModeIdGroup.setSelection(false);
            this.chkPlmModeIdGroup.setEnabled(false);
            Button tempButton = new Button(cmpPlmModelId, 32);
            tempButton.setText("1");
            tempButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
            grpPlmModeIdGroupData.width = 6 * tempButton.computeSize((int)-1, (int)-1).x + plmModeIdGroupLayout.horizontalSpacing * 6 + 2 * plmModeIdGroupLayout.marginWidth;
            grpPlmModeIdGroupData.height = 1 * tempButton.computeSize((int)-1, (int)-1).y + plmModeIdGroupLayout.verticalSpacing * 1 + 2 * plmModeIdGroupLayout.marginHeight;
            tempButton.dispose();
        } else {
            this.chkPlmModeIdGroup.setSelection(true);
            for (int i = 0; i < this.modeIdList.size(); ++i) {
                Button addBtn = new Button((Composite)this.grpPlmModeId, 32);
                addBtn.setText(this.modeIdList.get(i).toString());
                addBtn.setData((Object)(1 << this.modeIdList.get(i)));
                addBtn.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
            }
        }
        this.grpPlmModeId.setLayoutData((Object)grpPlmModeIdGroupData);
        this.chkPlmModeIdGroup.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!DynamicSarConfigurationModifier.this.chkPlmModeIdGroup.getSelection()) {
                    DynamicSarConfigurationModifier.this.setSubCheckboxSelection((Composite)DynamicSarConfigurationModifier.this.grpPlmModeId, false);
                    DynamicSarConfigurationModifier.this.setChildrenEnable((Composite)DynamicSarConfigurationModifier.this.grpPlmModeId, false);
                } else {
                    DynamicSarConfigurationModifier.this.setChildrenEnable((Composite)DynamicSarConfigurationModifier.this.grpPlmModeId, true);
                }
            }
        });
        Composite cmpDmd = new Composite((Composite)this.shell, 4);
        FormLayout cmpDmdLayout = new FormLayout();
        cmpDmdLayout.marginWidth = 5;
        cmpDmdLayout.marginHeight = 5;
        cmpDmd.setLayout((Layout)cmpDmdLayout);
        cmpDmd.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.grpDmd = new Group(cmpDmd, 4);
        FormData frmDataGrpdmd = new FormData();
        frmDataGrpdmd.left = new FormAttachment(0, 0);
        frmDataGrpdmd.right = new FormAttachment(100, 0);
        GridLayout grpDmdLayout = new GridLayout(3, false);
        grpDmdLayout.verticalSpacing = 15;
        grpDmdLayout.horizontalSpacing = 20;
        this.grpDmd.setLayout((Layout)grpDmdLayout);
        this.grpDmd.setLayoutData((Object)frmDataGrpdmd);
        this.grpDmd.setText("On Table Status");
        this.rbtnDmdMotionLess = GuiUtils.addButtonToComposite("On Table", "", (Composite)this.grpDmd, 16, 16384, 0x1000000, false, false, 1, 1);
        this.rbtnDmdMotion = GuiUtils.addButtonToComposite("Not On Table", "", (Composite)this.grpDmd, 16, 16384, 0x1000000, false, false, 1, 1);
        this.rbtnDmdNotCare = GuiUtils.addButtonToComposite("Not Care", "", (Composite)this.grpDmd, 16, 16384, 0x1000000, false, false, 1, 1);
        this.rbtnDmdNotCare.setSelection(true);
        Composite cmpIndex = new Composite((Composite)this.shell, 4);
        FormLayout cmpIndexLayout = new FormLayout();
        cmpIndexLayout.marginWidth = 5;
        cmpIndexLayout.marginHeight = 5;
        cmpIndex.setLayout((Layout)cmpIndexLayout);
        cmpIndex.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        Group grpIndex = new Group(cmpIndex, 4);
        FormData frmDataGrpIndex = new FormData();
        frmDataGrpIndex.left = new FormAttachment(0, 0);
        frmDataGrpIndex.right = new FormAttachment(100, 0);
        GridLayout grpIndexLayout = new GridLayout(2, false);
        grpIndexLayout.verticalSpacing = 15;
        grpIndexLayout.horizontalSpacing = 20;
        grpIndex.setLayout((Layout)grpIndexLayout);
        grpIndex.setLayoutData((Object)frmDataGrpIndex);
        grpIndex.setText("Power Policy Index");
        GuiUtils.addLabelToComposite("Index:", (Composite)grpIndex, 4, 16384, 0x1000000, false, false, 1, 1);
        this.cspnIndex = GuiUtils.addCustomSpinnerToComposite(3, this.shell, (Composite)grpIndex, 2048, 16384, 0x1000000, false, false, 1, 1);
        Composite cmpsOkCancel = new Composite((Composite)this.shell, 0);
        cmpsOkCancel.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.horizontalSpacing = 10;
        gridLayout.verticalSpacing = 10;
        cmpsOkCancel.setLayout((Layout)gridLayout);
        Button btnOk = new Button(cmpsOkCancel, 0);
        GridData gd_btnOk = new GridData(131072, 0x1000000, true, false, 1, 1);
        btnOk.setLayoutData((Object)gd_btnOk);
        gd_btnOk.widthHint = GuiUtils.getButtonWidth((Control)this.shell);
        btnOk.setText("OK");
        btnOk.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DynamicSarConfigurationModifier.this.save();
            }
        });
        Button btnCancel = new Button(cmpsOkCancel, 0);
        GridData gd_btnCancel = new GridData(4, 0x1000000, false, false, 1, 1);
        btnCancel.setLayoutData((Object)gd_btnCancel);
        gd_btnCancel.widthHint = GuiUtils.getButtonWidth((Control)this.shell);
        btnCancel.setText("Cancel");
        btnCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DynamicSarConfigurationModifier.this.shell.close();
            }
        });
        this.shell.setSize(this.shell.computeSize(-1, -1));
        this.shell.setLocation(GuiUtils.getMiddleLocation(this.shell, this.display));
    }

    public void fillData() {
        if (this._currentItem == null) {
            return;
        }
        this.fillCheckbox((Composite)this.grpPlmModeId, this._currentItem.getText(0));
        this.fillCheckbox((Composite)this.grpDmd, this._currentItem.getText(1));
        this.cspnIndex.setSelection(Integer.parseInt(this._currentItem.getText(2)));
    }

    public void save() {
        DynamicSarConfigurationPayload.ConditionTable condition;
        String[] data = new String[]{this.getChildrenCheckboxSelectedText((Composite)this.grpPlmModeId), this.getChildrenCheckboxSelectedText((Composite)this.grpDmd), this.cspnIndex.getText()};
        try {
            this.parent.checkNewConfiguration(this.currentTable, data);
        }
        catch (Exception e) {
            MessageBox messageBox = new MessageBox(this.shell, 513);
            messageBox.setText("Invalid Configuration");
            messageBox.setMessage(e.getMessage());
            messageBox.open();
            return;
        }
        if (this._currentItem == null) {
            condition = new DynamicSarConfigurationPayload.ConditionTable();
            this.parent.addConfigurationRow(data, this.currentTable, condition);
        } else {
            condition = (DynamicSarConfigurationPayload.ConditionTable)this._currentItem.getData();
            this._currentItem.setText(data);
        }
        condition.plmModeId = !this.chkPlmModeIdGroup.getSelection() ? -1 : this.getChildrenCheckboxSelectedDataAsInt((Composite)this.grpPlmModeId);
        condition.dmdStatus = this.rbtnDmdMotionLess.getSelection() ? 0 : (this.rbtnDmdMotion.getSelection() ? 1 : 255);
        condition.indexNumber = Integer.valueOf(this.cspnIndex.getText());
        this.parent.setModified();
        this.shell.close();
    }

    public void setSubCheckboxSelection(Composite parentControl, boolean selection) {
        Control[] child;
        for (Control control : child = parentControl.getChildren()) {
            if (control.getClass() != Button.class || (control.getStyle() & 0x20) <= 0 && (control.getStyle() & 0x10) <= 0) continue;
            ((Button)control).setSelection(selection);
        }
    }

    public void setChildrenEnable(Composite parentControl, boolean isEnabled) {
        Control[] child;
        for (Control control : child = parentControl.getChildren()) {
            if (!(control instanceof Button) || (control.getStyle() & 0x20) <= 0 && (control.getStyle() & 0x10) <= 0) continue;
            control.setEnabled(isEnabled);
        }
    }

    public String getChildrenCheckboxSelectedText(Composite parentControl) {
        Control[] neighborControls;
        StringBuffer text = new StringBuffer();
        boolean isNeedGetChildrenText = true;
        Control[] child = parentControl.getChildren();
        for (Control control : neighborControls = parentControl.getParent().getChildren()) {
            if (!(control instanceof Button) || (control.getStyle() & 0x20) <= 0 || ((Button)control).getSelection()) continue;
            text.append("Not Available").append(",");
            isNeedGetChildrenText = false;
            break;
        }
        if (isNeedGetChildrenText) {
            for (Control control : child) {
                if (control.getClass() != Button.class || (control.getStyle() & 0x20) <= 0 && (control.getStyle() & 0x10) <= 0 || !((Button)control).getSelection()) continue;
                text.append(((Button)control).getText()).append(",");
            }
        }
        if (text.length() > 0) {
            return text.substring(0, text.length() - 1);
        }
        return text.toString();
    }

    public int getChildrenCheckboxSelectedDataAsInt(Composite parentControl) {
        Control[] child = parentControl.getChildren();
        int ret = 0;
        for (Control control : child) {
            if (control.getClass() != Button.class || (control.getStyle() & 0x20) <= 0 && (control.getStyle() & 0x10) <= 0 || !((Button)control).getSelection()) continue;
            int value = (Integer)control.getData();
            ret |= value;
        }
        return ret;
    }

    public void fillCheckbox(Composite parentControl, String itemText) {
        if (itemText.compareTo("Not Available") == 0) {
            Control[] neighborControls;
            for (Control control : neighborControls = parentControl.getParent().getChildren()) {
                if (!(control instanceof Button) || (control.getStyle() & 0x20) <= 0) continue;
                ((Button)control).setSelection(false);
                this.setChildrenEnable(parentControl, false);
                break;
            }
        } else {
            Control[] child;
            String[] checkValues = itemText.split(",");
            block1: for (Control control : child = parentControl.getChildren()) {
                if (!(control instanceof Button) || (control.getStyle() & 0x20) <= 0 && (control.getStyle() & 0x10) <= 0) continue;
                ((Button)control).setSelection(false);
                for (String value : checkValues) {
                    if (((Button)control).getText().compareTo(value) != 0) continue;
                    ((Button)control).setSelection(true);
                    continue block1;
                }
            }
        }
    }
}

